/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.esb;

import com.aurea.maven.plugins.sonic.esb.AbstractESBConnectMojo;
import com.aurea.maven.plugins.sonic.utils.FileUtilities;
import com.aurea.maven.plugins.sonic.utils.SnippetsProcessor;
import com.aurea.maven.plugins.sonic.utils.Xpp3Utils;
import com.sonicsw.deploy.action.CreateMapAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

public abstract class AbstractEsbPackageMojo
extends AbstractESBConnectMojo {
    private MavenProjectHelper projectHelper;
    private String artifactID;
    protected File esbTailorPropFile;
    protected File testEsbTailorPropFile;
    protected ArchiverManager archiverManager;
    ArrayList<String> parameterMatches;
    ArrayList<String> testParameterMatches;
    String xarExcludes;
    protected boolean copyXarToDeploy;

    protected abstract String getGeneratedSrcDir();

    protected abstract String getAssemblyDir();

    protected abstract List<Resource> getResources();

    protected abstract File getEsbTailorPropFile();

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        super.doExecute();
        File archiveFile = null;
        this.getLog().info((CharSequence)"Packaging ESB project ...");
        try {
            archiveFile = this.createEsbAssembly();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to package ESB archive " + (archiveFile == null ? "null" : archiveFile.getAbsolutePath()), e);
        }
        String classifier = this.getClassifier();
        if (classifier != null) {
            this.projectHelper.attachArtifact(this.project, this.getType(), classifier, archiveFile);
        } else {
            this.project.getArtifact().setFile(archiveFile);
        }
    }

    protected void addArtifactReplaceRules(List<Xpp3Dom> _replaceRules) {
        Xpp3Dom projectReplace = new Xpp3Dom("stringReplaceMap");
        projectReplace.setAttribute("name", "sonicfs:///workspace/" + this.getProjectName() + this.getSonicEsbSourceDirectoryFromBase());
        projectReplace.setAttribute("updatedName", "sonicfs:///" + this.getSonicFSProjectDir());
        _replaceRules.add(projectReplace);
        Xpp3Dom libReplace = new Xpp3Dom("stringReplaceMap");
        libReplace.setAttribute("name", "sonicfs:///workspace/" + this.getProjectName() + "/lib/" + this.getArtifactId());
        libReplace.setAttribute("updatedName", "sonicfs:///" + this.getSonicFSResourcesDir() + "/" + this.getGroupId().replaceAll("\\.", "/") + "/" + this.getArtifactId() + "/" + this.getVersion() + "/" + this.getFinalAssemblyBaseName());
        _replaceRules.add(libReplace);
    }

    protected void generateTailoring(SnippetsProcessor _sp) throws Exception {
        XmlStreamReader reader = null;
        XmlStreamReader esbtailorReader = null;
        String tailorFile = this.getTailorDir() + "/" + this.getFinalAssemblyBaseName() + ".xar.xml";
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        Xpp3Dom tailorDom = null;
        String tailorRulesFile = "ESB/deploy/" + this.getESBVersion() + "/DefaultTailorRules.xml";
        String rulesFile = this.getAssemblyDir() + "/" + this.getRulesFileName();
        try {
            InputStream is = cl.getResourceAsStream(tailorRulesFile);
            byte[] content = new byte[is.available()];
            is.read(content);
            FileUtilities.writeFile(content, rulesFile);
            reader = new XmlStreamReader(new File(rulesFile));
            tailorDom = Xpp3DomBuilder.build((Reader)reader);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Could not access: " + tailorRulesFile), (Throwable)e);
        }
        Xpp3Dom stringReplace = tailorDom.getChild("DevEnvRules").getChild("stringReplaceMaps");
        Xpp3Utils.removeAllChildren(tailorDom, "DevEnvRules/stringReplaceMaps");
        List<Xpp3Dom> replaceRules = Xpp3Utils.collectElements(this.getDependencyDirectory(), "**/*.xar.xml", "StringReplaceMaps/stringReplaceMap");
        this.addArtifactReplaceRules(replaceRules);
        this.getLog().debug((CharSequence)"Inserting Tailor Rules ------");
        this.getLog().debug((CharSequence)("Check File " + this.getEsbTailorPropFile()));
        this.getLog().debug((CharSequence)("Base-Dir: " + this.project.getBasedir()));
        File esbTailorFile = this.getEsbTailorPropFile();
        if (esbTailorFile.exists()) {
            try {
                this.getLog().info((CharSequence)"Tailoring the String Replace Maps with custom tailoring");
                esbtailorReader = new XmlStreamReader(esbTailorFile);
                Xpp3Dom esbtailorDom = Xpp3DomBuilder.build((Reader)esbtailorReader);
                for (Xpp3Dom child : esbtailorDom.getChild("CustomStringReplaceMaps").getChildren()) {
                    Xpp3Dom stringreplacer = new Xpp3Dom("stringReplaceMap");
                    stringreplacer.setAttribute("name", child.getAttribute("name"));
                    stringreplacer.setAttribute("updatedName", child.getAttribute("updatedName"));
                    replaceRules.add(stringreplacer);
                }
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Problem encountered with the formatting of the file: " + e.getMessage()), (Throwable)e);
            }
        } else {
            this.getLog().debug((CharSequence)"No Tailoring File Found");
        }
        replaceRules = Xpp3Utils.unifyXpp3List(replaceRules, "/stringReplaceMap/@name");
        for (Xpp3Dom replaceRule : replaceRules) {
            stringReplace.addChild(replaceRule);
        }
        Xpp3Dom propertiesReplaceMap = this.getSonicConnectPropertiesReplaceMap();
        if (propertiesReplaceMap != null) {
            this.getLog().debug((CharSequence)"Need to insert the Property Replace Maps ");
            tailorDom.addChild(propertiesReplaceMap);
        } else {
            this.getLog().debug((CharSequence)"No Properties File Found for Sonic Connect Project");
        }
        List<Xpp3Dom> serviceRules = Xpp3Utils.collectElements(this.getDependencyDirectory(), "**/*.rules.snippet");
        serviceRules = Xpp3Utils.unifyXpp3List(serviceRules, "/ServiceRule/@type");
        Xpp3Dom insertPoint = tailorDom.getChild("ServiceRules");
        for (Xpp3Dom serviceRule : serviceRules) {
            if (serviceRule.getChildCount() <= 0) continue;
            insertPoint.addChild(serviceRule);
        }
        FileUtilities.writeFile(tailorDom.toString().getBytes(), rulesFile);
        CreateMapAction cmAction = new CreateMapAction(new File(tailorFile), new File(rulesFile));
        cmAction.run(_sp.getXarAnalyser().getStorage());
        reader = new XmlStreamReader(new File(tailorFile));
        tailorDom = Xpp3DomBuilder.build((Reader)reader);
        Xpp3Utils.removeAllChildren(tailorDom, "EndpointMaps");
        Xpp3Utils.removeAllChildren(tailorDom, "ProcessMaps/ProcessMap");
        List<Xpp3Dom> serviceMaps = Xpp3Utils.collectElements(tailorDom, "ServiceMaps/ServiceMap");
        for (Xpp3Dom serviceMap : serviceMaps) {
            Xpp3Dom paramMap = null;
            if (serviceMap.getChild("paramMap") != null) {
                paramMap = serviceMap.getChild("paramMap");
            }
            Xpp3Utils.removeAllChildren(serviceMap);
            if (paramMap == null) continue;
            serviceMap.addChild(paramMap);
        }
        FileUtilities.writeFile(tailorDom.toString().getBytes(), tailorFile);
    }

    protected void generateVariables() throws Exception {
        String tailorFile = this.getTailorDir() + "/" + this.getFinalAssemblyBaseName() + ".xar.xml";
        Xpp3Dom variables = new Xpp3Dom("Variables");
        XmlStreamReader reader = new XmlStreamReader(new File(tailorFile));
        Xpp3Dom tailorDom = Xpp3DomBuilder.build((Reader)reader);
        this.generateVariablesFromTailoring(tailorDom, variables, null);
        this.generateVariablesFromProperties(variables);
        FileUtilities.writeFile(variables.toString().getBytes(), this.getSnippetDir() + "/" + this.getFinalAssemblyBaseName() + ".variables.snippet");
        FileUtilities.writeFile(tailorDom.toString().getBytes(), tailorFile);
    }

    protected void generateVariablesFromProperties(Xpp3Dom _variables) {
    }

    protected void generateVariablesFromTailoring(Xpp3Dom _element, Xpp3Dom _variables, String _context) {
        String nextContext = _context;
        if (_element != null) {
            String updatedNameAttribute;
            if ("StringParam".equals(_element.getName())) {
                String paramName = "@" + _context + "." + _element.getAttribute("name").trim() + "@";
                String paramContent = null;
                if (_element.getAttribute("url") != null) {
                    paramContent = _element.getAttribute("url");
                    _element.setAttribute("url", paramName);
                } else {
                    paramContent = _element.getValue();
                    _element.setValue(paramName);
                }
                _variables.addChild(Xpp3Utils.createXpp3Dom("Variable", paramContent, "name=" + paramName));
            }
            if ("XmlParam".equals(_element.getName()) && "connections".equals(_element.getAttribute("name"))) {
                this.getLog().debug((CharSequence)"TBO: ------ Need to treat a connection Object");
                for (Xpp3Dom child : _element.getChildren()) {
                    this.generateDatabaseVariables(child, _variables, "db.connect." + _context);
                }
            }
            if ("stringReplaceMap".equals(_element.getName()) && (updatedNameAttribute = _element.getAttribute("updatedName")) != null && updatedNameAttribute.startsWith("@") && updatedNameAttribute.endsWith("@")) {
                this.getLog().debug((CharSequence)("Found stringReplaceMap variable: " + updatedNameAttribute));
                _variables.addChild(Xpp3Utils.createXpp3Dom("Variable", null, "name=" + updatedNameAttribute));
            }
            if ("ServiceMap".equals(_element.getName())) {
                nextContext = "svc." + _element.getAttribute("name");
            } else if ("ConnectionMap".equals(_element.getName())) {
                nextContext = "con." + _element.getAttribute("name");
            }
            if ("propertyReplaceMap".equals(_element.getName())) {
                String prop = _element.getAttribute("propertyName");
                String val = _element.getAttribute("updatedValue");
                String parameter = "@connect." + this.artifactID + "." + prop + "@";
                _element.setAttribute("updatedValue", parameter);
                _variables.addChild(Xpp3Utils.createXpp3Dom("Variable", val, "name=" + parameter));
                this.getLog().debug((CharSequence)("Found PropertyReplaceMap Variable " + parameter + " with value " + val));
            }
            for (Xpp3Dom child : _element.getChildren()) {
                this.generateVariablesFromTailoring(child, _variables, nextContext);
            }
        }
    }

    protected void generateDatabaseVariables(Xpp3Dom _element, Xpp3Dom _variables, String _context) {
        this.getLog().debug((CharSequence)("Element: " + _element.getName() + " --- " + _context));
        if ("connection".equals(_element.getName()) || "rdbms:connection".equals(_element.getName())) {
            this.getLog().debug((CharSequence)"Creating the connection stuff");
            String password = _element.getAttribute("password");
            String passwordref = "@" + _context + "." + _element.getName() + ".password" + "@";
            _element.setAttribute("password", passwordref);
            _variables.addChild(Xpp3Utils.createXpp3Dom("Variable", password, "name=" + passwordref));
            String username = _element.getAttribute("username");
            String usernameref = "@" + _context + "." + _element.getName() + ".username" + "@";
            _element.setAttribute("username", usernameref);
            _variables.addChild(Xpp3Utils.createXpp3Dom("Variable", username, "name=" + usernameref));
            String jdbcURL = _element.getAttribute("jdbcURL");
            String jdbcURLref = "@" + _context + "." + _element.getName() + ".jdbcURL" + "@";
            _element.setAttribute("jdbcURL", jdbcURLref);
            _variables.addChild(Xpp3Utils.createXpp3Dom("Variable", jdbcURL, "name=" + jdbcURLref));
            String name = _element.getAttribute("name");
            String nameref = "@" + _context + "." + _element.getName() + ".name" + "@";
            _element.setAttribute("name", nameref);
            _variables.addChild(Xpp3Utils.createXpp3Dom("Variable", name, "name=" + nameref));
        }
        if ("scheduledQueries".equals(_element.getName())) {
            int queryNum = 0;
            this.getLog().debug((CharSequence)("Handling Scheduled Queries --- " + queryNum));
            for (Xpp3Dom child : _element.getChildren()) {
                this.generateDatabaseQueries(child, _variables, "query." + queryNum + "." + _context);
                ++queryNum;
            }
        } else {
            for (Xpp3Dom child : _element.getChildren()) {
                this.generateDatabaseVariables(child, _variables, _context);
            }
        }
    }

    protected void generateDatabaseQueries(Xpp3Dom _element, Xpp3Dom _variables, String _context) {
        for (Xpp3Dom child : _element.getChildren()) {
            if ("address".equals(child.getName())) {
                String ref = child.getAttribute("endpoint_ref");
                String refname = "@" + _context + "." + child.getName() + ".endpoint_ref@";
                String type = child.getAttribute("type");
                String typename = "@" + _context + "." + child.getName() + ".type@";
                child.setAttribute("endpoint_ref", refname);
                child.setAttribute("type", typename);
                _variables.addChild(Xpp3Utils.createXpp3Dom("Variable", ref, "name=" + refname));
                _variables.addChild(Xpp3Utils.createXpp3Dom("Variable", type, "name=" + typename));
                continue;
            }
            String paramName = "@" + _context + "." + child.getName().trim() + "@";
            String paramContent = child.getValue();
            this.getLog().debug((CharSequence)("TBO ----- Setting paramName = " + paramName + " Content = " + paramContent));
            child.setValue(paramName);
            _variables.addChild(Xpp3Utils.createXpp3Dom("Variable", paramContent, "name=" + paramName));
        }
    }

    protected void copyGeneratedSrcToXarDir() throws MojoExecutionException {
        String xarDir = this.getPackageXarDir();
        this.getLog().info((CharSequence)"Copying generated src to xar dir ...");
        this.getLog().debug((CharSequence)("generatedSrcDir: " + this.getGeneratedSrcDir()));
        this.getLog().debug((CharSequence)("xarDir: " + xarDir));
        new File(xarDir, "ESB").mkdirs();
        new File(xarDir, "SonicFS").mkdirs();
        try {
            StringBuffer excludes = new StringBuffer();
            String separator = "";
            for (Xpp3Dom svc : Xpp3Utils.collectElements(this.getDependencyDirectory(), "**/*.rules.snippet")) {
                String svcName = svc.getAttribute("type");
                excludes.append(separator);
                excludes.append("ESB/ServiceTypes/" + svcName + ".*");
                separator = ",";
                excludes.append(separator);
                excludes.append("SonicFS/System/**/" + svcName + ".properties");
                excludes.append(separator);
                excludes.append("SonicFS/System/**/" + svcName + ".gif");
            }
            FileUtilities.copyFiles(this.getGeneratedSrcDir(), xarDir, null, excludes.toString() + "," + this.getXarExcludePatterns(), null, false);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error copying xar content: ", e);
        }
    }

    protected void createAssemblyStructure() {
        String[] dirs;
        for (String dirName : dirs = new String[]{this.getAssemblyDir(), this.getSnippetDir(), this.getTailorDir()}) {
            File dir = new File(dirName);
            dir.mkdirs();
        }
    }

    protected void generateQueuesSnippet(SnippetsProcessor _sp) throws Exception {
        String queuesFile = this.getFinalAssemblyBaseName() + ".queues.snippet";
        FileUtilities.writeFile(_sp.getQueuesSnippet().getBytes(), this.getSnippetDir() + "/" + queuesFile);
    }

    protected void generateSvcInstancesSnippet(SnippetsProcessor _sp) throws Exception {
        String instancesFile = this.getFinalAssemblyBaseName() + ".instances.snippet";
        FileUtilities.writeFile(_sp.getSvcInstancesSnippet(this.getGroupId() + "." + this.getArtifactId()).getBytes(), this.getSnippetDir() + "/" + instancesFile);
    }

    protected String getAssemblyXarsDir() {
        return this.getAssemblyDir() + "/" + "xars";
    }

    protected String getTailorDir() {
        return this.getAssemblyXarsDir() + "/" + "tailor";
    }

    protected String getSnippetDir() {
        return this.getAssemblyXarsDir() + "/" + "sdm-snippets";
    }

    protected abstract String getType();

    File createEsbAssembly() throws Exception {
        this.copyGeneratedSrcToXarDir();
        this.createAssemblyStructure();
        this.getLog().info((CharSequence)"Creating ESB assembly ...");
        File archiveFile = new File(this.getAssemblyDir());
        this.copyJarFiles();
        File xarArchive = this.createXarFile();
        FileUtils.copyFileToDirectory((File)xarArchive, (File)new File(archiveFile, "xars"));
        if (this.copyXarToDeploy) {
            File deployDir = new File(this.project.getBasedir(), "deploy");
            this.getLog().info((CharSequence)("Copying xar archive to " + deployDir.getPath()));
            FileUtils.copyFileToDirectory((File)xarArchive, (File)deployDir);
        }
        SnippetsProcessor sp = new SnippetsProcessor(xarArchive);
        this.getLog().debug((CharSequence)"Creating Queue snippet ...");
        this.generateQueuesSnippet(sp);
        this.getLog().debug((CharSequence)"Creating Tailoring rules ...");
        this.generateTailorRules(sp);
        this.getLog().debug((CharSequence)"Creating Tailoring file ...");
        this.generateTailoring(sp);
        this.getLog().debug((CharSequence)"Creating Instance snippet ...");
        this.generateSvcInstancesSnippet(sp);
        this.getLog().debug((CharSequence)"Extracting Variables ...");
        this.generateVariables();
        Archiver archiver = this.archiverManager.getArchiver("zip");
        archiveFile = this.getArchiveFile(this.project.getBuild().getDirectory(), this.getFinalAssemblyBaseName(true), "zip");
        archiver.setDestFile(archiveFile);
        archiver.addDirectory(new File(this.getAssemblyDir()));
        archiver.createArchive();
        FileUtils.forceDelete((File)new File("target" + File.separatorChar + "unzip"));
        return archiveFile;
    }

    protected File createXarFile() throws Exception {
        List<Resource> resources = this.getResources();
        for (Resource resource : resources) {
            FileUtilities.copyFiles(resource.getDirectory(), this.getPackageXarDir() + "/SonicFS", "**/*", this.getXarExcludePatterns(), "/workspace/" + this.getProjectName() + resource.getDirectory().replace(this.project.getBasedir().getAbsolutePath(), ""), false);
        }
        FileUtilities.copyFiles(this.getSonicEsbSourceDirectory().getAbsolutePath(), this.getPackageXarDir() + "/SonicFS", "**/*", "**/*.esbp,**/*.sid,**/*.esbsvc," + this.getXarExcludePatterns(), "/workspace/" + this.getProjectName() + this.getSonicEsbSourceDirectoryFromBase(), false);
        File archiveFile = this.getArchiveFile(this.getPackageXarFileDir(), this.getFinalAssemblyBaseName(), "xar");
        Archiver archiver = this.archiverManager.getArchiver("zip");
        archiver.setDestFile(archiveFile);
        archiver.addDirectory(new File(this.getPackageXarDir()));
        archiver.createArchive();
        return archiveFile;
    }

    protected String getXarExcludePatterns() {
        return this.xarExcludes;
    }

    private File getArchiveFile(String _basedir, String _finalBaseName, String _extension) {
        return new File(_basedir, _finalBaseName + "." + _extension);
    }

    private void generateTailorRules(SnippetsProcessor _sp) throws Exception {
        String rulesFile = this.getFinalAssemblyBaseName() + ".rules.snippet";
        ArrayList<String> pm = this.getParameterMatches();
        if (pm == null) {
            pm = new ArrayList();
        }
        this.getLog().debug((CharSequence)"Checking the Tailor Rule File for parameter rule definitions");
        XmlStreamReader esbtailorReader = null;
        File esbTailorFile = this.getEsbTailorPropFile();
        if (esbTailorFile.exists()) {
            try {
                this.getLog().info((CharSequence)"Tailoring the Init Parameter Visibility");
                esbtailorReader = new XmlStreamReader(esbTailorFile);
                Xpp3Dom esbtailorDom = Xpp3DomBuilder.build((Reader)esbtailorReader);
                if (esbtailorDom.getChild("parameterMatches") == null) {
                    this.getLog().info((CharSequence)"No External Parameter Matches found");
                }
                for (Xpp3Dom child : esbtailorDom.getChild("parameterMatches").getChildren()) {
                    pm.add(child.getValue());
                    this.getLog().debug((CharSequence)("added: " + child.getValue()));
                }
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Problem encountered with the formatting of the file: " + e.getMessage()), (Throwable)e);
            }
        } else {
            this.getLog().debug((CharSequence)"No Tailoring File Found");
        }
        if (pm.size() == 0) {
            pm.add(".*");
        }
        FileUtilities.writeFile(_sp.getTailorSnippet(pm).getBytes(), this.getSnippetDir() + "/" + rulesFile);
    }

    protected abstract ArrayList<String> getParameterMatches();

    private Xpp3Dom getSonicConnectPropertiesReplaceMap() {
        File connectProperties = new File(new File(this.project.getBasedir(), "lib"), this.project.getArtifactId() + ".properties");
        if (connectProperties.exists()) {
            Properties props = new Properties();
            try {
                FileInputStream fis = new FileInputStream(connectProperties);
                props.load(fis);
                fis.close();
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"No Valid Properties file found!", (Throwable)e);
                return null;
            }
            Xpp3Dom propertyRules = new Xpp3Dom("PropertyRules");
            Xpp3Dom propertyReplaceMaps = new Xpp3Dom("PropertyReplaceMaps");
            propertyReplaceMaps.setAttribute("artifactName", this.artifactID + ".properties");
            Xpp3Dom replaceMap = null;
            for (String string : props.keySet()) {
                this.getLog().debug((CharSequence)("Found Property " + string + ":" + props.getProperty(string)));
                if (props.getProperty(string).startsWith("$")) {
                    this.getLog().debug((CharSequence)("Ignoring key " + string + " : " + props.getProperty(string)));
                    continue;
                }
                replaceMap = new Xpp3Dom("propertyReplaceMap");
                replaceMap.setAttribute("propertyName", string);
                replaceMap.setAttribute("updatedValue", props.getProperty(string));
                propertyReplaceMaps.addChild(replaceMap);
            }
            propertyRules.addChild(propertyReplaceMaps);
            return propertyRules;
        }
        return null;
    }
}

