/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.topology.utils;

import java.io.Serializable;
import java.util.ArrayList;

public class MachineConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    String machineId;
    ArrayList<String> alternateIds;
    ArrayList<String> logicalhosts;
    String containerDir;
    String registerAsService;
    String encryptPWD;
    String serviceStartupTime;

    public MachineConfig() {
        this.alternateIds = new ArrayList();
        this.logicalhosts = new ArrayList();
    }

    public MachineConfig(String id, ArrayList<String> aid, ArrayList<String> loghost, String container, String regasService, String encrypt, String startup) {
        this.machineId = id;
        this.alternateIds = aid;
        this.logicalhosts = loghost;
        this.containerDir = container;
        this.registerAsService = regasService;
        this.encryptPWD = encrypt;
        this.serviceStartupTime = startup;
    }

    public void addAlternateId(String aid) {
        if (!this.alternateIds.contains(aid)) {
            this.alternateIds.add(aid);
        }
    }

    public void addLogicalHosts(String lh) {
        if (!this.logicalhosts.contains(lh)) {
            this.logicalhosts.add(lh);
        }
    }

    public String getMachineId() {
        return this.machineId;
    }

    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    public ArrayList<String> getAlternateIds() {
        return this.alternateIds;
    }

    public void setAlternateIds(ArrayList<String> alternateIds) {
        this.alternateIds = alternateIds;
    }

    public ArrayList<String> getLogicalhosts() {
        return this.logicalhosts;
    }

    public void setLogicalhosts(ArrayList<String> logicalhosts) {
        this.logicalhosts = logicalhosts;
    }

    public String getContainerDir() {
        return this.containerDir;
    }

    public void setContainerDir(String containerDir) {
        this.containerDir = containerDir;
    }

    public String getRegisterAsService() {
        return this.registerAsService;
    }

    public void setRegisterAsService(String registerAsService) {
        this.registerAsService = registerAsService;
    }

    public String getEncryptPWD() {
        return this.encryptPWD;
    }

    public void setEncryptPWD(String encryptPWD) {
        this.encryptPWD = encryptPWD;
    }

    public String getServiceStartupTime() {
        return this.serviceStartupTime;
    }

    public void setServiceStartupTime(String serviceStartupTime) {
        this.serviceStartupTime = serviceStartupTime;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("Machine Configuration\n");
        sb.append("---------------------\n");
        sb.append("Machine-Id:            " + this.getMachineId() + "\n");
        for (i = 0; i < this.getAlternateIds().size(); ++i) {
            sb.append("   Alternate-Id:      " + this.getAlternateIds().get(i) + "\n");
        }
        for (i = 0; i < this.getLogicalhosts().size(); ++i) {
            sb.append("   Logical-Host:      " + this.getLogicalhosts().get(i) + "\n");
        }
        sb.append("Container Dir:            " + this.getContainerDir() + "\n");
        sb.append("Register as Service       " + this.getRegisterAsService() + "\n");
        sb.append("Encrypt Password          " + this.getEncryptPWD() + "\n");
        sb.append("Service Startup Time      " + this.getServiceStartupTime() + "\n");
        sb.append("\n---------------------\n");
        return sb.toString();
    }
}

