/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.utils;

import com.sonicsw.esb.mgmtapi.ESBAPI;
import com.sonicsw.esb.mgmtapi.ESBAPIFactory;
import com.sonicsw.esb.mgmtapi.config.IConnectionConfig;
import com.sonicsw.esb.mgmtapi.config.IContainerConfig;
import com.sonicsw.esb.mgmtapi.config.IContainerConfigAPI;
import com.sonicsw.esb.mgmtapi.config.IEndpointConfigAPI;
import com.sonicsw.esb.mgmtapi.config.IJMSConnectionConfig;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mf.mgmtapi.config.IContainerBean;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.xqimpl.mgmtapi.config.IXQContainerBean;
import com.sonicsw.xqimpl.mgmtapi.config.XQMgmtBeanFactory;

public class CreateESBContainer {
    public static void main(String[] _args) {
        CreateESBContainer cec = new CreateESBContainer();
        cec.createContainer();
        cec.lookupConnections();
        cec.addContainerToMF();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addContainerToMF() {
        XQMgmtBeanFactory domain = new XQMgmtBeanFactory();
        try {
            domain.connect("Domain1", "tcp://localhost:2506", "Administrator", "Administrator");
            IContainerBean container = domain.getContainerBean("/Containers/ctKoneMsg");
            IXQContainerBean esbContainer = domain.getXQContainerBean("/ESB Containers/TestDomainESB");
            IContainerBean.IComponentsType containerComponents = container.getComponents();
            IContainerBean.IStartupParams startup = containerComponents.createEntry();
            startup.setConfigRef((IMgmtBeanBase)esbContainer);
            startup.setAutoStart(true);
            containerComponents.addEntry("TestDomainESB", startup);
            domain.saveContainerBean(container);
        }
        catch (MgmtException e) {
            e.printStackTrace();
        }
        finally {
            try {
                domain.commit();
                domain.flush();
                domain.disconnect();
            }
            catch (MgmtException e) {
                e.printStackTrace();
            }
            catch (ConfigServiceException e) {
                e.printStackTrace();
            }
            System.gc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookupConnections() {
        ESBAPI eapi = null;
        try {
            ESBAPIFactory efac = ESBAPIFactory.createESBAPIFactory();
            eapi = efac.createAPI("Domain1", "tcp://localhost:2506", "Administrator", "Administrator");
            IEndpointConfigAPI epapi = eapi.getEndpointConfigAPI();
            String[] connections = epapi.listConnections();
            for (int i = 0; i < connections.length; ++i) {
                IConnectionConfig iecfg = epapi.getConnectionConfig(connections[i]);
                if (connections[i].equals("jms_defaultConnection")) {
                    IJMSConnectionConfig ijms = (IJMSConnectionConfig)iecfg.getAdapter(iecfg.getConnectionType());
                    ijms.setBrokerURLs("tcp://localhost:2506");
                }
                epapi.saveConnection(iecfg);
            }
        }
        catch (Exception exception) {
        }
        finally {
            eapi.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createContainer() {
        System.out.println("createContainer");
        ESBAPI eapi = null;
        try {
            System.out.println("Creating ESB API Factory");
            ESBAPIFactory efac = ESBAPIFactory.createESBAPIFactory();
            System.out.println("Factory API Created");
            System.out.println("Creating the API Handle");
            eapi = efac.createAPI("Domain1", "tcp://localhost:2506", "Administrator", "Administrator");
            System.out.println("API Handle Created");
            System.out.println("Creating the Container handle");
            IContainerConfigAPI ceapi = eapi.getContainerConfigAPI();
            System.out.println("Container handle created");
            System.out.println("Checking if container exists");
            IContainerConfig existing = ceapi.getESBContainer("TestDomainESB");
            System.out.println("Done Checking");
            if (existing == null) {
                System.out.println("Create ESB Container");
                IContainerConfig newContainer = ceapi.createESBContainer("TestDomainESB");
                System.out.println("Container Created");
                System.out.println("Saving the new ESB Container");
                ceapi.saveESBContainer(newContainer);
                System.out.println("Container Saved");
            } else {
                System.out.println("Container was existing");
            }
        }
        catch (Exception e) {
            System.out.println("Error happened: " + e.getMessage());
        }
        finally {
            eapi.dispose();
        }
        System.out.println("Done");
    }
}

