/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class FileUtilities {
    public static void deleteFilesInDir(String _baseDir, String _includes, String _excludes) {
        File dir = new File(_baseDir);
        if (!dir.exists() && !dir.isDirectory()) {
            return;
        }
        for (String file : FileUtilities.getFileList(_baseDir, _includes, _excludes)) {
            new File(_baseDir, file).delete();
        }
    }

    public static void copyFiles(String _baseDir, String _targetBase) throws Exception {
        FileUtilities.copyFiles(_baseDir, _targetBase, null, null, null, false);
    }

    public static void copyFiles(String _baseDir, String _targetBase, String _includes, String _excludes, String _targetDirs, boolean _flatten) throws Exception {
        File dir = new File(_baseDir);
        if (!dir.exists() && !dir.isDirectory()) {
            return;
        }
        File targetBaseDir = new File(_targetBase);
        String[] targetDirList = null;
        targetDirList = _targetDirs == null ? new String[]{""} : _targetDirs.split(",");
        File srcFile = null;
        File destFile = null;
        for (String targetDirName : targetDirList) {
            File targetDir = new File(targetBaseDir, targetDirName);
            String[] files = FileUtilities.getFileList(_baseDir, _includes, _excludes);
            if (files.length <= 0 && !targetDir.getPath().contains("classes")) continue;
            targetDir.mkdirs();
            for (String file : files) {
                srcFile = new File(_baseDir, file);
                if (_flatten) {
                    destFile = new File(targetDir, srcFile.getName());
                } else {
                    destFile = new File(targetDir, file);
                    destFile.getParentFile().mkdirs();
                }
                try {
                    FileUtils.copyFile((File)srcFile, (File)destFile);
                }
                catch (IOException ioe) {
                    throw new Exception("Error copying [" + srcFile + "->" + destFile + "]", ioe);
                }
            }
        }
    }

    public static String[] getFileList(String _baseDir, String _includes, String _excludes) {
        String[] result = new String[]{};
        if (!new File(_baseDir).exists()) {
            return result;
        }
        try {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(_baseDir);
            scanner.addDefaultExcludes();
            if (_includes != null) {
                scanner.setIncludes(_includes.split(","));
            } else {
                scanner.setIncludes(new String[]{"**/*"});
            }
            if (_excludes != null) {
                ArrayList<String> excludeList = new ArrayList<String>();
                for (String exclude : DirectoryScanner.DEFAULTEXCLUDES) {
                    excludeList.add(exclude);
                }
                for (String exclude : _excludes.split(",")) {
                    excludeList.add(exclude);
                }
                scanner.setExcludes(excludeList.toArray(new String[excludeList.size()]));
            } else {
                scanner.addDefaultExcludes();
            }
            scanner.scan();
            result = scanner.getIncludedFiles();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void writeFile(byte[] _content, String _fileName) {
        File outputFile = new File(_fileName);
        outputFile.getParentFile().mkdirs();
        FileUtilities.writeFile(_content, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(byte[] _content, File _file) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(_file);
            fos.write(_content);
            fos.close();
        }
        catch (IOException ioe) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static byte[] readFile(String _fileName) throws IOException {
        FileInputStream fis = null;
        File file = new File(_fileName);
        fis = new FileInputStream(file);
        byte[] fileContents = new byte[(int)file.length()];
        fis.read(fileContents);
        fis.close();
        return fileContents;
    }
}

