/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.esb;

import com.aurea.maven.plugins.sonic.esb.AbstractESBMojo;
import com.aurea.maven.plugins.sonic.utils.ProjectAnalyzer;
import java.util.HashSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class EsbDependenciesMojo
extends AbstractESBMojo {
    protected boolean validateDependencies;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.validateDependencies) {
            this.validateDependencies();
        } else {
            this.getLog().warn((CharSequence)"Dependency validation will be skipped");
        }
        this.getLog().info((CharSequence)"Depenency validation complete");
    }

    private void validateDependencies() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Validating process dependencies");
        HashSet<String> localProcessNames = ProjectAnalyzer.getProcessNames(this.getSonicEsbSourceDirectory().getAbsolutePath());
        HashSet<String> subProcesssNames = ProjectAnalyzer.getSubProcessesOfProcesses(this.getSonicEsbSourceDirectory());
        HashSet<String> dependencyProcessNames = this.getDependencyProcessNames();
        this.getLog().debug((CharSequence)("Local processes found: " + localProcessNames.toString()));
        this.getLog().debug((CharSequence)("Sub-processes found: " + subProcesssNames.toString()));
        this.getLog().debug((CharSequence)("Dependency processes found: " + dependencyProcessNames.toString()));
        HashSet<String> knownProcesses = new HashSet<String>();
        knownProcesses.addAll(localProcessNames);
        knownProcesses.addAll(dependencyProcessNames);
        if (!knownProcesses.containsAll(subProcesssNames)) {
            HashSet<String> unknownProcesses = new HashSet<String>();
            unknownProcesses.addAll(subProcesssNames);
            unknownProcesses.removeAll(knownProcesses);
            throw new MojoExecutionException("Not all sub-processes are known. Please add dependencies containing the following processes: " + unknownProcesses.toString());
        }
    }
}

