/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.topology;

import com.aurea.maven.plugins.sonic.topology.AbstractTopoMojo;
import com.aurea.maven.plugins.sonic.topology.utils.Environment;
import com.aurea.maven.plugins.sonic.topology.utils.MachineConfig;
import com.aurea.maven.plugins.sonic.topology.utils.ParameterHandlingException;
import com.aurea.maven.plugins.sonic.topology.utils.ParameterHolder;
import com.aurea.maven.plugins.sonic.topology.utils.TopologyHolder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectOutputStream;
import no.geosoft.cc.util.SmartTokenizer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class TopoGenerateTopologyHolderMojo
extends AbstractTopoMojo {
    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Generating Topology Holder");
        if (!this.getTopologyDefinitionFile().exists() || !this.getTopologyDefinitionFile().isFile()) {
            throw new MojoExecutionException("The Topology definition file is not available: " + this.getTopologyDefinitionFile().getAbsolutePath());
        }
        this.getTargetTopologyDir().mkdirs();
        TopologyHolder[] topoHolder = null;
        try {
            topoHolder = this.parseTopologyGenFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("IO Exception with Topology File: " + e.getMessage());
        }
        try {
            this.saveTopologyHolderInfo(topoHolder);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new MojoExecutionException("IO Exception with Topology File: " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException("IO Exception with Topology File: " + e.getMessage());
        }
    }

    private void saveTopologyHolderInfo(TopologyHolder[] topoHolder) throws FileNotFoundException, IOException {
        for (int i = 0; i < topoHolder.length; ++i) {
            String fName = topoHolder[i].getTopologyId();
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(new File(this.getTargetTopologyDir(), fName + ".topo.ser")));
            oos.writeObject(topoHolder[i]);
            oos.close();
        }
    }

    private TopologyHolder[] parseTopologyGenFile() throws IOException, MojoExecutionException {
        String line;
        FileReader fr = new FileReader(this.getTopologyDefinitionFile());
        BufferedReader br = new BufferedReader(fr);
        TopologyHolder[] tpholder = null;
        while ((line = br.readLine()) != null) {
            int i;
            int i2;
            String[] pline;
            this.getLog().info((CharSequence)("READ-LINE: " + line));
            if (line.startsWith("HEADER")) {
                this.getLog().info((CharSequence)"Parsing Header information");
                pline = this.parseTopologyLine(line);
                tpholder = new TopologyHolder[pline.length - 1];
                for (i2 = 1; i2 < pline.length; ++i2) {
                    this.getLog().info((CharSequence)("Parameter Found:" + pline[i2]));
                    tpholder[i2 - 1] = new TopologyHolder(pline[i2]);
                }
                line = br.readLine();
                if (line == null || !line.toUpperCase().startsWith("topologyEnvID".toUpperCase())) {
                    br.close();
                    throw new MojoExecutionException("Problem in the Topology File ... not topologyEnvID entry found");
                }
                pline = null;
                pline = this.parseTopologyLine(line);
                for (i2 = 1; i2 < pline.length; ++i2) {
                    tpholder[i2 - 1].setTopoEnvId(pline[i2]);
                }
            }
            while (line.startsWith("BEGIN-MACHINE")) {
                this.getLog().info((CharSequence)"Machines configuration");
                MachineConfig[] mc = new MachineConfig[tpholder.length];
                for (i = 0; i < mc.length; ++i) {
                    mc[i] = new MachineConfig();
                }
                this.getLog().info((CharSequence)"Init machine config done");
                while ((line = br.readLine()) != null && !line.startsWith("END-MACHINE")) {
                    pline = this.parseTopologyLine(line);
                    this.getLog().info((CharSequence)("mc.length: " + mc.length + " ... pline.lenght: " + pline.length));
                    if (pline[0].toUpperCase().equals("Machine-id".toUpperCase())) {
                        for (i = 1; i < pline.length; ++i) {
                            mc[i - 1].setMachineId(pline[i]);
                        }
                        this.getLog().info((CharSequence)"Handling Machine-id");
                    }
                    if (pline[0].toUpperCase().equals("Alternate-id".toUpperCase())) {
                        for (i = 1; i < pline.length; ++i) {
                            mc[i - 1].addAlternateId(pline[i]);
                        }
                        this.getLog().info((CharSequence)"Handling Alternate-id");
                    }
                    if (pline[0].toUpperCase().equals("LogicalHost".toUpperCase())) {
                        for (i = 1; i < pline.length; ++i) {
                            mc[i - 1].addLogicalHosts(pline[i]);
                        }
                        this.getLog().info((CharSequence)"Handling LogicalHost");
                    }
                    if (pline[0].toUpperCase().equals("Machine-ContainersDir".toUpperCase())) {
                        for (i = 1; i < pline.length; ++i) {
                            mc[i - 1].setContainerDir(pline[i]);
                        }
                        this.getLog().info((CharSequence)"Machine-ContainersDir");
                    }
                    if (pline[0].toUpperCase().equals("Machine-RegisterAsService".toUpperCase())) {
                        for (i = 1; i < pline.length; ++i) {
                            mc[i - 1].setRegisterAsService(pline[i]);
                        }
                        this.getLog().info((CharSequence)"Machine-RegisterAsService");
                    }
                    if (pline[0].toUpperCase().equals("Machine-EncryptPWD".toUpperCase())) {
                        for (i = 1; i < pline.length; ++i) {
                            mc[i - 1].setEncryptPWD(pline[i]);
                        }
                        this.getLog().info((CharSequence)"Handling Machine-EncryptPWD");
                    }
                    if (!pline[0].toUpperCase().equals("Machine-ServiceStartupTimeout".toUpperCase())) continue;
                    for (i = 1; i < pline.length; ++i) {
                        mc[i - 1].setServiceStartupTime(pline[i]);
                    }
                    this.getLog().info((CharSequence)"Handling Machine-ServiceStartupTimeout");
                }
                this.getLog().info((CharSequence)"Need to add Machine configurations here");
                for (i = 0; i < mc.length; ++i) {
                    tpholder[i].getMachineHolder().addMachineConfig(mc[i]);
                }
                this.getLog().info((CharSequence)"Machine configuration is added");
            }
            this.getLog().info((CharSequence)"Machines Are Configured");
            if (line.startsWith("BEGIN-ENVIRONMENT")) {
                this.getLog().info((CharSequence)"Configuring Environment");
                Environment[] env = new Environment[tpholder.length];
                for (i2 = 0; i2 < env.length; ++i2) {
                    env[i2] = new Environment();
                }
                while ((line = br.readLine()) != null && !line.startsWith("END-ENVIRONMENT")) {
                    String[] pline2 = this.parseTopologyLine(line);
                    if (pline2[0].toUpperCase().equals("ContainersDir".toUpperCase())) {
                        for (i = 1; i < pline2.length; ++i) {
                            env[i - 1].setContainerDir(pline2[i]);
                        }
                        this.getLog().info((CharSequence)"ContainersDir");
                    }
                    if (pline2[0].toUpperCase().equals("RegisterAsService".toUpperCase())) {
                        for (i = 1; i < pline2.length; ++i) {
                            env[i - 1].setRegisterAsService(pline2[i]);
                        }
                        this.getLog().info((CharSequence)"RegisterAsService");
                    }
                    if (pline2[0].toUpperCase().equals("EncryptPWD".toUpperCase())) {
                        for (i = 1; i < pline2.length; ++i) {
                            env[i - 1].setEncryptPWD(pline2[i]);
                        }
                        this.getLog().info((CharSequence)"Handling EncryptPWD");
                    }
                    if (!pline2[0].toUpperCase().equals("ServiceStartupTimeout".toUpperCase())) continue;
                    for (i = 1; i < pline2.length; ++i) {
                        env[i - 1].setServiceStartupTime(pline2[i]);
                    }
                    this.getLog().info((CharSequence)"Handling Machine-ServiceStartupTimeout");
                }
                this.getLog().info((CharSequence)"Need to add Environment configurations here");
                for (i2 = 0; i2 < env.length; ++i2) {
                    this.getLog().info((CharSequence)env[i2].toString());
                    tpholder[i2].setEnv(env[i2]);
                }
                this.getLog().info((CharSequence)"Environment configuration is added");
            }
            if (!line.startsWith("BEGIN-PARAMETERS")) continue;
            this.getLog().info((CharSequence)"Starting Parameter Configuration");
            ParameterHolder[] parm = new ParameterHolder[tpholder.length];
            for (i2 = 0; i2 < parm.length; ++i2) {
                parm[i2] = new ParameterHolder();
            }
            while ((line = br.readLine()) != null && !line.startsWith("END-PARAMETERS")) {
                String[] pline3 = this.parseTopologyLine(line);
                for (i = 1; i < pline3.length; ++i) {
                    this.getLog().warn((CharSequence)("pline[0] " + pline3[0] + " --- pline[" + i + "] " + pline3[i]));
                    if (pline3[i].equals("")) {
                        this.getLog().warn((CharSequence)"null token found");
                    }
                    try {
                        parm[i - 1].addParameter("@" + pline3[0] + "@", pline3[i]);
                        continue;
                    }
                    catch (ParameterHandlingException e) {
                        br.close();
                        throw new MojoExecutionException(e.getMessage());
                    }
                }
            }
            this.getLog().info((CharSequence)"Need to add Parameter configurations here");
            for (i2 = 0; i2 < parm.length; ++i2) {
                tpholder[i2].setPholder(parm[i2]);
            }
            this.getLog().info((CharSequence)"Parameter configuration is added");
        }
        for (int i = 0; i < tpholder.length; ++i) {
            this.getLog().info((CharSequence)("Topology entry created for: " + tpholder[i].toString()));
        }
        br.close();
        return tpholder;
    }

    private String[] parseTopologyLine(String line) {
        this.getLog().info((CharSequence)("Parsing: " + line));
        SmartTokenizer st = new SmartTokenizer(line, this.topoFileSeparator);
        String[] retVal = new String[st.countTokens()];
        int index = 0;
        while (st.hasMoreTokens()) {
            retVal[index] = st.nextToken();
            ++index;
        }
        return retVal;
    }
}

