/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.utils;

import com.aurea.maven.plugins.sonic.sdm.container.impl.DefaultServiceType;
import com.aurea.maven.plugins.sonic.utils.FileUtilities;
import com.progress.sonic.utilities.esb.admin.XarAnalyzer;
import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DependencyAnalyzer {
    private String baseDir = null;
    private List<String> serviceJarFiles = null;
    private List<String> serviceCtJarFiles = null;
    private List<String> packagedJarFiles = null;

    public DependencyAnalyzer(String _baseDir) {
        this.baseDir = _baseDir;
    }

    public final String[] getDependencyJars() {
        return FileUtilities.getFileList(this.getJarDependencyDir(), "**/*.jar", null);
    }

    public final List<String> getServiceJarFiles() {
        if (this.serviceJarFiles == null) {
            this.serviceJarFiles = new ArrayList<String>();
            this.serviceCtJarFiles = new ArrayList<String>();
            for (String xarFile : FileUtilities.getFileList(this.getXarDependencyDir(), "**/*.xar", null)) {
                try {
                    XarAnalyzer analyzer = new XarAnalyzer(new File(this.getXarDependencyDir() + "/" + xarFile));
                    for (IArtifact sTypeArtifact : analyzer.getArtifacts(ESBArtifact.SERVICE_TYPE)) {
                        DefaultServiceType sType = new DefaultServiceType();
                        byte[] bytes = analyzer.getContent(sTypeArtifact);
                        String temp = new String(bytes);
                        temp = temp.replace("<xq:selfFirst/>", "<xq:selfFirst>false</xq:selfFirst>");
                        sType.load(new ByteArrayInputStream(temp.getBytes()));
                        this.serviceJarFiles.addAll(sType.getInstanceClasspath());
                        this.serviceJarFiles.addAll(sType.getTypeClasspath());
                        this.serviceJarFiles.addAll(sType.getContainerClasspath());
                        this.serviceCtJarFiles.addAll(sType.getContainerClasspath());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.serviceJarFiles;
    }

    public final List<String> getServiceCtJarFiles() {
        if (this.serviceCtJarFiles == null) {
            this.getServiceJarFiles();
        }
        return this.serviceCtJarFiles;
    }

    public final List<String> getUnpackagedJarFiles() {
        ArrayList<String> result = new ArrayList<String>();
        for (String jarFile : this.getDependencyJars()) {
            String toCompare = "/SonicFS/ESBResources/" + jarFile.replaceAll("\\\\", "/");
            if (this.getPackagedJarFiles().contains(toCompare)) continue;
            result.add(jarFile);
        }
        return result;
    }

    public final List<String> getPackagedJarFiles() {
        if (this.packagedJarFiles == null) {
            this.packagedJarFiles = new ArrayList<String>();
            for (String xarFile : FileUtilities.getFileList(this.getXarDependencyDir(), "**/*.xar", null)) {
                XarAnalyzer analyzer = new XarAnalyzer(new File(this.getXarDependencyDir() + "/" + xarFile));
                try {
                    for (IArtifact jarFile : analyzer.getArtifacts((IArtifact)new SonicFSArtifact("ESBResources/"))) {
                        this.packagedJarFiles.add(jarFile.getArchivePath());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.packagedJarFiles;
    }

    public final List<String> additionalContainerClassPath(String _cpPattern, List<String> _existingClasspath, boolean _ignoreServiceTypeDeps) {
        ArrayList<String> result = new ArrayList<String>();
        if (_existingClasspath != null) {
            result.addAll(_existingClasspath);
        }
        for (String jarFile : this.getDependencyJars()) {
            String jarURL = "sonicfs:///ESBResources/" + jarFile.replaceAll("\\\\", "/");
            if (_ignoreServiceTypeDeps && this.getServiceJarFiles().contains(jarURL) || result.contains(jarURL) || !jarFile.matches(_cpPattern)) continue;
            result.add(jarURL);
        }
        if (!_ignoreServiceTypeDeps) {
            for (String jarURL : this.getServiceCtJarFiles()) {
                String jarFile = jarURL.substring(jarURL.lastIndexOf(47) + 1);
                if (!jarFile.matches(_cpPattern) || result.contains(jarURL)) continue;
                result.add(jarURL);
            }
        }
        return result;
    }

    public final String getXarDependencyDir() {
        return this.baseDir + "/xar";
    }

    public final String getJarDependencyDir() {
        return this.baseDir + "/jar";
    }
}

