/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.esb;

import com.aurea.maven.plugins.sonic.esb.AbstractESBConnectMojo;
import com.aurea.maven.plugins.sonic.utils.FileUtilities;
import com.aurea.maven.plugins.sonic.utils.Xpp3Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class ConnectGenerateMojo
extends AbstractESBConnectMojo {
    protected BuildPluginManager pluginManager;
    protected MavenSession session;

    @Override
    protected final void doExecute() throws MojoExecutionException, MojoFailureException {
        super.doExecute();
        this.generateSonicConnectClient();
    }

    protected void generateSonicConnectClient() throws MojoExecutionException {
        if (this.wadlFiles == null || "".equals(this.wadlFiles)) {
            return;
        }
        if (this.wadlBaseUrl == null) {
            this.wadlBaseUrl = "";
        }
        this.getLog().info((CharSequence)"Generating Sonic Connect client code for WADL files ...");
        String outputDir = this.getOutputDirectory() + "/generated/src/main/java/connect";
        try {
            FileUtils.deleteDirectory((String)outputDir);
            new File(outputDir).mkdirs();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        String[] files = this.wadlFiles.split(",");
        for (int i = 0; i < files.length; ++i) {
            String wadl = files[i];
            ArrayList<MojoExecutor.Element> wadlOptions = new ArrayList<MojoExecutor.Element>();
            MojoExecutor.Element wadlOption = MojoExecutor.element((String)MojoExecutor.name((String)"wadlOption"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"wadl"), (String)wadl)});
            wadlOptions.add(wadlOption);
            File wadlOutputDir = new File(outputDir, "wadl" + i);
            try {
                MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.cxf"), (String)MojoExecutor.artifactId((String)"cxf-wadl2java-plugin"), (String)MojoExecutor.version((String)"3.1.7")), (String)MojoExecutor.goal((String)"wadl2java"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"sourceRoot"), (String)wadlOutputDir.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"defaultOptions"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"packagename"), (String)this.wadlPackage)}), MojoExecutor.element((String)MojoExecutor.name((String)"wadlOptions"), (MojoExecutor.Element[])wadlOptions.toArray(new MojoExecutor.Element[wadlOptions.size()]))}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
            }
            catch (MojoExecutionException ex) {
                ex.printStackTrace();
                throw ex;
            }
            String[] generatedFiles = FileUtilities.getFileList(wadlOutputDir.getAbsolutePath(), "**/*.java", null);
            if (generatedFiles == null || generatedFiles.length == 0) {
                this.getLog().warn((CharSequence)("No generated files found for wadl = " + wadl));
                continue;
            }
            try {
                String basePath = null;
                XmlStreamReader reader = null;
                File wadlFile = new File(wadl);
                if (wadlFile.exists()) {
                    reader = new XmlStreamReader(wadlFile);
                } else {
                    URL wadlUrl = new URL(wadl);
                    reader = new XmlStreamReader(wadlUrl);
                }
                Xpp3Dom dom = Xpp3DomBuilder.build((Reader)reader);
                basePath = (String)Xpp3Utils.evaluateXPath(dom, "//@base", XPathConstants.STRING);
                if (basePath == null) {
                    basePath = this.wadlBaseUrl;
                } else if (!basePath.toLowerCase().startsWith("http")) {
                    basePath = this.wadlBaseUrl + basePath;
                }
                for (String f : generatedFiles) {
                    File javaFile = new File(wadlOutputDir, f);
                    String javaSource = new String(FileUtilities.readFile(javaFile.getAbsolutePath()), "UTF-8");
                    int classDeclaration = this.calculateClassStart(javaSource);
                    if (classDeclaration < 0) {
                        this.getLog().warn((CharSequence)("Can't find a valid class declaration for file = " + javaFile.getAbsolutePath()));
                        continue;
                    }
                    int resourceDeclaration = javaSource.indexOf("@Path");
                    if (resourceDeclaration < 0 || resourceDeclaration > classDeclaration) {
                        this.getLog().warn((CharSequence)("Can't find a valid resource declaration (@Path) for file = " + javaFile.getAbsolutePath()));
                        continue;
                    }
                    int importDeclaration = javaSource.indexOf("import javax.ws.rs.Path");
                    if (importDeclaration < 0) {
                        this.getLog().warn((CharSequence)("Can't find a valid import declaration (javax.ws.rs.Path) for file = " + javaFile.getAbsolutePath()));
                        continue;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(javaSource.substring(0, importDeclaration));
                    sb.append("import com.aurea.sonic.esb.connect.annotation.SonicConnect;\n");
                    sb.append(javaSource.substring(importDeclaration, classDeclaration));
                    sb.append("@SonicConnect(baseUrl = \"" + basePath + "\", client = true)\n");
                    String classSource = javaSource.substring(classDeclaration);
                    classSource = classSource.replace(" root(", " root_method(");
                    classSource = classSource.replace(" application.wadl(", " application_wadl(");
                    sb.append(classSource);
                    try (FileOutputStream fos = new FileOutputStream(javaFile);){
                        fos.write(sb.toString().getBytes());
                    }
                }
                continue;
            }
            catch (IOException | XmlPullParserException e) {
                e.printStackTrace();
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }

    private int calculateClassStart(String javaSource) {
        int classDeclaration = javaSource.indexOf("public interface");
        if (classDeclaration < 0) {
            classDeclaration = javaSource.indexOf("public class");
        }
        return classDeclaration;
    }
}

