/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.sdm;

import com.aurea.maven.plugins.sonic.AbstractSonicMojo;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractSdmMojo
extends AbstractSonicMojo {
    private static final String TOPOLOGY_XSD = "/SDM/schema/2015/Topology.xsd";
    private Set<String> mandatoryElements;

    protected File getTargetSDMDir() {
        return new File(this.getOutputDirectory(), "sonicesb/sdm");
    }

    protected File getGeneratedPropertiesFile() {
        return new File(this.getTargetSDMDir(), "/generated.tailoring.properties");
    }

    protected File getGeneratedTopologyFile() {
        return new File(this.getTargetSDMDir(), "/generated.Topology.xml");
    }

    protected File getMasterTopologyFile() {
        return new File(this.getTargetSDMDir(), "/Topology.xml");
    }

    protected Properties buildPropertiesFromTopology(File topoFile) throws MojoExecutionException {
        try {
            Properties generated = new Properties();
            XmlStreamReader topoReader = new XmlStreamReader(topoFile);
            Xpp3Dom topology = Xpp3DomBuilder.build((Reader)topoReader);
            Xpp3Dom parameters = topology.getChild("Parameters");
            for (Xpp3Dom parameter : parameters.getChildren()) {
                String id = this.getChildElementValue(parameter, "Id");
                String value = this.getChildElementValue(parameter, "Value");
                String string = value = !value.isEmpty() ? value : this.getChildElementValue(parameter, "EncryptedValue");
                if (value.isEmpty()) continue;
                this.getLog().debug((CharSequence)("Adding Property: " + id + " -- " + value));
                generated.put(id, value);
            }
            return generated;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception while reading topology file: " + topoFile.getName(), e);
        }
    }

    protected String getChildElementValue(Xpp3Dom parent, String name) throws ParserConfigurationException, SAXException, IOException, IllegalArgumentException {
        Xpp3Dom childElement = parent.getChild(name);
        if (childElement != null) {
            return childElement.getValue() == null ? "" : childElement.getValue();
        }
        if (!this.getMandatoryElements().contains(name)) {
            return "";
        }
        throw new IllegalArgumentException("Child element " + name + " does not exist in element " + parent.getName());
    }

    private Set<String> getMandatoryElements() throws ParserConfigurationException, SAXException, IOException {
        if (this.mandatoryElements == null) {
            this.mandatoryElements = new HashSet<String>();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            Document document = docBuilder.parse(((Object)((Object)this)).getClass().getResourceAsStream(TOPOLOGY_XSD));
            document.getDocumentElement().normalize();
            NodeList nodes = document.getElementsByTagName("xsd:element");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element item = (Element)nodes.item(i);
                String itemMinOccurrence = item.getAttribute("minOccurs");
                if (itemMinOccurrence == null || itemMinOccurrence.isEmpty() || Integer.parseInt(itemMinOccurrence) <= 0) continue;
                this.mandatoryElements.add(item.getAttribute("name"));
            }
        }
        return this.mandatoryElements;
    }
}

