/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.sdm;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class QueueMapping {
    private String id;
    private final List<String> includes = new ArrayList<String>();
    private final List<String> excludes = new ArrayList<String>();
    private String parameterSetId;
    private boolean suppressJNDI = true;

    public QueueMapping() {
    }

    public QueueMapping(String _id, String _include) {
        this();
        this.setId(_id);
        this.includes.add(_include);
    }

    public QueueMapping(Xpp3Dom _dom) {
        this();
        Xpp3Dom includesElement;
        Xpp3Dom idElement = _dom.getChild("id");
        if (idElement == null) {
            throw new RuntimeException("id element is required in a queueMapping");
        }
        this.setId(_dom.getChild("id").getValue());
        Xpp3Dom parameterSetElement = _dom.getChild("parameterSet");
        if (parameterSetElement != null) {
            this.setParameterSetId(parameterSetElement.getValue());
        }
        if ((includesElement = _dom.getChild("includes")) != null) {
            for (Xpp3Dom includeElement : includesElement.getChildren("include")) {
                this.addInclude(includeElement.getValue());
            }
        } else {
            this.addInclude(".*");
        }
        Xpp3Dom excludesElement = _dom.getChild("excludes");
        if (excludesElement != null) {
            for (Xpp3Dom excludeElement : excludesElement.getChildren("exclude")) {
                this.addExclude(excludeElement.getValue());
            }
        }
    }

    public boolean matches(String _queueName) {
        for (String exclude : this.excludes) {
            if (!_queueName.matches(exclude)) continue;
            return false;
        }
        for (String include : this.includes) {
            if (!_queueName.matches(include)) continue;
            return true;
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String _id) {
        this.id = _id;
    }

    public void addInclude(String _regex) {
        if (_regex == null) {
            throw new IllegalArgumentException("Regex must not be null");
        }
        this.includes.add(_regex);
    }

    public void addExclude(String _regex) {
        if (_regex == null) {
            throw new IllegalArgumentException("Regex must not be null");
        }
        this.excludes.add(_regex);
    }

    public void setParameterSetId(String _parameterSetId) {
        this.parameterSetId = _parameterSetId;
    }

    public String getParameterSetId() {
        return this.parameterSetId;
    }

    public void setSuppressJNDI(boolean _suppressJNDI) {
        this.suppressJNDI = _suppressJNDI;
    }

    public boolean isSuppressJNDI() {
        return this.suppressJNDI;
    }

    public String toString() {
        return String.format("id: %s, includes: %s, excludes: %s", this.getId(), this.includes, this.excludes);
    }
}

