/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.utils;

import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mf.mgmtapi.config.IContainerBean;
import com.sonicsw.mq.mgmtapi.config.IAcceptorTcpsBean;
import com.sonicsw.mq.mgmtapi.config.IAcceptorsBean;
import com.sonicsw.mq.mgmtapi.config.IBrokerBean;
import com.sonicsw.mq.mgmtapi.config.MQMgmtBeanFactory;
import com.sonicsw.mx.config.ConfigServiceException;
import java.io.File;
import java.util.Iterator;
import java.util.List;

public class OffLineDSConfigurator {
    public static void main(String[] _args) {
        OffLineDSConfigurator oldsc = new OffLineDSConfigurator();
        oldsc.go();
    }

    public final void moveDomain(String _from, String _to) {
        File moveFile = null;
        File destDir = new File(_to);
        boolean dsSuccess = false;
        System.out.println("Moving DS");
        moveFile = new File(_from + File.separatorChar + "ds.xml");
        System.out.println("File to move = " + moveFile.getAbsolutePath());
        dsSuccess = moveFile.renameTo(new File(destDir, moveFile.getName()));
        if (dsSuccess) {
            System.out.println("Move of ds.xml completed");
        }
        System.out.println("Moving Store");
        moveFile = new File(_from + File.separatorChar + "SonicMQStore");
        dsSuccess = moveFile.renameTo(new File(destDir, moveFile.getName()));
        if (dsSuccess) {
            System.out.println("Move of SonicMQStore completed");
        }
        System.out.println("Moving Domain1");
        moveFile = new File(_from + File.separatorChar + "Domain1");
        dsSuccess = moveFile.renameTo(new File(destDir, moveFile.getName()));
        if (dsSuccess) {
            System.out.println("Move of Domain1 completed");
        }
        System.out.println("Moving log");
        moveFile = new File(_from + File.separatorChar + "log");
        dsSuccess = moveFile.renameTo(new File(destDir, moveFile.getName()));
        if (dsSuccess) {
            System.out.println("Move of log completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void go() {
        System.out.println("Current Directory: " + System.getProperty("user.dir"));
        MQMgmtBeanFactory domain = new MQMgmtBeanFactory();
        try {
            System.out.println("Connecting to the Domain");
            domain.connect("Domain1", "localhost:3606", "Administrator", "Administrator");
            System.out.println("Domain name = " + domain.getDomain());
            List list = domain.getFolderNames("/");
            System.out.println("number of elements: " + list.size());
            Iterator it = list.iterator();
            System.out.println("Getting Names - Start");
            while (it.hasNext()) {
                System.out.println("Names: " + it.next().toString());
            }
            System.out.println("Getting Names - End");
            list = domain.getBrokerBeanNames();
            System.out.println("number of elements: " + list.size());
            it = list.iterator();
            System.out.println("Getting BrokerNames - Start");
            while (it.hasNext()) {
                System.out.println("Broker Names: " + it.next().toString());
            }
            System.out.println("Getting Broker Names - End");
            System.out.println("Getting the Broker Bean for the Management Broker");
            IBrokerBean broker = domain.getBrokerBean("/Brokers/brManagement");
            System.out.println("Got the bean for: " + broker.getBrokerName());
            System.out.println("Getting the Acceptor Bean");
            IAcceptorsBean.IAcceptorMapType acceptor = broker.getAcceptorsBean().getAcceptors();
            List names = acceptor.getKeyNames();
            for (String name : names) {
                System.out.println("ACCLIST Attributes: " + name);
                if (!name.startsWith("TCP_ACCEPTOR")) continue;
                IAcceptorTcpsBean acc = (IAcceptorTcpsBean)acceptor.getItem(name);
                acc.setAcceptorUrl("tcp://localhost:3506");
            }
            System.out.println("Acceptor port changed");
            System.out.println("Changing ConnectionURLs for the container");
            List containers = domain.getContainerBeanNames();
            for (String name : containers) {
                System.out.println("Container name: " + name);
                if (!name.toUpperCase().endsWith("CTMANAGEMENT")) continue;
                IContainerBean container = domain.getContainerBean(name);
                IContainerBean.IConnectionType connection = container.getConnection();
                connection.setConnectionURLs("tcp://localhost:3506");
                domain.saveContainerBean(container);
            }
            System.out.println("Disconnecting from the Domain");
            domain.commit();
            domain.flush();
            domain.disconnect();
            domain = null;
            System.gc();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (MgmtException e) {
            e.printStackTrace();
        }
        catch (ConfigServiceException e) {
            e.printStackTrace();
        }
    }
}

