/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.sdm;

import com.aurea.maven.plugins.sonic.sdm.AbstractSdmMojo;
import com.aurea.maven.plugins.sonic.sdm.QueueMapping;
import com.aurea.maven.plugins.sonic.sdm.QueueMappings;
import com.aurea.maven.plugins.sonic.sdm.container.IContainerSetting;
import com.aurea.maven.plugins.sonic.sdm.container.IESBContainer;
import com.aurea.maven.plugins.sonic.sdm.container.IIncludePattern;
import com.aurea.maven.plugins.sonic.sdm.container.IMFContainer;
import com.aurea.maven.plugins.sonic.sdm.container.impl.DefaultContainerMap;
import com.aurea.maven.plugins.sonic.sdm.container.impl.DefaultContainerSetting;
import com.aurea.maven.plugins.sonic.sdm.container.impl.DefaultESBContainer;
import com.aurea.maven.plugins.sonic.sdm.container.impl.DefaultIncludePattern;
import com.aurea.maven.plugins.sonic.sdm.container.impl.DefaultMFContainer;
import com.aurea.maven.plugins.sonic.topology.utils.ParameterHandlingException;
import com.aurea.maven.plugins.sonic.topology.utils.TopologyHolder;
import com.aurea.maven.plugins.sonic.utils.DependencyAnalyzer;
import com.aurea.maven.plugins.sonic.utils.FileUtilities;
import com.aurea.maven.plugins.sonic.utils.Xpp3Utils;
import commonj.sdo.DataObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import no.geosoft.cc.util.SmartTokenizer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import org.xml.sax.SAXException;

public class SdmGenerateModelMojo
extends AbstractSdmMojo {
    private MavenSession session;
    protected BuildPluginManager pluginManager;
    protected String sonicTarget;
    protected File containerPropFile;
    protected boolean isInlineGeneration;
    protected String eSBContainerClasspathOverride;
    protected File queueMappingsFile;
    protected boolean forcePropertyGeneration;
    protected ArchiverManager archiverManager;
    protected File topogenDir;
    protected DefaultContainerMap containerMap;
    private Collection<IESBContainer> esbContainers;
    private Collection<IESBContainer> cleanEsbContainer;
    private DependencyAnalyzer depAnalyzer = null;
    private HashMap<String, String> ContainerIncludeFiles;
    private ArrayList<String> containerSubst;
    private static final String DEFAULT_SDM_HOST_VALUE = "ESBHost";
    private static final String DEFAULT_XAR_HOST_VALUE = "XARHost";
    HashMap<String, ArrayList<String>> ESBtoMFMapping = new HashMap();

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().info((CharSequence)"Generating updated SDM model ...");
            this.getTargetSDMDir().mkdirs();
            File depdir = new File(this.getDependencyDirectory(), this.topogenDir.getName());
            if (!depdir.exists()) {
                this.performOldResourceHandling();
                this.createSDMModel();
                this.createTopology();
                this.generateMasterTopology();
                if (this.forcePropertyGeneration) {
                    this.createProperties();
                }
            } else {
                this.performNewResourceHandling();
                this.createSDMModel();
                this.createTopologyWithDefault();
                this.generateMasterTopologyFromDefaultTopology();
                if (this.forcePropertyGeneration) {
                    this.createProperties();
                }
            }
        }
        catch (MojoExecutionException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error creating SDM Model - " + e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error creating SDM Model - " + e.getMessage(), e);
        }
    }

    private void updateTailoringProperties() throws MojoExecutionException {
        Properties generatedProperties = null;
        Properties updateProperties = null;
        try {
            generatedProperties = new Properties();
            FileInputStream fis = new FileInputStream(this.getGeneratedPropertiesFile());
            generatedProperties.load(fis);
            fis.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not read generated properties files: " + this.getGeneratedPropertiesFile());
        }
        for (String toUpdate : FileUtilities.getFileList(this.getTargetSDMDir().getAbsolutePath(), "*.tailoring.properties", "generated.tailoring.properties")) {
            try {
                this.getLog().info((CharSequence)"------------------------------------------------------------------------");
                this.getLog().info((CharSequence)("Updating property file: " + toUpdate));
                updateProperties = new Properties();
                FileInputStream fis = new FileInputStream(this.getTargetSDMDir() + "/" + toUpdate);
                updateProperties.load(fis);
                fis.close();
                boolean updated = false;
                for (Object parameter : generatedProperties.keySet()) {
                    String parameterName = parameter.toString();
                    if (updateProperties.containsKey(parameterName)) continue;
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Found " + parameterName + " property with value " + generatedProperties.getProperty(parameterName)));
                    }
                    updateProperties.put(parameterName, generatedProperties.getProperty(parameterName));
                    updated = true;
                }
                if (!updated) continue;
                Properties sortedProperties = new Properties(){

                    @Override
                    public synchronized Enumeration<Object> keys() {
                        return Collections.enumeration(new TreeSet<Object>(super.keySet()));
                    }
                };
                sortedProperties.putAll((Map<?, ?>)updateProperties);
                try (FileOutputStream fos = new FileOutputStream(this.getTargetSDMDir() + "/" + toUpdate);){
                    sortedProperties.store(fos, "Generated by maven-sonicesb-plugin:sdm-generate-model");
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Could not read " + this.getTargetSDMDir() + "/" + toUpdate));
            }
        }
    }

    private void generateMasterTopologyFromDefaultTopology() throws Exception {
        File topo = this.getMasterTopologyFile();
        if (topo.exists()) {
            this.getLog().info((CharSequence)"Topology file is existing ... will NOT Override");
            return;
        }
        Properties props = this.assemblePropertyList();
        TopologyHolder tHolder = this.getTopologyHolder(new File(this.getDependencyDirectory(), this.getTargetTopologyDir().getName() + File.separator + this.defaultTopologyPrefix + ".topo.ser"));
        TreeSet<String> propNames = new TreeSet<String>();
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            propNames.add((String)en.nextElement());
        }
        this.getLog().info((CharSequence)"Topology File not found ... Generating new Master Topology File");
        Xpp3Dom topology = new Xpp3Dom("Topology");
        Xpp3Dom includeDom = new Xpp3Dom("Id");
        Xpp3Dom parameters = new Xpp3Dom("Parameters");
        Xpp3Dom paramId = null;
        Xpp3Dom defaultValue = null;
        Xpp3Dom parameter = null;
        topology.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        topology.setAttribute("xsi:noNamespaceSchemaLocation", "Topology.xsd");
        topology.setAttribute("xmlns:xi", "http://www.w3.org/2001/XInclude");
        for (String key : propNames) {
            block6: {
                parameter = new Xpp3Dom("Parameter");
                paramId = new Xpp3Dom("Id");
                paramId.setValue(key);
                defaultValue = new Xpp3Dom("DefaultValue");
                try {
                    defaultValue.setValue(tHolder.getPholder().getParameter(key));
                    this.getLog().debug((CharSequence)("Master Topo Parameter found ...  " + key));
                }
                catch (ParameterHandlingException e) {
                    this.getLog().debug((CharSequence)("Master Topo Parameter not found ... setting default from xml : " + key));
                    String keyValue = props.getProperty(key);
                    if (keyValue == null) break block6;
                    defaultValue.setValue(props.getProperty(key));
                }
            }
            parameter.addChild(paramId);
            parameter.addChild(defaultValue);
            parameters.addChild(parameter);
        }
        topology.addChild(parameters);
        for (String toCompare : FileUtilities.getFileList(this.getTargetSDMDir().getAbsolutePath(), "*.Topology.xml", "generated.Topology.xml")) {
            includeDom = new Xpp3Dom("xi:include");
            includeDom.setAttribute("href", toCompare);
            topology.addChild(includeDom);
        }
        Xpp3Dom environment = new Xpp3Dom("Environment");
        Xpp3Dom envId = new Xpp3Dom("Id");
        envId.setValue("default");
        environment.addChild(envId);
        Xpp3Dom machines = new Xpp3Dom("Machines");
        Xpp3Dom machine = new Xpp3Dom("Machine");
        Xpp3Dom machineId = new Xpp3Dom("Id");
        machineId.setValue("localhost");
        machine.addChild(machineId);
        Xpp3Dom altId = new Xpp3Dom("AlternateId");
        altId.setValue("127.0.0.1");
        machine.addChild(altId);
        Xpp3Dom altId2 = new Xpp3Dom("AlternateId");
        altId2.setValue("::1");
        machine.addChild(altId2);
        machines.addChild(machine);
        environment.addChild(machines);
        topology.addChild(environment);
        FileUtilities.writeFile(topology.toString().getBytes(), this.getMasterTopologyFile());
    }

    private Properties assemblePropertyList() throws Exception {
        Xpp3Dom tunemodelDom;
        XmlStreamReader tunereader;
        File tunefile;
        Properties props = new Properties();
        ArrayList<String> varNames = new ArrayList<String>();
        XmlStreamReader reader = new XmlStreamReader(new File(this.getTargetSDMDir(), "Model.xml"));
        Xpp3Dom modelDom = Xpp3DomBuilder.build((Reader)reader);
        this.getVariableNamesFromModel(modelDom, varNames);
        File propfile = new File(this.getTargetSDMDir(), "DefaultTuning.xml");
        if (propfile.exists()) {
            XmlStreamReader propreader = new XmlStreamReader(new File(this.getTargetSDMDir(), "DefaultTuning.xml"));
            Xpp3Dom propmodelDom = Xpp3DomBuilder.build((Reader)propreader);
            this.getVariableNamesFromModel(propmodelDom, varNames);
        }
        if ((tunefile = new File(this.getTargetSDMDir(), "Tuning.xml")).exists()) {
            tunereader = new XmlStreamReader(new File(this.getTargetSDMDir(), "Tuning.xml"));
            tunemodelDom = Xpp3DomBuilder.build((Reader)tunereader);
            this.getVariableNamesFromModel(tunemodelDom, varNames);
        }
        if (this.containerPropFile.exists()) {
            this.getLog().debug((CharSequence)"CHECKING THE CONTAINER PROPERTIES FILE");
            tunereader = new XmlStreamReader(this.containerPropFile);
            tunemodelDom = Xpp3DomBuilder.build((Reader)tunereader);
            this.getVariableNamesFromModel(tunemodelDom, varNames);
        }
        for (String varName : varNames) {
            this.getLog().info((CharSequence)("Found Variable Name: " + varName));
            props.put(varName, "");
        }
        for (Xpp3Dom variable : Xpp3Utils.collectElements(this.getDependencyDirectory(), "**/*.variables.snippet")) {
            String name = variable.getAttribute("name");
            String value = variable.getValue();
            this.getLog().debug((CharSequence)("Setting variable: [" + name + "] = [" + value + "]"));
            props.put(name, value != null ? value : "");
        }
        return props;
    }

    private TopologyHolder getTopologyHolder(File fileName) throws Exception {
        TopologyHolder tHolder = null;
        File topoDefault = fileName;
        try (ObjectInputStream ois = null;){
            ois = new ObjectInputStream(new FileInputStream(topoDefault));
            tHolder = (TopologyHolder)ois.readObject();
        }
        return tHolder;
    }

    private void createTopologyWithDefault() throws Exception {
        File[] topoFiles;
        TopologyHolder tHolder = this.getTopologyHolder(new File(this.getDependencyDirectory(), this.getTargetTopologyDir().getName() + File.separator + this.defaultTopologyPrefix + ".topo.ser"));
        this.getLog().info((CharSequence)"Creating generated.Topology.xml");
        Properties props = this.assemblePropertyList();
        TreeSet<String> propNames = new TreeSet<String>();
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            propNames.add((String)en.nextElement());
        }
        Xpp3Dom topology = new Xpp3Dom("Environment");
        Xpp3Dom id = new Xpp3Dom("Id");
        Xpp3Dom machines = new Xpp3Dom("Machines");
        Xpp3Dom machine = new Xpp3Dom("Machine");
        Xpp3Dom parameters = new Xpp3Dom("Parameters");
        id.setValue("GeneratedTopology");
        topology.addChild(id);
        machines.addChild(machine);
        Xpp3Dom element = null;
        Xpp3Dom child = null;
        Xpp3Dom paramId = null;
        Xpp3Dom defaultValue = null;
        Xpp3Dom parameter = null;
        element = new Xpp3Dom("Id");
        element.setValue("Generated_Machine");
        machine.addChild(element);
        element = new Xpp3Dom("AlternateId");
        element.setValue("Generated_Alternate");
        machine.addChild(element);
        element = new Xpp3Dom("LogicalHosts");
        machine.addChild(element);
        child = new Xpp3Dom("LogicalHost");
        child.setValue("GeneratedHost");
        element.addChild(child);
        element = new Xpp3Dom("Settings");
        topology.addChild(machines);
        topology.addChild(element);
        topology.addChild(parameters);
        for (String key : propNames) {
            parameter = new Xpp3Dom("Parameter");
            paramId = new Xpp3Dom("Id");
            paramId.setValue(key);
            defaultValue = new Xpp3Dom("Value");
            try {
                defaultValue.setValue(tHolder.getPholder().getParameter(key));
                this.getLog().debug((CharSequence)("Parameter found ...  " + key));
            }
            catch (ParameterHandlingException e) {
                this.getLog().debug((CharSequence)("Parameter not found ... setting default from xml : " + key));
                defaultValue.setValue(props.getProperty(key));
            }
            parameter.addChild(paramId);
            parameter.addChild(defaultValue);
            parameters.addChild(parameter);
        }
        FileUtilities.writeFile(topology.toString().getBytes(), this.getGeneratedTopologyFile());
        this.getLog().info((CharSequence)"Building the remaining Topology Files as they are found in the /toplogy Directory");
        File topodir = new File(this.getDependencyDirectory(), this.getTargetTopologyDir().getName());
        FilenameFilter myFileNameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".topo.ser") && !name.equals(SdmGenerateModelMojo.this.defaultTopologyPrefix + ".topo.ser");
            }
        };
        for (File file : topoFiles = topodir.listFiles(myFileNameFilter)) {
            this.getLog().info((CharSequence)("Topo Ser File Found: " + file.getName()));
            TopologyHolder envTopoHolder = this.getTopologyHolder(new File(this.getDependencyDirectory(), this.getTargetTopologyDir().getName() + File.separator + file.getName()));
            this.getLog().info((CharSequence)("Creating " + file.getName() + ".Topology.xml files"));
            String topoenv = envTopoHolder.createEnvironmentTopology(tHolder, propNames);
            FileUtilities.writeFile(topoenv.getBytes(), this.getTargetSDMDir() + File.separator + envTopoHolder.getTopologyId() + ".Topology.xml");
        }
    }

    private void performNewResourceHandling() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Copying resources from " + this.getSonicEsbSourceDirectory() + " to " + this.getTargetSDMDir().getAbsolutePath()));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)"2.4.3")), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)this.getTargetSDMDir().getAbsolutePath()), MojoExecutor.element((String)"resources", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"resource", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"directory", (String)this.getSonicEsbSourceDirectory().getAbsolutePath()), MojoExecutor.element((String)"excludes", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"exclude", (String)this.containerPropFile.getName()), MojoExecutor.element((String)"exclude", (String)this.queueMappingsFile.getName()), MojoExecutor.element((String)"exclude", (String)"*.Topology.xml")}), MojoExecutor.element((String)"filtering", (String)"false")})})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        this.getLog().info((CharSequence)"Filtering the following resources: Model.xml");
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)"2.4.3")), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)this.getTargetSDMDir().getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"overwrite"), (String)"true"), MojoExecutor.element((String)"escapeString", (String)"\\"), MojoExecutor.element((String)"resources", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"resource", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"directory", (String)this.getSonicEsbSourceDirectory().getAbsolutePath()), MojoExecutor.element((String)"includes", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"include", (String)"Model.xml"), MojoExecutor.element((String)"include", (String)"*.properties"), MojoExecutor.element((String)"include", (String)"*Deletes.xml"), MojoExecutor.element((String)"include", (String)"*Rollback.xml")}), MojoExecutor.element((String)"filtering", (String)"true")})})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        this.getLog().info((CharSequence)"Filtering the following resources: Tuning.xml");
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)"2.4.3")), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)this.getTargetSDMDir().getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"overwrite"), (String)"true"), MojoExecutor.element((String)"escapeString", (String)"\\"), MojoExecutor.element((String)"resources", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"resource", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"directory", (String)this.getSonicEsbSourceDirectory().getAbsolutePath()), MojoExecutor.element((String)"includes", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"include", (String)"Tuning.xml")}), MojoExecutor.element((String)"filtering", (String)"false")})})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    private void performOldResourceHandling() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Copying resources from " + this.getSonicEsbSourceDirectory() + " to " + this.getTargetSDMDir().getAbsolutePath()));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)"2.4.3")), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)this.getTargetSDMDir().getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"overwrite"), (String)"true"), MojoExecutor.element((String)"resources", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"resource", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"directory", (String)this.getSonicEsbSourceDirectory().getAbsolutePath()), MojoExecutor.element((String)"excludes", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"exclude", (String)this.containerPropFile.getName()), MojoExecutor.element((String)"exclude", (String)this.queueMappingsFile.getName())}), MojoExecutor.element((String)"filtering", (String)"false")})})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        this.getLog().info((CharSequence)"Filtering the following resources: Model.xml");
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)"2.4.3")), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)this.getTargetSDMDir().getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"overwrite"), (String)"true"), MojoExecutor.element((String)"escapeString", (String)"\\"), MojoExecutor.element((String)"resources", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"resource", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"directory", (String)this.getSonicEsbSourceDirectory().getAbsolutePath()), MojoExecutor.element((String)"includes", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"include", (String)"Model.xml"), MojoExecutor.element((String)"include", (String)"*.properties"), MojoExecutor.element((String)"include", (String)"*Deletes.xml"), MojoExecutor.element((String)"include", (String)"*Rollback.xml")}), MojoExecutor.element((String)"filtering", (String)"true")})})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    private void createSDMModel() throws Exception {
        this.getLog().info((CharSequence)"Relocating the Xar Generation code ...");
        if (this.isInlineGeneration) {
            this.generateESBContainerIncludes();
            this.generateCleanESBContainerXar();
        } else {
            this.generateContainerXar();
        }
        this.getLog().debug((CharSequence)"Creating SDM model from the sources...");
        File sdmDir = new File(this.getTargetSDMDir().getAbsolutePath());
        sdmDir.mkdirs();
        this.getLog().debug((CharSequence)"Collecting XAR archives from dependencies...");
        this.copyXarArchives();
        this.getLog().debug((CharSequence)"Rewriting SDM Model to reflect dependencies...");
        this.injectSDMSettings();
    }

    private void generateCleanESBContainerXar() throws Exception {
        this.getLog().info((CharSequence)"Creating Clean xar archive for the ESBContainers");
        String xarDirectory = this.getPackageXarDir();
        new File(xarDirectory, "ESB/Containers").mkdirs();
        new File(xarDirectory, "SonicFS").mkdirs();
        HashMap<String, String> instanceReplaceMaps = new HashMap<String, String>();
        for (IESBContainer container : this.getCleanESBContainerSettings(false, instanceReplaceMaps)) {
            String fileName = container.getName() + ".xml";
            FileUtilities.writeFile(container.toString().getBytes(), xarDirectory + "/ESB/Containers/" + fileName);
        }
        File xarFile = new File(this.getTargetSDMDir(), "xars/" + this.getFinalAssemblyBaseName() + ".xar");
        Archiver archiver = this.archiverManager.getArchiver("zip");
        archiver.setDestFile(xarFile);
        archiver.addDirectory(new File(xarDirectory));
        this.getLog().info((CharSequence)("Creating the archive " + xarFile.getAbsolutePath()));
        archiver.createArchive();
        for (String key : instanceReplaceMaps.keySet()) {
            this.getLog().debug((CharSequence)("Replacing: " + key + " with: " + instanceReplaceMaps.get(key)));
        }
        if (!instanceReplaceMaps.isEmpty()) {
            this.createCleanESBContainerTailoring(instanceReplaceMaps);
        }
    }

    private void createCleanESBContainerTailoring(HashMap<String, String> instanceReplaceMaps) {
        File outputFile = new File(this.getTargetSDMDir(), "xars" + File.separatorChar + "tailor" + File.separatorChar + this.getFinalAssemblyBaseName() + ".xar.xml");
        File outputDir = new File(this.getTargetSDMDir(), "xars" + File.separatorChar + "tailor");
        if (!outputDir.exists()) {
            outputDir.mkdirs();
            this.getLog().debug((CharSequence)"CREATED DIRECTORY for TAILORING");
        }
        Xpp3Dom tailorMap = new Xpp3Dom("TailoringMaps");
        tailorMap.setAttribute("xmlns", "http://www.sonicsw.com/sonicxq");
        tailorMap.setAttribute("version", "TailorMap8.0");
        tailorMap.addChild(new Xpp3Dom("ProcessMaps"));
        tailorMap.addChild(new Xpp3Dom("ServiceMaps"));
        tailorMap.addChild(new Xpp3Dom("EndpointMaps"));
        tailorMap.addChild(new Xpp3Dom("ConnectionMaps"));
        Xpp3Dom stringReplaceMaps = new Xpp3Dom("StringReplaceMaps");
        stringReplaceMaps.setAttribute("xmlns:xi", "http://www.w3.org/2001/XMLSchema-instance");
        for (String key : instanceReplaceMaps.keySet()) {
            Xpp3Dom map = new Xpp3Dom("stringReplaceMap");
            map.setAttribute("updatedName", instanceReplaceMaps.get(key));
            map.setAttribute("name", key);
            stringReplaceMaps.addChild(map);
        }
        tailorMap.addChild(stringReplaceMaps);
        this.getLog().debug((CharSequence)("WRITING FILE " + outputFile));
        FileUtilities.writeFile(tailorMap.toString().getBytes(), outputFile);
    }

    private Collection<IESBContainer> getCleanESBContainerSettings(boolean inLine, HashMap<String, String> instanceReplaceMaps) throws Exception {
        if (this.cleanEsbContainer == null) {
            ArrayList[] configs = this.readESBContainerConfiguration();
            this.getLog().debug((CharSequence)"Adding Clean External ESB Configuration - Start");
            ArrayList esbConfig = configs[0];
            for (IContainerSetting container : esbConfig) {
                this.containerMap.getESBContainerSettings().remove(container);
                this.containerMap.getESBContainerSettings().add(container);
            }
            this.getLog().info((CharSequence)("ESB Clean container mapping: " + this.containerMap.getESBContainerSettings()));
            ArrayList mfConfig = configs[1];
            for (IContainerSetting container : mfConfig) {
                this.containerMap.getMFContainerSettings().remove(container);
                this.containerMap.getMFContainerSettings().add(container);
            }
            this.getLog().debug((CharSequence)("MF container mapping: " + this.containerMap.getMFContainerSettings()));
            this.getLog().debug((CharSequence)"Adding External ESB Configuration - Done");
            HashMap<String, IESBContainer> esbContainerMap = new HashMap<String, IESBContainer>();
            this.getLog().info((CharSequence)"---------------------------------------------");
            this.getLog().debug((CharSequence)"Building Container settings for SDM model...");
            List<Xpp3Dom> serviceInstances = Xpp3Utils.collectElements(this.getDependencyDirectory(), "**/*.instances.snippet");
            for (Xpp3Dom serviceInstance : serviceInstances) {
                String containerHint = serviceInstance.getAttribute("hint");
                this.getLog().debug((CharSequence)("Matching service instance " + serviceInstance.getAttribute("name") + "/" + serviceInstance.getAttribute("process") + "\r\n\t(containerHint: " + containerHint + ")"));
                if (this.containerMap == null) {
                    throw new Exception("containerMap not specified in plugin configuration");
                }
                Map<String, Properties> matches = this.containerMap.matchESBContainerSettings(containerHint);
                if (matches.size() == 0 && this.containerMap.isUseESBDefaultIncludes()) {
                    this.getLog().warn((CharSequence)"No matching ESBContainer setting found...will use default...");
                    matches.put(this.containerMap.getDefaultESBContainerSetting().getName(), new Properties());
                }
                for (String matchedName : matches.keySet()) {
                    this.addCleanServiceInstance(esbContainerMap, matchedName, serviceInstance, matches.get(matchedName), inLine, instanceReplaceMaps);
                }
            }
            this.cleanEsbContainer = esbContainerMap.values();
        }
        return this.cleanEsbContainer;
    }

    private void copyXarArchives() throws Exception {
        String[] xarFiles;
        String xarBaseDirectory = this.getDepAnalyzer().getXarDependencyDir() + "/compile";
        for (String xarFileName : xarFiles = FileUtilities.getFileList(xarBaseDirectory, "**/*.xar", null)) {
            File xarDir = new File(xarBaseDirectory, xarFileName).getParentFile();
            FileUtilities.copyFiles(xarDir.getAbsolutePath(), this.getTargetSDMDir() + "/xars", null, "sdm-snippets/*.snippet", null, false);
        }
    }

    private void injectSDMSettings() throws Exception {
        File sdmFile = new File(this.getTargetSDMDir(), "Model.xml");
        XmlStreamReader sdmReader = new XmlStreamReader(sdmFile);
        Xpp3Dom sdmDom = Xpp3DomBuilder.build((Reader)sdmReader);
        this.setModelVersion(sdmDom);
        this.assignQueues(sdmDom);
        for (String xarAchive : FileUtilities.getFileList(this.getTargetSDMDir() + "/xars", "**/*.xar", null)) {
            Xpp3Dom elem = new Xpp3Dom("ESBArchive");
            String archiveName = new File(this.getTargetSDMDir(), xarAchive).getName();
            this.getLog().info((CharSequence)("Adding XAR archive SDM package: " + archiveName));
            Xpp3Dom hosts = new Xpp3Dom("LogicalHosts");
            hosts.addChild(Xpp3Utils.createXpp3Dom("LogicalHost", DEFAULT_XAR_HOST_VALUE));
            elem.addChild(hosts);
            elem.addChild(Xpp3Utils.createXpp3Dom("Id", archiveName));
            sdmDom.addChild(elem);
        }
        if (this.isInlineGeneration) {
            this.getLog().info((CharSequence)"Lookup of the Includes for the Model.xml file");
            File includeDir = new File(this.getTargetSDMDir() + File.separator + "modelincludes");
            if (includeDir.exists()) {
                sdmDom.setAttribute("xmlns:xi", "http://www.w3.org/2001/XInclude");
                this.getLog().debug((CharSequence)"TBO2 ------------ INCLUDES DIR FOUND .... TEST");
                File[] content = includeDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith("_inc_model.xml");
                    }
                });
                this.getLog().debug((CharSequence)"FINDING THE FILES AND THE KEYS");
                for (String key : this.ContainerIncludeFiles.keySet()) {
                    String value = this.ContainerIncludeFiles.get(key);
                    this.getLog().debug((CharSequence)("Found key " + key + " : " + value));
                }
                this.getLog().debug((CharSequence)"END FINDING THE FILES AND THE KEYS");
                this.getLog().debug((CharSequence)"FINDING THE Model AND THE KEYS");
                this.replaceMFESBContainers(sdmDom);
                for (int i = 0; i < content.length; ++i) {
                    this.getLog().debug((CharSequence)("Filename Found: " + content[i].getName() + " --- " + content[i].getPath()));
                    if (this.containerSubst != null && this.containerSubst.contains(content[i].getName())) {
                        this.getLog().info((CharSequence)("href already included ... " + content[i].getName() + " Will skip generic include"));
                        continue;
                    }
                    Xpp3Dom includeDom = new Xpp3Dom("xi:include");
                    includeDom.setAttribute("href", "modelincludes/" + content[i].getName());
                    sdmDom.addChild(includeDom);
                }
                File tuningFile = new File(this.getTargetSDMDir(), "Tuning.xml");
                XmlStreamReader tuningReader = new XmlStreamReader(tuningFile);
                Xpp3Dom tuningDom = Xpp3DomBuilder.build((Reader)tuningReader);
                tuningDom.setAttribute("xmlns:xi", "http://www.w3.org/2001/XInclude");
                File[] tuningctnt = includeDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith("_inc_tuning.xml");
                    }
                });
                for (int i = 0; i < tuningctnt.length; ++i) {
                    this.getLog().debug((CharSequence)("Filename Found: " + tuningctnt[i].getName() + " --- " + tuningctnt[i].getPath()));
                    Xpp3Dom includeDom = new Xpp3Dom("xi:include");
                    includeDom.setAttribute("href", "modelincludes/" + tuningctnt[i].getName());
                    tuningDom.addChild(includeDom);
                }
                FileUtilities.writeFile(tuningDom.toString().getBytes(), tuningFile.getAbsolutePath());
            }
        } else {
            this.getLog().info((CharSequence)"Generating the container.xml old fashion style");
            for (Xpp3Dom mfContainer : this.getMFContainerSettings()) {
                Map<String, Properties> map = this.containerMap.matchMFContainerSettings(mfContainer.getChild("Id").getValue());
                Properties props = map.get(mfContainer.getChild("TargetContainer").getValue());
                String segment = (String)props.get("Segment");
                if (segment != null && !segment.equals("")) {
                    Xpp3Dom segmentElement = new Xpp3Dom("Segment");
                    Xpp3Dom segID = new Xpp3Dom("Id");
                    segID.setValue(segment);
                    segmentElement.addChild(segID);
                    segmentElement.addChild(mfContainer);
                    sdmDom.addChild(segmentElement);
                    continue;
                }
                sdmDom.addChild(mfContainer);
            }
        }
        FileUtilities.writeFile(sdmDom.toString().getBytes(), sdmFile.getAbsolutePath());
    }

    private void replaceMFESBContainers(Xpp3Dom sdmDom) {
        Xpp3Dom[] elements = sdmDom.getChildren();
        for (int i = 0; i < elements.length; ++i) {
            this.handleESBIncludeElements(elements[i]);
        }
    }

    private void handleESBIncludeElements(Xpp3Dom element) {
        String ref;
        this.getLog().debug((CharSequence)("Element Name: " + element.getName()));
        if (element.getName().equals("xi:include") && (ref = element.getAttribute("href")) != null && ref.startsWith("mfesbcontainer/")) {
            this.getLog().debug((CharSequence)"Found a substitute");
            String mykey = ref.substring("mfesbcontainer/".length());
            this.getLog().debug((CharSequence)("Finding the key value " + mykey));
            if (!this.ESBtoMFMapping.containsKey(mykey)) {
                element.setAttribute("href", "ERROR: No Containers found for key " + mykey);
            } else {
                boolean primFlag = true;
                ArrayList<String> esbContainers = this.ESBtoMFMapping.get(mykey);
                for (String ctn : esbContainers) {
                    this.getLog().info((CharSequence)("Found Containers for " + mykey + " : " + ctn));
                    if (primFlag) {
                        element.setAttribute("href", "modelincludes/" + ctn + "_" + mykey + "_inc_model.xml");
                        primFlag = false;
                    } else {
                        Xpp3Dom newref = new Xpp3Dom("xi:include");
                        newref.setAttribute("href", "modelincludes/" + ctn + "_" + mykey + "_inc_model.xml");
                        element.getParent().addChild(newref);
                    }
                    if (this.containerSubst == null) {
                        this.containerSubst = new ArrayList();
                    }
                    this.containerSubst.add(ctn + "_" + mykey + "_inc_model.xml");
                }
            }
        }
        Xpp3Dom[] elements = element.getChildren();
        for (int i = 0; i < elements.length; ++i) {
            this.handleESBIncludeElements(elements[i]);
        }
    }

    private void setModelVersion(Xpp3Dom sdmDom) {
        Xpp3Dom modelNameElement = new Xpp3Dom("ModelName");
        modelNameElement.setValue(this.project.getName());
        Xpp3Dom versionElement = new Xpp3Dom("Version");
        versionElement.setValue(this.project.getVersion());
        Xpp3Dom descriptionElement = new Xpp3Dom("Description");
        descriptionElement.setValue(this.project.getDescription());
        Xpp3Dom generalConfig = sdmDom.getChild("GeneralConfig");
        while (generalConfig.getChildCount() != 0) {
            generalConfig.removeChild(0);
        }
        generalConfig.addChild(modelNameElement);
        generalConfig.addChild(versionElement);
        generalConfig.addChild(descriptionElement);
    }

    private void assignQueues(Xpp3Dom _sdmDom) throws Exception {
        Xpp3Dom defaultInsertPoint = _sdmDom.getChild("Queues");
        if (defaultInsertPoint == null) {
            _sdmDom.addChild(Xpp3Utils.createXpp3Dom("Queues"));
            defaultInsertPoint = _sdmDom.getChild("Queues");
            defaultInsertPoint.addChild(Xpp3Utils.createXpp3Dom("Id", "Queues"));
        }
        QueueMappings queueMappings = this.readQueueMappings(defaultInsertPoint.getChild("Id").getValue());
        this.getLog().info((CharSequence)queueMappings.toString());
        List<Xpp3Dom> queues = Xpp3Utils.collectElements(this.getDependencyDirectory(), "**/*.queues.snippet");
        queues = Xpp3Utils.unifyXpp3List(queues, "/Queue/Id/text()");
        this.getLog().info((CharSequence)("Assigning " + queues.size() + " queues"));
        for (Xpp3Dom queue : queues) {
            String queueName = queue.getChild("Id").getValue();
            if (queueName.contains("::")) {
                this.getLog().warn((CharSequence)String.format("Skipping queue '%s' because it references a remote queue.", queueName));
                continue;
            }
            QueueMapping queueMapping = queueMappings.getMappingForQueue(queueName);
            if (queueMapping.getParameterSetId() != null) {
                queue.addChild(Xpp3Utils.createXpp3Dom("ParameterSet", queueMapping.getParameterSetId()));
            }
            this.getLog().debug((CharSequence)String.format("Adding queue %s to %s", queueName, queueMapping.getId()));
            Xpp3Dom queuesElement = this.findQueuesElementWithId(_sdmDom, queueMapping.getId());
            if (queuesElement == null) {
                throw new MojoExecutionException(String.format("Cannot add queue %s, queues element %s does not exist.", queueName, queueMapping.getId()));
            }
            queuesElement.addChild(queue);
        }
    }

    private Xpp3Dom findQueuesElementWithId(Xpp3Dom _sdmDom, String _id) {
        Xpp3Dom[] queuesElements;
        for (Xpp3Dom queuesElement : queuesElements = _sdmDom.getChildren("Queues")) {
            Xpp3Dom idElement = queuesElement.getChild("Id");
            if (idElement == null || !_id.equals(idElement.getValue())) continue;
            return queuesElement;
        }
        return null;
    }

    private QueueMappings readQueueMappings(String _defaultQueuesElement) throws MojoExecutionException {
        if (this.queueMappingsFile == null || !this.queueMappingsFile.canRead()) {
            String fileName = this.queueMappingsFile != null ? this.queueMappingsFile.getPath() : "(null)";
            this.getLog().info((CharSequence)("Unable to read file: " + fileName + ". Using default queue mapping."));
            QueueMappings mappings = new QueueMappings();
            mappings.addMapping(new QueueMapping(_defaultQueuesElement, ".*"));
            return mappings;
        }
        try {
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream("/schema/QueueMappings.xsd")));
            schema.newValidator().validate(new StreamSource(this.queueMappingsFile));
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Unable to validate " + this.queueMappingsFile, (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read " + this.queueMappingsFile, (Exception)e);
        }
        try {
            XmlStreamReader xmlReader = new XmlStreamReader(this.queueMappingsFile);
            Xpp3Dom mappingsDom = Xpp3DomBuilder.build((Reader)xmlReader);
            return new QueueMappings(mappingsDom, _defaultQueuesElement);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read " + this.queueMappingsFile, (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Unable to parse " + this.queueMappingsFile, (Exception)((Object)e));
        }
    }

    private Collection<Xpp3Dom> getMFContainerSettings() throws Exception {
        ArrayList<Xpp3Dom> result = new ArrayList<Xpp3Dom>();
        HashMap<String, IMFContainer> mfContainerMap = new HashMap<String, IMFContainer>();
        this.getLog().info((CharSequence)"Matching ESBContainers to MFContainers ...");
        for (IESBContainer esbContainer : this.getESBContainerSettings(false)) {
            this.getLog().info((CharSequence)("Matching ESBContainer : " + esbContainer.getName()));
            Map<String, Properties> matches = this.containerMap.matchMFContainerSettings(esbContainer.getName());
            if (matches.size() == 0 && this.containerMap.isUseMFDefaultIncludes()) {
                this.getLog().warn((CharSequence)"No matching MFContainer setting found...will use default...");
                IContainerSetting defaultContainer = this.containerMap.getDefaultMFContainerSetting();
                String mfName = defaultContainer.getName();
                String hosts = null;
                String autoStart = null;
                try {
                    hosts = defaultContainer.getIncludes().get(0).getIncludeProperties().getProperty("Hosts");
                }
                catch (RuntimeException e) {
                    hosts = DEFAULT_SDM_HOST_VALUE;
                }
                try {
                    autoStart = defaultContainer.getIncludes().get(0).getIncludeProperties().getProperty("AutoStart");
                    this.getLog().debug((CharSequence)("TBO ----- GETTING THE AUTOSTART: - Value: " + autoStart));
                }
                catch (RuntimeException e) {
                    this.getLog().debug((CharSequence)"TBO -------- No value found for Autostart Element for the ESB Container");
                }
                this.getLog().debug((CharSequence)"FELICE is my Mate");
                Properties props = new Properties();
                props.put("Hosts", hosts);
                props.put("bootContainer", Boolean.toString(defaultContainer.isBootContainer()));
                props.put("backupContainer", defaultContainer.getBackupContainer());
                props.put("clone", Boolean.toString(defaultContainer.isClone()));
                props.put("Segment", defaultContainer.getSegment());
                props.put("logDirectory", defaultContainer.getLogDirectory());
                props.put("containerParameterSet", defaultContainer.getContainerParameterSet());
                matches.put(mfName, props);
            }
            for (String mfContainerName : matches.keySet()) {
                this.getLog().info((CharSequence)("Adding ESBContainer " + esbContainer.getName() + " to MFContainer " + mfContainerName));
                this.addESBContainerToMF(mfContainerMap, mfContainerName, esbContainer.getName(), matches.get(mfContainerName));
            }
        }
        for (IMFContainer container : mfContainerMap.values()) {
            result.add(container.removeNamespaces8());
        }
        return result;
    }

    private ArrayList[] readESBContainerConfiguration() {
        XmlStreamReader esbContainerReader = null;
        ArrayList<DefaultContainerSetting> esbContainerList = new ArrayList<DefaultContainerSetting>();
        ArrayList<DefaultContainerSetting> mfContainerList = new ArrayList<DefaultContainerSetting>();
        this.getLog().debug((CharSequence)"TBO ----- Inserting ESBContainer Configuration ------");
        this.getLog().debug((CharSequence)("TBO ----- Check File " + this.containerPropFile));
        this.getLog().debug((CharSequence)("TBO ----- Base-Dir: " + this.project.getBasedir()));
        if (this.containerPropFile.exists()) {
            try {
                this.getLog().debug((CharSequence)"Tailoring the ESBContainers");
                esbContainerReader = new XmlStreamReader(this.containerPropFile);
                Xpp3Dom esbContainerDom = Xpp3DomBuilder.build((Reader)esbContainerReader);
                DefaultContainerSetting ecsESB = null;
                for (Xpp3Dom child : esbContainerDom.getChild("containerMap").getChild("esbContainerSettings").getChildren()) {
                    this.getLog().debug((CharSequence)("TBO ----- Configuration Element: " + child.getName()));
                    String name = child.getChild("name").getValue();
                    this.getLog().debug((CharSequence)("TBO ----- Name of the Container: " + name));
                    String busConnection = child.getChild("busConnection") != null ? child.getChild("busConnection").getValue() : null;
                    String routingHttpConnection = child.getChild("routingHttpConnection") != null ? child.getChild("routingHttpConnection").getValue() : null;
                    String enablePayloadCapture = child.getChild("enablePayloadCapture") != null ? child.getChild("enablePayloadCapture").getValue() : null;
                    String useForLookingGlass = child.getChild("useForLookingGlass") != null ? child.getChild("useForLookingGlass").getValue() : null;
                    String useIntraContainerMessaging = child.getChild("useIntraContainerMessaging") != null ? child.getChild("useIntraContainerMessaging").getValue() : null;
                    ecsESB = new DefaultContainerSetting(name);
                    ecsESB.setBusConnection(busConnection);
                    ecsESB.setEnablePayloadCapture(enablePayloadCapture);
                    ecsESB.setRoutingHttpConnection(routingHttpConnection);
                    ecsESB.setUseForLookingGlass(useForLookingGlass);
                    ecsESB.setUseIntraContainerMessaging(useIntraContainerMessaging);
                    if (child.getChild("includes") != null) {
                        for (Xpp3Dom includepatterns : child.getChild("includes").getChildren()) {
                            String pattern = includepatterns.getChild("pattern").getValue();
                            this.getLog().debug((CharSequence)("TBO ----- Pattern: " + pattern));
                            DefaultIncludePattern expat = new DefaultIncludePattern(pattern);
                            for (Xpp3Dom properties : includepatterns.getChild("includeProperties").getChildren()) {
                                String propname = properties.getChild("name").getValue();
                                String propvalue = properties.getChild("value").getValue();
                                this.getLog().debug((CharSequence)("TBO ---- Property [" + propname + "] Value [" + propvalue + "]"));
                                expat.getIncludeProperties().put(propname, propvalue);
                            }
                            ecsESB.getIncludes().add(expat);
                        }
                    }
                    esbContainerList.add(ecsESB);
                }
                DefaultContainerSetting ecsMF = null;
                for (Xpp3Dom child : esbContainerDom.getChild("containerMap").getChild("mfContainerSettings").getChildren()) {
                    this.getLog().debug((CharSequence)("TBO MF----- Configuration Element: " + child.getName()));
                    String name = child.getChild("name").getValue();
                    this.getLog().debug((CharSequence)("TBO MF----- Name of the Container: " + name));
                    ecsMF = new DefaultContainerSetting(name);
                    if (child.getChild("backupContainer") != null) {
                        String backupContainer = child.getChild("backupContainer").getValue();
                        if (StringUtils.isNotEmpty((String)backupContainer)) {
                            ecsMF.setBackupContainer(backupContainer);
                        }
                        this.getLog().debug((CharSequence)("GDR MF----- Backup Container: " + backupContainer));
                    }
                    if (child.getChild("bootContainer") != null) {
                        boolean bootContainer = Boolean.parseBoolean(child.getChild("bootContainer").getValue());
                        ecsMF.setBootContainer(bootContainer);
                        this.getLog().debug((CharSequence)("TBO MF----- Boot Container: " + bootContainer));
                    }
                    if (child.getChild("clone") != null) {
                        boolean clone = Boolean.parseBoolean(child.getChild("clone").getValue());
                        ecsMF.setClone(clone);
                        this.getLog().debug((CharSequence)("TBO MF----- clone value: " + clone));
                    } else {
                        ecsMF.setClone(false);
                    }
                    if (child.getChild("LogDirectory") != null) {
                        String ldir = child.getChild("LogDirectory").getValue();
                        if (StringUtils.isNotEmpty((String)ldir)) {
                            ecsMF.setLogDirectory(ldir);
                        }
                        this.getLog().debug((CharSequence)("GDR MF----- Segment: " + ldir));
                    }
                    if (child.getChild("ContainerParameterSet") != null) {
                        String cps = child.getChild("ContainerParameterSet").getValue();
                        if (StringUtils.isNotEmpty((String)cps)) {
                            ecsMF.setContainerParameterSet(cps);
                        }
                        this.getLog().debug((CharSequence)("GDR MF----- Segment: " + cps));
                    }
                    if (child.getChild("Segment") != null) {
                        String Segment = child.getChild("Segment").getValue();
                        if (StringUtils.isNotEmpty((String)Segment)) {
                            ecsMF.setSegment(Segment);
                        }
                        this.getLog().debug((CharSequence)("GDR MF----- Segment: " + Segment));
                    }
                    if (child.getChild("includes") != null) {
                        for (Xpp3Dom includepatterns : child.getChild("includes").getChildren()) {
                            String pattern = includepatterns.getChild("pattern").getValue();
                            this.getLog().debug((CharSequence)("TBO MF----- Pattern: " + pattern));
                            DefaultIncludePattern expat = new DefaultIncludePattern(pattern);
                            for (Xpp3Dom properties : includepatterns.getChild("includeProperties").getChildren()) {
                                String propname = properties.getChild("name").getValue();
                                String propvalue = properties.getChild("value").getValue();
                                this.getLog().debug((CharSequence)("TBO MF---- Property [" + propname + "] Value [" + propvalue + "]"));
                                Properties props = expat.getIncludeProperties();
                                props.put(propname, propvalue);
                            }
                            ecsMF.getIncludes().add(expat);
                        }
                    }
                    mfContainerList.add(ecsMF);
                }
            }
            catch (Exception e) {
                this.getLog().debug((CharSequence)("Problem encountered with the formatting of the file: " + e.getMessage()));
                e.printStackTrace();
            }
            this.printContainerTailoringContent("ESB", esbContainerList);
            this.printContainerTailoringContent("MF", mfContainerList);
        } else {
            this.getLog().info((CharSequence)"No Tailoring File Found");
        }
        ArrayList[] ret = new ArrayList[]{esbContainerList, mfContainerList};
        return ret;
    }

    private void printContainerTailoringContent(String _mode, ArrayList<DefaultContainerSetting> _containers) {
        for (DefaultContainerSetting cs : _containers) {
            this.getLog().debug((CharSequence)("MODE: " + _mode));
            this.getLog().debug((CharSequence)("   Container Name:   " + cs.getName()));
            this.getLog().debug((CharSequence)("   Boot Container:   " + cs.isBootContainer()));
            this.getLog().debug((CharSequence)("   Backup Container: " + cs.getBackupContainer()));
            this.getLog().debug((CharSequence)("   Clone:            " + cs.isClone()));
            this.getLog().debug((CharSequence)("   Segment           " + cs.getSegment()));
            List<IIncludePattern> includes = cs.getIncludes();
            for (IIncludePattern includePattern : includes) {
                this.getLog().debug((CharSequence)("     Include Pattern: " + includePattern.getPattern()));
                Properties props = includePattern.getIncludeProperties();
                for (String string : props.keySet()) {
                    String value = props.getProperty(string);
                    this.getLog().debug((CharSequence)("          Key: " + string + " - Value: " + value));
                }
            }
        }
    }

    private void addESBContainerToMF(HashMap<String, IMFContainer> _containerMap, String _mfContainerName, String _esbContainerName, Properties _includeProperties) {
        IMFContainer mfContainer = _containerMap.get(_mfContainerName);
        String hosts = _includeProperties.getProperty("Hosts", DEFAULT_SDM_HOST_VALUE);
        if (mfContainer == null) {
            boolean bootContainer = Boolean.valueOf(_includeProperties.getProperty("bootContainer"));
            String backupContainer = _includeProperties.getProperty("backupContainer");
            boolean clone = Boolean.valueOf(_includeProperties.getProperty("clone"));
            String Segment = _includeProperties.getProperty("Segment");
            this.getLog().debug((CharSequence)("Creating configuration - ESBContainer: " + _esbContainerName + "  MFContainer: " + _mfContainerName + "  hosts: " + hosts + "  Clone: " + clone + "  Bootcontainer: " + bootContainer + "  backup: " + backupContainer));
            mfContainer = new DefaultMFContainer(_esbContainerName, _mfContainerName, bootContainer, backupContainer, hosts, clone);
            _containerMap.put(_mfContainerName, mfContainer);
        } else {
            ((DefaultMFContainer)mfContainer).addHosts(hosts);
        }
    }

    private void generateESBContainerIncludes() throws Exception {
        this.getLog().info((CharSequence)"Creating ESB Includes for Model.xml and Tuning.xml");
        this.ContainerIncludeFiles = new HashMap();
        for (IESBContainer container : this.getESBContainerSettings(true)) {
            if (this.containerMap != null) {
                this.generateModelTuningESBIncludes(container);
                continue;
            }
            this.getLog().debug((CharSequence)"TBO --------- ContainerMap: No Such object present: Need to find another way ... aborting here");
        }
    }

    private void generateModelTuningESBIncludes(IESBContainer container) {
        Map<String, Properties> matches = this.containerMap.matchMFContainerSettings(container.getName());
        Iterator<String> itMF = matches.keySet().iterator();
        File includeDir = new File(this.getTargetSDMDir() + File.separator + "modelincludes");
        if (!includeDir.exists()) {
            includeDir.mkdirs();
        }
        Xpp3Dom element = null;
        while (itMF.hasNext()) {
            String key = itMF.next();
            if (!this.ESBtoMFMapping.containsKey(key)) {
                ArrayList<String> esbList = new ArrayList<String>();
                esbList.add(container.getName());
                this.ESBtoMFMapping.put(key, esbList);
            } else if (!this.ESBtoMFMapping.get(key).contains(container.getName())) {
                this.ESBtoMFMapping.get(key).add(container.getName());
            }
            Properties props = matches.get(key);
            Xpp3Dom esbContainer = new Xpp3Dom("ESBContainer");
            Xpp3Dom esbservices = new Xpp3Dom("Services");
            Xpp3Dom esbprocesses = new Xpp3Dom("Processes");
            Xpp3Dom logicalhosts = new Xpp3Dom("LogicalHosts");
            Xpp3Dom segmentElement = new Xpp3Dom("Segment");
            Xpp3Dom segID = new Xpp3Dom("Id");
            if (props.getProperty("Hosts") != null && !props.getProperty("Hosts").equals("")) {
                SmartTokenizer st = new SmartTokenizer(props.getProperty("Hosts"), ",");
                while (st.hasMoreTokens()) {
                    element = new Xpp3Dom("LogicalHost");
                    element.setValue(st.nextToken());
                    logicalhosts.addChild(element);
                }
                esbContainer.addChild(logicalhosts);
            }
            element = new Xpp3Dom("Id");
            element.setValue(container.getName());
            esbContainer.addChild(element);
            element = new Xpp3Dom("ParameterSet");
            element.setValue(container.getName() + "_ContainerParameter");
            esbContainer.addChild(element);
            element = new Xpp3Dom("TargetContainer");
            element.setValue(key);
            esbContainer.addChild(element);
            if (props.getProperty("containerParameterSet") != null && !props.getProperty("containerParameterSet").equals("")) {
                element = new Xpp3Dom("ContainerParameterSet");
                element.setValue(props.getProperty("containerParameterSet"));
                esbContainer.addChild(element);
            }
            if (props.getProperty("logDirectory") != null && !props.getProperty("logDirectory").equals("")) {
                element = new Xpp3Dom("LogDirectory");
                element.setValue(props.getProperty("logDirectory"));
                esbContainer.addChild(element);
            }
            this.getLog().debug((CharSequence)("AUTOSTART: " + props.getProperty("AutoStart")));
            String autoStart = props.getProperty("AutoStart");
            if (autoStart != null) {
                element = new Xpp3Dom("AutoStart");
                element.setValue(autoStart);
                esbContainer.addChild(element);
            }
            element = new Xpp3Dom("BootContainer");
            element.setValue(props.getProperty("bootContainer"));
            esbContainer.addChild(element);
            if (props.getProperty("backupContainer") != null && !props.getProperty("backupContainer").equals("")) {
                element = new Xpp3Dom("BackupContainer");
                element.setValue(props.getProperty("backupContainer"));
                esbContainer.addChild(element);
                element = new Xpp3Dom("Clone");
                element.setValue(props.getProperty("clone"));
                esbContainer.addChild(element);
            }
            DataObject services = container.getDataObject().getDataObject("services");
            List svclist = services.getList("serviceApplication");
            for (DataObject instance : svclist) {
                Xpp3Dom svc;
                if (instance.getString("service_ref").equals("PROCESS")) {
                    svc = new Xpp3Dom("Process");
                    esbprocesses.addChild(svc);
                } else {
                    svc = new Xpp3Dom("Service");
                    esbservices.addChild(svc);
                }
                element = new Xpp3Dom("Id");
                element.setValue(instance.getString("name"));
                svc.addChild(element);
                element = new Xpp3Dom("ListenerCount");
                element.setValue(instance.getString("Instances"));
                svc.addChild(element);
                element = new Xpp3Dom("StartupPriorityLevel");
                element.setValue(instance.getString("startupPriorityLevel"));
                svc.addChild(element);
                element = new Xpp3Dom("ConcurrentCalls");
                element.setValue(instance.getString("ConcurrentCalls"));
                svc.addChild(element);
            }
            esbContainer.addChild(esbservices);
            esbContainer.addChild(esbprocesses);
            if (props.getProperty("Segment") != null && !props.getProperty("Segment").equals("")) {
                segID.setValue(props.getProperty("Segment"));
                segmentElement.addChild(segID);
                segmentElement.addChild(esbContainer);
                FileUtilities.writeFile(segmentElement.toString().getBytes(), new File(includeDir, container.getName() + "_" + key + "_inc_model.xml"));
            } else {
                FileUtilities.writeFile(esbContainer.toString().getBytes(), new File(includeDir, container.getName() + "_" + key + "_inc_model.xml"));
            }
            this.ContainerIncludeFiles.put(key, new File(includeDir, container.getName() + "_" + key + "_inc_model.xml").getName());
        }
        Xpp3Dom parameterSet = new Xpp3Dom("ESBContainerParameters");
        parameterSet.setAttribute("id", container.getName() + "_ContainerParameter");
        Xpp3Dom resources = new Xpp3Dom("Resources");
        Xpp3Dom actoinalConfig = new Xpp3Dom("ActionalConfig");
        element = new Xpp3Dom("JmsDefaultConnection");
        element.setValue(container.getDataObject().getString("BusConnection"));
        parameterSet.addChild(element);
        element = new Xpp3Dom("HttpDefaultConnection");
        element.setValue(container.getDataObject().getString("RoutingHttpConnection"));
        parameterSet.addChild(element);
        element = new Xpp3Dom("UseIntraContainer");
        element.setValue(container.getDataObject().getString("useIntraContainerMessaging"));
        parameterSet.addChild(element);
        element = new Xpp3Dom("InterceptorEnabled");
        element.setValue(container.getDataObject().getString("useForLookingGlass"));
        actoinalConfig.addChild(element);
        element = new Xpp3Dom("PayloadReportingEnabled");
        element.setValue(container.getDataObject().getString("enablePayloadCapture"));
        actoinalConfig.addChild(element);
        parameterSet.addChild(actoinalConfig);
        if (container.getDataObject().getString("CLASSPATH") != null && !container.getDataObject().getString("CLASSPATH").equals("")) {
            element = new Xpp3Dom("Classpath");
            element.setValue(container.getDataObject().getString("CLASSPATH"));
            resources.addChild(element);
            parameterSet.addChild(resources);
        } else if (this.eSBContainerClasspathOverride != null && !this.eSBContainerClasspathOverride.equals("")) {
            element = new Xpp3Dom("Classpath");
            element.setValue(this.eSBContainerClasspathOverride);
            resources.addChild(element);
            parameterSet.addChild(resources);
        }
        FileUtilities.writeFile(parameterSet.toString().getBytes(), new File(includeDir, container.getName() + "_inc_tuning.xml"));
    }

    private void generateContainerXar() throws Exception {
        this.getLog().info((CharSequence)"Creating xar archive for the ESBContainers");
        String xarDirectory = this.getPackageXarDir();
        new File(xarDirectory, "ESB/Containers").mkdirs();
        new File(xarDirectory, "SonicFS").mkdirs();
        this.copyJarFiles();
        for (IESBContainer container : this.getESBContainerSettings(false)) {
            String fileName = container.getName() + ".xml";
            FileUtilities.writeFile(container.toString().getBytes(), xarDirectory + "/ESB/Containers/" + fileName);
        }
        FileUtilities.copyFiles(this.project.getBasedir() + "/src/main/resources", xarDirectory, "**/*", null, "SonicFS/" + this.getSonicFSProjectDir() + "/resources", false);
        File xarFile = new File(this.getTargetSDMDir(), "xars/" + this.getFinalAssemblyBaseName() + ".xar");
        Archiver archiver = this.archiverManager.getArchiver("zip");
        archiver.setDestFile(xarFile);
        archiver.addDirectory(new File(xarDirectory));
        archiver.createArchive();
    }

    private Collection<IESBContainer> getESBContainerSettings(boolean inLine) throws Exception {
        if (this.esbContainers == null) {
            ArrayList[] configs = this.readESBContainerConfiguration();
            this.getLog().debug((CharSequence)"Adding External ESB Configuration - Start");
            ArrayList esbConfig = configs[0];
            for (IContainerSetting container : esbConfig) {
                this.containerMap.getESBContainerSettings().remove(container);
                this.containerMap.getESBContainerSettings().add(container);
            }
            this.getLog().info((CharSequence)("ESB container mapping: " + this.containerMap.getESBContainerSettings()));
            ArrayList mfConfig = configs[1];
            for (IContainerSetting container : mfConfig) {
                this.containerMap.getMFContainerSettings().remove(container);
                this.containerMap.getMFContainerSettings().add(container);
            }
            this.getLog().debug((CharSequence)("MF container mapping: " + this.containerMap.getMFContainerSettings()));
            this.getLog().debug((CharSequence)"Adding External ESB Configuration - Done");
            HashMap<String, IESBContainer> esbContainerMap = new HashMap<String, IESBContainer>();
            this.getLog().info((CharSequence)"---------------------------------------------");
            this.getLog().debug((CharSequence)"Building Container settings for SDM model...");
            List<Xpp3Dom> serviceInstances = Xpp3Utils.collectElements(this.getDependencyDirectory(), "**/*.instances.snippet");
            for (Xpp3Dom serviceInstance : serviceInstances) {
                String containerHint = serviceInstance.getAttribute("hint");
                this.getLog().debug((CharSequence)("Matching service instance " + serviceInstance.getAttribute("name") + "/" + serviceInstance.getAttribute("process") + "\r\n\t(containerHint: " + containerHint + ")"));
                if (this.containerMap == null) {
                    throw new Exception("containerMap not specified in plugin configuration");
                }
                Map<String, Properties> matches = this.containerMap.matchESBContainerSettings(containerHint);
                if (matches.size() == 0 && this.containerMap.isUseESBDefaultIncludes()) {
                    this.getLog().warn((CharSequence)"No matching ESBContainer setting found...will use default...");
                    matches.put(this.containerMap.getDefaultESBContainerSetting().getName(), new Properties());
                }
                for (String matchedName : matches.keySet()) {
                    this.addServiceInstance(esbContainerMap, matchedName, serviceInstance, matches.get(matchedName), inLine);
                }
            }
            this.esbContainers = esbContainerMap.values();
        }
        return this.esbContainers;
    }

    private void addServiceInstance(HashMap<String, IESBContainer> _containerMap, String _esbContainerName, Xpp3Dom _serviceInstance, Properties _includeProperties, boolean inLine) {
        IESBContainer esbContainer = _containerMap.get(_esbContainerName);
        if (esbContainer == null) {
            esbContainer = this.createESBContainer(_containerMap, _esbContainerName, _includeProperties);
        }
        String instances = "1";
        try {
            String instancesStr;
            instances = instancesStr = _includeProperties.getProperty("instances", "1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getLog().debug((CharSequence)("Adding " + _serviceInstance.getAttribute("name") + " to ESBContainer " + _esbContainerName));
        esbContainer.addServiceInstance(_serviceInstance.getAttribute("name"), instances, _serviceInstance.getAttribute("process"), Integer.parseInt(_includeProperties.getProperty("startupPriorityLevel", "0")), Integer.parseInt(_includeProperties.getProperty("ConcurrentCalls", "0")), inLine);
    }

    private void addCleanServiceInstance(HashMap<String, IESBContainer> _containerMap, String _esbContainerName, Xpp3Dom _serviceInstance, Properties _includeProperties, boolean inLine, HashMap<String, String> instanceReplaceMaps) {
        IESBContainer esbContainer = _containerMap.get(_esbContainerName);
        if (esbContainer == null) {
            esbContainer = this.createESBContainer(_containerMap, _esbContainerName, _includeProperties);
        }
        String instances = "1";
        try {
            String instancesStr = _includeProperties.getProperty("instances", "1");
            if (instancesStr.startsWith("@") && instancesStr.endsWith("@")) {
                instances = "{" + instancesStr.substring(1, instancesStr.length() - 1) + "}";
                this.getLog().info((CharSequence)("SUBBING the tailoring : " + instances));
                instanceReplaceMaps.put(instances, instancesStr);
            } else {
                instances = instancesStr;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getLog().debug((CharSequence)("Adding " + _serviceInstance.getAttribute("name") + " to ESBContainer " + _esbContainerName));
        esbContainer.addServiceInstance(_serviceInstance.getAttribute("name"), instances, _serviceInstance.getAttribute("process"), Integer.parseInt(_includeProperties.getProperty("startupPriorityLevel", "0")), Integer.parseInt(_includeProperties.getProperty("ConcurrentCalls", "0")), inLine);
    }

    private IESBContainer createESBContainer(HashMap<String, IESBContainer> _containerMap, String _esbContainerName, Properties _includeProperties) {
        DefaultESBContainer esbContainer = new DefaultESBContainer();
        this.getLog().info((CharSequence)("Creating ESBContainer configuration: " + _esbContainerName));
        esbContainer.setName(_esbContainerName);
        String classpathOverride = _includeProperties.getProperty("classpathOverride", null);
        this.getLog().info((CharSequence)("ClasspathOverride ... Trying to get the Classpath Override " + classpathOverride));
        if (classpathOverride == null) {
            Object tempClassPath;
            String extendedAppendCpPattern = _includeProperties.getProperty("classpathPatternEx", "^$");
            String appendCpPattern = _includeProperties.getProperty("classpathPattern", ".*");
            String classpathSortPattern = _includeProperties.getProperty("classpathSortPattern", null);
            Object classPath = this.getDepAnalyzer().additionalContainerClassPath(extendedAppendCpPattern, null, false);
            classPath = this.getDepAnalyzer().additionalContainerClassPath(appendCpPattern, (List<String>)classPath, true);
            if (classpathSortPattern != null) {
                String[] sortPatterns = classpathSortPattern.split(";");
                tempClassPath = new ArrayList();
                for (String regex : sortPatterns) {
                    String[] entries;
                    for (String entry : entries = classPath.toArray(new String[classPath.size()])) {
                        if (!entry.matches(regex)) continue;
                        classPath.remove(entry);
                        tempClassPath.add(entry);
                    }
                }
                tempClassPath.addAll(classPath);
                classPath = tempClassPath;
            }
            if (classPath != null && classPath.size() > 0) {
                StringBuilder b = new StringBuilder();
                tempClassPath = classPath.iterator();
                while (tempClassPath.hasNext()) {
                    String s = (String)tempClassPath.next();
                    b.append(s);
                    b.append(';');
                }
                String cp = b.substring(0, b.length() - 1);
                this.getLog().info((CharSequence)("Setting container classpath to : " + cp));
                esbContainer.getDataObject().set("CLASSPATH", (Object)cp);
            }
        } else {
            esbContainer.getDataObject().set("CLASSPATH", (Object)classpathOverride);
        }
        if (!_includeProperties.getProperty("busConnection", "").equals("")) {
            esbContainer.getDataObject().set("BusConnection", (Object)_includeProperties.getProperty("busConnection", ""));
        }
        if (!_includeProperties.getProperty("routingHttpConnection", "").equals("")) {
            esbContainer.getDataObject().set("RoutingHttpConnection", (Object)_includeProperties.getProperty("routingHttpConnection", ""));
        }
        if (!_includeProperties.getProperty("enablePayloadCapture", "").equals("")) {
            esbContainer.getDataObject().set("enablePayloadCapture", (Object)new Boolean(_includeProperties.getProperty("enablePayloadCapture", "")));
        }
        if (!_includeProperties.getProperty("useForLookingGlass", "").equals("")) {
            esbContainer.getDataObject().set("useForLookingGlass", (Object)new Boolean(_includeProperties.getProperty("useForLookingGlass", "")));
        }
        if (!_includeProperties.getProperty("useIntraContainerMessaging", "").equals("")) {
            esbContainer.getDataObject().set("useIntraContainerMessaging", (Object)new Boolean(_includeProperties.getProperty("useIntraContainerMessaging", "")));
        }
        _containerMap.put(_esbContainerName, esbContainer);
        return esbContainer;
    }

    private void createProperties() throws Exception {
        this.getLog().info((CharSequence)"Creating generated.tailoring.properties");
        Properties props = new Properties();
        ArrayList<String> varNames = new ArrayList<String>();
        this.getModelProperties("Model.xml", varNames);
        this.getModelProperties("Tuning.xml", varNames);
        this.getModelProperties("DefaultTuning.xml", varNames);
        this.getModelProperties("ContainerProperties.xml", varNames);
        this.addModelPropertiesFromStaticFiles(new File(this.getTargetSDMDir() + File.separator + "modelincludes"), "_refOnly.xml", varNames);
        for (String varName : varNames) {
            this.getLog().info((CharSequence)("Found Variable Name: " + varName));
            props.put(varName, "");
        }
        for (Xpp3Dom variable : Xpp3Utils.collectElements(this.getDependencyDirectory(), "**/*.variables.snippet")) {
            String name = variable.getAttribute("name");
            String value = variable.getValue();
            this.getLog().debug((CharSequence)("Setting variable: [" + name + "] = [" + value + "]"));
            props.put(name, value != null ? value : "");
        }
        TreeSet<String> propNames = new TreeSet<String>();
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            propNames.add((String)en.nextElement());
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (String key : propNames) {
            bos.write((key + "=" + props.get(key) + "\n").getBytes());
        }
        FileUtilities.writeFile(bos.toByteArray(), this.getGeneratedPropertiesFile());
        this.updateTailoringProperties();
    }

    private void createTopology() throws Exception {
        this.getLog().info((CharSequence)"Creating generated.Topology.xml");
        Properties props = new Properties();
        ArrayList<String> varNames = new ArrayList<String>();
        this.getModelProperties("Model.xml", varNames);
        this.getModelProperties("Tuning.xml", varNames);
        this.getModelProperties("DefaultTuning.xml", varNames);
        this.getModelProperties("ContainerProperties.xml", varNames);
        this.addModelPropertiesFromStaticFiles(new File(this.getTargetSDMDir() + File.separator + "modelincludes"), "_refOnly.xml", varNames);
        for (String varName : varNames) {
            this.getLog().info((CharSequence)("Found Variable Name: " + varName));
            props.put(varName, "");
        }
        for (Xpp3Dom variable : Xpp3Utils.collectElements(this.getDependencyDirectory(), "**/*.variables.snippet")) {
            String name = variable.getAttribute("name");
            String value = variable.getValue();
            this.getLog().debug((CharSequence)("Setting variable: [" + name + "] = [" + value + "]"));
            props.put(name, value != null ? value : "");
        }
        TreeSet<String> propNames = new TreeSet<String>();
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            propNames.add((String)en.nextElement());
        }
        Xpp3Dom topology = new Xpp3Dom("Environment");
        Xpp3Dom id = new Xpp3Dom("Id");
        Xpp3Dom machines = new Xpp3Dom("Machines");
        Xpp3Dom machine = new Xpp3Dom("Machine");
        Xpp3Dom parameters = new Xpp3Dom("Parameters");
        id.setValue("GeneratedTopology");
        topology.addChild(id);
        machines.addChild(machine);
        Xpp3Dom element = null;
        Xpp3Dom child = null;
        Xpp3Dom paramId = null;
        Xpp3Dom defaultValue = null;
        Xpp3Dom parameter = null;
        element = new Xpp3Dom("Id");
        element.setValue("Generated_Machine");
        machine.addChild(element);
        element = new Xpp3Dom("AlternateId");
        element.setValue("Generated_Alternate");
        machine.addChild(element);
        element = new Xpp3Dom("LogicalHosts");
        machine.addChild(element);
        child = new Xpp3Dom("LogicalHost");
        child.setValue("GeneratedHost");
        element.addChild(child);
        element = new Xpp3Dom("Settings");
        topology.addChild(machines);
        topology.addChild(element);
        topology.addChild(parameters);
        for (String key : propNames) {
            parameter = new Xpp3Dom("Parameter");
            paramId = new Xpp3Dom("Id");
            paramId.setValue(key);
            defaultValue = new Xpp3Dom("Value");
            defaultValue.setValue(props.getProperty(key));
            parameter.addChild(paramId);
            parameter.addChild(defaultValue);
            parameters.addChild(parameter);
        }
        FileUtilities.writeFile(topology.toString().getBytes(), this.getGeneratedTopologyFile());
    }

    private void generateMasterTopology() throws Exception {
        Properties props = new Properties();
        ArrayList<String> varNames = new ArrayList<String>();
        this.getModelProperties("Model.xml", varNames);
        this.getModelProperties("Tuning.xml", varNames);
        this.getModelProperties("DefaultTuning.xml", varNames);
        this.getModelProperties("ContainerProperties.xml", varNames);
        this.addModelPropertiesFromStaticFiles(new File(this.getTargetSDMDir() + File.separator + "modelincludes"), "_refOnly.xml", varNames);
        for (String varName : varNames) {
            this.getLog().info((CharSequence)("Found Variable Name: " + varName));
            props.put(varName, "");
        }
        for (String toCompare : FileUtilities.getFileList(this.getTargetSDMDir().getAbsolutePath(), "*.Topology.xml", "generated.Topology.xml")) {
            Properties envProperties = this.buildPropertiesFromTopology(new File(this.getTargetSDMDir().getAbsolutePath(), toCompare));
            for (Object envPropKey : envProperties.keySet()) {
                if (props.containsKey(envPropKey.toString())) continue;
                this.getLog().info((CharSequence)("Found Variable Name: " + envPropKey));
                props.put(envPropKey, "");
            }
        }
        for (Xpp3Dom variable : Xpp3Utils.collectElements(this.getDependencyDirectory(), "**/*.variables.snippet")) {
            String name = variable.getAttribute("name");
            String value = variable.getValue();
            this.getLog().debug((CharSequence)("Setting variable: [" + name + "] = [" + value + "]"));
            props.put(name, value != null ? value : "");
        }
        TreeSet<String> propNames = new TreeSet<String>();
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            propNames.add((String)en.nextElement());
        }
        this.getLog().info((CharSequence)"Generating Master Topology File");
        Xpp3Dom topology = new Xpp3Dom("Topology");
        Xpp3Dom includeDom = new Xpp3Dom("Id");
        Xpp3Dom parameters = new Xpp3Dom("Parameters");
        Xpp3Dom paramId = null;
        Xpp3Dom defaultValue = null;
        Xpp3Dom parameter = null;
        topology.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        topology.setAttribute("xsi:noNamespaceSchemaLocation", "Topology.xsd");
        topology.setAttribute("xmlns:xi", "http://www.w3.org/2001/XInclude");
        for (String key : propNames) {
            parameter = new Xpp3Dom("Parameter");
            paramId = new Xpp3Dom("Id");
            paramId.setValue(key);
            defaultValue = new Xpp3Dom("DefaultValue");
            String keyValue = props.getProperty(key);
            if (keyValue != null) {
                defaultValue.setValue(props.getProperty(key));
            }
            parameter.addChild(paramId);
            parameter.addChild(defaultValue);
            parameters.addChild(parameter);
        }
        topology.addChild(parameters);
        for (String toCompare : FileUtilities.getFileList(this.getTargetSDMDir().getAbsolutePath(), "*.Topology.xml", "generated.Topology.xml")) {
            includeDom = new Xpp3Dom("xi:include");
            includeDom.setAttribute("href", toCompare);
            topology.addChild(includeDom);
        }
        Xpp3Dom environment = new Xpp3Dom("Environment");
        Xpp3Dom envId = new Xpp3Dom("Id");
        envId.setValue("default");
        environment.addChild(envId);
        Xpp3Dom machines = new Xpp3Dom("Machines");
        Xpp3Dom machine = new Xpp3Dom("Machine");
        Xpp3Dom machineId = new Xpp3Dom("Id");
        machineId.setValue("localhost");
        machine.addChild(machineId);
        Xpp3Dom altId = new Xpp3Dom("AlternateId");
        altId.setValue("127.0.0.1");
        machine.addChild(altId);
        Xpp3Dom altId2 = new Xpp3Dom("AlternateId");
        altId2.setValue("::1");
        machine.addChild(altId2);
        machines.addChild(machine);
        environment.addChild(machines);
        topology.addChild(environment);
        FileUtilities.writeFile(topology.toString().getBytes(), this.getMasterTopologyFile());
    }

    private void getModelProperties(String _modelFile, List<String> _names) throws Exception {
        if (_modelFile.equals("ContainerProperties.xml")) {
            if (this.containerPropFile.exists()) {
                XmlStreamReader reader = new XmlStreamReader(this.containerPropFile);
                Xpp3Dom modelDom = Xpp3DomBuilder.build((Reader)reader);
                this.getVariableNamesFromModel(modelDom, _names);
            }
        } else {
            File modelFile = new File(this.getTargetSDMDir(), _modelFile);
            if (modelFile.exists()) {
                XmlStreamReader reader = new XmlStreamReader(modelFile);
                Xpp3Dom modelDom = Xpp3DomBuilder.build((Reader)reader);
                this.getVariableNamesFromModel(modelDom, _names);
            }
        }
    }

    private void addModelPropertiesFromStaticFiles(File directory, final String filter, List<String> varNames) {
        if (directory.exists()) {
            this.getLog().debug((CharSequence)("TBO2 ------------ INCLUDES DIR FOUND .... for filter " + filter));
            File[] content = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(filter);
                }
            });
            for (int i = 0; i < content.length; ++i) {
                this.getLog().info((CharSequence)("TBO --- Found extra include file to check: " + content[i].getName()));
                try {
                    XmlStreamReader reader = new XmlStreamReader(content[i]);
                    Xpp3Dom modelDom = Xpp3DomBuilder.build((Reader)reader);
                    this.getVariableNamesFromModel(modelDom, varNames);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (XmlPullParserException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void getVariableNamesFromModel(Xpp3Dom _element, List<String> _names) {
        Pattern pattern = Pattern.compile("(@[^\\s^\\@]*@)");
        String content = _element.getValue();
        boolean valueFound = false;
        if (content != null) {
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                valueFound = true;
                if (_names.contains(matcher.group())) continue;
                _names.add(matcher.group());
            }
        }
        if (!valueFound) {
            for (Xpp3Dom child : _element.getChildren()) {
                this.getVariableNamesFromModel(child, _names);
            }
        }
    }

    private DependencyAnalyzer getDepAnalyzer() {
        if (this.depAnalyzer == null) {
            this.depAnalyzer = new DependencyAnalyzer(this.getDependencyDirectory());
        }
        return this.depAnalyzer;
    }
}

