/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.utils;

import com.aurea.maven.plugins.sonic.sdm.container.impl.DefaultServiceType;
import com.aurea.maven.plugins.sonic.utils.Xpp3Utils;
import com.progress.sonic.utilities.esb.admin.XarAnalyzer;
import com.progress.sonic.utilities.mfutils.MFUtils;
import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.artifact.ESBArtifact;
import commonj.sdo.DataObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

public class SnippetsProcessor {
    private XarAnalyzer xarAnalyser;
    public static final String HINT_ATTRIBUTE = "hint";

    public SnippetsProcessor(IArtifactStorage _as) {
        this.setXarAnalyser(new XarAnalyzer(_as));
    }

    public SnippetsProcessor(File _f) {
        this.setXarAnalyser(new XarAnalyzer(_f));
    }

    public SnippetsProcessor(String _fileName) {
        this.setXarAnalyser(new XarAnalyzer(_fileName));
    }

    public SnippetsProcessor(MFUtils _utils) throws Exception {
        this.setXarAnalyser(new XarAnalyzer(_utils));
    }

    public final String getTailorSnippet(List<String> _paramPatterns) {
        Xpp3Dom result = new Xpp3Dom("ServiceRules");
        try {
            List sTypes = this.xarAnalyser.getArtifacts(ESBArtifact.SERVICE_TYPE);
            for (IArtifact sTypeArtifact : sTypes) {
                DefaultServiceType sType = new DefaultServiceType();
                byte[] bytes = this.xarAnalyser.getStorage().getContentsAsBytes(sTypeArtifact);
                String temp = new String(bytes);
                temp = temp.replace("<xq:selfFirst/>", "<xq:selfFirst>false</xq:selfFirst>");
                sType.load(new ByteArrayInputStream(temp.getBytes()));
                List params = sType.getDataObject().getList("validParams/init/stringParam");
                if (params == null) continue;
                Xpp3Dom svcRule = Xpp3Utils.createXpp3Dom("ServiceRule", null, "type=" + sType.getDataObject().getString("name"));
                block3: for (DataObject param : params) {
                    String pName = param.getString("name");
                    for (String paramPattern : _paramPatterns) {
                        if (!pName.matches(paramPattern)) continue;
                        svcRule.addChild(Xpp3Utils.createXpp3Dom("Param", null, "name=" + pName));
                        continue block3;
                    }
                }
                if (svcRule.getChildCount() <= 0) continue;
                result.addChild(svcRule);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result.toString();
    }

    public final String getQueuesSnippet() {
        Xpp3Dom result = new Xpp3Dom("Queues");
        try {
            List endpoints = this.xarAnalyser.getArtifacts(ESBArtifact.ENDPOINT);
            for (IArtifact a : endpoints) {
                Xpp3Dom artifactDom = Xpp3DomBuilder.build((Reader)new StringReader(this.xarAnalyser.getStorage().getContentsAsString(a)));
                List<Xpp3Dom> params = Xpp3Utils.collectElements(artifactDom, "(xq:)?params/(xq:)?stringParam");
                boolean isQueue = false;
                String destName = null;
                for (Xpp3Dom param : params) {
                    if ("destination".equals(param.getAttribute("name"))) {
                        destName = param.getValue();
                    }
                    if (!"type".equals(param.getAttribute("name"))) continue;
                    isQueue = "QUEUE".equals(param.getValue());
                }
                if (!isQueue || destName == null || destName.contains("::") || destName.equals("SonicMQ.deadMessage") || destName.equals("SonicMQ.routingQueue")) continue;
                Xpp3Dom q = new Xpp3Dom("Queue");
                Xpp3Dom id = new Xpp3Dom("Id");
                id.setValue(destName);
                q.addChild(id);
                result.addChild(q);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result.toString();
    }

    public final String getSvcInstancesSnippet(String _containerHint) {
        Xpp3Dom result = new Xpp3Dom("ServiceInstances");
        try {
            for (IArtifact svcInstance : this.xarAnalyser.getArtifacts(ESBArtifact.SERVICE)) {
                String svcName = svcInstance.getName();
                result.addChild(Xpp3Utils.createXpp3Dom("ServiceInstance", null, "name=" + svcName + ";" + HINT_ATTRIBUTE + "=" + _containerHint + "." + svcName));
            }
            for (IArtifact procInstance : this.xarAnalyser.getArtifacts(ESBArtifact.PROCESS)) {
                String procName = procInstance.getName();
                Xpp3Dom procDOM = Xpp3DomBuilder.build((Reader)new StringReader(this.xarAnalyser.getStorage().getContentsAsString(procInstance)));
                if (procDOM.getAttribute("entry_ref") == null) continue;
                result.addChild(Xpp3Utils.createXpp3Dom("ServiceInstance", null, "name=BPEType;hint=" + _containerHint + ".process." + procName + ";" + "process=" + procName));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result.toString();
    }

    public final XarAnalyzer getXarAnalyser() {
        return this.xarAnalyser;
    }

    public final void setXarAnalyser(XarAnalyzer _xarAnalyser) {
        this.xarAnalyser = _xarAnalyser;
    }
}

