/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.esb;

import com.aurea.maven.plugins.sonic.esb.AbstractESBConnectMojo;
import com.aurea.maven.plugins.sonic.utils.FileUtilities;
import com.aurea.maven.plugins.sonic.utils.ProjectAnalyzer;
import com.aurea.maven.plugins.sonic.utils.xmlsorter.XMLSort;
import com.progress.sonic.utilities.esb.admin.ESBAdmin;
import com.progress.sonic.utilities.esb.admin.ESBArtifactCopyJob;
import com.progress.sonic.utilities.esb.admin.EndpointAdmin;
import com.progress.sonic.utilities.esb.admin.ProcessAdmin;
import com.progress.sonic.utilities.esb.admin.ServiceAdmin;
import com.progress.sonic.utilities.mfutils.MFUtils;
import com.progress.sonic.utilities.mfutils.NullArtifactNotificationListener;
import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactNotificationListener;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.artifact.ArtifactFactory;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.storage.DSArtifactStorage;
import com.sonicsw.deploy.storage.FileArtifactStorage;
import com.sonicsw.deploy.tools.common.ExportPropertiesArtifact;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractExportGeneratedSrcMojo
extends AbstractESBConnectMojo {
    protected BuildPluginManager pluginManager;
    private static final int DOMAIN_PING_TIMEOUT = 1000;
    protected boolean failOnExportError;
    protected boolean skipExport;
    protected String exportPropFileName;

    protected abstract File getDeployGenSrcDir();

    protected abstract String getProjectProcessesXarDir();

    protected abstract String getTmpExportToGeneratedSrcDir();

    @Override
    protected final void doExecute() throws MojoExecutionException, MojoFailureException {
        super.doExecute();
        try {
            if (!this.skipExport && !MFUtils.pingDomain((String)this.getManagementUrl(), (int)1000)) {
                this.getLog().warn((CharSequence)"Could not connect to Sonic Domain");
                return;
            }
            if (!this.skipExport) {
                this.exportToDeployGeneratedSrc();
            } else {
                this.getLog().info((CharSequence)"Skipping export of resources from the directory Service");
            }
            this.validateGeneratedSrc();
        }
        finally {
            this.getMFUtils().cleanup();
        }
    }

    private void validateGeneratedSrc() throws MojoExecutionException {
        if (!this.getDeployGenSrcDir().exists() || !this.getDeployGenSrcDir().isDirectory()) {
            throw new MojoExecutionException("The generated directory " + this.getDeployGenSrcDir() + " does not exist. Build cannot continue.");
        }
    }

    protected void exportToDeployGeneratedSrc() throws MojoExecutionException {
        try {
            String tmpExportDir = this.getOutputDirectory() + this.getTmpExportToGeneratedSrcDir();
            File tmpExportDirFile = new File(tmpExportDir);
            tmpExportDirFile.mkdirs();
            FileArtifactStorage destStorage = new FileArtifactStorage();
            destStorage.addNotificationListener((IArtifactNotificationListener)new NullArtifactNotificationListener());
            destStorage.setRoot(tmpExportDir);
            ExportPropertiesArtifact expProps = this.getExportProperties();
            this.addExportIgnores(expProps);
            DSArtifactStorage storage = this.getMFUtils().getDSArtifactStorage();
            ESBArtifactCopyJob copyJob = new ESBArtifactCopyJob((IArtifactStorage)storage, (IArtifactStorage)destStorage, expProps, this.failOnExportError);
            copyJob.setCleanBeforeCopy(true);
            this.getLog().info((CharSequence)"Exporting resources from Sonic Domain ...");
            copyJob.copy();
            File dxsiExtractDir = new File(this.getDependencyDirectory(), "dxsi");
            File xarTmpDir = new File(dxsiExtractDir, "xarTmp");
            FileUtilities.copyFiles(xarTmpDir.getPath(), tmpExportDir, null, null, null, false);
            this.beautifyXarDirectory(tmpExportDirFile);
            this.getLog().info((CharSequence)("Deleting all files from " + this.getDeployGenSrcDir().getPath() + " directory."));
            FileUtilities.deleteFilesInDir(this.getDeployGenSrcDir().getPath(), "**/*", "**/.*");
            new File(this.getDeployGenSrcDir().getPath()).mkdirs();
            this.getLog().info((CharSequence)("Copying files to " + this.getDeployGenSrcDir().getPath() + " directory."));
            FileUtilities.copyFiles(tmpExportDir, this.getDeployGenSrcDir().getPath(), null, null, null, false);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Export of resources failed", (Throwable)e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            this.getMFUtils().cleanup();
        }
    }

    protected void addExportIgnores(ExportPropertiesArtifact _expProps) {
        this.addExportIgnoresForDependencies(_expProps);
        IArtifact sonicfs = ArtifactFactory.createArtifact((String)"SonicFS", (String)"System/SonicESB/jsHelperFunctions.js");
        _expProps.addIgnore(sonicfs);
        sonicfs = ArtifactFactory.createArtifact((String)"SonicFS", (String)"System/SonicESB/7.6/jsHelperFunctions.js");
        _expProps.addIgnore(sonicfs);
        sonicfs = ArtifactFactory.createArtifact((String)"SonicFS", (String)"System/SonicESB/7.6/Common/jsHelperFunctions.js");
        _expProps.addIgnore(sonicfs);
        sonicfs = ArtifactFactory.createArtifact((String)"SonicFS", (String)("workspace/" + this.getProjectName() + "/"));
        _expProps.addIgnore(sonicfs);
        this.getLog().info((CharSequence)"Done...Building Artifact ignore List from Dependencies : ...");
    }

    protected ExportPropertiesArtifact getExportProperties() throws MojoExecutionException {
        ExportPropertiesArtifact expProps = new ExportPropertiesArtifact();
        File expPropFile = this.getExportPropFile();
        try {
            this.getLog().debug((CharSequence)("TBO ---- File Information: " + expPropFile.getAbsolutePath()));
            if (expPropFile.exists() && expPropFile.isFile() && expPropFile.canRead()) {
                expProps.init(expPropFile);
                expProps.addIgnore(ExportPropertiesArtifact.getDefaultIgnore());
                this.getLog().info((CharSequence)("Using existing property file : " + this.getExportPropFile()));
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Error reading " + this.getExportPropFile() + "! Will not use it."));
            expProps = new ExportPropertiesArtifact();
        }
        ESBAdmin esbAdmin = this.getMFUtils().getESBAdmin();
        ProcessAdmin processAdmin = new ProcessAdmin(esbAdmin.getEsbApi());
        ServiceAdmin serviceAdmin = new ServiceAdmin(esbAdmin.getEsbApi());
        EndpointAdmin endpointAdmin = new EndpointAdmin(esbAdmin.getEsbApi());
        try {
            ESBArtifact artifact;
            this.getLog().info((CharSequence)"Scan for local service configurations to be included in domain export...");
            for (File serviceFile : ProjectAnalyzer.getServiceConfigSourceFiles(this.getSonicEsbSourceDirectory().getAbsolutePath())) {
                String serviceConfigName = ProjectAnalyzer.getServiceConfigNameFromFile(serviceFile);
                this.getLog().info((CharSequence)("Found ESB Service Configuration : " + serviceConfigName));
                this.getLog().info((CharSequence)("Importing '" + serviceConfigName + "' service config in Sonic Domain"));
                serviceAdmin.importServiceConfig(serviceFile, true);
                String endpoint = ProjectAnalyzer.getServiceConfigEntryRefFromFile(serviceFile);
                if (endpoint != null && !endpoint.isEmpty()) {
                    this.getLog().info((CharSequence)("Creating '" + endpoint + "' endpoint in Sonic Domain for ESB Service " + serviceConfigName));
                    endpointAdmin.createTopicEndpoint(endpoint);
                }
                artifact = new ESBArtifact(ESBArtifact.SERVICE, serviceConfigName);
                expProps.addRoot((IArtifact)artifact);
            }
            this.getLog().info((CharSequence)"Scan for Sonic Connect service configuration to be included in domain export...");
            File defaultSonicConnectServiceConfig = new File(this.project.getBasedir(), this.connectServiceLocation);
            if (defaultSonicConnectServiceConfig.exists()) {
                String serviceConfigName = ProjectAnalyzer.getServiceConfigNameFromFile(defaultSonicConnectServiceConfig);
                this.getLog().info((CharSequence)("Found ESB Service Configuration : " + serviceConfigName));
                this.getLog().info((CharSequence)("Importing '" + serviceConfigName + "' service config in Sonic Domain"));
                serviceAdmin.importServiceConfig(defaultSonicConnectServiceConfig, true);
                String endpoint = ProjectAnalyzer.getServiceConfigEntryRefFromFile(defaultSonicConnectServiceConfig);
                if (endpoint != null && !endpoint.isEmpty()) {
                    this.getLog().info((CharSequence)("Creating '" + endpoint + "' endpoint in Sonic Domain for ESB Service " + serviceConfigName));
                    endpointAdmin.createTopicEndpoint(endpoint);
                }
                ESBArtifact artifact2 = new ESBArtifact(ESBArtifact.SERVICE, serviceConfigName);
                expProps.addRoot((IArtifact)artifact2);
            }
            this.getLog().info((CharSequence)"Scan for local processes to be included in domain export...");
            for (File processFile : ProjectAnalyzer.getProcessSourceFiles(this.getSonicEsbSourceDirectory().getAbsolutePath())) {
                String processName = ProjectAnalyzer.getProcessNameFromFile(processFile);
                this.getLog().info((CharSequence)("Found ESB Process : " + processName));
                this.getLog().info((CharSequence)("Importing '" + processName + "' process in Sonic Domain"));
                processAdmin.importProcess(processFile, true);
                artifact = new ESBArtifact(ESBArtifact.PROCESS, processName);
                expProps.addRoot((IArtifact)artifact);
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Using empty root list as export properties");
            this.getLog().debug((Throwable)e);
            expProps = new ExportPropertiesArtifact();
        }
        return expProps;
    }

    protected File getExportPropFile() {
        return new File(this.getSonicEsbSourceDirectory(), this.exportPropFileName);
    }

    private void beautifyXarDirectory(File xarDir) {
        String[] dirsToBeautify;
        this.getLog().info((CharSequence)"Beautifying ESB artifacts");
        for (String dir : dirsToBeautify = new String[]{"ESB/Endpoints", "ESB/Services"}) {
            File workDir = new File(xarDir, dir);
            if (!workDir.canRead()) continue;
            try {
                List workFiles = FileUtils.getFiles((File)workDir, (String)"*.xml", (String)"", (boolean)true);
                for (File workFile : workFiles) {
                    this.getLog().debug((CharSequence)("Beautifying file " + workFile.getName()));
                    XMLSort.sortXMLFile(workFile);
                }
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
        }
    }
}

