/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.esb;

import com.aurea.maven.plugins.sonic.esb.EsbPackageMojo;
import com.aurea.maven.plugins.sonic.utils.FileUtilities;
import com.aurea.maven.plugins.sonic.utils.ZipUtilities;
import java.io.File;
import java.util.List;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class EsbDxsiPackageMojo
extends EsbPackageMojo {
    protected File targetDxsiDir;
    protected File unpackDxsiDir;

    @Override
    protected File createXarFile() throws Exception {
        String[] xarFiles;
        String[] xarExtension = new String[]{"xar"};
        for (String xarFilename : xarFiles = FileUtils.getFilesFromExtension((String)this.targetDxsiDir.getPath(), (String[])xarExtension)) {
            ZipUtilities.doUnzipAction(xarFilename, this.unpackDxsiDir.getPath());
        }
        FileUtilities.copyFiles(this.unpackDxsiDir.getCanonicalPath(), this.getPackageXarDir() + "", "**/*", this.getXarExcludePatterns(), "", false);
        return super.createXarFile();
    }

    @Override
    protected void addArtifactReplaceRules(List<Xpp3Dom> _replaceRules) {
        String originalValue = "sonicfs:///DataXtend/" + this.getProjectName();
        String updatedValue = "sonicfs:///" + this.getSonicFSProjectRoot() + "/" + this.getGroupId().replace(".", "/") + "/" + this.getArtifactId() + "/" + this.getVersion();
        Xpp3Dom projectReplace = new Xpp3Dom("stringReplaceMap");
        projectReplace.setAttribute("name", originalValue);
        projectReplace.setAttribute("updatedName", updatedValue);
        _replaceRules.add(projectReplace);
        this.getLog().info((CharSequence)("Adding stringReplaceMap: " + originalValue + " -> " + updatedValue));
    }

    private String getTargetDxsiDirRelativeToBasedir() {
        return this.targetDxsiDir.getAbsolutePath().replace(this.project.getBasedir().getAbsolutePath(), "").replace("\\", "/");
    }
}

