/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.topology.utils;

import com.aurea.maven.plugins.sonic.topology.utils.MachineConfig;
import java.io.Serializable;
import java.util.ArrayList;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MachineHolder
implements Serializable {
    private static final long serialVersionUID = 1L;
    ArrayList<MachineConfig> machineConfigs = new ArrayList();

    public void addMachineConfig(MachineConfig mc) {
        this.machineConfigs.add(mc);
    }

    public void removeMachineConfig(MachineConfig mc) {
        if (this.machineConfigs.contains(mc)) {
            this.machineConfigs.remove(mc);
        }
    }

    public ArrayList<MachineConfig> getMachineConfigs() {
        return this.machineConfigs;
    }

    /*
     * WARNING - void declaration
     */
    public void createMachineXmlContent(Xpp3Dom topology) {
        Xpp3Dom machines = new Xpp3Dom("Machines");
        for (MachineConfig mc : this.getMachineConfigs()) {
            void var8_8;
            void var8_18;
            void var8_16;
            void var8_14;
            if (mc.getMachineId().equals("")) continue;
            Xpp3Dom machine = new Xpp3Dom("Machine");
            Xpp3Dom machineId = new Xpp3Dom("Id");
            machineId.setValue(mc.getMachineId());
            machine.addChild(machineId);
            for (String string : mc.getAlternateIds()) {
                if (string.equals("")) continue;
                Xpp3Dom alternateId = new Xpp3Dom("AlternateId");
                alternateId.setValue(string);
                machine.addChild(alternateId);
            }
            Xpp3Dom logicalHosts = null;
            for (String logHostStr : mc.getLogicalhosts()) {
                if (logHostStr.isEmpty()) continue;
                Xpp3Dom logicalHost = new Xpp3Dom("LogicalHost");
                logicalHost.setValue(logHostStr);
                if (logicalHosts == null) {
                    logicalHosts = new Xpp3Dom("LogicalHosts");
                }
                logicalHosts.addChild(logicalHost);
            }
            Object var8_12 = null;
            if (mc.getContainerDir() != null && !mc.getContainerDir().equals("")) {
                if (var8_12 == null) {
                    Xpp3Dom xpp3Dom = new Xpp3Dom("Settings");
                }
                Xpp3Dom location = new Xpp3Dom("Locations");
                Xpp3Dom containerDir = new Xpp3Dom("ContainersDir");
                containerDir.setValue(mc.getContainerDir());
                location.addChild(containerDir);
                var8_14.addChild(location);
            }
            if (mc.getEncryptPWD() != null && !mc.getEncryptPWD().equals("")) {
                if (var8_14 == null) {
                    Xpp3Dom xpp3Dom = new Xpp3Dom("Settings");
                }
                Xpp3Dom encryption = new Xpp3Dom("BootfilesEncryptionPassword");
                encryption.setValue(mc.getEncryptPWD());
                var8_16.addChild(encryption);
            }
            if (mc.getRegisterAsService() != null && !mc.getRegisterAsService().equals("")) {
                if (var8_16 == null) {
                    Xpp3Dom xpp3Dom = new Xpp3Dom("Settings");
                }
                Xpp3Dom winService = new Xpp3Dom("RegisterBootContainersAsServices");
                winService.setValue(mc.getRegisterAsService());
                var8_18.addChild(winService);
            }
            if (mc.getServiceStartupTime() != null && !mc.getServiceStartupTime().equals("")) {
                if (var8_18 == null) {
                    Xpp3Dom xpp3Dom = new Xpp3Dom("Settings");
                }
                Xpp3Dom timeout = new Xpp3Dom("WindowsServicesStartupTimeout");
                timeout.setValue(mc.getServiceStartupTime());
                var8_8.addChild(timeout);
            }
            machine.addChild(logicalHosts);
            if (var8_8 != null) {
                machine.addChild((Xpp3Dom)var8_8);
            }
            machines.addChild(machine);
        }
        topology.addChild(machines);
    }
}

