/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.topology.utils;

import com.aurea.maven.plugins.sonic.topology.utils.ParameterHandlingException;
import com.aurea.maven.plugins.sonic.topology.utils.TopologyHolder;
import java.io.Serializable;
import java.util.HashMap;
import java.util.SortedSet;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class ParameterHolder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<String, String> pmholder = new HashMap();

    public boolean addParameter(String param, String value) throws ParameterHandlingException {
        if (this.pmholder.containsKey(param)) {
            System.out.println("Parametervalue is existing -- Cannot replace as this indicates a possible bad configuration");
            throw new ParameterHandlingException("Parametervalue is existing -- Cannot replace as this indicates a possible bad configuration");
        }
        this.pmholder.put(param, value);
        return true;
    }

    public String getParameter(String param) throws ParameterHandlingException {
        if (this.pmholder.containsKey(param)) {
            return this.pmholder.get(param);
        }
        throw new ParameterHandlingException("Parameter not found ... faulty configuration!!!");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String key : this.pmholder.keySet()) {
            sb.append(key + " : " + this.pmholder.get(key) + "\n");
        }
        return sb.toString();
    }

    public void createParameterXmlContent(Xpp3Dom topology, TopologyHolder tHolder, SortedSet<String> propNames) {
        Xpp3Dom parameters = new Xpp3Dom("Parameters");
        Xpp3Dom value = null;
        for (String prop : propNames) {
            Xpp3Dom parameter = new Xpp3Dom("Parameter");
            Xpp3Dom id = new Xpp3Dom("Id");
            value = new Xpp3Dom("Value");
            id.setValue(prop);
            try {
                String propValue = this.getParameter(prop);
                if (propValue.equalsIgnoreCase("<<PARENT>>")) {
                    value.setValue(tHolder.getPholder().getParameter(prop));
                } else {
                    value.setValue(this.getParameter(prop));
                }
            }
            catch (ParameterHandlingException e) {
                try {
                    value.setValue(tHolder.getPholder().getParameter(prop));
                }
                catch (ParameterHandlingException e1) {
                    continue;
                }
            }
            parameter.addChild(id);
            parameter.addChild(value);
            parameters.addChild(parameter);
        }
        topology.addChild(parameters);
    }
}

