/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.utils;

import com.aurea.maven.plugins.sonic.utils.FileUtilities;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class Xpp3Utils {
    public static final String PROPERTY_SEPARATOR = ";";

    public static void removeAllChildren(Xpp3Dom _element) {
        if (_element != null) {
            while (_element.getChildCount() > 0) {
                _element.removeChild(0);
            }
        }
    }

    public static void removeAllChildren(Xpp3Dom _element, String _path) {
        List<Xpp3Dom> tbdParents = Xpp3Utils.collectElements(_element, _path);
        for (Xpp3Dom tbdParent : tbdParents) {
            while (tbdParent.getChildCount() > 0) {
                tbdParent.removeChild(0);
            }
        }
    }

    public static List<Xpp3Dom> collectElements(Xpp3Dom _element, String _path) {
        ArrayList<Xpp3Dom> result = new ArrayList<Xpp3Dom>();
        if (_element != null) {
            if (_path != null && !"".equals(_path)) {
                Xpp3Utils.buildElementList(_element, _path.split("/"), result);
            } else {
                for (Xpp3Dom child : _element.getChildren()) {
                    result.add(child);
                }
            }
        }
        return result;
    }

    private static void buildElementList(Xpp3Dom _element, String[] _path, List<Xpp3Dom> _result) {
        if (_path.length == 0) {
            return;
        }
        List<Xpp3Dom> children = Xpp3Utils.collectImmediateChilds(_element, _path[0]);
        if (_path.length == 1) {
            _result.addAll(children);
        } else {
            String[] tail = new String[_path.length - 1];
            for (int i = 1; i < _path.length; ++i) {
                tail[i - 1] = _path[i];
            }
            for (Xpp3Dom child : children) {
                Xpp3Utils.buildElementList(child, tail, _result);
            }
        }
    }

    private static List<Xpp3Dom> collectImmediateChilds(Xpp3Dom _element, String _path) {
        ArrayList<Xpp3Dom> result = new ArrayList<Xpp3Dom>();
        if (_element != null && _path != null) {
            for (Xpp3Dom child : _element.getChildren()) {
                if (!child.getName().matches(_path)) continue;
                result.add(child);
            }
        }
        return result;
    }

    public static List<Xpp3Dom> collectElements(String _baseDir, String _extension) throws Exception {
        return Xpp3Utils.collectElements(_baseDir, _extension, ".*");
    }

    public static List<Xpp3Dom> collectElements(String _baseDir, String _extension, String _path) throws Exception {
        String path = _path;
        if (path == null) {
            path = ".*";
        }
        ArrayList<Xpp3Dom> result = new ArrayList<Xpp3Dom>();
        File baseDirFile = new File(_baseDir);
        if (baseDirFile.exists() && baseDirFile.isDirectory()) {
            for (String fileName : FileUtilities.getFileList(_baseDir, _extension, null)) {
                File queuesFile = new File(_baseDir, fileName);
                XmlStreamReader reader = new XmlStreamReader(queuesFile);
                Xpp3Dom dom = Xpp3DomBuilder.build((Reader)reader);
                result.addAll(Xpp3Utils.collectElements(dom, path));
            }
        }
        return result;
    }

    public static void removeChildByName(Xpp3Dom _dom, String _childName) {
        Xpp3Dom[] children = _dom.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].getName().equals(_childName)) continue;
            _dom.removeChild(i);
            return;
        }
    }

    public static Xpp3Dom createXpp3Dom(String _tagName) {
        return Xpp3Utils.createXpp3Dom(_tagName, null, null);
    }

    public static Xpp3Dom createXpp3Dom(String _tagName, String _content) {
        return Xpp3Utils.createXpp3Dom(_tagName, _content, null);
    }

    public static Xpp3Dom createXpp3Dom(String _tagName, String _content, String _attributes) {
        Xpp3Dom result = new Xpp3Dom(_tagName);
        if (_content != null) {
            result.setValue(_content);
        }
        if (_attributes != null) {
            Properties props = Xpp3Utils.stringToProperties(_attributes);
            Enumeration<Object> en = props.keys();
            while (en.hasMoreElements()) {
                String propName = (String)en.nextElement();
                result.setAttribute(propName, props.getProperty(propName));
            }
        }
        return result;
    }

    private static Properties stringToProperties(String _attributes) {
        Properties result = new Properties();
        if (_attributes != null && !"".equals(_attributes)) {
            String[] props;
            for (String prop : props = _attributes.split(PROPERTY_SEPARATOR)) {
                String[] nvPair = prop.split("=");
                if (nvPair.length != 2) continue;
                result.put(nvPair[0], nvPair[1]);
            }
        }
        return result;
    }

    public static List<Xpp3Dom> unifyXpp3List(List<Xpp3Dom> _original, String _keyExpression) {
        HashMap<String, Xpp3Dom> map = new HashMap<String, Xpp3Dom>();
        for (Xpp3Dom doc : _original) {
            try {
                NodeList nl = (NodeList)Xpp3Utils.evaluateXPath(doc, _keyExpression);
                if (nl.getLength() != 1) {
                    throw new RuntimeException("Xpath Expression received " + nl.getLength() + " nodes instead of one");
                }
                String key = nl.item(0).getTextContent();
                if (map.containsKey(key)) continue;
                map.put(key, doc);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList<Xpp3Dom> result = new ArrayList<Xpp3Dom>();
        result.addAll(map.values());
        return result;
    }

    public static Object evaluateXPath(Xpp3Dom _dom, String _xPathExpression) {
        Object result = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(_dom.toString().getBytes()));
            XPathFactory xpFactory = XPathFactory.newInstance();
            XPath xpath = xpFactory.newXPath();
            XPathExpression expr = xpath.compile(_xPathExpression);
            result = expr.evaluate(doc, XPathConstants.NODESET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Object evaluateXPath(Xpp3Dom _dom, String _xPathExpression, QName returnType) {
        Object result = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(_dom.toString().getBytes()));
            XPathFactory xpFactory = XPathFactory.newInstance();
            XPath xpath = xpFactory.newXPath();
            XPathExpression expr = xpath.compile(_xPathExpression);
            result = expr.evaluate(doc, returnType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

