/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.buildtools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class MakeVersion
extends Task {
    private String m_classname = null;
    private String m_outDirName = null;
    private String m_baseName = null;
    private Path m_classPath = null;
    private boolean m_override = false;
    private boolean m_addReleaseVersion = false;
    private String releaseVersion = "";

    public void setClass(String classname) {
        this.m_classname = classname;
    }

    public void setToDir(String toDir) {
        this.m_outDirName = toDir;
    }

    public void setBaseName(String baseName) {
        this.m_baseName = baseName;
    }

    public Path createClasspath() {
        this.m_classPath = new Path(this.getProject());
        return this.m_classPath;
    }

    public void setOverride(boolean b) {
        this.m_override = b;
    }

    public void setAddReleaseVersion(boolean addReleaseVersion) {
        this.m_addReleaseVersion = addReleaseVersion;
    }

    public void execute() throws BuildException {
        if (this.m_classname == null) {
            throw new BuildException("No Version class specified.");
        }
        if (this.m_outDirName == null) {
            throw new BuildException("No target directory file specified.");
        }
        if (this.m_baseName == null) {
            throw new BuildException("No basename specified.");
        }
        File outDir = new File(this.m_outDirName);
        if (!outDir.exists()) {
            throw new BuildException("Output directory does not exist: " + this.m_outDirName);
        }
        try {
            Class clazz = null;
            if (this.m_classPath != null) {
                AntClassLoader cl = new AntClassLoader(this.getProject(), this.m_classPath);
                clazz = cl.findClass(this.m_classname);
            } else {
                clazz = Class.forName(this.m_classname);
            }
            String major = this.getVersionProperty(clazz, "getMajorVersion");
            String minor = this.getVersionProperty(clazz, "getMinorVersion");
            String point = this.getOptionalVersionProperty(clazz, "getPointVersion");
            point = point != null ? point : "0";
            String build = this.getVersionProperty(clazz, "getBuildNumber");
            String revision = this.getOptionalVersionProperty(clazz, "getRevisionNumber");
            if (this.m_addReleaseVersion) {
                this.releaseVersion = this.getVersionProperty(clazz, "getReleaseVersion");
            }
            this.writeBasenameFile(outDir, major, minor, point, build, revision);
            this.writePropertiesFile(outDir, major, minor, point, build);
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void writeBasenameFile(File outDir, String major, String minor, String point, String build, String revision) throws IOException {
        String filename = this.m_baseName + major + "." + minor + "." + point + this.releaseVersion + ".txt";
        File outFile = new File(outDir, filename);
        this.log("Checking version file: " + outFile.getAbsolutePath(), 3);
        if (!outFile.exists() || this.m_override) {
            PrintWriter pw = new PrintWriter(new FileWriter(outFile));
            pw.println("MAJOR_VERSION=" + major);
            pw.println("MINOR_VERSION=" + minor);
            pw.println("POINT_VERSION=" + (point != null ? point : "0"));
            pw.println(this.isSet(build) ? "BUILD_NUMBER=" + build : "DEVELOPER BUILD");
            if (this.isSet(revision)) {
                pw.println("REVISION=" + revision);
            }
            pw.flush();
            pw.close();
            this.log("Created version file: " + outFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePropertiesFile(File outDir, String major, String minor, String point, String build) throws IOException {
        Properties properties = new Properties();
        properties.setProperty("progress.sonic.version", major + "." + minor + "." + point + "." + build);
        try (FileOutputStream out = new FileOutputStream(new File(outDir, "progress.sonic.version.properties"));){
            properties.store(out, null);
        }
    }

    private String getVersionProperty(Class c, String methodname) throws Exception {
        String result = this.getOptionalVersionProperty(c, methodname);
        if (result == null) {
            throw new BuildException("Could not find method '" + methodname + "' in class: " + c.getName());
        }
        return result;
    }

    private String getOptionalVersionProperty(Class c, String methodname) throws Exception {
        try {
            Method m = c.getMethod(methodname, new Class[0]);
            Object o = m.invoke(null, new Object[0]);
            return o.toString();
        }
        catch (NoSuchMethodException excp) {
            return null;
        }
    }

    private boolean isSet(String property) {
        return property != null && !"0".equals(property);
    }
}

