/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.buildtools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class Pack200Task
extends MatchingTask {
    private static final String EXT_JAR = ".jar";
    private static final String ERRMSG_ZF = "zipfile attribute must end";
    protected static final String COM_PREFIX = "com.sun.java.util.jar.pack.";
    private boolean doRepack = false;
    private boolean doGZIP = false;
    private File dir;
    private boolean removeSource = false;
    private HashMap<String, String> propMap = new HashMap();

    public void execute() throws BuildException {
        String[] files;
        if (null == this.dir || !this.dir.exists() || !this.dir.isDirectory()) {
            throw new BuildException("dir attribute is not set of not a directory.");
        }
        if (this.doRepack) {
            this.doGZIP = false;
            this.removeSource = false;
        }
        DirectoryScanner ds = this.getDirectoryScanner(this.dir);
        for (String file : files = ds.getIncludedFiles()) {
            String outFile;
            if (file.endsWith(EXT_JAR)) {
                if (this.doRepack) {
                    outFile = file;
                } else {
                    outFile = file + ".pack";
                    if (this.doGZIP) {
                        outFile = outFile + ".gz";
                    }
                }
            } else {
                throw new BuildException("File " + file + " must and with .jar");
            }
            this.pack(new File(this.dir, file), new File(this.dir, outFile));
        }
    }

    private void validate(File outputFile) throws BuildException {
        if (this.doGZIP) {
            if (!outputFile.toString().toLowerCase().endsWith(".gz")) {
                throw new BuildException("zipfile attribute must end with .gz extension", this.getLocation());
            }
        } else if (this.doRepack) {
            if (!outputFile.toString().toLowerCase().endsWith(EXT_JAR)) {
                throw new BuildException("zipfile attribute must end with .jar extension", this.getLocation());
            }
        } else if (!outputFile.toString().toLowerCase().endsWith(".pack") && !outputFile.toString().toLowerCase().endsWith(".pac")) {
            throw new BuildException("zipfile attribute must endwith .pack or .pac extension", this.getLocation());
        }
    }

    public void setDir(File _dir) {
        this.dir = _dir;
    }

    public void setRemoveSource(boolean _removeSource) {
        this.removeSource = _removeSource;
    }

    public void setRepack(boolean value) {
        this.doRepack = value;
    }

    public void setGZIPOutput(boolean value) {
        this.doGZIP = value;
    }

    public void setStripDebug(String value) {
        this.propMap.put("com.sun.java.util.jar.pack.strip.debug", value);
    }

    public void setModificationTime(String value) {
        this.propMap.put("pack.modification.time", value);
    }

    public void setDeflateHint(String value) {
        this.propMap.put("pack.deflate.hint", value);
    }

    public void setKeepFileOrder(String value) {
        this.propMap.put("pack.keep.file.order", value);
    }

    public void setSegmentLimit(String value) {
        this.propMap.put("pack.segment.limit", value);
    }

    public void setEffort(String value) {
        this.propMap.put("pack.effort", value);
    }

    public void setUnknownAttribute(String value) {
        this.propMap.put("pack.unknown.attribute", value);
    }

    public void setVerbose(String value) {
        this.propMap.put("com.sun.java.util.jar.pack.verbose", value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pack(File source, File targetFile) {
        block7: {
            this.validate(targetFile);
            try {
                if (this.doRepack) {
                    this.log("Repack Pack200 " + source);
                    File packFile = new File(targetFile.toString() + ".tmp");
                    try {
                        this.compress(source, packFile);
                        this.uncompress(packFile, targetFile);
                        break block7;
                    }
                    finally {
                        packFile.delete();
                    }
                }
                this.log("Pack200 " + source);
                this.compress(source, targetFile);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new BuildException("Error in pack200");
            }
        }
        if (this.removeSource) {
            source.delete();
        }
    }

    private void uncompress(File packFile, File targetFile) throws FileNotFoundException, IOException {
        BufferedInputStream previouslyPacked = new BufferedInputStream(new FileInputStream(packFile));
        JarOutputStream repackOutput = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(targetFile)));
        Pack200.Unpacker unpkr = Pack200.newUnpacker();
        unpkr.properties().putAll(this.propMap);
        unpkr.unpack((InputStream)previouslyPacked, repackOutput);
        ((InputStream)previouslyPacked).close();
        repackOutput.close();
    }

    private void compress(File source, File target) throws IOException, FileNotFoundException {
        if (target.exists() && target.lastModified() > source.lastModified()) {
            return;
        }
        Pack200.Packer pkr = Pack200.newPacker();
        pkr.properties().putAll(this.propMap);
        JarFile jarFile = new JarFile(source);
        FileOutputStream fos = new FileOutputStream(target);
        BufferedOutputStream os = this.doGZIP ? new BufferedOutputStream(new GZIPOutputStream(fos)) : new BufferedOutputStream(fos);
        pkr.pack(jarFile, (OutputStream)os);
        ((OutputStream)os).close();
    }
}

