/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.buildtools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.SortedMap;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class Unpack200Task
extends MatchingTask {
    private static final String EXT_PACK_GZ = ".pack.gz";
    private static final String EXT_PACK = ".pack";
    private SortedMap<String, String> propMap;
    private Pack200.Unpacker unpkr = Pack200.newUnpacker();
    private File dir;

    public Unpack200Task() {
        this.propMap = this.unpkr.properties();
    }

    public void setVerbose(String value) {
        this.propMap.put("com.sun.java.util.jar.pack.verbose", value);
    }

    public void setDir(File _dir) {
        this.dir = _dir;
    }

    public void execute() throws BuildException {
        String[] files;
        if (null == this.dir || !this.dir.exists() || !this.dir.isDirectory()) {
            throw new BuildException("dir attribute is not set of not a directory.");
        }
        DirectoryScanner ds = this.getDirectoryScanner(this.dir);
        for (String file : files = ds.getIncludedFiles()) {
            String outFile;
            if (file.endsWith(EXT_PACK)) {
                outFile = file.substring(0, file.length() - EXT_PACK.length());
            } else if (file.endsWith(EXT_PACK_GZ)) {
                outFile = file.substring(0, file.length() - EXT_PACK_GZ.length());
            } else {
                throw new BuildException("File " + file + " must and with .pack[.gz]");
            }
            this.extract(new File(this.dir, file), new File(this.dir, outFile));
        }
    }

    private FileType getMagic(File in) throws IOException {
        DataInputStream is = new DataInputStream(new FileInputStream(in));
        int i = is.readInt();
        is.close();
        if ((i & 0xFFFFFF00) == 529205248) {
            return FileType.gzip;
        }
        if (i == -889270259) {
            return FileType.pack200;
        }
        if (i == 1347093252) {
            return FileType.zip;
        }
        return FileType.unknown;
    }

    private void extract(File source, File dest) {
        this.log("Unpacking with Unpack200", 3);
        this.log("Source File :" + source, 3);
        this.log("Dest.  File :" + dest, 3);
        try {
            FileInputStream fis = new FileInputStream(source);
            BufferedInputStream is = FileType.gzip == this.getMagic(source) ? new BufferedInputStream(new GZIPInputStream(fis)) : new BufferedInputStream(fis);
            FileOutputStream fos = new FileOutputStream(dest);
            JarOutputStream jout = new JarOutputStream(new BufferedOutputStream(fos));
            this.unpkr.unpack((InputStream)is, jout);
            jout.close();
        }
        catch (IOException ioe) {
            throw new BuildException("Error in unpack200");
        }
    }

    static enum FileType {
        unknown,
        gzip,
        pack200,
        zip;

    }
}

