/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.eclipse;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.Version;
import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromElementType;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.util.MonitoredContainer;
import com.sonicsw.mf.common.util.MonitoredContainerList;
import com.sonicsw.mf.eclipse.EclipseDSHandler;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.util.SonicFSException;
import com.sonicsw.mx.config.util.SonicFSFileSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class AddToDS {
    private static String AUTO_START_DAEMON_NAME = "/Framework Components/WorkbenchAutoStartContainers";
    private static String DAEMON_ARCHIVE_VALUE = "MF/" + Version.getMajorVersion() + "." + Version.getMinorVersion() + "/MFdaemon.car";
    private static volatile String m_DMContainerConfigID;
    private static final String VERSION_MAJOR_MINOR;
    private static final String SYSTEM_IW_MAJOR_MINOR_LIB;
    private static final String ECLIPSE_HANDLER_JAR;
    private static final String ECLIPSE_HANDLER_JAR_URL;
    private static final String MFLIBRARY_DS_HANDLERS_ECLIPSE_HANDLER = "/_MFLibrary/ds_handlers/EclipseHandler";
    private static final String WORKSPACE_HANDLER_NAME_PREFIX = "/workspace";
    private static boolean DEBUG;
    private static boolean firstDebug;
    private static volatile String m_url;
    private static volatile String m_user;
    private static volatile String m_password;
    private static volatile String m_domain;
    private String m_importFile = null;
    private String m_eclipseWorkspace = null;
    private static volatile ConfigServerUtility m_csu;
    private static volatile IDirectoryAdminService m_dsAdmin;
    private static volatile IDirectoryFileSystemService m_dsFS;
    private static volatile SonicFSFileSystem m_fs;
    static volatile IConfigServer configServer;

    public static void main(String[] args) throws Exception {
        new AddToDS(args);
    }

    public AddToDS(String[] args) throws Exception {
        this.parseArgs(args);
        AddToDS.connect();
        try {
            this.unregisterEclipseHandler();
            this.unregisterWorkspaceMapping();
            AddToDS.disconnect();
            AddToDS.connect();
            AddToDS.initializeLauncherDaemon();
            m_dsFS.createFolder(WORKSPACE_HANDLER_NAME_PREFIX, true);
            this.uploadEclipseHandlerJar();
            this.registerWorkspaceMapping();
            this.registerEclipseHandler();
            this.setupMonitoredContainers();
        }
        catch (Exception e) {
            System.out.println("*Error*: while seeding the Eclipse handler due to " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        finally {
            if (m_csu != null) {
                try {
                    AddToDS.disconnect();
                }
                catch (ConfigServiceException e) {}
                m_csu = null;
                m_dsAdmin = null;
                m_dsFS = null;
                m_fs = null;
            }
        }
    }

    private void unregisterWorkspaceMapping() {
        try {
            IDirElement mappingEl = m_dsAdmin.getElement("/_MFLibrary/ds_handlers/eclipse/_mapping", false, false);
            if (mappingEl != null) {
                this.m_eclipseWorkspace = (String)mappingEl.getAttributes().getAttribute("ECLIPSE_WORKSPACE_DISK_LOCATION");
                m_dsAdmin.deleteElement("/_MFLibrary/ds_handlers/eclipse/_mapping", null);
            }
        }
        catch (DirectoryServiceException directoryServiceException) {
            // empty catch block
        }
    }

    private void registerWorkspaceMapping() throws ConfigException, DirectoryServiceException {
        try {
            m_dsAdmin.createDirectory("/_MFLibrary/ds_handlers/eclipse");
        }
        catch (DirectoryServiceException e) {
            // empty catch block
        }
        IDirElement handlerMap = ElementFactory.createElement((String)"/_MFLibrary/ds_handlers/eclipse/_mapping", (String)"Eclipse_Map", (String)"1.0");
        IAttributeSet topSet = handlerMap.getAttributes();
        topSet.setStringAttribute("ECLIPSE_WORKSPACE_DISK_LOCATION", this.m_eclipseWorkspace);
        AddToDS.debug("Set string attribute for ECLIPSE_WORKSPACE_DISK_LOCATION");
        m_dsAdmin.setElement(handlerMap.doneUpdate(), null);
    }

    private void registerEclipseHandler() throws ReadOnlyException, AttributeSetTypeException, ConfigException, DirectoryServiceException, VersionOutofSyncException {
        IDirElement handlerEl = ElementFactory.createElement((String)MFLIBRARY_DS_HANDLERS_ECLIPSE_HANDLER, (String)"MF_DS_HANDLER", (String)VERSION_MAJOR_MINOR);
        IAttributeSet topSet = handlerEl.getAttributes();
        topSet.setStringAttribute("DS_HANDLER_NAME", WORKSPACE_HANDLER_NAME_PREFIX);
        topSet.setStringAttribute("DS_HANDLER_CLASS", EclipseDSHandler.class.getName());
        IAttributeList archiveList = topSet.createAttributeList("DS_HANDLER_ARCHIVES");
        archiveList.addStringItem(ECLIPSE_HANDLER_JAR_URL);
        m_dsAdmin.setElement(handlerEl.doneUpdate(), null);
    }

    private void unregisterEclipseHandler() throws DirectoryServiceException, VersionOutofSyncException {
        IDirElement handlerElement = m_dsAdmin.getElement(MFLIBRARY_DS_HANDLERS_ECLIPSE_HANDLER, false);
        AddToDS.debug("handlerElement = " + handlerElement);
        if (handlerElement != null) {
            m_dsAdmin.deleteElement(MFLIBRARY_DS_HANDLERS_ECLIPSE_HANDLER, null);
        }
    }

    private void uploadEclipseHandlerJar() throws SonicFSException {
        m_fs.createDirectoryPath(SYSTEM_IW_MAJOR_MINOR_LIB);
        m_fs.updateFile(ECLIPSE_HANDLER_JAR, new File(this.m_importFile), true);
    }

    private void parseArgs(String[] args) {
        if (args.length < 10) {
            AddToDS.printUsage();
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equalsIgnoreCase("-url")) {
                    m_url = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-user")) {
                    m_user = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-password")) {
                    m_password = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-domain")) {
                    m_domain = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-importFile")) {
                    this.m_importFile = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-eclipseWorkspace")) {
                    this.m_eclipseWorkspace = args[++i];
                    continue;
                }
                AddToDS.printUsage();
                continue;
            }
            AddToDS.printUsage();
        }
        if (m_url == null || m_user == null || m_domain == null || this.m_importFile == null || this.m_eclipseWorkspace == null) {
            AddToDS.printUsage();
        }
    }

    private void setupMonitoredContainers() throws Exception {
        try {
            MonitoredContainerList.setMonitoredContainerList((IDirectoryFileSystemService)m_dsFS, (MonitoredContainer[])new MonitoredContainer[]{new MonitoredContainer("/Containers/dev_ESBCore", true), new MonitoredContainer("/Containers/dev_ESBTest", true)});
            if (DEBUG) {
                MonitoredContainer[] mcList = MonitoredContainerList.getMonitoredContainerList((IDirectoryFileSystemService)m_dsFS);
                for (int i = 0; i < mcList.length; ++i) {
                    AddToDS.debug("MonitoredContainerList[" + i + "] = (" + mcList[i].getContainerLogicalPath() + ", " + mcList[i].isAutoLaunch() + ")");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error: while setting monitored container list due to " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    private static void printUsage() {
        System.out.println("(-url <url>) (-user <user>) (-password <password>) (-domain <domain>) (-importFile <import file>) (-eclipseWorkspace <eclipse workspace>)");
        System.out.println("The pairs can be in any order, but all must be used");
        System.out.println("Example:\n-url tcp://localhost:2506 -user Administrator -password Administrator -domain Domain1 -importFile C:\\Sonic\\Workbench8.0\\lib\\EclipseHandler.jar -eclipseWorkspace C:\\Sonic\\Workbench8.0\\workspace");
        System.exit(1);
    }

    protected static void debug(String message) {
        if (DEBUG && firstDebug) {
            System.out.println("AddToDS:");
            firstDebug = false;
        }
        if (DEBUG) {
            System.out.println("\tAddToDS: " + message);
        }
    }

    private static void connect() throws ConfigServiceException {
        m_csu = new ConfigServerUtility();
        m_csu.connect(m_domain, m_url, m_user, m_password, true);
        m_dsAdmin = (IDirectoryAdminService)m_csu.getDirectoryService();
        m_dsFS = m_csu.getDirectoryService();
        m_fs = new SonicFSFileSystem(m_csu.getDirectoryService(), m_user);
        configServer = m_csu.getConfigServer();
    }

    private static void disconnect() throws ConfigServiceException {
        m_csu.disconnect();
        m_csu = null;
        m_dsAdmin = null;
        m_dsFS = null;
        m_fs = null;
        configServer = null;
    }

    public static void configureLauncherDaemon(String[] args) throws Exception {
        try {
            AddToDS.parseLDArgs(args);
            AddToDS.connect();
            AddToDS.initializeLauncherDaemon();
        }
        catch (Exception e) {
            System.out.println("*Error*: while configuring Launcher Daemon " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        finally {
            if (m_csu != null) {
                try {
                    AddToDS.disconnect();
                }
                catch (ConfigServiceException configServiceException) {}
                m_csu = null;
                m_dsAdmin = null;
                m_dsFS = null;
                m_fs = null;
                configServer = null;
            }
        }
    }

    private static void parseLDArgs(String[] args) {
        if (args.length < 6) {
            AddToDS.printLDUsage();
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equalsIgnoreCase("-url")) {
                    m_url = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-user")) {
                    m_user = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-password")) {
                    m_password = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-domain")) {
                    m_domain = args[++i];
                    continue;
                }
                AddToDS.printLDUsage();
                continue;
            }
            AddToDS.printLDUsage();
        }
        if (m_url == null || m_user == null || m_domain == null) {
            AddToDS.printLDUsage();
        }
    }

    private static void printLDUsage() {
        System.out.println("(-url <url>) (-user <user>) (-password <password>) (-domain <domain>)");
        System.out.println("The pairs can be in any order, but all must be used");
        System.out.println("Example:\n-url tcp://localhost:2506 -user Administrator -password Administrator -domain Domain1 ");
        System.exit(1);
    }

    private static void initializeLauncherDaemon() throws Exception {
        AddToDS.findDomainManagerName();
        if (configServer.loadConfigElement(AUTO_START_DAEMON_NAME) == null && m_DMContainerConfigID != null) {
            AddToDS.createAutoLaunchDaemon();
        }
    }

    private static IConfigElement createAutoLaunchDaemon() throws Exception {
        IConfigBean daemon = null;
        try {
            daemon = configServer.createConfigBean(AUTO_START_DAEMON_NAME, "MF_ACTIVATION_DAEMON", "107", false);
            daemon.setAttribute("CLASSNAME", (Object)"com.sonicsw.mf.framework.daemon.ActivationDaemon");
            daemon.setAttribute("ARCHIVE_NAME", (Object)DAEMON_ARCHIVE_VALUE);
            daemon.createAttributeMap("CONTAINERS");
            HashMap<String, String> metaAttributes = configServer.getMetaAttributes(AUTO_START_DAEMON_NAME);
            if (metaAttributes == null) {
                metaAttributes = new HashMap<String, String>();
            }
            metaAttributes.put("TYPE", "MF_ACTIVATION_DAEMON");
            metaAttributes.put("CONFIG_VERSION", "107");
            metaAttributes.put("PRODUCT_VERSION", "10.0");
            IConfigElement domainManager = configServer.loadConfigElement(m_DMContainerConfigID);
            IAttributeMap componentsMap = (IAttributeMap)domainManager.getAttribute("COMPONENTS");
            IAttributeMap daemonMap = componentsMap.createAttributeMap("AutoLaunchDaemon");
            daemonMap.setAttribute("CONFIG_REF", (Object)daemon);
            componentsMap.setAttribute("AutoLaunchDaemon", (Object)daemonMap);
            configServer.storeConfigElement(domainManager);
            configServer.storeConfigElement((IConfigElement)daemon);
            configServer.setMetaAttributes(AUTO_START_DAEMON_NAME, metaAttributes);
            AddToDS.debug(AUTO_START_DAEMON_NAME);
        }
        catch (Exception e) {
            System.out.println("Error: while creating Auto Launch Daemon due to " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return daemon;
    }

    private static void findDomainManagerName() throws MalformedObjectNameException, ConfigServiceException, ReflectionException, InstanceNotFoundException, MBeanException {
        IRemoteMBeanServer mBeanServer = m_csu.getMBeanServer();
        if (mBeanServer != null && mBeanServer.isConnected()) {
            ObjectName id = new ObjectName(m_csu.getDomain() + "." + "DIRECTORY SERVICE" + ":ID=" + "AGENT");
            IContainerState state = (IContainerState)m_csu.getMBeanServer().invoke(id, "getContainerState", new Object[0], new String[0]);
            m_DMContainerConfigID = configServer.storageToLogical(state.getRuntimeIdentity().getConfigIdentity().getName());
        } else {
            Set containers = AddToDS.listAllOfType("MF_CONTAINER");
            if (containers != null) {
                Iterator containersIT = containers.iterator();
                String domainManagerID = null;
                boolean multipleContainers = false;
                while (containersIT.hasNext() && !multipleContainers) {
                    String containerName = (String)containersIT.next();
                    IConfigElement[] dsComponents = AddToDS.getComponents(containerName, "MF_DIRECTORY_SERVICE");
                    if (dsComponents != null && dsComponents.length == 1) {
                        if (domainManagerID == null) {
                            domainManagerID = containerName;
                        } else {
                            multipleContainers = true;
                        }
                    }
                    if (multipleContainers) continue;
                    m_DMContainerConfigID = domainManagerID;
                }
            }
        }
    }

    private static Set listAllOfType(String type) throws ConfigServiceException {
        Query typeQuery = new Query();
        typeQuery.setFrom((From)new FromElementType(type));
        return configServer.listConfigElements(typeQuery);
    }

    private static IConfigElement[] getComponents(String containerName, String componentType) throws ConfigServiceException {
        ArrayList<IConfigElement> result = new ArrayList<IConfigElement>();
        IConfigElement container = configServer.loadConfigElement(containerName);
        if (container == null) {
            throw new ConfigServiceException("getComponents failed: container " + containerName + " does not exist");
        }
        IAttributeMap components = (IAttributeMap)container.getAttribute("COMPONENTS");
        Collection compCollection = components.values();
        for (Object x : compCollection) {
            IAttributeMap componentMap = (IAttributeMap)x;
            IConfigBean component = (IConfigBean)componentMap.getAttribute("CONFIG_REF");
            if (!component.getConfigType().getName().equals(componentType)) continue;
            IConfigElement configEl = configServer.loadConfigElement(component.getName());
            result.add(configEl);
        }
        IConfigElement[] resultArray = new IConfigElement[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    static {
        VERSION_MAJOR_MINOR = Version.getMajorVersion() + "." + Version.getMinorVersion();
        SYSTEM_IW_MAJOR_MINOR_LIB = "/System/IW/" + VERSION_MAJOR_MINOR + "/lib";
        ECLIPSE_HANDLER_JAR = SYSTEM_IW_MAJOR_MINOR_LIB + "/EclipseHandler.jar";
        ECLIPSE_HANDLER_JAR_URL = "sonicfs://" + ECLIPSE_HANDLER_JAR;
        DEBUG = true;
        firstDebug = true;
        m_url = null;
        m_user = null;
        m_password = null;
        m_domain = null;
    }
}

