/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.eclipse;

import com.sonicsw.mf.common.config.AbstractDSHandler;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.config.IChunkedBlobStreamer;
import com.sonicsw.mf.common.config.IDSHandlerContext;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.INamingNotification;
import com.sonicsw.mf.common.config.INextVersionToken;
import com.sonicsw.mf.common.config.impl.Blob;
import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.config.impl.ElementCreateNotification;
import com.sonicsw.mf.common.config.impl.ElementIdentity;
import com.sonicsw.mf.common.config.impl.FolderCreateNotification;
import com.sonicsw.mf.common.config.impl.MetaAttributesChangeNotification;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.common.view.INamingListener;
import com.sonicsw.mf.eclipse.LinkDescription;
import com.sonicsw.mf.eclipse.ProjectDescriptionReader;
import com.sonicsw.mf.eclipse.SafeChunkyInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

public class EclipseDSHandler
extends AbstractDSHandler
implements IChunkedBlobStreamer {
    private static final String URI_PREFIX = "URI//";
    private static final String FILE_SEPARATOR = System.getProperties().getProperty("file.separator");
    private static final char FILE_SEPARATOR_CHAR = FILE_SEPARATOR.charAt(0);
    private static final String ECLIPSE_ELEMENT_TYPE = "MF_FILE";
    private static final String ECLIPSE_ELEMENT_RELEASE_VERSION = "100";
    public static final String ECLIPSE_WORKSPACE_DISK_LOCATION_ATTR = "ECLIPSE_WORKSPACE_DISK_LOCATION";
    public static final String MAP_ELEMENT_NAME = "EclipseMap";
    public static final String MAPPING_STORAGE_DIRECTORY = "/_MFLibrary/ds_handlers/eclipse";
    public static final String MAPPING_STORAGE_NAME = "/_MFLibrary/ds_handlers/eclipse/_mapping";
    private static final String TOOL_ATTRIBUTES_ATTR = "TOOL_ATTRIBUTES";
    private static final String SIZE_ATTR = "SIZE";
    private static final String LAST_MODIFIED_TIME_ATTR = "LAST_MODIFIED_TIME";
    private static final String PERMISSIONS_ATTR = "PERMISSIONS";
    private static final String CREATION_TIME_ATTR = "CREATION_TIME";
    private static final String CREATED_BY_ATTR = "CREATED_BY";
    private static final String HIDDEN_ATTR = "HIDDEN";
    private static final String PROJECT_METADATA_DIR = ".metadata" + FILE_SEPARATOR + ".plugins" + FILE_SEPARATOR + "org.eclipse.core.resources" + FILE_SEPARATOR + ".projects";
    private static final String PROJECT_SAFETABLE_PATH = ".metadata" + FILE_SEPARATOR + ".plugins" + FILE_SEPARATOR + "org.eclipse.core.resources" + FILE_SEPARATOR + ".safetable" + FILE_SEPARATOR + "org.eclipse.core.resources";
    private static final String PROJECT_DESCRIPTION_FILE = ".project";
    private static final String DS_FILE_SEPARATOR = new String(new byte[]{47});
    private String m_workspaceDiskLocation;
    private String m_metadataFolder;
    private NamingNotificationManager m_notificationManager;
    boolean DEBUG = false;

    public EclipseDSHandler() {
        String prop = System.getProperty("EclipseHandlerDebug", "false");
        this.DEBUG = prop.equals("true");
        if (this.DEBUG) {
            System.out.println("EclipseDSHandler constructor called");
        }
        this.m_notificationManager = new NamingNotificationManager();
    }

    public void setMetaAttributes(String name, HashMap newAttributes) throws DirectoryServiceException {
    }

    public HashMap getMetaAttributes(String logicalName) throws DirectoryServiceException {
        if (this.DEBUG) {
            System.out.println("\nAPI CALL EclipseDSHandler.getMetaAttributes for logicalName " + logicalName);
        }
        HashMap<String, String> metaAttrs = new HashMap<String, String>();
        EclipseFile eFile = new EclipseFile(logicalName);
        String onDiskName = eFile.m_diskLocation;
        if (onDiskName == null) {
            String withoutSlash;
            String withSlash;
            if (this.DEBUG) {
                System.out.println("EclipseDSHandler.getMetaAttributes onDiskName was null");
            }
            if (logicalName.endsWith(DS_FILE_SEPARATOR)) {
                withSlash = logicalName;
                withoutSlash = logicalName.substring(0, logicalName.length() - 1);
            } else {
                withoutSlash = logicalName;
                withSlash = logicalName + DS_FILE_SEPARATOR;
            }
            if (withSlash.equals(this.m_handlerName) || withoutSlash.equals(this.m_handlerName)) {
                String[] definedMetaAttributes = this.m_dsContext.getDefinedFolderMetaAttributes();
                for (int i = 0; i < definedMetaAttributes.length; ++i) {
                    metaAttrs.put(definedMetaAttributes[i], null);
                }
                metaAttrs.put("_FOLDER_NAME", logicalName);
                return metaAttrs;
            }
            return null;
        }
        File onDiskFile = new File(onDiskName);
        if (onDiskFile.exists()) {
            if (this.DEBUG) {
                System.out.println("EclipseDSHandler.getMetaAttributes file exists: " + onDiskName);
            }
            String[] definedMetaAttributes = onDiskFile.isFile() ? this.m_dsContext.getDefinedElementMetaAttributes() : this.m_dsContext.getDefinedFolderMetaAttributes();
            for (int i = 0; i < definedMetaAttributes.length; ++i) {
                metaAttrs.put(definedMetaAttributes[i], null);
            }
            if (onDiskFile.isFile()) {
                if (this.DEBUG) {
                    System.out.println("EclipseDSHandler.getMetaAttributes logicalName is a file\n");
                }
                metaAttrs.put("_ELEMENT_IDENTITY", (String)this.createElementIdentity(logicalName));
                metaAttrs.put(TOOL_ATTRIBUTES_ATTR, "TYPE=MF_FILE");
            } else {
                if (this.DEBUG) {
                    System.out.println("EclipseDSHandler.getMetaAttributes logicalName is a folder, setting _FOLDER_NAME to " + logicalName + "\n");
                }
                metaAttrs.put("_FOLDER_NAME", logicalName);
            }
            return metaAttrs;
        }
        if (this.DEBUG) {
            System.out.println("EclipseDSHandler.getMetaAttributes file does not exist: " + onDiskName + "\n");
        }
        return null;
    }

    public HashMap[] listFolders(String folderPath) throws DirectoryServiceException {
        if (this.DEBUG) {
            System.out.println("\nAPI CALL EclipseDSHandler.listFolders folderPath == " + folderPath);
        }
        ArrayList returnFolders = this.listFoldersInternal(folderPath);
        HashMap[] all = new HashMap[returnFolders.size()];
        return returnFolders.toArray(all);
    }

    public HashMap[] listFSAll(String folderPath) throws DirectoryServiceException {
        if (this.DEBUG) {
            System.out.println("\nAPI CALL EclipseDSHandler.listFSAll with folder " + folderPath);
        }
        ArrayList returnAll = this.listFSAll(folderPath, true, true, null);
        HashMap[] all = new HashMap[returnAll.size()];
        return returnAll.toArray(all);
    }

    private void addLinkedResources(EclipseFile eFile, ArrayList returnAll) throws DirectoryServiceException {
        if (this.DEBUG) {
            System.out.println("\nEclipseDSHandler.addLinkedResources, file.m_diskLocation == " + eFile.m_diskLocation);
        }
        if (eFile.m_logicalName.endsWith(eFile.m_projectName) && eFile.m_linkedResources != null) {
            HashMap linkedResources = eFile.m_linkedResources;
            Set linkNames = linkedResources.keySet();
            for (String linkName : linkNames) {
                LinkDescription descr = (LinkDescription)linkedResources.get(linkName);
                if (descr.getType() != 2) continue;
                returnAll.add(this.getMetaAttributes(eFile.m_logicalName + '/' + linkName));
            }
        }
    }

    public ArrayList listFSAll(String folderPath, boolean getFolders, boolean getElements, String extension) throws DirectoryServiceException {
        ArrayList retList = new ArrayList();
        if (this.DEBUG) {
            System.out.println("\nAPI CALL EclipseDSHandler.listFSAll folderPath == " + folderPath);
        }
        if (getFolders) {
            retList.addAll(this.listFoldersInternal(folderPath));
        }
        if (getElements) {
            retList.addAll(this.listFSElementsInternal(folderPath, extension));
        }
        return retList;
    }

    public HashMap[] listFSElements(String folderPath) throws DirectoryServiceException {
        if (this.DEBUG) {
            System.out.println("\nAPI CALL EclipseDSHandler.listFSElements with folder " + folderPath);
        }
        ArrayList<HashMap> returnElements = new ArrayList<HashMap>();
        EclipseFile eFile = new EclipseFile(folderPath);
        String mappedPath = eFile.m_diskLocation;
        if (mappedPath == null) {
            String withoutSlash;
            String withSlash;
            if (folderPath.endsWith(DS_FILE_SEPARATOR)) {
                withSlash = folderPath;
                withoutSlash = folderPath.substring(0, folderPath.length() - 1);
            } else {
                withoutSlash = folderPath;
                withSlash = folderPath + DS_FILE_SEPARATOR;
            }
            if (withSlash.equals(this.m_handlerName) || withoutSlash.equals(this.m_handlerName)) {
                return new HashMap[0];
            }
            throw new DirectoryServiceException("Folder " + folderPath + " does not exist");
        }
        File mappedFile = new File(mappedPath);
        if (!mappedFile.exists()) {
            throw new DirectoryServiceException("Folder " + folderPath + " does not exist");
        }
        if (mappedFile.isFile()) {
            throw new DirectoryServiceException(folderPath + " is not a folder");
        }
        File[] children = mappedFile.listFiles();
        String projectName = eFile.m_projectName;
        try {
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].isFile()) continue;
                returnElements.add(this.getMetaAttributes(this.getLogicalName(children[i].getCanonicalPath(), projectName)));
            }
        }
        catch (Exception e) {
            if (this.DEBUG) {
                System.out.println("EclipseDSHandler.listFSElements caught exception, trace follows");
                e.printStackTrace(System.out);
            }
            throw new DirectoryServiceException("Could not list files for " + folderPath + ": " + e.toString(), (Throwable)e);
        }
        HashMap[] all = new HashMap[returnElements.size()];
        return returnElements.toArray(all);
    }

    public IBlob getBlobByLogicalName(String blobName) throws DirectoryServiceException {
        if (this.DEBUG) {
            System.out.println("\nAPI CALL EclipseDSHandler.getBlobByLogicalName blobName == " + blobName);
        }
        return this.getFSBlob(blobName, false, 0);
    }

    public IBlob getBlob(String blobName, boolean forUpdate, int offset) throws DirectoryServiceException {
        if (this.DEBUG) {
            System.out.println("\nAPI CALL EclipseDSHandler.getBlob blobName == " + blobName);
        }
        return this.getFSBlob(blobName, forUpdate, offset);
    }

    public IBlob getFSBlob(String blobName, boolean forUpdate) throws DirectoryServiceException {
        if (this.DEBUG) {
            System.out.println("\nAPI CALL EclipseDSHandler.getFSBlob(2 arguments) blobName == " + blobName);
        }
        return this.getFSBlob(blobName, forUpdate, 0);
    }

    public IBlob getFSBlob(String blobName, boolean forUpdate, int offset) throws DirectoryServiceException {
        if (this.DEBUG) {
            System.out.println("\nAPI CALL EclipseDSHandler.getFSBlob (3 arguments) getting called");
        }
        EclipseFile eFile = new EclipseFile(blobName);
        String fileOnDisk = eFile.m_diskLocation;
        if (fileOnDisk == null) {
            return null;
        }
        File diskFile = new File(fileOnDisk);
        if (!diskFile.exists()) {
            return null;
        }
        if (diskFile.isDirectory()) {
            throw new DirectoryServiceException(blobName + " is not a file");
        }
        Blob returnBlob = null;
        byte[] fileChunk = null;
        try {
            Integer blobTransferState;
            IDirElement blobEl = this.craftNewElement(blobName, diskFile);
            RandomAccessFile fStream = new RandomAccessFile(diskFile, "r");
            fStream.seek(offset);
            if ((long)(offset + 1000000) >= diskFile.length()) {
                fileChunk = new byte[(int)(diskFile.length() - (long)offset)];
                blobTransferState = IBlob.END;
            } else {
                fileChunk = new byte[1000000];
                blobTransferState = IBlob.PARTIAL;
            }
            fStream.read(fileChunk);
            fStream.close();
            returnBlob = new Blob(blobEl, fileChunk, (IChunkedBlobStreamer)this);
            Blob.markBlobState((Element)((Element)blobEl), (Object)blobTransferState, (String)"BLOB_TRANSFER_STATE");
            if (this.DEBUG) {
                System.out.println("Setting the blob logical to true\n");
            }
            returnBlob.setLogical(true);
        }
        catch (Exception e) {
            if (this.DEBUG) {
                System.out.println("EclipseDSHandler.getFSBlob caught exception, stack trace follows");
                e.printStackTrace();
            }
            throw new DirectoryServiceException("Could not fetch blob " + blobName + ": " + e.toString(), (Throwable)e);
        }
        return returnBlob;
    }

    public void appendFSBlob(IBasicElement element, byte[] blob, int offset, boolean last) throws DirectoryServiceException {
        String logicalFileName = element.getIdentity().getName();
        if (this.DEBUG) {
            System.out.println("\nAPI CALL EclipseDSHandler.appendFSBlob logicalFileName == " + logicalFileName);
        }
        EclipseFile eFile = new EclipseFile(logicalFileName, offset == 0);
        String mappedPath = eFile.m_diskLocation;
        if (mappedPath == null) {
            throw new DirectoryServiceException("Folder for " + logicalFileName + " does not exist");
        }
        File blobFile = new File(mappedPath);
        if (offset == 0 && blobFile.exists()) {
            blobFile.delete();
        }
        if (offset != 0 && blobFile.length() != (long)offset) {
            throw new DirectoryServiceException("Cannot append to a blob in the middle of an existing file: " + logicalFileName);
        }
        try {
            FileOutputStream fileOutStream = new FileOutputStream(mappedPath, true);
            fileOutStream.write(blob);
            fileOutStream.close();
            if (last && element instanceof Element) {
                this.newFileNotifications(logicalFileName);
            }
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Error while appending to file " + logicalFileName + ": " + e.toString(), (Throwable)e);
        }
    }

    private void newFileNotifications(String logicalName) {
        HashMap<String, Object> metaAttrs = new HashMap<String, Object>();
        metaAttrs.put("_ELEMENT_IDENTITY", this.createElementIdentity(logicalName));
        metaAttrs.put(TOOL_ATTRIBUTES_ATTR, "TYPE=MF_FILE");
        this.m_notificationManager.notifyNamingEvent((INamingNotification)new ElementCreateNotification(logicalName));
        this.m_notificationManager.notifyNamingEvent((INamingNotification)new MetaAttributesChangeNotification(logicalName, metaAttrs));
    }

    public void createFolder(String folderName) throws DirectoryServiceException {
        this.createFolder(folderName, false);
    }

    public void createFolder(String folderName, boolean existingOk) throws DirectoryServiceException {
        if (this.DEBUG) {
            System.out.println("\nAPI call EclipseDSHandler.createFolder folderName " + folderName + " existingOk == " + existingOk);
        }
        EclipseFile eFile = new EclipseFile(folderName, true);
        String mappedPath = eFile.m_diskLocation;
        if (mappedPath == null) {
            throw new DirectoryServiceException("Parent folder for " + folderName + " does not exist");
        }
        File newFolder = new File(mappedPath);
        if (newFolder.exists() && !existingOk) {
            throw new DirectoryServiceException("Folder " + folderName + " cannot be created because it exists");
        }
        if (!newFolder.exists()) {
            boolean madeDir = newFolder.mkdir();
            if (!madeDir) {
                throw new DirectoryServiceException("Unable to create folder " + folderName + ": mkdir returned false");
            }
            this.m_notificationManager.notifyNamingEvent((INamingNotification)new FolderCreateNotification(folderName));
        }
    }

    public void attachFSBlob(IBasicElement fileElement, byte[] blob) throws DirectoryServiceException, VersionOutofSyncException {
        String logicalFileName = fileElement.getIdentity().getName();
        if (this.DEBUG) {
            System.out.println("\nAPI CALL EclipseDSHandler.attachFSBlob logicalFileName == " + logicalFileName);
        }
        EclipseFile eFile = new EclipseFile(logicalFileName, true);
        String mappedPath = eFile.m_diskLocation;
        if (mappedPath == null) {
            throw new DirectoryServiceException("Folder for " + logicalFileName + " does not exist");
        }
        try {
            FileOutputStream fileStream = new FileOutputStream(mappedPath);
            fileStream.write(blob);
            fileStream.close();
            if (fileElement instanceof Element) {
                this.newFileNotifications(logicalFileName);
            }
        }
        catch (Exception e) {
            if (this.DEBUG) {
                e.printStackTrace();
            }
            throw new DirectoryServiceException("Unable to attach blob " + logicalFileName + ": " + e.toString(), (Throwable)e);
        }
    }

    public void attachFSBlob(IBasicElement fileElement, InputStream blobStream) throws DirectoryServiceException, VersionOutofSyncException {
        String logicalFileName = fileElement.getIdentity().getName();
        if (this.DEBUG) {
            System.out.println("\nAPI CALL EclipseDSHandler.attachFSBlob logicalFileName == " + logicalFileName);
        }
        EclipseFile eFile = new EclipseFile(logicalFileName, true);
        String mappedPath = eFile.m_diskLocation;
        if (mappedPath == null) {
            throw new DirectoryServiceException("Folder for " + logicalFileName + " does not exist");
        }
        File eclipseFile = new File(mappedPath);
        try {
            BufferedInputStream bStream = new BufferedInputStream(blobStream, 1000000);
            int src = 0;
            int readIn = 0;
            FileOutputStream eclipseStream = new FileOutputStream(eclipseFile);
            while (readIn != -1) {
                int chunkIndex = 0;
                ByteArrayOutputStream oStream = new ByteArrayOutputStream();
                while (chunkIndex < 1000000 && readIn != -1) {
                    readIn = bStream.read();
                    if (readIn == -1) continue;
                    oStream.write(readIn);
                    ++chunkIndex;
                }
                oStream.close();
                byte[] blobPiece = oStream.toByteArray();
                if (src > 0) {
                    eclipseStream = new FileOutputStream(eclipseFile, true);
                }
                eclipseStream.write(blobPiece);
                eclipseStream.close();
                src += blobPiece.length;
            }
            if (fileElement instanceof Element) {
                this.newFileNotifications(logicalFileName);
            }
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Unable to attach blob " + logicalFileName + ": " + e.toString(), (Throwable)e);
        }
    }

    public IDirElement getFSElement(String elementPath, boolean forUpdate) throws DirectoryServiceException {
        if (this.DEBUG) {
            System.out.println("\nAPI CALL EclipseDSHandler.getFSElement " + elementPath);
        }
        EclipseFile eFile = new EclipseFile(elementPath);
        String nameOnDisk = eFile.m_diskLocation;
        if (nameOnDisk == null) {
            return null;
        }
        File fileOnDisk = new File(nameOnDisk);
        if (!fileOnDisk.exists()) {
            return null;
        }
        if (fileOnDisk.isDirectory()) {
            throw new DirectoryServiceException(elementPath + " is a folder, not an element");
        }
        try {
            return this.craftNewElement(elementPath, fileOnDisk);
        }
        catch (Exception e) {
            if (this.DEBUG) {
                System.out.println("EclipseDSHandler.getFSElement caught exception, trace follows");
                e.printStackTrace();
            }
            throw new DirectoryServiceException(e.toString(), (Throwable)e);
        }
    }

    public IDirElement[] getFSElements(String folderPath, boolean forUpdate) throws DirectoryServiceException {
        if (this.DEBUG) {
            System.out.println("\nAPI CALL EclipseDSHandler.getFSElements with folder " + folderPath);
        }
        ArrayList<IDirElement> returnList = new ArrayList<IDirElement>();
        EclipseFile eFile = new EclipseFile(folderPath);
        String nameOnDisk = eFile.m_diskLocation;
        if (nameOnDisk == null) {
            String withoutSlash;
            String withSlash;
            if (folderPath.endsWith(DS_FILE_SEPARATOR)) {
                withSlash = folderPath;
                withoutSlash = folderPath.substring(0, folderPath.length() - 1);
            } else {
                withoutSlash = folderPath;
                withSlash = folderPath + DS_FILE_SEPARATOR;
            }
            if (withSlash.equals(this.m_handlerName) || withoutSlash.equals(this.m_handlerName)) {
                return new IDirElement[0];
            }
            throw new DirectoryServiceException("Folder " + folderPath + " does not exist");
        }
        File fileOnDisk = new File(nameOnDisk);
        if (!fileOnDisk.exists()) {
            throw new DirectoryServiceException("Folder " + folderPath + " does not exist");
        }
        if (fileOnDisk.isFile()) {
            throw new DirectoryServiceException(folderPath + " is a file, not an element");
        }
        try {
            File[] children = fileOnDisk.listFiles();
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].isFile()) continue;
                returnList.add(this.craftNewElement(this.getLogicalName(children[i].getCanonicalPath(), eFile.m_projectName), children[i]));
            }
        }
        catch (Exception e) {
            if (this.DEBUG) {
                System.out.println("EclipseDSHandler.getFSElements caught exception, trace follows");
                e.printStackTrace();
            }
            throw new DirectoryServiceException("Couldn't get all elements for folder " + folderPath + ": " + e.toString(), (Throwable)e);
        }
        IDirElement[] elements = new IDirElement[returnList.size()];
        return returnList.toArray(elements);
    }

    public IElementIdentity getFSIdentity(String elementPath) throws DirectoryServiceException {
        if (this.DEBUG) {
            System.out.println("\nAPI CALL EclipseDSHandler.getFSIdentity for element " + elementPath);
        }
        EclipseFile eFile = new EclipseFile(elementPath);
        String nameOnDisk = eFile.m_diskLocation;
        if (nameOnDisk == null) {
            String withoutSlash;
            String withSlash;
            if (elementPath.endsWith(DS_FILE_SEPARATOR)) {
                withSlash = elementPath;
                withoutSlash = elementPath.substring(0, elementPath.length() - 1);
            } else {
                withoutSlash = elementPath;
                withSlash = elementPath + DS_FILE_SEPARATOR;
            }
            if (withSlash.equals(this.m_handlerName) || withoutSlash.equals(this.m_handlerName)) {
                throw new DirectoryServiceException(elementPath + " is a folder, not an element");
            }
            throw new DirectoryServiceException("Element " + elementPath + " does not exist");
        }
        File fileOnDisk = new File(nameOnDisk);
        if (!fileOnDisk.exists()) {
            throw new DirectoryServiceException("Element " + elementPath + " does not exist");
        }
        if (fileOnDisk.isDirectory()) {
            throw new DirectoryServiceException(elementPath + " is a folder, not an element");
        }
        return this.createElementIdentity(elementPath);
    }

    public IDirElement getFSElement(String elementPath, boolean forUpdate, boolean getSubclassingDelta) throws DirectoryServiceException {
        return this.getFSElement(elementPath, forUpdate);
    }

    public INextVersionToken createFSElement(IDirElement element) throws DirectoryServiceException, VersionOutofSyncException {
        String elName;
        if (this.DEBUG) {
            System.out.println("\nAPI CALL EclipseDHandler.createFSElement");
        }
        if ((elName = element.getIdentity().getName()).endsWith(MAP_ELEMENT_NAME)) {
            this.m_workspaceDiskLocation = (String)element.getAttributes().getAttribute(ECLIPSE_WORKSPACE_DISK_LOCATION_ATTR);
            try {
                this.m_workspaceDiskLocation = new File(this.m_workspaceDiskLocation).getCanonicalPath();
                this.m_metadataFolder = new File(this.m_workspaceDiskLocation, ".metadata").getCanonicalPath();
            }
            catch (IOException e) {
                throw new DirectoryServiceException(e.toString(), (Throwable)e);
            }
            if (this.DEBUG) {
                System.out.println("Eclipse handler setting disk location to " + this.m_workspaceDiskLocation + "\n");
            }
            ((ElementIdentity)element.getIdentity()).setName(MAPPING_STORAGE_NAME);
            if (!this.m_dsContext.directoryExists(MAPPING_STORAGE_DIRECTORY)) {
                this.m_dsContext.createDirectory(MAPPING_STORAGE_DIRECTORY);
            }
            if (this.m_dsContext.getElement(MAPPING_STORAGE_NAME) != null) {
                this.m_dsContext.deleteElement(MAPPING_STORAGE_NAME);
            }
        } else {
            throw new DirectoryServiceException("Operation not supported: createFSElement");
        }
        this.m_dsContext.setElement(element);
        return null;
    }

    public void setDSContext(IDSHandlerContext dsContext) throws DirectoryServiceException {
        super.setDSContext(dsContext);
        IDirElement mapping = null;
        if (this.m_dsContext.directoryExists(MAPPING_STORAGE_DIRECTORY) && (mapping = this.m_dsContext.getElement(MAPPING_STORAGE_NAME)) != null) {
            IAttributeSet topSet = mapping.getAttributes();
            String diskMap = (String)topSet.getAttribute(ECLIPSE_WORKSPACE_DISK_LOCATION_ATTR);
            try {
                this.m_workspaceDiskLocation = new File(diskMap).getCanonicalPath();
                this.m_metadataFolder = new File(this.m_workspaceDiskLocation, ".metadata").getCanonicalPath();
            }
            catch (IOException e) {
                throw new DirectoryServiceException(e.toString(), (Throwable)e);
            }
        }
    }

    private String linkedLocation(String projectName) throws Exception {
        String locationPath = this.m_workspaceDiskLocation + FILE_SEPARATOR + PROJECT_METADATA_DIR + FILE_SEPARATOR + projectName + FILE_SEPARATOR + ".location";
        if (this.DEBUG) {
            System.out.println("\nEclipseDSHandler.linkedLocation opening location file : " + locationPath);
        }
        File locationFile = new File(locationPath);
        if (this.DEBUG && locationFile.exists()) {
            System.out.println("EclipseDSHandler.linkedLocation location file exists and is of size " + locationFile.length());
        }
        if (locationFile.exists()) {
            DataInputStream inStream = new DataInputStream(new SafeChunkyInputStream(locationFile));
            String location = inStream.readUTF();
            if (this.DEBUG) {
                System.out.println("EclipseDSHandler.linkedLocation read location from file: " + location);
            }
            inStream.close();
            location = EclipseDSHandler.getLocation(location);
            if (location == null) {
                return null;
            }
            return new File(location).getCanonicalPath();
        }
        return null;
    }

    public static String getLocation(String location) {
        if (!location.startsWith(URI_PREFIX)) {
            return null;
        }
        if (location.startsWith(URI_PREFIX)) {
            location = location.substring(URI_PREFIX.length());
        }
        URI uri = URI.create(location);
        String file = uri.getSchemeSpecificPart();
        return file;
    }

    private String getLogicalName(String diskName, String projectName) throws Exception {
        if (this.DEBUG) {
            System.out.println("\nEclipseDSHandler.getLogicalName diskName " + diskName + " m_workspaceDiskLocation " + this.m_workspaceDiskLocation + " projectName == " + projectName);
        }
        String replacement = null;
        if (diskName.startsWith(this.m_workspaceDiskLocation)) {
            replacement = this.m_handlerName + diskName.substring(this.m_workspaceDiskLocation.length());
            replacement = replacement.replace(FILE_SEPARATOR_CHAR, '/');
        } else {
            if (this.DEBUG) {
                System.out.println("EclipseDSHandler.getLogicalName name could be a linked project or local with linked resource");
            }
            replacement = this.m_handlerName + '/' + projectName;
            String location = this.linkedLocation(projectName);
            String projectSubdir = "";
            if (location != null) {
                if (this.DEBUG) {
                    System.out.println("EclipseDSHandler.getLogicalName it's a linked project, location == " + location);
                }
                if (diskName.indexOf(location) > -1) {
                    if (this.DEBUG) {
                        System.out.println("EclipseDSHandler.getLogicalName > -1 test succeeds");
                    }
                    projectSubdir = diskName.substring(location.length() + 1);
                } else {
                    projectSubdir = this.linkedResourceSubDir(location, diskName);
                    if (this.DEBUG) {
                        System.out.println("EclipseDSHandler.getLogicalName > -1 test did not succeed");
                    }
                }
            } else {
                if (this.DEBUG) {
                    System.out.println("EclipseDSHandler.getLogicalName it's a linked resource in a local project");
                }
                projectSubdir = this.linkedResourceSubDir(this.m_workspaceDiskLocation + FILE_SEPARATOR + projectName, diskName);
            }
            if (this.DEBUG) {
                System.out.println("EclipseDSHandler.getLogicalName projectSubDir == " + projectSubdir);
            }
            replacement = replacement + '/' + projectSubdir;
        }
        if (replacement != null) {
            replacement = replacement.replace(FILE_SEPARATOR_CHAR, '/');
        }
        if (this.DEBUG) {
            System.out.println("EclipseDSHandler.getLogicalName " + diskName + " returning " + replacement + "\n");
        }
        return replacement;
    }

    private String linkedResourceSubDir(String projectFileLocation, String diskName) throws IOException {
        String subDir = "";
        File projectFile = new File(projectFileLocation + FILE_SEPARATOR + PROJECT_DESCRIPTION_FILE);
        if (projectFile.exists()) {
            HashMap linkedDescriptions;
            LinkDescription linkedResDescription;
            if (this.DEBUG) {
                System.out.println("\nEclipseDSHandler.linkedResourceLogicalName found the .project file " + projectFile.getCanonicalPath());
            }
            if ((linkedResDescription = this.findResourceInLinks(diskName, linkedDescriptions = this.findLinkedResources(projectFile.getCanonicalPath()))) != null) {
                String location = new File(linkedResDescription.getLocation()).getCanonicalPath();
                subDir = linkedResDescription.getName() + '/' + diskName.substring(location.length() + 1);
                if (this.DEBUG) {
                    System.out.println("EclipseDShandler.linkedResourceLogicalName found linked description, subDir = " + subDir + "\n");
                }
            } else if (this.DEBUG) {
                System.out.println("EclipseDSHandler.linkedResourceLogicalName could not find the linked resource directory for " + diskName + "\n");
            }
        } else if (this.DEBUG) {
            System.out.println("\nEclipseDSHandler.linkedResourceLogicalName could not find the .project file " + projectFile.getAbsolutePath() + "\n");
        }
        return subDir;
    }

    private LinkDescription findResourceInLinks(String resourceDiskName, HashMap linkedResources) throws IOException {
        String canonicalDiskName = new File(resourceDiskName).getCanonicalPath();
        Collection linkResCol = linkedResources.values();
        for (LinkDescription linkDescr : linkResCol) {
            String linkLocation = linkDescr.getLocation();
            String canonicalLinkLocation = new File(linkLocation).getCanonicalPath();
            if (!canonicalDiskName.startsWith(canonicalLinkLocation)) continue;
            return linkDescr;
        }
        return null;
    }

    private IElementIdentity createElementIdentity(String logicalName) {
        ElementIdentity id = new ElementIdentity(logicalName, ECLIPSE_ELEMENT_TYPE, ECLIPSE_ELEMENT_RELEASE_VERSION);
        id.setCreationTimestamp(System.currentTimeMillis());
        return id;
    }

    private IDirElement craftNewElement(String elName, File onDiskFile) throws Exception {
        Element newElement;
        IAttributeSet topSet;
        IAttributeSet systemAttrs;
        if (this.DEBUG) {
            System.out.println("\nEclipseDSHandler.craftNewElement " + elName + ", on disk file: " + onDiskFile);
        }
        if ((systemAttrs = (IAttributeSet)(topSet = (newElement = new Element(this.createElementIdentity(elName), false)).getAttributes()).getAttribute("_MF_SYSTEM_ATTRIBUTES")) == null) {
            systemAttrs = topSet.createAttributeSet("_MF_SYSTEM_ATTRIBUTES");
        }
        if (this.DEBUG) {
            System.out.println("EclipseDSHandler.craftNewElement about to set DO_NOT_CACHE");
        }
        systemAttrs.setBooleanAttribute("DO_NOT_CACHE", Boolean.TRUE);
        if (this.DEBUG) {
            System.out.println("EclipseDSHandler.craftNewElement about to set LAST_MODIFIED_TIME");
        }
        topSet.setLongAttribute(LAST_MODIFIED_TIME_ATTR, new Long(onDiskFile.lastModified()));
        topSet.setLongAttribute(CREATION_TIME_ATTR, new Long(0L));
        topSet.setStringAttribute(CREATED_BY_ATTR, "");
        topSet.setBooleanAttribute(HIDDEN_ATTR, new Boolean(onDiskFile.isHidden()));
        topSet.setStringAttribute(PERMISSIONS_ATTR, "");
        FileInputStream fileStream = new FileInputStream(onDiskFile);
        if (this.DEBUG) {
            System.out.println("EclipseDSHandler.craftNewElement about to set SIZE");
        }
        topSet.setIntegerAttribute(SIZE_ATTR, new Integer(fileStream.available()));
        fileStream.close();
        if (this.DEBUG) {
            System.out.println("EclipseDSHandler.craftNewElement about to return element\n");
        }
        return newElement;
    }

    private void testMapInit() throws DirectoryServiceException {
        if (this.m_handlerName == null || this.m_workspaceDiskLocation == null) {
            throw new DirectoryServiceException("Eclipse handler map has not been initialized");
        }
    }

    private String[] getProjects() {
        String projectsDirName;
        File projectsDir;
        if (this.DEBUG) {
            System.out.println("EclipseDSHandler.getProjects ");
        }
        if ((projectsDir = new File(projectsDirName = this.m_workspaceDiskLocation + FILE_SEPARATOR + PROJECT_METADATA_DIR)).isDirectory()) {
            return projectsDir.list();
        }
        return new String[0];
    }

    private boolean isAProject(String projectName) {
        String[] projects = this.getProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!projectName.equalsIgnoreCase(projects[i])) continue;
            return true;
        }
        return false;
    }

    private ArrayList listFoldersInternal(String folderPath) throws DirectoryServiceException {
        if (this.DEBUG) {
            System.out.println("listFoldersInternal " + folderPath);
        }
        ArrayList<HashMap> returnFolders = new ArrayList<HashMap>();
        EclipseFile eFile = new EclipseFile(folderPath);
        String mappedPath = eFile.m_diskLocation;
        if (mappedPath == null) {
            String withoutSlash;
            String withSlash;
            if (folderPath.endsWith(DS_FILE_SEPARATOR)) {
                withSlash = folderPath;
                withoutSlash = folderPath.substring(0, folderPath.length() - 1);
            } else {
                withoutSlash = folderPath;
                withSlash = folderPath + DS_FILE_SEPARATOR;
            }
            if (!withSlash.equals(this.m_handlerName) && !withoutSlash.equals(this.m_handlerName)) {
                throw new DirectoryServiceException("Folder " + folderPath + " does not exist");
            }
            return new ArrayList();
        }
        File mappedFile = new File(mappedPath);
        if (!mappedFile.exists()) {
            if (this.DEBUG) {
                System.out.println("\nEclipseDSHandler.listFoldersInternal " + mappedPath + " doesn't exist");
            }
            throw new DirectoryServiceException("Folder " + folderPath + " does not exist");
        }
        if (mappedFile.isFile()) {
            if (this.DEBUG) {
                System.out.println("\nEclipseDSHandler.listFoldersInternal " + mappedPath + " is a file, not a folder");
            }
            throw new DirectoryServiceException(folderPath + " is not a folder");
        }
        if (this.DEBUG) {
            System.out.println("\nEclipseDSHandler.listFoldersInternal about to call java File.listFiles\n");
        }
        File[] children = mappedFile.listFiles();
        if (this.DEBUG) {
            System.out.println("\nEclipseDSHandler.listFoldersInternal File.listFiles returned " + children.length + " items");
        }
        String projectName = eFile.m_projectName;
        try {
            for (int i = 0; i < children.length; ++i) {
                if (this.DEBUG) {
                    System.out.println("\nEclipseDSHandler.listFoldersInternal processing child " + children[i].toString());
                }
                if (!children[i].isDirectory() || children[i].getCanonicalPath().equals(this.m_metadataFolder)) continue;
                returnFolders.add(this.getMetaAttributes(this.getLogicalName(children[i].getCanonicalPath(), projectName)));
            }
        }
        catch (Exception ex) {
            if (this.DEBUG) {
                ex.printStackTrace();
            }
            throw new DirectoryServiceException("Could not list folders for " + folderPath + ": " + ex.toString(), (Throwable)ex);
        }
        this.addLinkedResources(eFile, returnFolders);
        this.addLinkedProjects(mappedPath, returnFolders);
        return returnFolders;
    }

    private void addLinkedProjects(String mappedPath, ArrayList folderList) throws DirectoryServiceException {
        if (this.DEBUG) {
            System.out.println("\nEclipseDSHandler.addLinkedProjects mappedPath == " + mappedPath + " m_workspaceDiskLocation == " + this.m_workspaceDiskLocation);
        }
        if (mappedPath.equals(this.m_workspaceDiskLocation)) {
            File projectsDir;
            if (this.DEBUG) {
                System.out.println("EclipseDSHandler.addLinkedProjects passed the test");
            }
            if ((projectsDir = new File(this.m_workspaceDiskLocation + FILE_SEPARATOR + PROJECT_METADATA_DIR)).exists()) {
                File[] projects = projectsDir.listFiles();
                for (int i = 0; i < projects.length; ++i) {
                    if (!this.isLinkedDirectory(projects[i])) continue;
                    if (this.DEBUG) {
                        System.out.println("EclipseDSHandler.addLinkedProjects found linked project, adding folder " + this.m_handlerName + '/' + projects[i].getName());
                    }
                    folderList.add(this.getMetaAttributes(this.m_handlerName + '/' + projects[i].getName()));
                }
            }
        }
        if (this.DEBUG) {
            System.out.println();
        }
    }

    private boolean isLinkedDirectory(File projectDir) {
        if (this.DEBUG) {
            System.out.println("\nEclipseDShandler.isLinkedDirectory for file " + projectDir + " will return " + new File(projectDir, ".location").exists() + "\n");
        }
        return new File(projectDir, ".location").exists();
    }

    private ArrayList listFSElementsInternal(String folderPath, String extension) throws DirectoryServiceException {
        if (this.DEBUG) {
            System.out.println("\nEclipseDSHandler.listFSElementsInternal with folder " + folderPath + "\n");
        }
        ArrayList<HashMap> returnElements = new ArrayList<HashMap>();
        EclipseFile eFile = new EclipseFile(folderPath);
        String mappedPath = eFile.m_diskLocation;
        if (mappedPath == null) {
            String withoutSlash;
            String withSlash;
            if (folderPath.endsWith(DS_FILE_SEPARATOR)) {
                withSlash = folderPath;
                withoutSlash = folderPath.substring(0, folderPath.length() - 1);
            } else {
                withoutSlash = folderPath;
                withSlash = folderPath + DS_FILE_SEPARATOR;
            }
            if (withSlash.equals(this.m_handlerName) || withoutSlash.equals(this.m_handlerName)) {
                return new ArrayList();
            }
            throw new DirectoryServiceException("Folder " + folderPath + " does not exist");
        }
        File mappedFile = new File(mappedPath);
        if (!mappedFile.exists()) {
            throw new DirectoryServiceException("Folder " + folderPath + " does not exist");
        }
        if (mappedFile.isFile()) {
            throw new DirectoryServiceException(folderPath + " is not a folder");
        }
        File[] children = mappedFile.listFiles();
        String projectName = eFile.m_projectName;
        try {
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].isFile() || extension != null && !children[i].getName().endsWith(extension)) continue;
                returnElements.add(this.getMetaAttributes(this.getLogicalName(children[i].getCanonicalPath(), projectName)));
            }
        }
        catch (Exception e) {
            if (this.DEBUG) {
                System.out.println("EclipseDSHandler.listFSElementsInternal caught exception, trace follows");
                e.printStackTrace();
            }
            throw new DirectoryServiceException("Could not list files for " + folderPath + ": " + e.toString(), (Throwable)e);
        }
        return returnElements;
    }

    HashMap findLinkedResources(String descrFile) throws IOException {
        return new ProjectDescriptionReader().read(descrFile);
    }

    public void subscribe(INamingListener listener) {
        this.m_notificationManager.subscribe(listener);
    }

    public void doNotify() {
        this.m_notificationManager.doNotify();
    }

    private final class NamingNotificationManager {
        INamingListener m_listener = null;
        ArrayList m_notifications = new ArrayList();

        NamingNotificationManager() {
        }

        void reset() {
            this.m_notifications = new ArrayList();
        }

        void doNotify() {
            if (this.m_listener != null && !this.m_notifications.isEmpty()) {
                this.m_listener.onNotifications(this.m_notifications);
            }
            this.reset();
        }

        void notifyNamingEvent(INamingNotification notification) {
            this.m_notifications.add(notification);
        }

        void notifyNamingEvents(ArrayList notifications) {
            for (int i = 0; i < notifications.size(); ++i) {
                this.m_notifications.add(notifications.get(i));
            }
        }

        void subscribe(INamingListener listener) {
            this.m_listener = listener;
        }

        void unsubscribe() {
            this.m_listener = null;
        }
    }

    class EclipseFile {
        String m_projectName;
        String m_diskLocation;
        boolean m_inWorkspace;
        String m_logicalName;
        String m_strippedOfMap;
        String m_nameAfterProjectName = "";
        String m_linkedProjectLocation;
        String m_linkedResourceLocation;
        HashMap m_linkedResources;

        EclipseFile(String logicalName) throws DirectoryServiceException {
            this(logicalName, false);
        }

        EclipseFile(String logicalName, boolean createFile) throws DirectoryServiceException {
            this.m_logicalName = logicalName;
            try {
                this.parse(createFile);
            }
            catch (DirectoryServiceException ex) {
                if (EclipseDSHandler.this.DEBUG) {
                    ex.printStackTrace();
                }
                throw ex;
            }
            catch (Exception ex) {
                if (EclipseDSHandler.this.DEBUG) {
                    ex.printStackTrace();
                }
                throw new DirectoryServiceException("EclipseFile constructor: Unable to parse logical name of eclipse file " + logicalName + ": " + ex.toString(), (Throwable)ex);
            }
        }

        HashMap parseLinkedResources() throws IOException {
            if (EclipseDSHandler.this.DEBUG) {
                System.out.println("\nEclipseFile.parseLinkedResources getting called");
            }
            File descrFile = this.m_inWorkspace ? new File(EclipseDSHandler.this.m_workspaceDiskLocation + FILE_SEPARATOR + this.m_projectName + FILE_SEPARATOR + EclipseDSHandler.PROJECT_DESCRIPTION_FILE) : new File(this.m_linkedProjectLocation, EclipseDSHandler.PROJECT_DESCRIPTION_FILE);
            if (EclipseDSHandler.this.DEBUG) {
                System.out.println("EclipseFile.parseLinkedResources descrFile == " + descrFile.toString() + "\n");
            }
            if (descrFile.exists()) {
                return EclipseDSHandler.this.findLinkedResources(descrFile.getCanonicalPath());
            }
            return null;
        }

        String checkLinkedResources(boolean createFile) throws IOException {
            if (EclipseDSHandler.this.DEBUG) {
                System.out.println("\nEclipseFile.checkLinkedResources called");
            }
            if (EclipseDSHandler.this.DEBUG) {
                System.out.println("\n m_linkedResources= " + this.m_linkedResources + " :: m_nameAfterProjectName= [" + this.m_nameAfterProjectName + "]");
            }
            if (this.m_linkedResources != null && this.m_nameAfterProjectName.length() > 0) {
                if (EclipseDSHandler.this.DEBUG) {
                    System.out.println("EclipseFile.checkLinkedResources resources are not null\n");
                }
                Collection descriptionsCollection = this.m_linkedResources.values();
                for (LinkDescription linkDescr : descriptionsCollection) {
                    File possibleFile;
                    String linkLocation = linkDescr.getLocation();
                    String linkName = linkDescr.getName();
                    int linkType = linkDescr.getType();
                    int nameAfterLinkedLocation = -1;
                    if (this.m_nameAfterProjectName.indexOf(linkName) <= -1 || linkType != 2 || !(possibleFile = (nameAfterLinkedLocation = this.m_nameAfterProjectName.indexOf(47)) > -1 ? new File(linkLocation, this.m_nameAfterProjectName.substring(nameAfterLinkedLocation + 1)) : new File(linkLocation)).exists() && (!createFile || !possibleFile.getParentFile().exists())) continue;
                    this.m_linkedResourceLocation = new File(linkLocation).getCanonicalPath();
                    return possibleFile.getCanonicalPath();
                }
            } else if (EclipseDSHandler.this.DEBUG) {
                System.out.println("EclipseFile.checkLinkedResources did not find a linked resource\n");
            }
            return null;
        }

        final void parse(boolean createFile) throws Exception {
            EclipseDSHandler.this.testMapInit();
            if (EclipseDSHandler.this.DEBUG) {
                System.out.println("\nEclipseFile.parse createFile == " + createFile);
            }
            if (EclipseDSHandler.this.DEBUG) {
                System.out.println("EclipseFile.parse m_logicalName == " + this.m_logicalName);
            }
            this.m_strippedOfMap = this.stripEclipseMap();
            if (EclipseDSHandler.this.DEBUG) {
                System.out.println("EclipseFile.parse m_strippedOfMap == " + this.m_strippedOfMap);
            }
            this.m_projectName = this.projectName(createFile);
            if (EclipseDSHandler.this.DEBUG) {
                System.out.println("EclipseFile.parse m_projectName == " + this.m_projectName);
            }
            this.m_inWorkspace = this.projectInWorkspace();
            if (EclipseDSHandler.this.DEBUG) {
                System.out.println("EclipseFile.parse m_inWorkspace == " + this.m_inWorkspace);
            }
            if (EclipseDSHandler.this.DEBUG) {
                System.out.println("EclipseFile.parse m_nameAfterProjectName == " + this.m_nameAfterProjectName);
            }
            if (this.m_inWorkspace) {
                this.m_diskLocation = EclipseDSHandler.this.m_workspaceDiskLocation + FILE_SEPARATOR + this.m_strippedOfMap;
                if (EclipseDSHandler.this.DEBUG) {
                    System.out.println("EclipseFile.parse m_diskLocation in m_inWorkspace block " + this.m_diskLocation);
                }
                boolean localParentFileExists = new File(this.m_diskLocation).getParentFile().exists();
                this.m_linkedResources = this.parseLinkedResources();
                if (!new File(this.m_diskLocation).exists()) {
                    String linkedDiskLocation = this.checkLinkedResources(createFile);
                    if (linkedDiskLocation != null && new File(linkedDiskLocation).exists()) {
                        this.m_diskLocation = linkedDiskLocation;
                    } else if (!localParentFileExists) {
                        boolean linkedParentFileExists;
                        this.m_diskLocation = linkedDiskLocation != null ? ((linkedParentFileExists = new File(linkedDiskLocation).getParentFile().exists()) && createFile ? linkedDiskLocation : null) : null;
                    } else if (!createFile) {
                        this.m_diskLocation = null;
                    }
                }
            } else {
                if (EclipseDSHandler.this.DEBUG) {
                    System.out.println("EclipseFile.parse logicalName could be linked");
                }
                this.m_linkedProjectLocation = EclipseDSHandler.this.linkedLocation(this.m_projectName);
                this.m_linkedResources = this.parseLinkedResources();
                if (EclipseDSHandler.this.DEBUG) {
                    System.out.println("parsing... m_linkedResources = " + this.m_linkedResources);
                }
                if (EclipseDSHandler.this.DEBUG) {
                    System.out.println("parsing... m_linkedProjectLocation = " + this.m_linkedProjectLocation);
                }
                if (EclipseDSHandler.this.DEBUG) {
                    System.out.println("parsing... m_strippedOfMap = " + this.m_strippedOfMap);
                }
                if (EclipseDSHandler.this.DEBUG) {
                    System.out.println("parsing... m_strippedOfMap.indexOf(IMFDirectories.MF_DIR_SEPARATOR) = " + this.m_strippedOfMap.indexOf(47));
                }
                try {
                    this.m_diskLocation = this.m_strippedOfMap.indexOf(47) > -1 ? this.m_linkedProjectLocation + FILE_SEPARATOR + this.m_strippedOfMap.substring(this.m_strippedOfMap.indexOf(47) + 1) : this.m_linkedProjectLocation;
                    if (EclipseDSHandler.this.DEBUG) {
                        System.out.println("parsing.... m_diskLocation = " + this.m_diskLocation);
                    }
                    if (this.m_diskLocation != null && !new File(this.m_diskLocation).exists()) {
                        String linkedDiskLocation = this.checkLinkedResources(createFile);
                        if (linkedDiskLocation != null && new File(linkedDiskLocation).exists()) {
                            this.m_diskLocation = linkedDiskLocation;
                        } else {
                            boolean localParentFileExists = new File(this.m_diskLocation).getParentFile().exists();
                            if (!localParentFileExists) {
                                boolean linkedParentFileExists;
                                this.m_diskLocation = linkedDiskLocation != null ? ((linkedParentFileExists = new File(linkedDiskLocation).getParentFile().exists()) && createFile ? linkedDiskLocation : null) : null;
                            } else if (!createFile) {
                                this.m_diskLocation = null;
                            }
                        }
                    }
                }
                catch (Exception ioE) {
                    if (EclipseDSHandler.this.DEBUG) {
                        System.out.println("EclipseFile.parse throwing exception, trace follows");
                        ioE.printStackTrace();
                    }
                    throw new DirectoryServiceException("Unable to find path for linked project " + this.m_logicalName + ": " + ioE.toString(), (Throwable)ioE);
                }
            }
            if (this.m_diskLocation != null) {
                if (this.m_diskLocation.endsWith(FILE_SEPARATOR)) {
                    this.m_diskLocation = this.m_diskLocation.substring(0, this.m_diskLocation.length() - 1);
                }
                this.m_diskLocation = this.m_diskLocation.replace('/', FILE_SEPARATOR_CHAR);
                this.m_diskLocation = new File(this.m_diskLocation).getCanonicalPath();
            }
            if (EclipseDSHandler.this.DEBUG) {
                System.out.println("EclipseFile.parse disk location ==  " + this.m_diskLocation + "\n");
            }
        }

        private String stripEclipseMap() {
            String tempStripped = this.m_logicalName.substring(EclipseDSHandler.this.m_handlerName.length());
            if (tempStripped.length() == 0) {
                return tempStripped;
            }
            return tempStripped.substring(1);
        }

        private String projectName(boolean createFile) throws DirectoryServiceException {
            if (this.m_strippedOfMap.length() == 0) {
                this.m_nameAfterProjectName = "";
                return "";
            }
            if (this.m_strippedOfMap.indexOf(47) == -1) {
                File testFile = new File(EclipseDSHandler.this.m_workspaceDiskLocation + FILE_SEPARATOR + this.m_strippedOfMap);
                if (createFile || testFile.isFile()) {
                    this.m_nameAfterProjectName = this.m_strippedOfMap;
                    return "";
                }
                this.m_nameAfterProjectName = "";
                return this.m_strippedOfMap;
            }
            this.m_nameAfterProjectName = this.m_strippedOfMap.substring(this.m_strippedOfMap.indexOf(47) + 1);
            return this.m_strippedOfMap.substring(0, this.m_strippedOfMap.indexOf(47));
        }

        private boolean projectInWorkspace() {
            if (this.m_projectName.length() == 0) {
                if (EclipseDSHandler.this.DEBUG) {
                    System.out.println("\nEclipseFile.projectInWorkspace m_projectName length == 0\n");
                }
                return true;
            }
            File root = new File(EclipseDSHandler.this.m_workspaceDiskLocation);
            String[] projectsInRoot = root.list();
            if (projectsInRoot != null) {
                for (int i = 0; i < projectsInRoot.length; ++i) {
                    if (!projectsInRoot[i].equalsIgnoreCase(this.m_projectName)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

