/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.eclipse;

import com.sonicsw.mf.eclipse.LinkDescription;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectDescriptionReader
extends DefaultHandler {
    public static final String LINKED_RESOURCES = "linkedResources";
    public static final String LINK = "link";
    public static final String LOCATION = "location";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String PROJECT_DESCRIPTION = "projectDescription";
    protected static final int S_INITIAL = 8;
    protected static final int S_LINK = 9;
    protected static final int S_LINK_LOCATION = 10;
    protected static final int S_LINK_NAME = 11;
    protected static final int S_LINK_TYPE = 12;
    protected static final int S_LINKED_RESOURCES = 13;
    protected static final int S_PROJECT_DESC = 17;
    protected final StringBuffer charBuffer = new StringBuffer();
    protected Stack objectStack;
    protected HashMap m_linkedResources = null;
    protected int state = 8;
    private boolean DEBUG = false;

    @Override
    public void characters(char[] chars, int offset, int length) {
        this.charBuffer.append(chars, offset, length);
    }

    @Override
    public void endElement(String uri, String elementName, String qname) {
        if (this.DEBUG) {
            System.out.println("endElement " + elementName + " state == " + this.state);
        }
        switch (this.state) {
            case 9: {
                this.endLinkElement(elementName);
                break;
            }
            case 13: {
                this.endLinkedResourcesElement(elementName);
                return;
            }
            case 11: {
                this.endLinkName(elementName);
                break;
            }
            case 12: {
                this.endLinkType(elementName);
                break;
            }
            case 10: {
                this.endLinkLocation(elementName);
            }
        }
        this.charBuffer.setLength(0);
    }

    private void endLinkedResourcesElement(String elementName) {
        if (elementName.equals(LINKED_RESOURCES)) {
            if (this.DEBUG) {
                System.out.println("endLinkedresourcesElement " + elementName);
            }
            this.m_linkedResources = (HashMap)this.objectStack.pop();
            this.state = 17;
            if (this.m_linkedResources.isEmpty()) {
                return;
            }
            Set keySet = this.m_linkedResources.keySet();
            Iterator keySetIterator = keySet.iterator();
            if (this.DEBUG) {
                System.out.println("Printing linked resources");
            }
            while (keySetIterator.hasNext()) {
                Object key = keySetIterator.next();
                Object value = this.m_linkedResources.get(key);
                if (!this.DEBUG) continue;
                System.out.println("key == " + key + " value == " + value);
            }
        }
    }

    private void endLinkElement(String elementName) {
        if (elementName.equals(LINK)) {
            if (this.DEBUG) {
                System.out.println("endLinkElement");
            }
            this.state = 13;
            LinkDescription link = (LinkDescription)this.objectStack.pop();
            String name = link.getName();
            int type = link.getType();
            String location = link.getLocation();
            if (name == null || name.length() == 0) {
                if (this.DEBUG) {
                    System.out.println("The name of the link is not defined");
                }
                return;
            }
            if (type == -1) {
                if (this.DEBUG) {
                    System.out.println("The type of the link is not defined");
                }
                return;
            }
            if (location == null || location.length() == 0) {
                if (this.DEBUG) {
                    System.out.println("The location of the link is not defined");
                }
                return;
            }
            ((HashMap)this.objectStack.peek()).put(link.getName(), link);
        }
    }

    private void endLinkLocation(String elementName) {
        if (elementName.equals(LOCATION)) {
            if (this.DEBUG) {
                System.out.println("endLinkLocation");
            }
            String newLocation = this.charBuffer.toString().trim();
            ((LinkDescription)this.objectStack.peek()).setLocation(newLocation);
            this.state = 9;
        }
    }

    private void endLinkName(String elementName) {
        if (elementName.equals(NAME)) {
            if (this.DEBUG) {
                System.out.println("endLinkName");
            }
            String newName = this.charBuffer.toString().trim();
            String oldName = ((LinkDescription)this.objectStack.peek()).getName();
            if (oldName.length() != 0) {
                if (this.DEBUG) {
                    System.out.println("Expected to find oldName of length 0, but found " + oldName);
                }
            } else {
                ((LinkDescription)this.objectStack.peek()).setName(newName);
            }
            this.state = 9;
        }
    }

    private void endLinkType(String elementName) {
        if (elementName.equals(TYPE)) {
            if (this.DEBUG) {
                System.out.println("endLinkType");
            }
            int newType = 1;
            try {
                newType = Integer.parseInt(this.charBuffer.toString().trim());
            }
            catch (NumberFormatException e) {
                this.log(e);
            }
            int oldType = ((LinkDescription)this.objectStack.peek()).getType();
            if (oldType != -1) {
                if (this.DEBUG) {
                    System.out.println("Expected to find old type == -1, found " + oldType);
                }
            } else {
                ((LinkDescription)this.objectStack.peek()).setType(newType);
            }
            this.state = 9;
        }
    }

    @Override
    public void error(SAXParseException error) {
        this.log(error);
    }

    @Override
    public void fatalError(SAXParseException error) throws SAXException {
        String message = error.getMessage();
        if (this.DEBUG) {
            System.out.println("ERROR: " + message);
        }
        throw error;
    }

    protected void log(Exception ex) {
        String message = ex.getMessage();
        if (this.DEBUG) {
            System.out.println("LOG: " + message);
        }
    }

    private void parseProjectDescription(String elementName) {
        if (this.DEBUG) {
            System.out.println("parseProjectDescription " + elementName);
        }
        if (elementName.equals(LINKED_RESOURCES)) {
            this.objectStack.push(new HashMap());
            this.state = 13;
            return;
        }
    }

    public String read(InputSource input) {
        this.objectStack = new Stack();
        if (this.DEBUG) {
            System.out.println("read InputSource");
        }
        this.state = 8;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                factory.setFeature("http://xml.org/sax/features/string-interning", true);
            }
            catch (SAXException e) {
                // empty catch block
            }
            SAXParser parser = factory.newSAXParser();
            parser.parse(input, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            this.log(e);
        }
        catch (IOException e) {
            this.log(e);
        }
        catch (SAXException e) {
            this.log(e);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Error e) {
            e.printStackTrace();
            throw e;
        }
        return "Finished parsing";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap read(String location) throws IOException {
        if (this.DEBUG) {
            System.out.println("read String");
        }
        try (BufferedInputStream file = null;){
            file = new BufferedInputStream(new FileInputStream(location));
            this.read(new InputSource(file));
            HashMap hashMap = this.m_linkedResources;
            return hashMap;
        }
    }

    @Override
    public void startElement(String uri, String elementName, String qname, Attributes attributes) throws SAXException {
        this.charBuffer.setLength(0);
        if (this.DEBUG) {
            System.out.println("startElement " + elementName + " state == " + this.state);
        }
        switch (this.state) {
            case 8: {
                if (elementName.equals(PROJECT_DESCRIPTION)) {
                    this.state = 17;
                    break;
                }
                throw new SAXException("Element name does not start a project description: " + elementName);
            }
            case 17: {
                this.parseProjectDescription(elementName);
                break;
            }
            case 13: {
                if (!elementName.equals(LINK)) break;
                this.state = 9;
                this.objectStack.push(new LinkDescription());
                break;
            }
            case 9: {
                if (elementName.equals(NAME)) {
                    this.state = 11;
                    break;
                }
                if (elementName.equals(TYPE)) {
                    this.state = 12;
                    break;
                }
                if (!elementName.equals(LOCATION)) break;
                this.state = 10;
            }
        }
    }

    @Override
    public void warning(SAXParseException error) {
        this.log(error);
    }
}

