/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.eclipse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SafeChunkyInputStream
extends InputStream {
    protected static final int BUFFER_SIZE = 8192;
    protected byte[] buffer;
    protected int bufferLength = 0;
    protected byte[] chunk;
    protected int chunkLength = 0;
    protected boolean endOfFile = false;
    protected InputStream input;
    protected int nextByteInBuffer = 0;
    protected int nextByteInChunk = 0;
    private static final int SIZE_LASTMODIFIED = 8;
    private static final int SIZE_COUNTER = 1;
    private static final int SIZE_KEY_SUFFIX = 9;
    private static final byte[] BEGIN_CHUNK = new byte[]{64, -79, -117, -127, 35, -68, 0, 20, 26, 37, -106, -25, -93, -109, -66, 30};
    private static final byte[] END_CHUNK = new byte[]{-64, 88, -5, -13, 35, -68, 0, 20, 26, 81, -13, -116, 123, -69, 119, -58};
    private static final int CHUNK_DELIMITER_SIZE = BEGIN_CHUNK.length;

    public SafeChunkyInputStream(File target) throws IOException {
        this(target, 8192);
    }

    public SafeChunkyInputStream(File target, int bufferSize) throws IOException {
        this.input = new FileInputStream(target);
        this.buffer = new byte[bufferSize];
    }

    protected void accumulate(byte[] data, int start, int end) {
        byte[] result = new byte[this.chunk.length + end - start];
        System.arraycopy(this.chunk, 0, result, 0, this.chunk.length);
        System.arraycopy(data, start, result, this.chunk.length, end - start);
        this.chunk = result;
        this.chunkLength = this.chunkLength + end - start;
    }

    @Override
    public int available() throws IOException {
        return this.chunkLength - this.nextByteInChunk;
    }

    protected void buildChunk() throws IOException {
        int end;
        if (this.nextByteInBuffer + CHUNK_DELIMITER_SIZE > this.bufferLength) {
            this.shiftAndFillBuffer();
        }
        if ((end = this.find(END_CHUNK, this.nextByteInBuffer, this.bufferLength, true)) != -1) {
            this.accumulate(this.buffer, this.nextByteInBuffer, end);
            this.nextByteInBuffer = end + CHUNK_DELIMITER_SIZE;
            return;
        }
        this.accumulate(this.buffer, this.nextByteInBuffer, this.bufferLength);
        this.bufferLength = this.input.read(this.buffer);
        this.nextByteInBuffer = 0;
        if (this.bufferLength == -1) {
            this.endOfFile = true;
            return;
        }
        this.buildChunk();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    protected boolean compare(byte[] source, byte[] target, int startIndex) {
        for (int i = 0; i < target.length; ++i) {
            if (source[startIndex] != target[i]) {
                return false;
            }
            ++startIndex;
        }
        return true;
    }

    protected int find(byte[] pattern, int startIndex, int endIndex, boolean accumulate) throws IOException {
        int pos = this.findByte(pattern[0], startIndex, endIndex);
        if (pos == -1) {
            return -1;
        }
        if (pos + CHUNK_DELIMITER_SIZE > this.bufferLength) {
            if (accumulate) {
                this.accumulate(this.buffer, this.nextByteInBuffer, pos);
            }
            this.nextByteInBuffer = pos;
            pos = 0;
            this.shiftAndFillBuffer();
        }
        if (this.compare(this.buffer, pattern, pos)) {
            return pos;
        }
        return this.find(pattern, pos + 1, endIndex, accumulate);
    }

    protected int findByte(byte target, int startIndex, int endIndex) {
        while (startIndex < endIndex) {
            if (this.buffer[startIndex] == target) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    protected void findChunkStart() throws IOException {
        int begin;
        if (this.nextByteInBuffer + CHUNK_DELIMITER_SIZE > this.bufferLength) {
            this.shiftAndFillBuffer();
        }
        if ((begin = this.find(BEGIN_CHUNK, this.nextByteInBuffer, this.bufferLength, false)) != -1) {
            this.nextByteInBuffer = begin + CHUNK_DELIMITER_SIZE;
            return;
        }
        this.bufferLength = this.input.read(this.buffer);
        this.nextByteInBuffer = 0;
        if (this.bufferLength == -1) {
            this.resetChunk();
            this.endOfFile = true;
            return;
        }
        this.findChunkStart();
    }

    @Override
    public int read() throws IOException {
        if (this.endOfFile) {
            return -1;
        }
        if (this.nextByteInChunk < this.chunkLength) {
            return this.chunk[this.nextByteInChunk++] & 0xFF;
        }
        this.resetChunk();
        this.findChunkStart();
        if (this.endOfFile) {
            return -1;
        }
        this.buildChunk();
        this.refineChunk();
        return this.read();
    }

    protected void refineChunk() {
        int start = this.chunkLength - CHUNK_DELIMITER_SIZE;
        if (start < 0) {
            return;
        }
        for (int i = start; i >= 0; --i) {
            if (!this.compare(this.chunk, BEGIN_CHUNK, i)) continue;
            this.nextByteInChunk = i + CHUNK_DELIMITER_SIZE;
            return;
        }
    }

    protected void resetChunk() {
        this.chunk = new byte[0];
        this.chunkLength = 0;
        this.nextByteInChunk = 0;
    }

    protected void shiftAndFillBuffer() throws IOException {
        int length = this.bufferLength - this.nextByteInBuffer;
        System.arraycopy(this.buffer, this.nextByteInBuffer, this.buffer, 0, length);
        this.nextByteInBuffer = 0;
        this.bufferLength = length;
        int read = this.input.read(this.buffer, this.bufferLength, this.buffer.length - this.bufferLength);
        if (read != -1) {
            this.bufferLength += read;
        } else {
            this.resetChunk();
            this.endOfFile = true;
        }
    }
}

