/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.jndi.mfcontext;

import com.sonicsw.jndi.mfcontext.MFContext;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public final class MFContextFactory
implements InitialContextFactory {
    public Context getInitialContext(Hashtable env) throws NamingException {
        String providerURL = (String)env.get("java.naming.provider.url");
        HashMap params = this.extractParams(providerURL);
        if (params.containsKey("domain")) {
            env.put("com.sonicsw.jndi.mfcontext.domain", params.get("domain"));
        }
        if (params.containsKey("connectTimeout")) {
            env.put("com.sonicsw.jndi.mfcontext.connectTimeout", params.get("connectTimeout"));
        }
        if (params.containsKey("idleTimeout")) {
            env.put("com.sonicsw.jndi.mfcontext.idleTimeout", params.get("idleTimeout"));
        }
        if (params.containsKey("requestTimeout")) {
            env.put("com.sonicsw.jndi.mfcontext.requestTimeout", params.get("requestTimeout"));
        }
        if (params.containsKey("lookupRetries")) {
            env.put("com.sonicsw.jndi.mfcontext.lookupRetries", params.get("lookupRetries"));
        }
        if (params.containsKey("socketTimeout")) {
            env.put("com.sonicsw.jndi.mfcontext.socketConnectTimeout", params.get("socketTimeout"));
        }
        if (params.containsKey("node")) {
            env.put("com.sonicsw.jndi.mfcontext.node", params.get("node"));
        }
        StringBuffer connectionURLs = new StringBuffer();
        String initialCtxName = this.getConnectionURLs(providerURL, connectionURLs);
        MFContext root = new MFContext(connectionURLs.toString(), initialCtxName, env);
        return root;
    }

    private HashMap extractParams(String providerURL) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (providerURL == null || providerURL.length() == 0) {
            return params;
        }
        StringTokenizer st = new StringTokenizer(providerURL, ", ");
        String firstURL = st.nextToken();
        if (!firstURL.contains("?")) {
            return params;
        }
        st = new StringTokenizer(firstURL, "?");
        st.nextToken();
        st = new StringTokenizer(st.nextToken(), "=&");
        while (st.hasMoreTokens()) {
            params.put(st.nextToken(), st.nextToken());
        }
        return params;
    }

    private String getConnectionURLs(String providerURL, StringBuffer connectionURLs) throws NamingException {
        String initialCtxName = null;
        if (providerURL == null || providerURL.length() == 0) {
            connectionURLs.append("tcp://localhost:2506");
            initialCtxName = "";
        } else {
            StringTokenizer st = new StringTokenizer(providerURL, ", ");
            while (st.hasMoreTokens()) {
                int ctxSearchStartPosn;
                int ctxPosn;
                String connectionURL = st.nextToken();
                String ctxName = "";
                if ((ctxPosn = connectionURL.indexOf("/", ctxSearchStartPosn += (ctxSearchStartPosn = connectionURL.indexOf("//")) == -1 ? 1 : 2)) >= 0) {
                    ctxName = connectionURL.substring(ctxPosn + 1);
                    if (ctxName.indexOf(63) > 0) {
                        ctxName = ctxName.substring(0, ctxName.indexOf(63));
                    }
                    connectionURL = connectionURL.substring(0, ctxPosn);
                }
                if (initialCtxName == null) {
                    initialCtxName = ctxName;
                } else if (!ctxName.equals(initialCtxName)) {
                    throw new NamingException("When specifying multiple URLs, each URL must specify the same context.");
                }
                if (connectionURLs.length() > 0) {
                    connectionURLs.append(',');
                }
                if (connectionURL.indexOf(63) > 0) {
                    connectionURL = connectionURL.substring(0, connectionURL.indexOf(63));
                }
                connectionURLs.append(connectionURL);
            }
        }
        return initialCtxName;
    }
}

