/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.comm.jms;

import com.sonicsw.mf.comm.IDurableConnectorConsumer;
import com.sonicsw.mf.common.MgmtMsgTooBigException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import progress.message.jclient.Message;

public class MessageSizeValidator {
    public static final String MESSAGE_SIZE_MAX_MB_PROPERTY = "sonicsw.mf.msgSizeMaxMb";
    private static final int MESSAGE_SIZE_MAX_BYTES;
    public static final String MESSAGE_SIZE_WARN_MB_PROPERTY = "sonicsw.mf.msgSizeWarnMb";
    private static final int MESSAGE_SIZE_WARN_BYTES;
    public static final String MESSAGE_SIZE_MAX_WARNINGS_PROPERTY = "sonicsw.mf.msgSizeMaxWarnings";
    private static final int MAX_LOG_WARNINGS;
    public static final String MESSAGE_SIZE_MAX_ERRORS_PROPERTY = "sonicsw.mf.msgSizeMaxErrors";
    private static final int MAX_LOG_ERRORS;
    public static final String MESSAGE_SIZE_MAX_DUMPS_PROPERTY = "sonicsw.mf.msgSizeMaxDumps";
    private static final int MAX_MSG_DUMPS;
    public static final String MESSAGE_SIZE_DUMP_DIR_PROPERTY = "sonicsw.mf.msgSizeDumpDir";
    public static final String MESSAGE_SIZE_DUMP_PREFIX_PROPERTY = "sonicsw.mf.msgSizeDumpPrefix";
    private static final String MESSAGE_DUMP_PREFIX;
    private static final String MESSAGE_DUMP_EXTENSION = ".mdump";
    private static int s_warningCount;
    private static int s_errorCount;
    private static int s_dumpCount;
    private static Object s_countLock;
    private static Object s_fileLock;
    private IDurableConnectorConsumer m_consumer;

    private static float getFloatProperty(String propName, float defaultVal) {
        float result = -1.0f;
        try {
            String floatStr = System.getProperty(propName);
            if (floatStr != null) {
                result = Float.parseFloat(floatStr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result < 0.0f ? defaultVal : result;
    }

    public MessageSizeValidator(IDurableConnectorConsumer consumer) {
        this.m_consumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(javax.jms.Message jmsMessage, String subject) throws JMSException, MgmtMsgTooBigException {
        boolean lastDump;
        boolean doDump;
        boolean lastLog;
        boolean doLog;
        String formatStr;
        boolean warningOnly;
        if (!(jmsMessage instanceof Message)) {
            return;
        }
        Message message = (Message)jmsMessage;
        int bodySize = message.getBodySize();
        if (bodySize < MESSAGE_SIZE_WARN_BYTES) {
            return;
        }
        if (bodySize > MESSAGE_SIZE_MAX_BYTES) {
            warningOnly = false;
            formatStr = "Management message in excess of the %1.1fMb limit was generated. The message was rejected.";
        } else {
            warningOnly = true;
            formatStr = "Management message in excess of the %1.1fMb warning threshold was generated.";
        }
        Object object = s_countLock;
        synchronized (object) {
            if (warningOnly) {
                doLog = ++s_warningCount <= MAX_LOG_WARNINGS;
                lastLog = s_warningCount == MAX_LOG_WARNINGS;
            } else {
                doLog = ++s_errorCount <= MAX_LOG_ERRORS;
                lastLog = s_errorCount == MAX_LOG_ERRORS;
            }
            doDump = doLog && ++s_dumpCount <= MAX_MSG_DUMPS;
            lastDump = s_dumpCount == MAX_MSG_DUMPS;
        }
        float limitMb = (float)(warningOnly ? MESSAGE_SIZE_WARN_BYTES : MESSAGE_SIZE_MAX_BYTES) / 1048576.0f;
        String errorStr = String.format(formatStr, Float.valueOf(limitMb));
        if (doLog) {
            String dumpfile;
            StringBuilder detailBuff = new StringBuilder(errorStr);
            HashMap<String, String> displayProps = this.getDisplayProperties((javax.jms.Message)message, subject);
            displayProps.put("Msg body", Integer.toString(bodySize) + " bytes");
            for (Map.Entry<String, String> prop : displayProps.entrySet()) {
                detailBuff.append("\n    ");
                detailBuff.append(prop.getKey());
                detailBuff.append(": ");
                detailBuff.append(prop.getValue());
            }
            if (doDump && (dumpfile = this.writeMsgToFile((javax.jms.Message)message)) != null) {
                detailBuff.append("\nMessage dumped to " + dumpfile);
            }
            this.m_consumer.logMessage(detailBuff.toString(), warningOnly ? 2 : 1);
            if (lastLog) {
                this.m_consumer.logMessage("Reached max log limit for large mgmt message " + (warningOnly ? "warnings" : "errors") + ", limit is " + (warningOnly ? MAX_LOG_WARNINGS : MAX_LOG_ERRORS), 3);
            }
            if (lastDump) {
                this.m_consumer.logMessage("Reached max msg dump limit for large mgmt messages, limit is " + MAX_MSG_DUMPS, 3);
            }
        }
        if (!warningOnly) {
            throw new MgmtMsgTooBigException(errorStr);
        }
    }

    private HashMap<String, String> getDisplayProperties(javax.jms.Message message, String subject) {
        LinkedHashMap<String, String> displayProps = new LinkedHashMap<String, String>();
        try {
            String typeStr;
            displayProps.put("Subject", subject);
            displayProps.put("JMS_SonicMQ_mf_comms_type", message.getStringProperty("JMS_SonicMQ_mf_comms_type"));
            short type = message.getShortProperty("JMS_SonicMQ_mf_content_type");
            switch (type) {
                case 0: {
                    typeStr = "notification";
                    break;
                }
                case 1: {
                    typeStr = "request";
                    break;
                }
                case 2: {
                    typeStr = "reply";
                    break;
                }
                default: {
                    typeStr = "unknown";
                }
            }
            if (message.getBooleanProperty("JMS_SonicMQ_mf_oneway_request")) {
                typeStr = typeStr + " (oneway)";
            }
            displayProps.put("JMS_SonicMQ_mf_content_type", typeStr);
            displayProps.put("JMS_SonicMQ_mf_target", message.getStringProperty("JMS_SonicMQ_mf_target"));
            displayProps.put("JMS_SonicMQ_mf_reply_subject", message.getStringProperty("JMS_SonicMQ_mf_reply_subject"));
            displayProps.put("JMS_SonicMQ_mf_operation", message.getStringProperty("JMS_SonicMQ_mf_operation"));
        }
        catch (Throwable t) {
            this.m_consumer.logMessage("Diagnostics failure: unable to get mgmt message properties", t, 2);
        }
        return displayProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeMsgToFile(javax.jms.Message message) {
        String genFilename = null;
        String fullFilename = null;
        OutputStream os = null;
        Throwable error = null;
        Object object = s_fileLock;
        synchronized (object) {
            try {
                String op = message.getStringProperty("JMS_SonicMQ_mf_operation");
                genFilename = MESSAGE_DUMP_PREFIX + '-' + System.currentTimeMillis() + '-' + op + MESSAGE_DUMP_EXTENSION;
                File dumpFile = new File(genFilename);
                fullFilename = dumpFile.getAbsolutePath();
                BytesMessage bytesMsg = (BytesMessage)message;
                bytesMsg.reset();
                if (dumpFile.exists()) {
                    throw new IOException("File already exists: " + fullFilename);
                }
                os = new BufferedOutputStream(new FileOutputStream(dumpFile));
                byte[] buff = new byte[16384];
                int length = bytesMsg.readBytes(buff);
                while (length > 0) {
                    os.write(buff, 0, length);
                    length = bytesMsg.readBytes(buff);
                }
            }
            catch (Throwable t) {
                error = t;
                fullFilename = null;
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        if (error != null) {
            this.m_consumer.logMessage("Diagnostics failure: unable to dump mgmt message to '" + genFilename + "'", error, 2);
        }
        return fullFilename;
    }

    static {
        float mb = MessageSizeValidator.getFloatProperty(MESSAGE_SIZE_MAX_MB_PROPERTY, 9.9f);
        MESSAGE_SIZE_MAX_BYTES = (int)(1048576.0 * (double)mb);
        mb = MessageSizeValidator.getFloatProperty(MESSAGE_SIZE_WARN_MB_PROPERTY, 8.0f);
        int warnBytes = (int)(1048576.0 * (double)mb);
        MESSAGE_SIZE_WARN_BYTES = warnBytes < MESSAGE_SIZE_MAX_BYTES ? warnBytes : MESSAGE_SIZE_MAX_BYTES;
        MAX_LOG_WARNINGS = Integer.getInteger(MESSAGE_SIZE_MAX_WARNINGS_PROPERTY, 25);
        MAX_LOG_ERRORS = Integer.getInteger(MESSAGE_SIZE_MAX_ERRORS_PROPERTY, 25);
        MAX_MSG_DUMPS = Integer.getInteger(MESSAGE_SIZE_MAX_DUMPS_PROPERTY, 1);
        String dir = System.getProperty(MESSAGE_SIZE_DUMP_DIR_PROPERTY);
        String filePrefix = System.getProperty(MESSAGE_SIZE_DUMP_PREFIX_PROPERTY, "MgmtMsg");
        MESSAGE_DUMP_PREFIX = (dir != null ? dir + File.separatorChar : "") + filePrefix;
        s_warningCount = 0;
        s_errorCount = 0;
        s_dumpCount = 0;
        s_countLock = new Object();
        s_fileLock = new Object();
    }
}

