/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.query;

import com.sonicsw.mf.common.config.query.impl.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public final class AttributeName
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final String ELEMENT_NAME_ATT_SEPARATOR = "|||";
    private static final int SERIALIZATION_VERSION = 4;
    private ArrayList m_components;
    private String m_elementName;

    public boolean equals(Object obj) {
        if (!(obj instanceof AttributeName)) {
            return false;
        }
        AttributeName other = (AttributeName)obj;
        if (!other.m_elementName.equals(this.m_elementName)) {
            return false;
        }
        return other.m_components.equals(this.m_components);
    }

    public int hashCode() {
        return this.m_elementName.hashCode() * 31 + this.m_components.hashCode();
    }

    public AttributeName(String name) {
        this();
        if (name == null) {
            throw new NullPointerException();
        }
        this.m_components.add(name);
    }

    private AttributeName(String elementName, ArrayList components) {
        this.m_components = components;
        this.m_elementName = elementName;
    }

    public AttributeName createClone() {
        return new AttributeName(this.m_elementName, (ArrayList)this.m_components.clone());
    }

    public AttributeName(int position) {
        this();
        if (position < 0) {
            throw new IllegalArgumentException();
        }
        this.m_components.add(new Integer(position));
    }

    public AttributeName(String elementName, boolean hasElementName) {
        this();
        if (hasElementName) {
            this.m_elementName = elementName;
        }
    }

    public AttributeName() {
        this.m_elementName = null;
        this.m_components = new ArrayList();
    }

    public AttributeName setNextComponent(String component) {
        if (component == null) {
            throw new NullPointerException();
        }
        this.m_components.add(component);
        return this;
    }

    public AttributeName setNextComponent(int position) {
        if (position < 0) {
            throw new IllegalArgumentException();
        }
        this.m_components.add(new Integer(position));
        return this;
    }

    public int getComponentCount() {
        return this.m_components.size();
    }

    public Object getComponent(int level) {
        return this.m_components.get(level);
    }

    public String toString() {
        String result = this.m_elementName == null ? "" : this.m_elementName + ELEMENT_NAME_ATT_SEPARATOR;
        for (int i = 0; i < this.m_components.size(); ++i) {
            result = result + this.m_components.get(i).toString();
            if (i + 1 >= this.m_components.size()) continue;
            result = result + "|";
        }
        return result;
    }

    public String getElementName() {
        return this.m_elementName;
    }

    public void setElementName(String elementName) {
        this.m_elementName = elementName;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(4);
        HashMap<String, Object> table = new HashMap<String, Object>(2, 1.0f);
        table.put("comp", this.m_components);
        table.put("element", this.m_elementName);
        s.writeObject(table);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int version = s.readInt();
        if (version != 4) {
            Util.throwSerialVersionMismatch((int)version, (int)4);
        }
        HashMap table = (HashMap)s.readObject();
        this.m_components = (ArrayList)table.get("comp");
        this.m_elementName = (String)table.get("element");
    }
}

