/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.util;

import com.sonicsw.mx.util.ICollationKeyProvider;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Vector;

public final class Sorter {
    public static final Collator COLLATOR = Collator.getInstance();

    public static String[] sort(Vector orderThese) {
        Object[] ordered = new String[orderThese.size()];
        orderThese.copyInto(ordered);
        try {
            return (String[])Sorter.sort(ordered, ordered.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ordered;
        }
    }

    public static Object[] sort(Object[] orderThese) {
        return Sorter.sort(orderThese, orderThese.length);
    }

    public static Object[] sort(Object[] orderThese, int count) {
        try {
            CollationKey[] keys = new CollationKey[count];
            Sorter.sort(orderThese, keys, count);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orderThese;
    }

    public static Object[] sort(Object[] orderThese, CollationKey[] keys, int count) {
        try {
            if (count > 0) {
                if (keys[0] == null) {
                    for (int i = 0; i < count; ++i) {
                        String keyString = null;
                        keyString = orderThese[i] instanceof String ? (String)orderThese[i] : (orderThese[i] instanceof Object[] ? (String)((Object[])orderThese[i])[0] : orderThese[i].toString());
                        keys[i] = COLLATOR.getCollationKey(keyString);
                    }
                }
                Sorter.internalSort(orderThese, keys, count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orderThese;
    }

    public static Object[] sort(Object[] orderThese, ICollationKeyProvider keyProvider, int count) {
        try {
            if (count > 0) {
                CollationKey[] keys = new CollationKey[count];
                if (keys[0] == null) {
                    for (int i = 0; i < count; ++i) {
                        keys[i] = keyProvider.getCollationKey(orderThese[i]);
                    }
                }
                Sorter.internalSort(orderThese, keys, count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orderThese;
    }

    private static void quickSort(Object[] a, CollationKey[] keys, int l, int r) throws Exception {
        int M = 4;
        Object v = null;
        if (r - l > M) {
            int i = r + l >> 1;
            if (keys[l].compareTo(keys[i]) > 0) {
                Sorter.swap(a, keys, l, i);
            }
            if (keys[l].compareTo(keys[r]) > 0) {
                Sorter.swap(a, keys, l, r);
            }
            if (keys[i].compareTo(keys[r]) > 0) {
                Sorter.swap(a, keys, i, r);
            }
            int j = r - 1;
            Sorter.swap(a, keys, i, j);
            i = l;
            CollationKey vKey = keys[j];
            while (true) {
                if (keys[++i].compareTo(vKey) < 0) {
                    continue;
                }
                while (keys[--j].compareTo(vKey) > 0) {
                }
                if (j < i) break;
                Sorter.swap(a, keys, i, j);
            }
            Sorter.swap(a, keys, i, r - 1);
            Sorter.quickSort(a, keys, l, j);
            Sorter.quickSort(a, keys, i + 1, r);
        }
    }

    private static void swap(Object[] a, CollationKey[] keys, int i, int j) {
        Object temp = a[i];
        a[i] = a[j];
        a[j] = temp;
        temp = keys[i];
        keys[i] = keys[j];
        keys[j] = (CollationKey)temp;
    }

    private static void insertionSort(Object[] a, CollationKey[] keys, int lo0, int hi0) throws Exception {
        for (int i = lo0 + 1; i <= hi0; ++i) {
            Object o = a[i];
            CollationKey vKey = keys[i];
            for (int j = i; j > lo0 && keys[j - 1].compareTo(vKey) > 0; --j) {
                a[j] = a[j - 1];
                keys[j] = keys[j - 1];
            }
            a[j] = o;
            keys[j] = vKey;
        }
    }

    private static void internalSort(Object[] a, CollationKey[] keys, int length) throws Exception {
        Sorter.quickSort(a, keys, 0, --length);
        Sorter.insertionSort(a, keys, 0, length);
    }
}

