/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.cache.impl;

import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.agent.cache.PersistentCacheException;
import com.sonicsw.mf.framework.agent.cache.impl.ConfigCache;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class BlobStorageSizeManager {
    private long m_cacheSize = 0L;
    private long m_maxCacheSize = 0L;
    private HashMap<String, Long> m_fileList;
    private File m_fileListFile;
    private HashSet<String> m_inUse;
    private boolean spaceWarningLogged = false;
    private int m_fileNamesPrefixLength;
    private String m_fileNamePrefix = "";
    private static final String FILE_LIST_FILE = "archive_list";
    private boolean DEBUG = false;

    BlobStorageSizeManager(String hostDirName, String domainName, String dataDirName, String password, boolean doSync, long maxSize) throws PersistentCacheException {
        this.m_fileNamesPrefixLength = hostDirName.length() + "_MFArchive".length() + 1;
        this.m_fileNamePrefix = hostDirName + System.getProperty("file.separator") + "_MFArchive";
        this.m_maxCacheSize = maxSize;
        if (this.DEBUG) {
            System.out.println("Initializing BlobStorageSizeManager, maxSize == " + maxSize);
        }
        this.m_fileListFile = new File(hostDirName, FILE_LIST_FILE);
        if (this.m_fileListFile.exists()) {
            this.initFileList();
        } else {
            this.m_fileList = new HashMap();
        }
        this.m_inUse = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markInUse(String fileName) {
        if (this.DEBUG) {
            System.out.println("BlobStorageSizeManager.markInUse " + fileName);
        }
        HashSet<String> hashSet = this.m_inUse;
        synchronized (hashSet) {
            this.m_inUse.add(this.removeFileNamePrefix(fileName));
        }
    }

    void addFile(String fileName, long size) throws PersistentCacheException {
        Long oldSize = this.m_fileList.put(this.removeFileNamePrefix(fileName), size);
        this.m_cacheSize += size;
        if (oldSize != null) {
            this.m_cacheSize -= oldSize.longValue();
        }
        this.persistFileList();
        if (this.DEBUG) {
            System.out.println("BlobStorageSizeManager.addFile " + fileName + ", size " + size + ", new cache size " + this.m_cacheSize);
        }
    }

    private void initFileList() throws PersistentCacheException {
        if (this.DEBUG) {
            System.out.println("BlobStorageSizeManager.initFileList from file: " + this.m_fileListFile);
        }
        try {
            BufferedInputStream fileIn = new BufferedInputStream(new FileInputStream(this.m_fileListFile));
            ObjectInputStream inS = new ObjectInputStream(fileIn);
            this.m_fileList = (HashMap)inS.readObject();
            if (this.DEBUG) {
                System.out.println("BlobStorageSizeManager.initFileList, read the file list from the stream");
            }
            fileIn.close();
            for (Long size : this.m_fileList.values()) {
                this.m_cacheSize += size.longValue();
            }
            if (this.DEBUG) {
                System.out.println("BlobStorageSizeManager.initFileList, the size of the re-constructed cache in bytes == " + this.m_cacheSize);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PersistentCacheException(e.toString(), e);
        }
    }

    private void spaceExceeded() {
        if (!this.spaceWarningLogged) {
            System.out.println(ContainerUtil.createLogMessage(null, (String)("Persistent cache size is too small. You must increase the current size of " + this.m_maxCacheSize + " bytes"), (int)2));
            this.spaceWarningLogged = true;
        }
    }

    void makeRoom(long size) throws PersistentCacheException {
        ArrayList<String> deletionList = new ArrayList<String>();
        if (this.m_maxCacheSize == 0L) {
            return;
        }
        if (this.DEBUG) {
            System.out.println("BlobStorageSizeManager.makeRoom " + size + ", printing all files in use");
            for (String fileName : this.m_inUse) {
                System.out.println(fileName);
            }
        }
        Iterator<String> files = this.m_fileList.keySet().iterator();
        while (files.hasNext() && size + this.m_cacheSize > this.m_maxCacheSize) {
            String deleteCandidateName = null;
            while (deleteCandidateName == null && files.hasNext()) {
                String fileName = files.next();
                if (this.m_inUse.contains(fileName)) continue;
                deleteCandidateName = fileName;
                break;
            }
            if (deleteCandidateName == null) {
                this.spaceExceeded();
                continue;
            }
            if (this.DEBUG) {
                System.out.println("BlobStorageSizeManager.makeRoom deleting the physical file " + deleteCandidateName);
            }
            this.deleteArchiveFile(deleteCandidateName);
            deletionList.add(deleteCandidateName);
            this.m_cacheSize -= this.m_fileList.get(deleteCandidateName).longValue();
        }
        if (!deletionList.isEmpty()) {
            for (String fileName : deletionList) {
                this.m_fileList.remove(fileName);
            }
            this.persistFileList();
        }
        if (size + this.m_cacheSize > this.m_maxCacheSize) {
            this.spaceExceeded();
        }
    }

    void addRoom(File cachedFile) throws PersistentCacheException {
        String fileName = this.removeFileNamePrefix(ConfigCache.getCanonicalPath(cachedFile));
        Long fileSize = this.m_fileList.get(fileName);
        if (fileSize != null) {
            if (this.DEBUG) {
                System.out.println("BlobStorageSizeManager.addRoom removing " + fileName + " and subtracting " + fileSize + " bytes from the size");
            }
            this.m_fileList.remove(fileName);
            this.m_cacheSize -= fileSize.longValue();
            this.persistFileList();
        }
    }

    private String removeFileNamePrefix(String fileName) {
        return fileName.substring(this.m_fileNamesPrefixLength);
    }

    private void deleteArchiveFile(String deleteThis) {
        File deleteFile = deleteThis.startsWith(System.getProperty("file.separator")) ? new File(this.m_fileNamePrefix + deleteThis) : new File(this.m_fileNamePrefix + System.getProperty("file.separator") + deleteThis);
        if (this.DEBUG) {
            System.out.println("BlobStorageSizeManager.deleteArchiveFile file == " + deleteFile.getAbsolutePath());
        }
        if (deleteFile.isDirectory()) {
            String[] files = deleteFile.list();
            for (int i = 0; i < files.length; ++i) {
                this.deleteArchiveFile(deleteThis + System.getProperty("file.separator") + files[i]);
            }
            deleteFile.delete();
        } else {
            boolean deleted = deleteFile.delete();
            if (this.DEBUG) {
                System.out.println("BlobStorageSizeManager.deleteArchiveFile " + deleteThis + " deleted == " + deleted);
            }
        }
    }

    private void persistFileList() throws PersistentCacheException {
        if (this.DEBUG) {
            System.out.println("BlobStorageSizeManager.persistFileList");
        }
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.m_fileListFile));
            oos.writeObject(this.m_fileList);
            oos.close();
        }
        catch (IOException e) {
            throw new PersistentCacheException(e.toString(), e);
        }
    }
}

