/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.cache.impl;

import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.LogicalStorageNameMapper;
import com.sonicsw.mf.common.config.NameMapperPathException;
import com.sonicsw.mf.common.config.impl.Blob;
import com.sonicsw.mf.common.config.impl.DeltaElement;
import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.config.impl.ElementIdentity;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.config.impl.IElementCache;
import com.sonicsw.mf.common.config.impl.VersionMisMatchException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.common.util.LockFile;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.agent.cache.CacheClosedException;
import com.sonicsw.mf.framework.agent.cache.CacheException;
import com.sonicsw.mf.framework.agent.cache.CacheIsLocked;
import com.sonicsw.mf.framework.agent.cache.IConfigCache;
import com.sonicsw.mf.framework.agent.cache.IConfigCacheView;
import com.sonicsw.mf.framework.agent.cache.LatestVersionMissingException;
import com.sonicsw.mf.framework.agent.cache.PersistentCacheException;
import com.sonicsw.mf.framework.agent.cache.impl.BlobStorageSizeManager;
import com.sonicsw.mf.framework.agent.cache.impl.ElementCache;
import com.sonicsw.mf.framework.agent.cache.impl.Lock;
import com.sonicsw.mf.framework.agent.cache.impl.PersistentBlobCache;
import com.sonicsw.mf.framework.directory.storage.StorageException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class ConfigCache
implements IConfigCache,
IConfigCacheView {
    private static final String EXT_PACK = ".pack";
    private static final boolean DEBUG = false;
    private static final String DS_BACKUP_VERSION_ATT = "ds_backup_version";
    static final String CONTENT_DIR = "content";
    private static final String OLD_ELEMENTS_LIST = "list";
    private static final String CACHE_CONTENT = "cache_content";
    public static final String NATIVE_LIBRARIES_DIR = "/native_libraries";
    private static final String CACHE_INFO = "cache_info";
    public static final String CONFIG_CACHE = ".cache";
    public static final String CACHE_LOCK_FILE = "cache.lock";
    public static final String UPDATE_LOCK_FILE = ".lock";
    private int m_tempSuffix = 0;
    private HashMap<String, IDirElement> m_elements;
    private HashMap<String, String> m_directories;
    private final HashMap<String, Long> m_info;
    private boolean m_open;
    private ElementCache m_elementCache;
    private LogicalStorageNameMapper m_logicalMap;
    private final boolean m_isPersistentCache;
    private final HashSet<Thread> m_updaters;
    private final File m_cacheRootDir;
    private final File m_cacheListFile;
    private final File m_cacheContentFile;
    private final File m_cacheInfoFile;
    private final LockFile m_cacheLockFile;
    private final PersistentBlobCache m_blobStorage;
    private final File m_cacheUpdateLockFile;
    private boolean m_cacheContentIsDirty;
    private AsyncContentUpdater m_asyncContentUpdater;
    private String m_storageError;
    private final Lock m_updaterLock;
    private final Lock m_archiveCleanerLock;
    private final BlobStorageSizeManager m_sizeManager;
    private final ReadWriteLock m_cacheLock = new ReentrantReadWriteLock();

    public ConfigCache() {
        this.m_isPersistentCache = false;
        this.m_updaters = null;
        this.m_elements = new HashMap();
        this.m_directories = new HashMap();
        this.m_logicalMap = new LogicalStorageNameMapper();
        this.m_info = new HashMap();
        this.m_cacheRootDir = null;
        this.m_cacheListFile = null;
        this.m_cacheContentFile = null;
        this.m_cacheInfoFile = null;
        this.m_cacheLockFile = null;
        this.m_cacheUpdateLockFile = null;
        this.m_open = true;
        this.m_archiveCleanerLock = null;
        this.m_updaterLock = null;
        this.m_sizeManager = null;
        this.m_blobStorage = null;
    }

    public ConfigCache(String cacheDirPath, String password) throws PersistentCacheException {
        this(cacheDirPath, password, 0L, false);
    }

    public ConfigCache(String cacheDirPath, String password, boolean reset) throws PersistentCacheException {
        this(cacheDirPath, password, 0L, reset);
    }

    public ConfigCache(String cacheDirPath, String password, long maxCacheSize) throws PersistentCacheException {
        this(cacheDirPath, password, maxCacheSize, false);
    }

    private ConfigCache(String cacheDirPath, String password, long persistentCacheMaxSize, boolean reset) throws PersistentCacheException {
        this.m_storageError = null;
        this.m_isPersistentCache = true;
        this.m_updaters = new HashSet();
        this.m_archiveCleanerLock = new Lock();
        this.m_updaterLock = new Lock();
        this.m_cacheRootDir = new File(cacheDirPath);
        if (!this.m_cacheRootDir.exists() && !this.m_cacheRootDir.mkdir()) {
            throw new PersistentCacheException("Failed to create the persistent cache directory \"" + ConfigCache.getCanonicalPath(this.m_cacheRootDir) + "\".");
        }
        if (reset) {
            ConfigCache.deleteCacheDir(this.m_cacheRootDir);
            if (this.m_cacheRootDir.exists()) {
                throw new PersistentCacheException("Could not delete obsolete cache \"" + ConfigCache.getCanonicalPath(this.m_cacheRootDir) + "\"; delete it and restart the container");
            }
            if (!this.m_cacheRootDir.mkdir()) {
                throw new PersistentCacheException("Failed to re-create the persistent cache directory \"" + ConfigCache.getCanonicalPath(this.m_cacheRootDir) + "\".");
            }
        }
        if (!this.m_cacheRootDir.canWrite()) {
            throw new PersistentCacheException("No write permission in directory \"" + ConfigCache.getCanonicalPath(this.m_cacheRootDir) + "\".");
        }
        this.m_cacheUpdateLockFile = new File(this.m_cacheRootDir, UPDATE_LOCK_FILE);
        File cacheLockFile = new File(this.m_cacheRootDir, CACHE_LOCK_FILE);
        this.m_cacheLockFile = new LockFile(cacheLockFile.getAbsolutePath());
        if (!this.m_cacheLockFile.lock()) {
            throw new CacheIsLocked("Configuration cache is locked; the cache directory \"" + ConfigCache.getCanonicalPath(this.m_cacheRootDir) + "\" is being used by another container which must be shutdown before starting this container.");
        }
        if (this.m_cacheUpdateLockFile.exists()) {
            this.m_cacheLockFile.unlock();
            throw new PersistentCacheException("Configuration cache is corrupt; the cache directory \"" + ConfigCache.getCanonicalPath(this.m_cacheRootDir) + "\" must be removed before restarting this container");
        }
        this.m_cacheInfoFile = new File(this.m_cacheRootDir, CACHE_INFO);
        this.m_info = this.readCacheInfoFile();
        this.m_cacheListFile = new File(this.m_cacheRootDir, OLD_ELEMENTS_LIST);
        this.m_cacheContentFile = new File(this.m_cacheRootDir, CACHE_CONTENT);
        if (this.m_cacheContentFile.exists()) {
            this.readCacheContentFile();
        } else {
            this.m_logicalMap = new LogicalStorageNameMapper();
            if (this.m_cacheListFile.exists()) {
                this.startUpdateInternal(Thread.currentThread());
                this.readCacheListFile();
                this.m_cacheContentIsDirty = true;
                this.m_cacheListFile.delete();
                this.finishUpdateInternal(Thread.currentThread());
            } else {
                this.m_elements = new HashMap();
                this.m_directories = new HashMap();
            }
        }
        this.m_elementCache = new ElementCache(null, ConfigCache.getCanonicalPath(this.m_cacheRootDir), password);
        for (Element element : this.m_elements.values()) {
            element.setCache((IElementCache)this.m_elementCache);
        }
        try {
            this.m_sizeManager = new BlobStorageSizeManager(ConfigCache.getCanonicalPath(this.m_cacheRootDir), CONTENT_DIR, "blobs", password, false, persistentCacheMaxSize);
            this.m_blobStorage = new PersistentBlobCache(ConfigCache.getCanonicalPath(this.m_cacheRootDir), CONTENT_DIR, "blobs", password, false);
        }
        catch (StorageException storageException) {
            throw new PersistentCacheException(storageException.toString(), storageException);
        }
        new ObsoleteArchiveRemover(this.m_cacheRootDir).doCleanup();
        this.m_open = true;
    }

    @Override
    public File getNativeLibDirectory() {
        if (this.m_cacheRootDir == null) {
            return null;
        }
        return new File(this.m_cacheRootDir, NATIVE_LIBRARIES_DIR);
    }

    @Override
    public File getCacheRootDirectory() {
        return this.m_cacheRootDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustSize(Integer newSize) {
        this.m_cacheLock.writeLock().lock();
        try {
            if (this.m_elementCache != null && newSize != null) {
                this.m_elementCache.adjustSize(newSize);
            }
        }
        finally {
            this.m_cacheLock.writeLock().unlock();
        }
    }

    private void readCacheContentFile() throws PersistentCacheException {
        try {
            BufferedInputStream fileIn = new BufferedInputStream(new FileInputStream(this.m_cacheContentFile));
            ObjectInputStream inS = new ObjectInputStream(fileIn);
            Object[] content = (Object[])inS.readObject();
            this.m_elements = (HashMap)content[0];
            this.m_directories = (HashMap)content[1];
            this.m_logicalMap = (LogicalStorageNameMapper)content[2];
            fileIn.close();
        }
        catch (ClassNotFoundException e) {
            throw new Error(e.toString(), e);
        }
        catch (IOException e) {
            throw new PersistentCacheException(e.toString(), e);
        }
    }

    private void readCacheListFile() {
        try {
            BufferedInputStream fileIn = new BufferedInputStream(new FileInputStream(this.m_cacheListFile));
            ObjectInputStream inS = new ObjectInputStream(fileIn);
            this.m_elements = (HashMap)inS.readObject();
            this.m_directories = (HashMap)inS.readObject();
            fileIn.close();
        }
        catch (ClassNotFoundException e) {
            throw new Error(e.toString(), e);
        }
        catch (IOException e) {
            throw new Error(e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, Long> readCacheInfoFile() {
        HashMap hashMap;
        BufferedInputStream fileIn = new BufferedInputStream(new FileInputStream(this.m_cacheInfoFile));
        ObjectInputStream inS = new ObjectInputStream(fileIn);
        try {
            hashMap = (HashMap)inS.readObject();
        }
        catch (Throwable throwable) {
            try {
                fileIn.close();
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                throw new Error(e.toString(), e);
            }
            catch (IOException e) {
                return new HashMap<String, Long>();
            }
        }
        fileIn.close();
        return hashMap;
    }

    private void validateOpen() throws CacheClosedException {
        if (!this.m_open) {
            throw new CacheClosedException("The cache is closed.");
        }
    }

    @Override
    public IConfigCacheView getCacheView() throws CacheClosedException {
        this.validateOpen();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBasicElement[] setElements(IElement[] elements) throws CacheClosedException, PersistentCacheException, VersionOutofSyncException {
        this.validateOpen();
        this.startUpdateInternal(Thread.currentThread());
        this.m_cacheLock.writeLock().lock();
        try {
            this.createBatch();
            boolean ok = false;
            ArrayList<IBasicElement> results = new ArrayList<IBasicElement>();
            try {
                for (int i = 0; i < elements.length; ++i) {
                    IDirElement element = (IDirElement)elements[i];
                    String storagePath = element.getIdentity().getName();
                    String logicalPath = null;
                    if (element.isDeleted() && i + 1 < elements.length && ((IDirElement)elements[i + 1]).getIdentity().getName().equals(storagePath)) {
                        logicalPath = this.storageToLogical(storagePath);
                    }
                    results.add(this.setElementInternal(element));
                    if (logicalPath == null) continue;
                    this.m_logicalMap.set(logicalPath, storagePath);
                    results.add(this.setElementInternal((IDirElement)elements[++i]));
                }
                ok = true;
                IBasicElement[] iBasicElementArray = results.toArray(new IBasicElement[results.size()]);
                this.saveBatch(ok);
                return iBasicElementArray;
            }
            catch (Throwable throwable) {
                this.saveBatch(ok);
                throw throwable;
            }
        }
        finally {
            this.m_cacheLock.writeLock().unlock();
            this.finishUpdateInternal(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBasicElement setElementByLogicalName(String path, IBasicElement element) throws CacheClosedException, PersistentCacheException, VersionOutofSyncException {
        if (element instanceof IElement && this.isDoNotCache((IElement)element)) {
            return element;
        }
        this.validateOpen();
        this.startUpdateInternal(Thread.currentThread());
        this.m_cacheLock.writeLock().lock();
        try {
            this.m_logicalMap.set(path, element.getIdentity().getName());
            element = element instanceof IDeltaDirElement ? this.setElementInternal((IDeltaDirElement)element) : this.setElementInternal((IDirElement)element);
        }
        finally {
            this.m_cacheLock.writeLock().unlock();
            this.finishUpdateInternal(Thread.currentThread());
        }
        return element;
    }

    private boolean archivedFileExists(IElementIdentity fileIdentity) throws CacheException {
        File archivedFile = new File(this.getArchiveFileName(fileIdentity));
        return archivedFile.exists();
    }

    private URL createURL(String tryString) throws Exception {
        URL returnThis;
        block2: {
            returnThis = null;
            try {
                returnThis = new URL(tryString);
            }
            catch (MalformedURLException ex) {
                File theFile = new File(tryString);
                if (!theFile.exists()) break block2;
                returnThis = theFile.toURL();
            }
        }
        return returnThis;
    }

    @Override
    public boolean isDoNotCache(IElement envEl) {
        IAttributeSet topSet = envEl.getAttributes();
        IAttributeSet systemAttrs = (IAttributeSet)topSet.getAttribute("_MF_SYSTEM_ATTRIBUTES");
        if (systemAttrs == null) {
            return false;
        }
        Boolean doNotCache = (Boolean)systemAttrs.getAttribute("DO_NOT_CACHE");
        if (doNotCache == null) {
            return false;
        }
        return doNotCache;
    }

    @Override
    public boolean isNonDS(IElement envEl) {
        IAttributeSet topSet = envEl.getAttributes();
        IAttributeSet systemAttrs = (IAttributeSet)topSet.getAttribute("_MF_SYSTEM_ATTRIBUTES");
        if (systemAttrs == null) {
            return false;
        }
        Boolean non_ds = (Boolean)systemAttrs.getAttribute("NON_DSFILE");
        if (non_ds == null) {
            return false;
        }
        return non_ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeFile(String location, String logicalName) throws PersistentCacheException {
        boolean refetch = false;
        URL url = null;
        URLConnection conn = null;
        String useLogicalName = logicalName;
        if (!logicalName.startsWith("/")) {
            useLogicalName = "/" + logicalName;
        }
        long newTimestamp = 0L;
        long timestamp = 0L;
        try {
            this.validateOpen();
            this.startUpdateInternal(Thread.currentThread());
            this.m_cacheLock.writeLock().lock();
            try {
                IElement envEl;
                block29: {
                    envEl = this.getElementByLogicalName(useLogicalName);
                    if (envEl != null) {
                        IAttributeSet topSet = envEl.getAttributes();
                        IAttributeSet systemAttrs = (IAttributeSet)topSet.getAttribute("_MF_SYSTEM_ATTRIBUTES");
                        Boolean non_ds = null;
                        if (systemAttrs != null) {
                            non_ds = (Boolean)systemAttrs.getAttribute("NON_DSFILE");
                        }
                        if (non_ds == null || !non_ds.booleanValue()) {
                            refetch = true;
                        } else {
                            IElementIdentity id = envEl.getIdentity();
                            timestamp = id.getCreationTimestamp();
                        }
                    } else {
                        refetch = true;
                    }
                    try {
                        url = this.createURL(location + useLogicalName);
                        if (url != null) break block29;
                        boolean topSet = false;
                        return topSet;
                    }
                    catch (Exception ex) {
                        boolean systemAttrs = false;
                        this.m_cacheLock.writeLock().unlock();
                        this.finishUpdateInternal(Thread.currentThread());
                        return systemAttrs;
                    }
                }
                conn = url.openConnection();
                if (conn != null) {
                    newTimestamp = conn.getLastModified();
                    if (newTimestamp > timestamp) {
                        refetch = true;
                    } else if (newTimestamp < timestamp) {
                        System.out.println(ContainerUtil.createLogMessage(null, (String)("Container cache found file on disk " + logicalName + " with an older timestamp than the cached file; the file was not replaced in the cache"), (int)3));
                    } else {
                        conn.getInputStream().close();
                    }
                }
                if (refetch) {
                    IDirElement storeElement = ElementFactory.createElement((String)useLogicalName, (String)"MF_FILE", (String)"1");
                    ElementIdentity id = (ElementIdentity)storeElement.getIdentity();
                    id.setCreationTimestamp(newTimestamp);
                    IAttributeSet topSet = storeElement.getAttributes();
                    IAttributeSet systemAttrs = topSet.createAttributeSet("_MF_SYSTEM_ATTRIBUTES");
                    systemAttrs.setBooleanAttribute("NON_DSFILE", Boolean.TRUE);
                    InputStream urlStream = conn.getInputStream();
                    Blob fileBlob = new Blob(storeElement, urlStream);
                    if (envEl != null) {
                        this.deleteElementInternal(envEl.getIdentity().getName());
                    }
                    this.setBlobByLogicalNameInternal(useLogicalName, (IBlob)fileBlob, false, false);
                    urlStream.close();
                }
            }
            finally {
                this.m_cacheLock.writeLock().unlock();
            }
        }
        catch (Exception ex) {
            if (ex instanceof PersistentCacheException) {
                throw (PersistentCacheException)ex;
            }
            throw new PersistentCacheException(ex.toString());
        }
        finally {
            this.finishUpdateInternal(Thread.currentThread());
        }
        return true;
    }

    @Override
    public void setBlobByLogicalName(String path, IBlob blob, boolean isNativeFile) throws CacheClosedException, PersistentCacheException, VersionOutofSyncException {
        this.setBlobByLogicalName(path, blob, isNativeFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlobByLogicalName(String path, IBlob blob, boolean isNativeFile, boolean replaceMap) throws CacheClosedException, PersistentCacheException, VersionOutofSyncException {
        this.validateOpen();
        try {
            this.startUpdateInternal(Thread.currentThread());
            this.m_cacheLock.writeLock().lock();
            try {
                this.setBlobByLogicalNameInternal(path, blob, isNativeFile, replaceMap);
            }
            finally {
                this.m_cacheLock.writeLock().unlock();
            }
        }
        finally {
            this.finishUpdateInternal(Thread.currentThread());
        }
    }

    @Override
    public File storeBlobTemporarily(IBlob blob) throws PersistentCacheException, CacheClosedException {
        this.validateOpen();
        this.startUpdateInternal(Thread.currentThread());
        this.m_cacheLock.writeLock().lock();
        try {
            int readIn;
            File tempFile = new File(this.getTempFileName(blob.getElement().getIdentity()));
            if (!tempFile.getParentFile().exists() && !tempFile.getParentFile().mkdirs()) {
                throw new PersistentCacheException("Could not create necessary directory " + tempFile.getParent());
            }
            InputStream stream = blob.getBlobStream();
            FileOutputStream outStream = new FileOutputStream(tempFile, true);
            BufferedInputStream bufInputStream = new BufferedInputStream(stream, 1000000);
            byte[] blobPiece = new byte[1000000];
            while ((readIn = bufInputStream.read(blobPiece)) != -1) {
                ((OutputStream)outStream).write(blobPiece, 0, readIn);
            }
            ((OutputStream)outStream).close();
            bufInputStream.close();
            this.m_sizeManager.makeRoom(tempFile.length());
            this.m_sizeManager.addFile(ConfigCache.getCanonicalPath(tempFile), tempFile.length());
            File file = tempFile;
            return file;
        }
        catch (Exception e) {
            throw new PersistentCacheException(e.toString(), e);
        }
        finally {
            this.m_cacheLock.writeLock().unlock();
            this.finishUpdateInternal(Thread.currentThread());
        }
    }

    private void setBlobByLogicalNameInternal(String path, IBlob blob, boolean isNativeFile, boolean replaceMap) throws CacheClosedException, PersistentCacheException, VersionOutofSyncException {
        IDirElement element = blob.getElement();
        IElementIdentity blobIdentity = element.getIdentity();
        String name = element.getIdentity().getName();
        EntityName nameE = this.validateName(name);
        if (this.isDoNotCache((IElement)element)) {
            return;
        }
        try {
            File cachedFile = new File(this.getArchiveFileName(blobIdentity));
            if (cachedFile.exists()) {
                Blob.markBlobState((Element)((Element)element), (Object)IBlob.COMPLETE, (String)"LARGE_FILE_STATE");
                this.setElementInternal(element, true);
                this.m_logicalMap.set(path, name);
                return;
            }
        }
        catch (Exception e) {
            throw new PersistentCacheException(e.toString(), e);
        }
        this.m_logicalMap.set(path, name, replaceMap);
        try {
            int read;
            int bufferSize = 1000000;
            Element cachedElement = (Element)this.m_elements.get(name);
            if (cachedElement != null) {
                Blob.markBlobState((Element)cachedElement, (Object)IBlob.INCOMPLETE, (String)"LARGE_FILE_STATE");
                this.setElementInternal((IDirElement)cachedElement, true);
            }
            InputStream stream = blob.getBlobStream();
            int offset = 0;
            byte[] bytes = new byte[bufferSize];
            while ((read = stream.read(bytes, 0, bufferSize)) != -1) {
                this.m_blobStorage.appendBlob(nameE, bytes, 0, read, offset);
                offset += read;
            }
            stream.close();
            if (this.isExpandable((Element)element) || this.isExpandable(this.m_blobStorage.blobToFile(nameE), (Element)element)) {
                this.expandInCache(path, blob);
            } else if (!this.archivedFileExists(blobIdentity)) {
                File tempFile = this.m_blobStorage.blobToFile(nameE);
                this.m_sizeManager.makeRoom(tempFile.length());
                FileInputStream inStream = new FileInputStream(tempFile);
                String archiveFileName = this.getArchiveFileName(blobIdentity);
                this.m_sizeManager.addFile(archiveFileName, tempFile.length());
                this.archiveFile(archiveFileName, inStream, isNativeFile ? path : null, true);
                inStream.close();
            }
            Blob.markBlobState((Element)((Element)element), (Object)IBlob.COMPLETE, (String)"LARGE_FILE_STATE");
            this.setElementInternal(element, true);
            this.m_blobStorage.deleteBlob(nameE);
        }
        catch (PersistentCacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistentCacheException(e.toString(), e);
        }
    }

    private boolean isExpandable(File file, Element el) {
        boolean expandable = false;
        try {
            expandable = Blob.isExpandableFile((File)file);
            Blob.markBlobState((Element)el, (Object)expandable, (String)"SONIC_EXPAND_IN_CACHE");
        }
        catch (Exception e) {
            // empty catch block
        }
        return expandable;
    }

    private boolean isExpandable(Element el) {
        Boolean expandableBoolean;
        IAttributeSet topSet = el.getAttributes();
        IAttributeSet systemAttrs = (IAttributeSet)topSet.getAttribute("_MF_SYSTEM_ATTRIBUTES");
        if (systemAttrs != null && (expandableBoolean = (Boolean)systemAttrs.getAttribute("SONIC_EXPAND_IN_CACHE")) != null) {
            return expandableBoolean;
        }
        return false;
    }

    private static String getExpandedArchiveName(IElement el) {
        IAttributeSet topSet = el.getAttributes();
        IAttributeSet systemAttrs = (IAttributeSet)topSet.getAttribute("_MF_SYSTEM_ATTRIBUTES");
        if (systemAttrs != null) {
            String expandedArchiveName = (String)systemAttrs.getAttribute("ARCHIVE_NAME");
            return expandedArchiveName;
        }
        return null;
    }

    private void expandInCache(String path, IBlob blob) throws Exception {
        IDirElement el = blob.getElement();
        File cachedFile = this.m_blobStorage.blobToFile(new EntityName(el.getIdentity().getName()));
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(cachedFile), 1000000));
        if (zipInputStream != null) {
            ZipEntry entry;
            this.m_sizeManager.makeRoom(cachedFile.length());
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String name = entry.getName();
                boolean needsUnpack200 = this.needsUnpack200(name);
                name = needsUnpack200 ? name.substring(0, name.length() - EXT_PACK.length()) : name;
                InputStream input = needsUnpack200 ? this.getUnpackedInputstream(zipInputStream, entry.getSize()) : zipInputStream;
                String expandedZipEntryFileName = this.getExpandedFileName(el.getIdentity(), name);
                if (entry.isDirectory()) {
                    File zipDir = new File(expandedZipEntryFileName);
                    if (zipDir.exists()) continue;
                    zipDir.mkdirs();
                    continue;
                }
                this.archiveFile(expandedZipEntryFileName, input, null, false);
            }
            zipInputStream.close();
            String archiveFileName = this.getArchiveFileName(el.getIdentity());
            this.m_sizeManager.addFile(archiveFileName, cachedFile.length() * 2L);
            this.m_sizeManager.markInUse(archiveFileName);
        }
    }

    private InputStream getUnpackedInputstream(ZipInputStream zipInputStream, long entrySize) throws IOException {
        int read;
        Pack200.Unpacker unpacker = Pack200.newUnpacker();
        long estimatedSize = entrySize;
        if (estimatedSize == -1L) {
            estimatedSize = 1000000L;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream((int)estimatedSize);
        byte[] buf = new byte[16384];
        while (-1 != (read = zipInputStream.read(buf))) {
            os.write(buf, 0, read);
        }
        buf = os.toByteArray();
        os = new ByteArrayOutputStream(buf.length * 2);
        ByteArrayInputStream input = new ByteArrayInputStream(buf);
        buf = null;
        JarOutputStream jout = new JarOutputStream(os);
        unpacker.unpack((InputStream)input, jout);
        jout.close();
        return new ByteArrayInputStream(os.toByteArray());
    }

    private boolean needsUnpack200(String name) {
        return name.endsWith(EXT_PACK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearNativeLibraryDirectory() throws CacheClosedException, PersistentCacheException {
        this.validateOpen();
        this.startUpdateInternal(Thread.currentThread());
        this.m_cacheLock.writeLock().lock();
        try {
            File tempDir;
            String dirName = this.m_cacheRootDir + NATIVE_LIBRARIES_DIR;
            File nativeLibDir = new File(dirName);
            if (nativeLibDir.exists()) {
                File[] files = nativeLibDir.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.m_sizeManager.addRoom(files[i]);
                    if (files[i].delete()) continue;
                    throw new PersistentCacheException("Unable to delete the native library file " + files[i]);
                }
            }
            if ((tempDir = new File(dirName = this.m_cacheRootDir + new String(new char[]{'/'}) + "_MFTemp")).exists()) {
                File[] files = tempDir.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.m_sizeManager.addRoom(files[i]);
                    if (files[i].delete()) continue;
                    throw new PersistentCacheException("Unable to delete the temporary cache file " + files[i]);
                }
            }
        }
        finally {
            this.m_cacheLock.writeLock().unlock();
            this.finishUpdateInternal(Thread.currentThread());
        }
    }

    private File archiveFile(String fileName, InputStream blobStream, String nativeLibLogicalName, boolean archiveOrLoose) throws PersistentCacheException {
        File archive = new File(fileName);
        File parentDir = archive.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new PersistentCacheException("Failed to create local archive directory for archive: " + archive);
        }
        if (!archive.exists()) {
            if (!parentDir.canWrite()) {
                throw new PersistentCacheException("Cannot write to local archive directory for archive: " + archive);
            }
            try {
                int readIn;
                OutputStream fos = new FileOutputStream(archive);
                FilterOutputStream nativeOutStream = null;
                File nativeLibFile = null;
                if (nativeLibLogicalName != null) {
                    String nativeLibFileName = this.m_cacheRootDir + NATIVE_LIBRARIES_DIR + nativeLibLogicalName.substring(nativeLibLogicalName.lastIndexOf("/"));
                    nativeLibFile = new File(nativeLibFileName);
                    File nativeLibDir = nativeLibFile.getParentFile();
                    if (!nativeLibDir.exists() && !nativeLibDir.mkdirs()) {
                        throw new PersistentCacheException("Failed to create local directory for native libraries: " + nativeLibDir);
                    }
                    if (!nativeLibDir.canWrite()) {
                        throw new PersistentCacheException("Cannot write to local native Library directory for library: " + nativeLibFile);
                    }
                    if (!nativeLibFile.exists()) {
                        nativeOutStream = new BufferedOutputStream(new FileOutputStream(nativeLibFile), 1000000);
                    }
                }
                fos = new BufferedOutputStream(fos, 1000000);
                byte[] buf = new byte[1000000];
                while ((readIn = blobStream.read(buf)) != -1) {
                    fos.write(buf, 0, readIn);
                    if (nativeOutStream == null) continue;
                    ((BufferedOutputStream)nativeOutStream).write(buf, 0, readIn);
                }
                fos.close();
                if (nativeOutStream != null) {
                    nativeOutStream.close();
                    this.m_sizeManager.addFile(ConfigCache.getCanonicalPath(nativeLibFile), nativeLibFile.length());
                }
            }
            catch (IOException e) {
                throw new PersistentCacheException("Failed to cache archive: " + archive, e);
            }
        }
        if (archiveOrLoose) {
            this.m_sizeManager.markInUse(ConfigCache.getCanonicalPath(archive));
        }
        return archive;
    }

    private String getArchiveFileName(IElementIdentity blobIdentity, String cacheArea) throws PersistentCacheException {
        String blobName = blobIdentity.getName();
        long version = blobIdentity.getVersion();
        long timestamp = blobIdentity.getCreationTimestamp();
        StringBuilder sb = null;
        try {
            sb = new StringBuilder(ConfigCache.getCanonicalPath(this.m_cacheRootDir));
        }
        catch (Exception ex) {
            throw new PersistentCacheException(ex.toString(), ex);
        }
        sb.append(File.separatorChar);
        sb.append(cacheArea);
        StringTokenizer urlTokens = new StringTokenizer(blobName, "/");
        while (urlTokens.hasMoreTokens()) {
            sb.append(File.separatorChar);
            if (urlTokens.countTokens() == 1) {
                sb.append(timestamp);
                sb.append('.');
                sb.append(version);
                sb.append('.');
            }
            sb.append(urlTokens.nextToken());
        }
        return sb.toString();
    }

    private String getArchiveFileName(IElementIdentity blobIdentity) throws PersistentCacheException {
        return this.getArchiveFileName(blobIdentity, "_MFArchive");
    }

    private String getTempFileName(IElementIdentity blobIdentity) throws PersistentCacheException {
        String blobName = blobIdentity.getName().substring(blobIdentity.getName().lastIndexOf(47) + 1);
        long version = blobIdentity.getVersion();
        long timestamp = blobIdentity.getCreationTimestamp();
        StringBuffer sb = null;
        try {
            sb = new StringBuffer(ConfigCache.getCanonicalPath(this.m_cacheRootDir));
        }
        catch (Exception ex) {
            throw new PersistentCacheException(ex.toString(), ex);
        }
        sb.append(File.separatorChar);
        sb.append("_MFTemp");
        StringTokenizer urlTokens = new StringTokenizer(blobName, "/");
        while (urlTokens.hasMoreTokens()) {
            sb.append(File.separatorChar);
            if (urlTokens.countTokens() == 1) {
                sb.append(timestamp);
                sb.append('.');
                sb.append(version);
                sb.append('.');
            }
            sb.append(urlTokens.nextToken());
        }
        return sb.toString() + "_" + this.m_tempSuffix++;
    }

    private String getExpandedFileName(IElementIdentity archiveID, String fileInExpandedJar) throws PersistentCacheException {
        String archiveFileName = this.getArchiveFileName(archiveID);
        return archiveFileName + File.separator + fileInExpandedJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getAvailableFileByLogicalName(String logicalName) throws CacheException {
        this.validateOpen();
        this.m_cacheLock.readLock().lock();
        try {
            IElement envelopeElement = this.getElementByLogicalName(logicalName);
            if (envelopeElement == null) {
                File file = null;
                return file;
            }
            IElementIdentity blobIdentity = envelopeElement.getIdentity();
            String expandedArchiveName = ConfigCache.getExpandedArchiveName(envelopeElement);
            File intendedArchiveVersion = new File(this.getArchiveFileName(blobIdentity));
            String intendedName = intendedArchiveVersion.getName();
            int firstDotPos = intendedName.indexOf(46);
            int secondDotPos = intendedName.indexOf(46, firstDotPos + 1);
            final String archiveName = intendedName.substring(secondDotPos + 1);
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(archiveName);
                }
            };
            File[] alternativeVersions = intendedArchiveVersion.getParentFile().listFiles(filter);
            if (alternativeVersions == null || alternativeVersions.length == 0) {
                File file = null;
                return file;
            }
            File alternateVersion = null;
            for (int i = 0; i < alternativeVersions.length; ++i) {
                if (alternateVersion != null) {
                    String winnerName = alternateVersion.getName();
                    int winnerFirstDot = winnerName.indexOf(46);
                    int winnerSecondDot = winnerName.indexOf(46, winnerFirstDot + 1);
                    long winnerTimestamp = Long.parseLong(winnerName.substring(0, winnerFirstDot));
                    int winnerVersion = Integer.parseInt(winnerName.substring(winnerFirstDot + 1, winnerSecondDot));
                    String testName = alternativeVersions[i].getName();
                    int testFirstDot = testName.indexOf(46);
                    int testSecondDot = testName.indexOf(46, testFirstDot + 1);
                    long testTimestamp = Long.parseLong(testName.substring(0, testFirstDot));
                    int testVersion = Integer.parseInt(testName.substring(testFirstDot + 1, testSecondDot));
                    if (testTimestamp > winnerTimestamp) {
                        alternateVersion = alternativeVersions[i];
                        continue;
                    }
                    if (testTimestamp != winnerTimestamp || testVersion <= winnerVersion) continue;
                    alternateVersion = alternativeVersions[i];
                    continue;
                }
                alternateVersion = alternativeVersions[i];
            }
            if (alternateVersion != null) {
                this.m_sizeManager.markInUse(ConfigCache.getCanonicalPath(alternateVersion));
            }
            if (alternateVersion != null && expandedArchiveName != null && !expandedArchiveName.equals(logicalName)) {
                String archiveMemberName = logicalName.substring(expandedArchiveName.length());
                alternateVersion = new File(alternateVersion, archiveMemberName);
            }
            File file = alternateVersion;
            return file;
        }
        finally {
            this.m_cacheLock.readLock().unlock();
        }
    }

    @Override
    public HashMap getStorageToLogicalMap() {
        return this.m_logicalMap.getStorageToLogicalMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyCorrections(HashMap corrections) throws CacheClosedException, PersistentCacheException {
        this.validateOpen();
        if (corrections != null && !corrections.isEmpty()) {
            this.startUpdateInternal(Thread.currentThread());
            this.m_cacheLock.writeLock().lock();
            try {
                this.m_logicalMap.applyCorrections(corrections);
                this.m_cacheContentIsDirty = true;
            }
            finally {
                this.m_cacheLock.writeLock().unlock();
                this.finishUpdateInternal(Thread.currentThread());
            }
        }
    }

    @Override
    public String storageToLogical(String storageName) {
        return this.m_logicalMap.storageToLogical(storageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBasicElement setElement(IBasicElement element) throws CacheClosedException, PersistentCacheException, VersionOutofSyncException {
        this.validateOpen();
        this.startUpdateInternal(Thread.currentThread());
        this.m_cacheLock.writeLock().lock();
        try {
            element = element instanceof IDeltaDirElement ? this.setElementInternal((IDeltaDirElement)element) : this.setElementInternal((IDirElement)element);
        }
        finally {
            this.m_cacheLock.writeLock().unlock();
            this.finishUpdateInternal(Thread.currentThread());
        }
        return element;
    }

    private IBasicElement setElementInternal(IDirElement element) throws CacheClosedException, PersistentCacheException {
        return this.setElementInternal(element, false);
    }

    private IBasicElement setElementInternal(IDirElement element, boolean overwrite) throws CacheClosedException, PersistentCacheException {
        if (this.isDoNotCache((IElement)element)) {
            return element;
        }
        IElementIdentity elementID = element.getIdentity();
        String elementName = elementID.getName();
        long elementVersion = elementID.getVersion();
        IElement oldElement = (IElement)this.m_elements.get(elementName);
        IElementIdentity oldID = null;
        long oldVersion = -1L;
        if (oldElement != null) {
            oldID = oldElement.getIdentity();
            oldVersion = oldID.getVersion();
        }
        DeltaElement calculatedDelta = null;
        if (element.isDeleted()) {
            if (oldElement == null) {
                return null;
            }
            if (!oldID.equalEntity(elementID)) {
                return null;
            }
            this.deleteElementInternal(elementName);
        } else {
            if (!overwrite && oldElement != null && elementVersion <= oldVersion) {
                return null;
            }
            if (oldElement != null && this.m_elementCache != null) {
                calculatedDelta = ((Element)oldElement).createDelta((Element)element);
            }
            ((Element)element).setReadOnly(true);
            this.m_elements.put(elementName, element);
            if (this.m_elementCache != null) {
                ((Element)element).cacheMe((IElementCache)this.m_elementCache);
                this.m_cacheContentIsDirty = true;
            }
        }
        if (calculatedDelta != null) {
            return calculatedDelta;
        }
        return element;
    }

    private IDeltaDirElement setElementInternal(IDeltaDirElement delta) throws VersionOutofSyncException, CacheClosedException, PersistentCacheException {
        IElementIdentity deltaID = delta.getIdentity();
        String elementName = deltaID.getName();
        IDirElement element = this.m_elements.get(elementName);
        if (element == null) {
            throw new VersionOutofSyncException("Element '" + elementName + "' is not in the cache.");
        }
        if (!element.getIdentity().equalEntity(deltaID)) {
            throw new VersionOutofSyncException("Element " + deltaID + " is not in the cache.");
        }
        try {
            Element newElement = (Element)((Element)element).createWritableClone();
            newElement.doApplyDelta((IDeltaElement)delta);
            newElement.setReadOnly(true);
            this.m_elements.put(elementName, (IDirElement)newElement);
            if (this.m_elementCache != null) {
                newElement.cacheMe((IElementCache)this.m_elementCache);
                this.m_cacheContentIsDirty = true;
            }
            return delta;
        }
        catch (VersionMisMatchException e) {
            if (e.isOldDelta()) {
                return null;
            }
            throw new VersionOutofSyncException("Element " + element.getIdentity() + " is obsolete." + " The current version of the element is " + deltaID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInterestInDir(String dirName) throws CacheClosedException, PersistentCacheException {
        this.validateOpen();
        this.startUpdateInternal(Thread.currentThread());
        this.m_cacheLock.writeLock().lock();
        try {
            this.m_directories.put(dirName, dirName);
            this.m_cacheContentIsDirty = true;
        }
        finally {
            this.m_cacheLock.writeLock().unlock();
            this.finishUpdateInternal(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.m_cacheLock.readLock().lock();
        try {
            boolean bl = this.m_elements.size() == 0 && this.m_directories.size() == 0;
            return bl;
        }
        finally {
            this.m_cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteElement(String elementName) throws CacheClosedException, PersistentCacheException {
        this.validateOpen();
        this.startUpdateInternal(Thread.currentThread());
        this.m_cacheLock.writeLock().lock();
        try {
            this.deleteElementInternal(elementName);
        }
        finally {
            this.m_cacheLock.writeLock().unlock();
            this.finishUpdateInternal(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteElements(String[] elementNames) throws CacheClosedException, PersistentCacheException {
        this.validateOpen();
        this.startUpdateInternal(Thread.currentThread());
        this.m_cacheLock.writeLock().lock();
        try {
            for (int i = 0; i < elementNames.length; ++i) {
                this.deleteElementInternal(elementNames[i]);
            }
        }
        finally {
            this.m_cacheLock.writeLock().unlock();
            this.finishUpdateInternal(Thread.currentThread());
        }
    }

    private void deleteElementInternal(String elementName) throws CacheClosedException, PersistentCacheException {
        this.m_elements.remove(elementName);
        this.m_logicalMap.deleteByStorageName(elementName);
        if (this.m_elementCache != null) {
            this.m_elementCache.removeAttributes(elementName);
            this.m_cacheContentIsDirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws PersistentCacheException {
        if (this.m_isPersistentCache) {
            this.m_updaterLock.waitUntilUnlocked();
            this.m_archiveCleanerLock.waitUntilUnlocked();
        }
        this.m_cacheLock.writeLock().lock();
        try {
            if (!this.m_open) {
                return;
            }
            this.m_open = false;
            this.m_elementCache = null;
            if (this.m_isPersistentCache) {
                this.m_cacheLockFile.unlock();
            }
        }
        finally {
            this.m_cacheLock.writeLock().unlock();
        }
    }

    private void persistCacheContentFile(Object[] contents) throws PersistentCacheException {
        long start = System.currentTimeMillis();
        try {
            FileOutputStream fos = new FileOutputStream(this.m_cacheContentFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(contents);
            oos.flush();
            fos.getFD().sync();
            fos.close();
        }
        catch (IOException e) {
            throw new PersistentCacheException(e.toString(), e);
        }
    }

    private void persistCacheInfoFile() throws PersistentCacheException {
        try {
            FileOutputStream fos = new FileOutputStream(this.m_cacheInfoFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(this.m_info);
            oos.flush();
            fos.getFD().sync();
            fos.close();
        }
        catch (IOException e) {
            throw new PersistentCacheException(e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IElement getElementByLogicalName(String path) throws CacheClosedException {
        this.m_cacheLock.readLock().lock();
        try {
            String storageName = null;
            String logicalName = null;
            try {
                storageName = this.m_logicalMap.logicalToStorage(path);
            }
            catch (NameMapperPathException elEx) {
                if (elEx.getMapperPathObject() instanceof String) {
                    storageName = (String)elEx.getMapperPathObject();
                }
                logicalName = elEx.getLogicalPath();
            }
            if (storageName == null) {
                IElement elEx = null;
                return elEx;
            }
            IElement el = this.getElement(storageName);
            if (el != null && logicalName != null) {
                if (this.isExpandable((Element)el)) {
                    try {
                        Blob.markBlobState((Element)((Element)el), (Object)logicalName, (String)"ARCHIVE_NAME");
                    }
                    catch (Exception e) {
                        el = null;
                    }
                } else {
                    el = null;
                }
            }
            IElement iElement = el;
            return iElement;
        }
        finally {
            this.m_cacheLock.readLock().unlock();
        }
    }

    public IBlob getFSBlob(String elementName, boolean forUpdate, int offset) throws PersistentCacheException {
        throw new PersistentCacheException("ConfigCache blobs do not contain logical names");
    }

    @Override
    public File getFileByLogicalName(String path, boolean isNativeFile) throws CacheException, LatestVersionMissingException {
        File targetArchiveFile = null;
        String archiveFileName = null;
        this.validateOpen();
        if (isNativeFile) {
            this.startUpdateInternal(Thread.currentThread());
            this.m_cacheLock.writeLock().lock();
        } else {
            this.m_cacheLock.readLock().lock();
        }
        try {
            String archiveMemberName;
            IElement element = this.getElementByLogicalName(path);
            if (element == null) {
                throw new LatestVersionMissingException("File is missing: " + path);
            }
            if (Blob.isIncompleteBlob((IDirElement)((IDirElement)element))) {
                throw new LatestVersionMissingException("File is incomplete: " + path);
            }
            String expandedArchiveName = ConfigCache.getExpandedArchiveName(element);
            boolean tryExpandedArchive = expandedArchiveName != null && !expandedArchiveName.equals(path);
            File cachedFile = new File(this.getArchiveFileName(element.getIdentity()));
            if (!cachedFile.exists()) {
                throw new LatestVersionMissingException("Latest file version not found: " + path);
            }
            String targetArchiveFileName = null;
            archiveFileName = this.getArchiveFileName(element.getIdentity());
            if (!tryExpandedArchive) {
                targetArchiveFileName = archiveFileName;
            } else {
                archiveMemberName = path.substring(expandedArchiveName.length());
                targetArchiveFileName = this.getExpandedFileName(element.getIdentity(), archiveMemberName);
            }
            targetArchiveFile = new File(targetArchiveFileName);
            if (!targetArchiveFile.exists()) {
                archiveMemberName = null;
                return archiveMemberName;
            }
            File nativeTarget = null;
            if (!isNativeFile) {
                this.m_sizeManager.markInUse(ConfigCache.getCanonicalPath(new File(archiveFileName)));
            } else {
                nativeTarget = new File(this.m_cacheRootDir + NATIVE_LIBRARIES_DIR + path.substring(path.lastIndexOf("/")));
            }
            if (isNativeFile && !nativeTarget.exists()) {
                File nativeLibDir = nativeTarget.getParentFile();
                if (!nativeLibDir.exists() && !nativeLibDir.mkdirs()) {
                    throw new PersistentCacheException("Failed to create local directory for native libraries: " + nativeTarget);
                }
                if (!nativeLibDir.canWrite()) {
                    throw new PersistentCacheException("Cannot write to local native Library directory for library: " + nativeTarget);
                }
                this.copyFile(targetArchiveFile, nativeTarget);
                if (nativeTarget.exists()) {
                    this.m_sizeManager.addFile(ConfigCache.getCanonicalPath(nativeTarget), nativeTarget.length());
                }
            }
        }
        catch (LatestVersionMissingException missing) {
            throw missing;
        }
        catch (Exception e) {
            throw new LatestVersionMissingException(e.toString(), e);
        }
        finally {
            if (isNativeFile) {
                this.m_cacheLock.writeLock().unlock();
                this.finishUpdateInternal(Thread.currentThread());
            } else {
                this.m_cacheLock.readLock().unlock();
            }
        }
        return targetArchiveFile;
    }

    private void copyFile(File fromFile, File toFile) throws Exception {
        if (fromFile.exists()) {
            BufferedInputStream fromBufStream = new BufferedInputStream(new FileInputStream(fromFile), 500000);
            BufferedOutputStream toBufStream = new BufferedOutputStream(new FileOutputStream(toFile), 500000);
            int readIn = fromBufStream.read();
            while (readIn != -1) {
                toBufStream.write(readIn);
                readIn = fromBufStream.read();
            }
            fromBufStream.close();
            toBufStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IElement getElement(String elementName) throws CacheClosedException {
        this.m_cacheLock.readLock().lock();
        try {
            this.validateOpen();
            IElement iElement = (IElement)this.m_elements.get(elementName);
            return iElement;
        }
        finally {
            this.m_cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getInterestInDir(String dirName) throws CacheClosedException {
        this.m_cacheLock.readLock().lock();
        try {
            this.validateOpen();
            boolean bl = this.m_directories.get(dirName) != null;
            return bl;
        }
        finally {
            this.m_cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IElementIdentity getElementIdentity(String elementName) throws CacheClosedException {
        this.m_cacheLock.readLock().lock();
        try {
            this.validateOpen();
            IElementIdentity iElementIdentity = this.m_elements.get(elementName).getIdentity();
            return iElementIdentity;
        }
        finally {
            this.m_cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IElement[] getAllElements() throws CacheClosedException {
        this.m_cacheLock.readLock().lock();
        try {
            this.validateOpen();
            Iterator<IDirElement> iterator = this.m_elements.values().iterator();
            IElement[] elements = new IElement[this.m_elements.size()];
            int i = 0;
            while (iterator.hasNext()) {
                elements[i++] = (IElement)iterator.next();
            }
            IElement[] iElementArray = elements;
            return iElementArray;
        }
        finally {
            this.m_cacheLock.readLock().unlock();
        }
    }

    private EntityName validateName(String name) {
        try {
            return new EntityName(name);
        }
        catch (ConfigException e) {
            e.printStackTrace();
            throw new Error(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IElement[] getAllElements(String dirName) throws CacheClosedException {
        this.m_cacheLock.readLock().lock();
        try {
            this.validateOpen();
            EntityName directory = this.validateName(dirName);
            Iterator<IDirElement> iterator = this.m_elements.values().iterator();
            ArrayList<IElement> result = new ArrayList<IElement>();
            while (iterator.hasNext()) {
                IElement element = (IElement)iterator.next();
                EntityName name = this.validateName(element.getIdentity().getName());
                if (!directory.isParent(name)) continue;
                result.add(element);
            }
            IElement[] elements = new IElement[result.size()];
            for (int i = 0; i < result.size(); ++i) {
                elements[i] = (IElement)result.get(i);
            }
            IElement[] iElementArray = elements;
            return iElementArray;
        }
        finally {
            this.m_cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IElementIdentity[] getAllIdentities(ArrayList<String> excludeList) throws CacheClosedException {
        this.m_cacheLock.readLock().lock();
        try {
            this.validateOpen();
            ArrayList<IElementIdentity> elementsIdsList = new ArrayList<IElementIdentity>();
            IElement[] elements = this.getAllElements();
            IElementIdentity[] ids = new IElementIdentity[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                if (excludeList != null && excludeList.contains(elements[i].getIdentity().getName())) continue;
                elementsIdsList.add(elements[i].getIdentity());
            }
            IElementIdentity[] iElementIdentityArray = elementsIdsList.toArray(new IElementIdentity[elementsIdsList.size()]);
            return iElementIdentityArray;
        }
        finally {
            this.m_cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAllInterestDirs() throws CacheClosedException {
        this.m_cacheLock.readLock().lock();
        try {
            this.validateOpen();
            Object[] dirs = this.m_directories.keySet().toArray();
            String[] result = new String[dirs.length];
            for (int i = 0; i < dirs.length; ++i) {
                result[i] = (String)dirs[i];
            }
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            this.m_cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDSBackupVersion(Long backupVersion) throws PersistentCacheException {
        block6: {
            this.m_cacheLock.writeLock().lock();
            try {
                Long currentVersion = this.m_info.get(DS_BACKUP_VERSION_ATT);
                if (currentVersion != null && currentVersion.equals(backupVersion)) break block6;
                this.m_info.put(DS_BACKUP_VERSION_ATT, backupVersion);
                if (!this.m_isPersistentCache) break block6;
                this.startUpdateInternal(Thread.currentThread());
                try {
                    this.persistCacheInfoFile();
                }
                finally {
                    this.finishUpdateInternal(Thread.currentThread());
                }
            }
            finally {
                this.m_cacheLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getDSBackupVersion() {
        this.m_cacheLock.readLock().lock();
        try {
            Long l = this.m_info.get(DS_BACKUP_VERSION_ATT);
            return l;
        }
        finally {
            this.m_cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] rename(String oldPath, String newPath) throws CacheClosedException, PersistentCacheException {
        this.startUpdateInternal(Thread.currentThread());
        this.m_cacheLock.writeLock().lock();
        try {
            String[] paths = null;
            paths = this.m_logicalMap.rename(oldPath, newPath);
            this.m_cacheContentIsDirty = true;
            String[] stringArray = paths;
            return stringArray;
        }
        finally {
            this.m_cacheLock.writeLock().unlock();
            this.finishUpdateInternal(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startUpdateInternal(Thread updater) throws PersistentCacheException {
        if (!this.m_isPersistentCache) {
            return;
        }
        File file = this.m_cacheUpdateLockFile;
        synchronized (file) {
            this.m_updaters.add(updater);
            this.m_cacheUpdateLockFile.notifyAll();
            try {
                if (this.m_updaters.size() == 1 && this.m_asyncContentUpdater == null) {
                    this.m_cacheUpdateLockFile.createNewFile();
                }
            }
            catch (IOException e) {
                throw new PersistentCacheException("Failed to create update lock: " + e.getMessage(), e);
            }
            this.m_updaterLock.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishUpdateInternal(Thread updater) throws PersistentCacheException {
        if (!this.m_isPersistentCache) {
            return;
        }
        File file = this.m_cacheUpdateLockFile;
        synchronized (file) {
            if (this.m_storageError != null) {
                PersistentCacheException persistentCacheException = new PersistentCacheException(this.m_storageError);
                this.m_storageError = null;
                throw persistentCacheException;
            }
            this.m_updaters.remove(updater);
            if (this.m_updaters.isEmpty()) {
                if (this.m_cacheContentIsDirty && this.m_asyncContentUpdater == null) {
                    this.m_asyncContentUpdater = new AsyncContentUpdater();
                    this.m_asyncContentUpdater.start();
                }
                if (this.m_asyncContentUpdater == null) {
                    this.m_cacheUpdateLockFile.delete();
                    this.m_updaterLock.unlock();
                }
            }
        }
    }

    public static void cleanupCorruptCache(String cacheDirPath, ILogger logger) {
        ConfigCache.cleanupCorruptCache(new File(cacheDirPath), logger);
    }

    public static void cleanupCorruptCache(File cacheDir, ILogger logger) {
        if (!cacheDir.exists() || !cacheDir.isDirectory()) {
            return;
        }
        LockFile cacheLockFile = new LockFile(cacheDir.getAbsolutePath() + File.separatorChar + CACHE_LOCK_FILE);
        if (!cacheLockFile.lock()) {
            return;
        }
        cacheLockFile.unlock();
        File cacheUpdateLockFile = new File(cacheDir, UPDATE_LOCK_FILE);
        if (cacheUpdateLockFile.exists()) {
            logger.logMessage("Corrupt cache found, cleanup initiated...", 2);
            ConfigCache.deleteCacheDir(cacheDir);
            logger.logMessage("...cache cleanup complete", 2);
        }
    }

    private static void deleteCacheDir(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                ConfigCache.deleteCacheDir(files[i]);
                continue;
            }
            files[i].delete();
        }
        dir.delete();
    }

    private void createBatch() {
        if (this.m_elementCache == null) {
            return;
        }
        this.m_elementCache.createBatch();
    }

    private void saveBatch(boolean ok) {
        if (this.m_elementCache == null) {
            return;
        }
        this.m_elementCache.saveBatch(ok);
    }

    private void storageError(String msg) {
        this.m_storageError = msg;
        throw new Error(msg);
    }

    static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            return file.getAbsolutePath();
        }
    }

    private static final class ArchiveFile
    extends File {
        private ArchiveFile(File file) {
            super(file.getAbsolutePath());
        }

        @Override
        public int compareTo(File file) {
            int compare = super.getParentFile().compareTo(file.getParentFile());
            if (compare != 0) {
                return compare;
            }
            int posntimestamp = 0;
            int posnversion = 0;
            String thisArchive = super.getName();
            posntimestamp = thisArchive.indexOf(46);
            posnversion = thisArchive.indexOf(46, posntimestamp + 1);
            long thisTimestamp = Long.parseLong(thisArchive.substring(0, posntimestamp));
            int thisVersion = Integer.parseInt(thisArchive.substring(posntimestamp + 1, posnversion));
            thisArchive = thisArchive.substring(posnversion + 1);
            String otherArchive = file.getName();
            posntimestamp = otherArchive.indexOf(46);
            posnversion = otherArchive.indexOf(46, posntimestamp + 1);
            long otherTimestamp = Long.parseLong(otherArchive.substring(0, posntimestamp));
            int otherVersion = Integer.parseInt(otherArchive.substring(posntimestamp + 1, posnversion));
            compare = thisArchive.compareToIgnoreCase(otherArchive = otherArchive.substring(posnversion + 1));
            if (compare != 0) {
                return compare;
            }
            if (thisTimestamp > otherTimestamp) {
                return 1;
            }
            if (thisTimestamp < otherTimestamp) {
                return -1;
            }
            if (thisVersion > otherVersion) {
                return 1;
            }
            return -1;
        }
    }

    class ObsoleteArchiveRemover {
        private File m_archiveDir;
        private TreeSet<ArchiveFile> m_set = new TreeSet();

        ObsoleteArchiveRemover(File cacheRoot) {
            this.m_archiveDir = new File(cacheRoot, "_MFArchive");
            if (this.m_archiveDir.exists()) {
                this.findArchives(this.m_set, this.m_archiveDir);
            }
        }

        void doCleanup() throws PersistentCacheException {
            if (!this.m_archiveDir.exists()) {
                return;
            }
            ConfigCache.this.m_archiveCleanerLock.lock();
            if (this.m_set.size() < 2) {
                ConfigCache.this.m_archiveCleanerLock.unlock();
                return;
            }
            Iterator<ArchiveFile> iterator = this.m_set.iterator();
            File previousFile = null;
            File previousDir = null;
            File currentFile = iterator.next();
            File currentDir = currentFile.getParentFile();
            while (iterator.hasNext()) {
                try {
                    long prevTimestamp;
                    int curFirstDotPos;
                    int curSecondDotPos;
                    previousFile = currentFile;
                    currentFile = iterator.next();
                    if (currentFile.equals(previousFile)) continue;
                    previousDir = currentDir;
                    currentDir = currentFile.getParentFile();
                    if (!currentDir.equals(previousDir)) continue;
                    String prevFullFileName = previousFile.getName();
                    int prevFirstDotPos = prevFullFileName.indexOf(46);
                    int prevSecondDotPos = prevFullFileName.indexOf(46, prevFirstDotPos + 1);
                    String previousFileName = prevFullFileName.substring(prevSecondDotPos + 1);
                    String curFullFileName = currentFile.getName();
                    String currentFileName = curFullFileName.substring((curSecondDotPos = curFullFileName.indexOf(46, (curFirstDotPos = curFullFileName.indexOf(46)) + 1)) + 1);
                    if (!currentFileName.equals(previousFileName)) continue;
                    File obsoleteFile = null;
                    long curTimestamp = Long.parseLong(curFullFileName.substring(0, curFirstDotPos));
                    if (curTimestamp > (prevTimestamp = Long.parseLong(prevFullFileName.substring(0, prevFirstDotPos)))) {
                        obsoleteFile = previousFile;
                    } else if (prevTimestamp > curTimestamp) {
                        obsoleteFile = currentFile;
                        currentFile = previousFile;
                        currentDir = previousDir;
                    } else {
                        int prevVersion;
                        int curVersion = Integer.parseInt(curFullFileName.substring(curFirstDotPos + 1, curSecondDotPos));
                        if (curVersion > (prevVersion = Integer.parseInt(prevFullFileName.substring(prevFirstDotPos + 1, prevSecondDotPos)))) {
                            obsoleteFile = previousFile;
                        } else if (prevVersion > curVersion) {
                            obsoleteFile = currentFile;
                            currentFile = previousFile;
                            currentDir = previousDir;
                        }
                    }
                    if (obsoleteFile == null || !obsoleteFile.exists()) continue;
                    this.deleteArchivedFile(obsoleteFile);
                    this.m_set.remove(obsoleteFile);
                    iterator = this.m_set.iterator();
                }
                catch (PersistentCacheException cacheE) {
                    throw cacheE;
                }
                catch (Exception e) {
                    throw new PersistentCacheException("Exception thrown while cleaning obsolete cache files: " + e.toString(), e);
                }
            }
            ConfigCache.this.m_archiveCleanerLock.unlock();
        }

        private void deleteArchivedFile(File deleteThis) throws PersistentCacheException {
            ConfigCache.this.m_sizeManager.addRoom(deleteThis);
            if (deleteThis.isDirectory()) {
                File[] files = deleteThis.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.deleteArchivedFile(files[i]);
                }
                deleteThis.delete();
            } else {
                deleteThis.delete();
            }
        }

        private void findArchives(Set<ArchiveFile> set, File dir) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory() && !this.hasTimestampVersion(files[i])) {
                    this.findArchives(set, files[i]);
                    continue;
                }
                set.add(new ArchiveFile(files[i]));
            }
        }

        private boolean hasTimestampVersion(File checkFile) {
            String fileName = checkFile.getName();
            int firstDot = fileName.indexOf(".");
            if (firstDot == -1) {
                return false;
            }
            int secondDot = fileName.indexOf(".", firstDot + 1);
            return secondDot != -1;
        }
    }

    private final class AsyncContentUpdater
    extends Thread {
        private AsyncContentUpdater() {
            super("Cache Content Updater");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File file = ConfigCache.this.m_cacheUpdateLockFile;
            synchronized (file) {
                int i = 10;
                while (i > 0) {
                    try {
                        ConfigCache.this.m_cacheUpdateLockFile.wait(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (ConfigCache.this.m_updaters.size() == 0) {
                        --i;
                        continue;
                    }
                    i = 10;
                }
                Iterator iterator = null;
                HashMap directories = null;
                LogicalStorageNameMapper logicalMap = null;
                ConfigCache.this.m_cacheLock.readLock().lock();
                try {
                    iterator = ((HashMap)ConfigCache.this.m_elements.clone()).entrySet().iterator();
                    directories = (HashMap)ConfigCache.this.m_directories.clone();
                    logicalMap = (LogicalStorageNameMapper)ConfigCache.this.m_logicalMap.clone();
                }
                finally {
                    ConfigCache.this.m_cacheLock.readLock().unlock();
                }
                HashMap elements = new HashMap();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Element element = ((Element)entry.getValue()).createHeaderClone();
                    element.dontWriteAttributes(true);
                    elements.put(entry.getKey(), element);
                }
                Object[] cacheContent = new Object[]{elements, directories, logicalMap};
                ConfigCache.this.m_cacheContentIsDirty = false;
                try {
                    ConfigCache.this.persistCacheContentFile(cacheContent);
                }
                catch (PersistentCacheException e) {
                    ConfigCache.this.storageError(e.toString());
                }
                ConfigCache.this.m_asyncContentUpdater = null;
                ConfigCache.this.m_cacheUpdateLockFile.delete();
                ConfigCache.this.m_updaterLock.unlock();
            }
        }
    }
}

