/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.cache.impl;

import java.util.HashMap;

final class ContentCache
extends HashMap {
    private Item m_leastUsed = null;
    private Item m_mostUsed = null;
    private int m_maxSize;
    private int m_usedSize;
    private boolean m_maxSuspended;

    ContentCache(int maxSize) {
        this.m_maxSize = maxSize;
        this.m_usedSize = 0;
        this.m_maxSuspended = false;
    }

    @Override
    public void clear() {
        super.clear();
        this.m_leastUsed = null;
        this.m_mostUsed = null;
        this.m_usedSize = 0;
        this.m_maxSuspended = false;
    }

    void put(String key, Object data, int size) {
        this.remove(key);
        int availableRoom = this.m_maxSize - this.m_usedSize;
        if (!this.m_maxSuspended && size > availableRoom && !this.makeRoom(size - availableRoom)) {
            throw new RuntimeException(key + " is too large - " + size + " bytes." + " Increase the MF container cache size from " + this.m_maxSize + ".");
        }
        Item newItem = new Item(key, data, size);
        super.put(key, newItem);
        this.m_usedSize += size;
        this.putAtEnd(newItem);
    }

    Object get(String key) {
        Item item = (Item)super.get(key);
        if (item == null) {
            return null;
        }
        if (item != this.m_mostUsed) {
            this.removeFromChain(item);
            this.putAtEnd(item);
        }
        return item.data;
    }

    void remove(String key) {
        Item item = (Item)super.remove(key);
        if (item == null) {
            return;
        }
        this.removeFromChain(item);
        this.m_usedSize -= item.size;
    }

    private void removeFromChain(Item item) {
        Item prev = item.prevItem;
        Item next = item.nextItem;
        if (prev != null) {
            prev.nextItem = next;
        }
        if (next != null) {
            next.prevItem = prev;
        }
        if (this.m_leastUsed == item) {
            this.m_leastUsed = next;
        }
        if (this.m_mostUsed == item) {
            this.m_mostUsed = prev;
        }
        item.prevItem = null;
        item.nextItem = null;
    }

    void adjustSize(int newSize) {
        this.m_maxSize = newSize < this.m_usedSize ? this.m_usedSize : newSize;
    }

    void adjustSize() {
        this.m_maxSize = this.m_maxSize >= this.m_usedSize ? this.m_maxSize : this.m_usedSize;
    }

    void suspendSizeLimit() {
        this.m_maxSuspended = true;
    }

    void restoreSizeLimit() {
        this.m_maxSuspended = false;
    }

    private void putAtEnd(Item item) {
        if (this.m_leastUsed == null) {
            this.m_leastUsed = this.m_mostUsed = item;
            return;
        }
        this.m_mostUsed.nextItem = item;
        item.prevItem = this.m_mostUsed;
        this.m_mostUsed = item;
    }

    private boolean makeRoom(int size) {
        for (int gain = 0; gain < size; gain += this.m_leastUsed.size) {
            if (this.m_leastUsed == null) {
                return false;
            }
            this.remove(this.m_leastUsed.key);
        }
        return true;
    }

    private class Item {
        private String key;
        private Object data;
        private int size;
        private Item nextItem;
        private Item prevItem;

        Item(String key, Object data, int size) {
            this.key = key;
            this.data = data;
            this.size = size;
            this.prevItem = null;
            this.nextItem = null;
        }
    }
}

