/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.daemon;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.runtime.IChildContainerState;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.framework.AbstractFrameworkComponent;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.daemon.ChildContainer;
import com.sonicsw.mf.framework.daemon.Scheduler;
import com.sonicsw.mx.util.IEmptyArray;
import com.sonicsw.sdf.AbstractMFComponentTracing;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public final class ActivationDaemon
extends AbstractFrameworkComponent {
    private SdfMFTracingIntegration m_SdfMFTracingIntegration;
    static volatile String m_mfXSD;
    private static final String DAEMON_TRACE_MASK_VALUES = "16=child container exec,32=child container stdout,64=child container stderr";
    public static final int TRACE_CHILDPROCESS_EXEC = 16;
    public static final int TRACE_CHILDPROCESS_STDOUT = 32;
    public static final int TRACE_CHILDPROCESS_STDERR = 64;
    private static final String ENV_FILE_SUFFIX = "_ADENV";
    private static final String ENV_ESCAPED_FILE_SUFFIX = "_ESCAPED";
    private static final long MAX_ENV_WAIT_TIME = 60000L;
    private HashMap m_childContainers = new HashMap(0);
    private Scheduler m_adScheduler;
    private ArrayList m_ADNativeEnv = null;
    private IAttributeSet m_containersAttributSet;
    public static final String FAILURE_NOTIFICATION_TYPE = "Failure";
    public static final String ACTIVATE_NOTIFICATION_TYPE = "Activate";
    public static final String DEACTIVATE_NOTIFICATION_TYPE = "Deactivate";
    public static final IChildContainerState[] EMPTY_CHILD_CONTAINER_STATE_ARRAY;
    private static final ArrayList ATTRIBUTE_INFOS;
    private static final ArrayList OPERATION_INFOS;
    private static final ArrayList NOTIFICATION_INFOS;

    public MBeanAttributeInfo[] getAttributeInfos() {
        return ATTRIBUTE_INFOS.toArray(IEmptyArray.EMPTY_ATTRIBUTE_INFO_ARRAY);
    }

    public MBeanOperationInfo[] getOperationInfos() {
        return OPERATION_INFOS.toArray(IEmptyArray.EMPTY_OPERATION_INFO_ARRAY);
    }

    public MBeanNotificationInfo[] getNotificationInfos() {
        return NOTIFICATION_INFOS.toArray(IEmptyArray.EMPTY_NOTIFICATION_INFO_ARRAY);
    }

    public void init(IComponentContext context) {
        super.init(context);
        IElement daemonConfig = context.getConfiguration(true);
        IElement xsdConfig = this.m_context.getConfiguration("/_MFSchemaDefinition", false);
        m_mfXSD = (String)xsdConfig.getAttributes().getAttribute("SCHEMA_DEFINITION");
        m_mfXSD = m_mfXSD.substring(m_mfXSD.indexOf("<"));
        IAttributeSet daemonAttrs = daemonConfig.getAttributes();
        this.m_containersAttributSet = (IAttributeSet)daemonAttrs.getAttribute("CONTAINERS");
        HashMap containers = this.m_containersAttributSet.getAttributes();
        if (containers != null) {
            for (Map.Entry entry : containers.entrySet()) {
                this.addChildContainer((String)entry.getKey(), (IAttributeSet)entry.getValue());
            }
        }
        IAttributeChangeHandler changeHandler = new IAttributeChangeHandler(){

            public void itemDeleted() {
            }

            public void itemModified(Object value) {
                ActivationDaemon.this.handleContainersAttributeSetChange((IDeltaAttributeSet)value);
            }
        };
        this.m_containersAttributSet.registerAttributeChangeHandler((Object)this.m_context, changeHandler);
    }

    public synchronized void start() {
        this.m_SdfMFTracingIntegration = new SdfMFTracingIntegration();
        this.m_SdfMFTracingIntegration.register();
        if (this.m_state == 3) {
            return;
        }
        try {
            this.m_ADNativeEnv = this.getADNativeEnvironment();
        }
        catch (Exception e) {
            this.m_context.logMessage("Unable to start activation daemon " + this.m_context.getComponentName().getComponentName(), (Throwable)e, 1);
            return;
        }
        Object[] childContainers = this.m_childContainers.values().toArray();
        for (int i = 0; i < childContainers.length; ++i) {
            final ChildContainer child = (ChildContainer)childContainers[i];
            if (!child.isAutoStart()) continue;
            Runnable activator = new Runnable(){

                @Override
                public void run() {
                    child.activate(true);
                }
            };
            this.m_context.scheduleTask(activator, new Date(System.currentTimeMillis()));
        }
        this.m_adScheduler = new Scheduler(this.m_frameworkContext, this.m_childContainers);
        this.m_adScheduler.start();
        super.start();
    }

    private String[] getEnvCommand() {
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.indexOf("windows") > -1) {
            return new String[]{"cmd.exe", "/c set > \"" + this.getTempEnvFile() + '\"'};
        }
        return new String[]{"sh", "-c", "env > \"" + this.getTempEnvFile() + '\"'};
    }

    private File getTempEnvFile() {
        return new File(this.m_container.getCacheDirectory(), this.m_container.getContainerIdentity().getContainerName() + ENV_FILE_SUFFIX);
    }

    private File escapeBackslashInFile() throws FileNotFoundException, IOException {
        File envFile = this.getTempEnvFile();
        if (!envFile.exists()) {
            throw new FileNotFoundException("The environment file was not found! (" + envFile + ")");
        }
        FileInputStream inputStream = new FileInputStream(envFile);
        File modifiedEnvFile = new File(envFile.getCanonicalPath() + ENV_ESCAPED_FILE_SUFFIX);
        FileOutputStream outStream = new FileOutputStream(modifiedEnvFile.getCanonicalPath());
        while (inputStream.available() > 0) {
            int byteRead = inputStream.read();
            if (byteRead == 92) {
                outStream.write(92);
            }
            outStream.write(byteRead);
        }
        inputStream.close();
        outStream.close();
        return modifiedEnvFile;
    }

    private ArrayList getEnvFromFile() throws IOException {
        File envFile = this.getTempEnvFile();
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 60000L) {
            try {
                FileInputStream testStream = new FileInputStream(envFile);
                testStream.close();
                break;
            }
            catch (Exception streamEx) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {}
            }
        }
        File envQuotedFile = this.escapeBackslashInFile();
        FileInputStream fileStream = new FileInputStream(envQuotedFile);
        Properties props = new Properties();
        props.load(fileStream);
        Enumeration<Object> propNames = props.keys();
        ArrayList<String> env = new ArrayList<String>();
        while (propNames.hasMoreElements()) {
            String key = (String)propNames.nextElement();
            String value = (String)props.get(key);
            env.add(key + "=" + value);
        }
        ((InputStream)fileStream).close();
        boolean deleted = envFile.delete();
        if (!deleted) {
            this.m_context.logMessage("Unable to delete temporary environment file " + envFile.getCanonicalPath(), 3);
        }
        if (!(deleted = envQuotedFile.delete())) {
            this.m_context.logMessage("Unable to delete temporary environment file " + envQuotedFile.getCanonicalPath(), 3);
        }
        return env;
    }

    private ArrayList getADNativeEnvironment() throws Exception {
        String[] command = this.getEnvCommand();
        Process envP = Runtime.getRuntime().exec(command);
        InputStream childOutput = envP.getInputStream();
        InputStream childErr = envP.getErrorStream();
        OutputStream childInput = envP.getOutputStream();
        GetEnvReader envOutput = new GetEnvReader(childOutput, true);
        GetEnvReader envErr = new GetEnvReader(childErr, false);
        Thread outputThread = new Thread((Runnable)envOutput, this.m_context.getComponentName().getComponentName() + "getEnv output Reader");
        outputThread.setDaemon(true);
        outputThread.start();
        Thread errThread = new Thread((Runnable)envErr, this.m_context.getComponentName().getComponentName() + "getEnv stderr Reader");
        errThread.setDaemon(true);
        errThread.start();
        GetEnvInputFlusher envInput = new GetEnvInputFlusher(childInput, outputThread);
        Thread inputThread = new Thread((Runnable)envInput, this.m_context.getComponentName().getComponentName() + "getEnv input flusher");
        inputThread.setDaemon(true);
        inputThread.start();
        while (outputThread.isAlive() || inputThread.isAlive() || errThread.isAlive()) {
            Thread.sleep(1000L);
        }
        return this.getEnvFromFile();
    }

    ArrayList getNativeEnvironment() {
        ArrayList<String> copiedList = new ArrayList<String>();
        for (String envSetting : this.m_ADNativeEnv) {
            copiedList.add(new String(envSetting));
        }
        return copiedList;
    }

    public synchronized void stop() {
        if (this.m_state == 1) {
            return;
        }
        this.m_state = (short)4;
        this.m_adScheduler.interrupt();
        this.m_adScheduler = null;
        Object[] childContainers = this.m_childContainers.values().toArray();
        for (int i = 0; i < childContainers.length; ++i) {
            ((ChildContainer)childContainers[i]).deactivate((short)2);
        }
        super.stop();
    }

    public void destroy() {
        this.m_containersAttributSet.unregisterAttributeChangeHandler((Object)this.m_context);
        Object[] childContainers = this.m_childContainers.values().toArray();
        for (int i = 0; i < childContainers.length; ++i) {
            ((ChildContainer)childContainers[i]).close();
        }
        this.m_childContainers.clear();
        super.destroy();
    }

    public void activate(String containerName) throws MFException {
        if (this.m_state != 3) {
            throw new IllegalStateException("Activation daemon must be online to activate a container");
        }
        final ChildContainer child = this.getChildContainer(containerName);
        if (child == null) {
            throw new MFException("Unknown container: " + containerName);
        }
        Runnable activator = new Runnable(){

            @Override
            public void run() {
                child.activate(false);
            }
        };
        this.m_context.scheduleTask(activator, new Date());
    }

    public void deactivate(String containerName) throws MFException {
        if (this.m_state != 3) {
            throw new IllegalStateException("Activation daemon must be online to deactivate a container");
        }
        final ChildContainer child = this.getChildContainer(containerName);
        if (child == null) {
            throw new MFException("Unknown container: " + containerName);
        }
        Runnable deactivator = new Runnable(){

            @Override
            public void run() {
                child.deactivate((short)2);
            }
        };
        this.m_context.scheduleTask(deactivator, new Date());
    }

    public void launch(String childConfigID) throws MFException {
        if (this.m_state != 3) {
            throw new IllegalStateException("Activation daemon must be online to launch a container");
        }
        final ChildContainer child = this.addChildContainer(childConfigID);
        Runnable activator = new Runnable(){

            @Override
            public void run() {
                child.activate(true);
            }
        };
        this.m_context.scheduleTask(activator, new Date(System.currentTimeMillis()));
    }

    public IChildContainerState[] getChildStates() {
        ArrayList<IChildContainerState> childStates = new ArrayList<IChildContainerState>();
        Object[] children = this.m_childContainers.values().toArray();
        for (int i = 0; i < children.length; ++i) {
            childStates.add(((ChildContainer)children[i]).getContainerState());
        }
        return childStates.toArray(EMPTY_CHILD_CONTAINER_STATE_ARRAY);
    }

    public synchronized void handleElementChange(IElementChange elementChange) {
        this.m_context.fireAttributeChangeHandlers();
    }

    public void setTraceMask(Integer traceMask) {
        this.setTraceMask(traceMask, false);
    }

    private void setTraceMask(Integer traceMask, boolean fromSDF) {
        if (!fromSDF && this.m_SdfMFTracingIntegration != null) {
            if (this.m_SdfMFTracingIntegration.wasUpdated()) {
                return;
            }
            this.m_SdfMFTracingIntegration.setTraceMask(traceMask);
        }
        super.setTraceMask(traceMask);
    }

    public String getTraceMaskValues() {
        return super.getTraceMaskValues() + "," + DAEMON_TRACE_MASK_VALUES;
    }

    public Integer getTraceMask() {
        return super.getTraceMask();
    }

    void notifyScheduler() {
        if (this.m_adScheduler != null) {
            this.m_adScheduler.changed();
        }
    }

    private ChildContainer getChildContainer(String runtimeName) {
        Object[] childContainers = this.m_childContainers.values().toArray();
        for (int i = 0; i < childContainers.length; ++i) {
            ChildContainer child = (ChildContainer)childContainers[i];
            if (child.getContainerState().getRuntimeIdentity().getCanonicalName().compareTo(runtimeName) != 0) continue;
            return child;
        }
        return null;
    }

    private synchronized ChildContainer addChildContainer(String childConfigID) {
        ChildContainer child2 = null;
        child2 = (ChildContainer)this.m_childContainers.get(childConfigID);
        if (child2 != null) {
            return child2;
        }
        for (ChildContainer child2 : this.m_childContainers.values()) {
            if (!child2.getConfigID().equals(childConfigID)) continue;
            return child2;
        }
        child2 = new ChildContainer(this, this.m_frameworkContext, childConfigID, null);
        this.m_childContainers.put(childConfigID, child2);
        return child2;
    }

    private synchronized void addChildContainer(String childName, IAttributeSet activationAttrs) {
        if (this.m_childContainers.containsKey(childName)) {
            return;
        }
        String childConfigID = ((Reference)activationAttrs.getAttribute("CONTAINER_REF")).getElementName();
        Object child = this.m_childContainers.remove(childConfigID);
        if (child == null) {
            child = new ChildContainer(this, this.m_frameworkContext, childConfigID, activationAttrs);
        }
        this.m_childContainers.put(childName, child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleContainersAttributeSetChange(IDeltaAttributeSet value) {
        String[] names = null;
        names = value.getDeletedAttributesNames();
        for (int i = 0; i < names.length; ++i) {
            ChildContainer child = (ChildContainer)this.m_childContainers.get(names[i]);
            if (child == null) continue;
            child.close();
            this.m_childContainers.remove(names[i]);
        }
        names = value.getNewAttributesNames();
        boolean notifyScheduler = false;
        for (int i = 0; i < names.length; ++i) {
            try {
                IAttributeSet activationAttrs = (IAttributeSet)value.getNewValue(names[i]);
                ChildContainer child = (ChildContainer)this.m_childContainers.get(names[i]);
                if (child == null) {
                    String childConfigID = ((Reference)activationAttrs.getAttribute("CONTAINER_REF")).getElementName();
                    child = (ChildContainer)this.m_childContainers.get(childConfigID);
                    if (child == null) {
                        this.addChildContainer(names[i], activationAttrs);
                        if (this.m_state == 3) {
                            final ChildContainer newChild = (ChildContainer)this.m_childContainers.get(names[i]);
                            if (newChild.isAutoStart()) {
                                Runnable activator = new Runnable(){

                                    @Override
                                    public void run() {
                                        newChild.activate(true);
                                    }
                                };
                                this.m_context.scheduleTask(activator, new Date(System.currentTimeMillis()));
                            } else {
                                notifyScheduler = true;
                            }
                        }
                    } else {
                        HashMap hashMap = this.m_childContainers;
                        synchronized (hashMap) {
                            this.m_childContainers.remove(childConfigID);
                            this.m_childContainers.put(names[i], child);
                        }
                    }
                }
                if (child == null) continue;
                child.setActivationSettings(activationAttrs);
                continue;
            }
            catch (NotModifiedAttException e) {
                // empty catch block
            }
        }
        if (notifyScheduler) {
            this.notifyScheduler();
        }
    }

    IContainer getContainer() {
        return this.m_container;
    }

    static {
        EMPTY_CHILD_CONTAINER_STATE_ARRAY = new IChildContainerState[0];
        ATTRIBUTE_INFOS = new ArrayList();
        OPERATION_INFOS = new ArrayList();
        NOTIFICATION_INFOS = new ArrayList();
        MBeanParameterInfo[] mbParamInfos = null;
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("id", String.class.getName(), "Runtime identity of the container to activate (e.g. \"Domain1.Container1\")")};
        OPERATION_INFOS.add(new MBeanOperationInfo("activate", "(Re)Activates a child container according to the schedule and activation rules defined for the container.", mbParamInfos, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("id", String.class.getName(), "Runtime identity of the container to deactivate (e.g. \"Domain1.Container1\")")};
        OPERATION_INFOS.add(new MBeanOperationInfo("deactivate", "Shuts down an active child container and disables the child from being re-launched due to the activation schedule and rules defined for the container.", mbParamInfos, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("configID", String.class.getName(), "The configuration identity of the container to launch.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("launch", "Dynamically launches the specified child container.", mbParamInfos, Void.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("getChildStates", "Gets the runtime state for all of the child containers managemed by this daemon.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, IChildContainerState[].class.getName(), 0));
        String[] notifTypes = null;
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], ACTIVATE_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Child container (re)launch complete."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], DEACTIVATE_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Child container shutdown complete."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], FAILURE_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Child container process has died."));
    }

    private final class GetEnvReader
    implements Runnable {
        InputStream stream;
        boolean stdout = false;

        private GetEnvReader(InputStream stream, boolean stdout) {
            this.stream = stream;
            this.stdout = stdout;
        }

        @Override
        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.stream));
            try {
                while (this.stream.available() > 0) {
                    reader.readLine();
                }
            }
            catch (IOException e) {
                ActivationDaemon.this.m_context.logMessage("Error reading the getEnv " + (this.stdout ? "output " : "error stream") + e, 2);
            }
        }
    }

    private final class GetEnvInputFlusher
    implements Runnable {
        OutputStream m_input;
        Thread m_readerThread;

        private GetEnvInputFlusher(OutputStream stream, Thread readerThread) {
            this.m_input = stream;
            this.m_readerThread = readerThread;
        }

        @Override
        public void run() {
            while (this.m_readerThread.isAlive()) {
                try {
                    this.m_input.write(System.getProperty("line.separator").getBytes());
                    this.m_input.flush();
                }
                catch (IOException ioE) {
                    break;
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interrupted) {
                    break;
                }
            }
        }
    }

    private class SdfMFTracingIntegration
    extends AbstractMFComponentTracing {
        private boolean m_updateTraceLevelWasCalled;

        SdfMFTracingIntegration() {
            super("sonic.mf.ad." + ActivationDaemon.this.m_context.getComponentName().getComponentName().replace(' ', '_'), ActivationDaemon.this.getTraceMaskValues());
            this.m_updateTraceLevelWasCalled = false;
            this.setTraceMask();
        }

        private void setTraceMask() {
            this.setTraceMask(new Integer(ActivationDaemon.this.m_traceMask));
        }

        boolean wasUpdated() {
            return this.m_updateTraceLevelWasCalled;
        }

        public void updateTraceLevel(String doiIDNotUsed, HashMap parameters, StringBuffer buffer) {
            super.updateTraceLevel(doiIDNotUsed, parameters, buffer);
            this.m_updateTraceLevelWasCalled = true;
            ActivationDaemon.this.setTraceMask(this.getCurrentMask(), true);
        }
    }
}

