/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.daemon;

import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.runtime.IChildContainerState;
import com.sonicsw.mf.common.runtime.IContainerExitCodes;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.runtime.impl.ChildContainerState;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.agent.cache.impl.ConfigCache;
import com.sonicsw.mf.framework.daemon.ActivationDaemon;
import com.sonicsw.mf.framework.daemon.ScheduleInfo;
import com.sonicsw.mx.util.IEmptyArray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;

class ChildContainer
implements Runnable {
    private IFrameworkComponentContext m_context;
    private String m_configID;
    private IElement m_config;
    private boolean m_isRunning = false;
    private boolean m_isClosing = false;
    private int m_activationRetries = 0;
    private ChildContainerState m_containerState;
    private CanonicalName m_containerName;
    private String m_cacheHostDir;
    private String m_cachePassword;
    private File m_workingDir;
    private File m_nativeLibrariesDir;
    private String m_nativeLibPath;
    private File m_cacheLockFile;
    private IAttributeSet m_containerAttrs;
    private IAttributeSet m_activationAttrs;
    private long m_retryInterval = 0L;
    private int m_retryTimes = -1;
    private ArrayList m_schedules = new ArrayList();
    private Process m_containerProcess = null;
    private OutputStream m_containerStdin = null;
    private OutputReader m_containerStdout = null;
    private InputFlusher m_inputFlusher = null;
    private OutputReader m_containerStderr = null;
    private ActivationDaemon m_daemon = null;
    private static String m_rootWorkingDir;
    private static ArrayList m_defaultCmdArgs;
    private static HashMap m_activationProps;
    private static final String LINE_SEPARATOR;
    private static final String QUOTE;
    private static final long MAX_DEACTIVATION_TIME = 300000L;
    private boolean m_ldLibraryPathSet = false;
    private boolean m_pathSet = false;
    private boolean m_shLibPathSet = false;
    private boolean m_libPathSet = false;

    ChildContainer(ActivationDaemon daemon, IFrameworkComponentContext context, String configID, IAttributeSet activationAttrs) {
        this.m_daemon = daemon;
        this.m_context = context;
        this.m_configID = configID;
        this.setActivationSettings(activationAttrs);
        Thread configReader = new Thread(context.getComponentName().getComponentName() + " - Child Configuration Reader"){

            @Override
            public void run() {
                ChildContainer.this.getConfiguration();
            }
        };
        configReader.setDaemon(true);
        configReader.start();
    }

    void setContainerSettings(IAttributeSet containerAttrs) throws Exception {
        this.m_containerAttrs = containerAttrs;
        this.parseContainerSettings();
        if (this.m_containerAttrs != null) {
            IAttributeChangeHandler changeHandler = new IAttributeChangeHandler(){

                public void itemDeleted() {
                }

                public void itemModified(Object value) {
                    ChildContainer.this.m_config = ChildContainer.this.m_context.getConfiguration(ChildContainer.this.m_configID, false);
                    try {
                        ChildContainer.this.m_containerAttrs = ChildContainer.this.m_config.getAttributes();
                        ChildContainer.this.parseContainerSettings();
                    }
                    catch (Exception e) {
                        ChildContainer.this.m_context.logMessage("Failed to apply modified container configuration [" + ChildContainer.this.m_configID + "] settings, trace follows...", (Throwable)e, 2);
                    }
                }
            };
            this.m_containerAttrs.registerAttributeChangeHandler((Object)this.m_context, changeHandler);
        }
    }

    final void setActivationSettings(IAttributeSet activationAttrs) {
        this.m_activationAttrs = activationAttrs;
        this.parseActivationSettings();
        if (this.m_activationAttrs != null) {
            IAttributeChangeHandler changeHandler = new IAttributeChangeHandler(){

                public void itemDeleted() {
                }

                public void itemModified(Object value) {
                    IAttributeSet daemonAttrs = (IAttributeSet)ChildContainer.this.m_context.getConfiguration(true).getAttributes().getAttribute("CONTAINERS");
                    for (IAttributeSet childAttrs : daemonAttrs.getAttributes().values()) {
                        Reference ref = (Reference)childAttrs.getAttribute("CONTAINER_REF");
                        if (!ref.getElementName().equals(ChildContainer.this.m_configID)) continue;
                        ChildContainer.this.m_activationAttrs = childAttrs;
                        ChildContainer.this.parseActivationSettings();
                        if (ChildContainer.this.m_schedules.size() <= 0) break;
                        ChildContainer.this.m_daemon.notifyScheduler();
                        break;
                    }
                }
            };
            this.m_activationAttrs.registerAttributeChangeHandler((Object)this.m_context, changeHandler);
        }
    }

    void close() {
        this.m_isClosing = true;
        if (this.m_containerAttrs != null) {
            this.m_containerAttrs.unregisterAttributeChangeHandler((Object)this.m_context);
        }
        if (this.m_activationAttrs != null) {
            this.m_activationAttrs.unregisterAttributeChangeHandler((Object)this.m_context);
        }
        this.deactivate((short)2);
    }

    ArrayList getSchedules() {
        return this.m_schedules;
    }

    IChildContainerState getContainerState() {
        return this.m_containerState;
    }

    synchronized void activate(boolean waitForConfig) {
        if (waitForConfig) {
            while (!this.m_isClosing && this.m_containerState == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.m_isClosing) continue;
                return;
            }
        }
        if (this.m_containerState == null) {
            throw new IllegalStateException("Container configuration not available");
        }
        this.m_activationRetries = 0;
        if (this.m_containerState.getState() != 3) {
            this.m_containerState.clearExitCode();
            this.m_containerState.setState((short)1);
            this.m_context.scheduleTask((Runnable)this, new Date());
        }
    }

    synchronized void deactivate(short endingState) {
        if (this.m_containerState == null) {
            return;
        }
        if (this.m_containerState.getState() == 3) {
            this.internalDeactivateContainer(endingState);
            this.sendDeactivateNotification();
        }
    }

    boolean isAutoStart() {
        return this.m_schedules.size() == 0;
    }

    boolean isClosing() {
        return this.m_isClosing;
    }

    private synchronized void parseContainerSettings() throws Exception {
        if (this.m_containerAttrs != null) {
            String domainName = (String)this.m_containerAttrs.getAttribute("DOMAIN_NAME");
            if (domainName == null) {
                domainName = "Domain1";
            }
            this.m_containerName = new CanonicalName(domainName, (String)this.m_containerAttrs.getAttribute("CONTAINER_NAME"), "");
            if (IContainer.CURRENT_LAUNCHER_VERSION == null) {
                this.m_workingDir = new File(m_rootWorkingDir + this.m_containerName.getContainerName());
            } else {
                File sonicContainer = new File(System.getProperty("sonicsw.mf.containers_directory"));
                this.m_workingDir = new File(sonicContainer, this.m_containerName.getDomainName() + "." + this.m_containerName.getContainerName());
            }
            if (!this.m_workingDir.exists() && !this.m_workingDir.mkdir()) {
                throw new RuntimeException("Failed to create container's working directory: " + this.m_workingDir.getAbsolutePath());
            }
            this.m_nativeLibrariesDir = new File(this.m_workingDir, IContainer.DEFAULT_LIBX_DIR);
            if (!this.m_nativeLibrariesDir.exists() && !this.m_nativeLibrariesDir.mkdir()) {
                throw new RuntimeException("Failed to create container's native library directory: " + this.m_nativeLibrariesDir.getAbsolutePath());
            }
            this.m_nativeLibPath = (String)this.m_containerAttrs.getAttribute("CONTAINER_NATIVE_LIBRARY_PATH");
            if (this.m_containerState == null) {
                this.m_containerState = new ChildContainerState(this.m_containerName, this.m_config.getIdentity());
                this.m_containerState.setState((short)1);
            }
            this.m_cacheLockFile = null;
            this.m_cacheHostDir = null;
            IAttributeSet cacheAttrs = (IAttributeSet)this.m_containerAttrs.getAttribute("CACHE");
            if (cacheAttrs == null) {
                this.m_cacheHostDir = "./container.cache";
            } else {
                this.m_cachePassword = (String)cacheAttrs.getAttribute("PASSWORD");
                this.m_cacheHostDir = (String)cacheAttrs.getAttribute("CACHE_DIRECTORY");
                if (this.m_cacheHostDir == null || this.m_cacheHostDir.length() == 0 || this.m_cacheHostDir.equals(".")) {
                    this.m_cacheHostDir = "./container.cache";
                }
            }
            if (this.m_cacheHostDir != null) {
                if (this.m_cacheHostDir.startsWith(".")) {
                    this.m_cacheHostDir = this.m_workingDir.getAbsolutePath() + File.separatorChar + this.m_cacheHostDir;
                }
                this.m_cacheLockFile = new File(this.m_cacheHostDir + File.separatorChar + "cache.lock");
            }
        }
    }

    private synchronized void parseActivationSettings() {
        if (this.m_activationAttrs != null) {
            this.setRetryInterval((Long)this.m_activationAttrs.getAttribute("RETRY_INTERVAL_SECONDS"));
            this.setRetryTimes((Integer)this.m_activationAttrs.getAttribute("RETRY_TIMES"));
            this.setSchedules((IAttributeSet)this.m_activationAttrs.getAttribute("SCHEDULES"));
        }
    }

    private synchronized void setRetryInterval(Long seconds) {
        this.m_retryInterval = seconds == null ? 0L : seconds;
    }

    private synchronized void setRetryTimes(Integer count) {
        this.m_retryTimes = count == null ? 0 : count;
    }

    private synchronized void setSchedules(IAttributeSet schedulesSet) {
        this.m_schedules.clear();
        if (schedulesSet != null) {
            Object[] schedules = schedulesSet.getAttributes().values().toArray();
            for (int i = 0; i < schedules.length; ++i) {
                ArrayList occursValues;
                String occursType;
                IAttributeSet scheduleAttrs = (IAttributeSet)schedules[i];
                String scheduleType = (String)scheduleAttrs.getAttribute("ACTION_TYPE");
                String occursString = (String)scheduleAttrs.getAttribute("OCCURS_VALUE");
                if (occursString == null) {
                    occursString = "12:30";
                }
                if ((occursType = (String)scheduleAttrs.getAttribute("OCCURS_TYPE")) == null) {
                    occursType = "daily";
                }
                if ((occursValues = this.parseOccursString(occursString, occursType)) == null) continue;
                ScheduleInfo scheduleInfo = new ScheduleInfo(scheduleType, occursType, occursValues);
                this.m_schedules.add(scheduleInfo);
            }
        }
    }

    private ArrayList parseOccursString(String occursString, String occursType) {
        ArrayList<Integer> result = new ArrayList<Integer>(0);
        if (occursString.length() == 0 || occursType.length() == 0) {
            this.m_context.logMessage("Invalid schedule found for container [" + this.m_configID + "]; schedule ignored", 2);
            return result;
        }
        ArrayList<String> fields = new ArrayList<String>(0);
        StringTokenizer st = new StringTokenizer(occursString, ";");
        while (st.hasMoreTokens()) {
            fields.add(st.nextToken());
        }
        st = new StringTokenizer((String)fields.get(0), ":");
        if (st.countTokens() != 2) {
            this.m_context.logMessage("Invalid schedule time format found [" + st.toString() + "] for container [" + this.m_configID + "]; schedule ignored", 2);
            return result;
        }
        ArrayList<String> times = new ArrayList<String>(2);
        while (st.hasMoreTokens()) {
            times.add(st.nextToken());
        }
        Integer hh = new Integer((String)times.get(0));
        if (hh > 23) {
            this.m_context.logMessage("Invalid schedule hour found [" + hh + "] for container [" + this.m_configID + "]; schedule ignored", 2);
            return result;
        }
        result.add(hh);
        Integer mm = new Integer((String)times.get(1));
        if (mm > 60) {
            this.m_context.logMessage("Invalid schedule minutes found [" + mm + "] for container [" + this.m_configID + "]; schedule ignored", 2);
            return result;
        }
        result.add(mm);
        if (fields.size() == 2) {
            Integer day = new Integer((String)fields.get(1));
            if (occursType.equalsIgnoreCase("WEEKLY") && (day > 7 || day < 1)) {
                this.m_context.logMessage("Invalid schedule day of week found [" + day + "] for container [" + this.m_configID + "]; schedule ignored", 2);
                return result;
            }
            if (occursType.equalsIgnoreCase("MONTHLY") && (day > 31 || day < 1)) {
                this.m_context.logMessage("Invalid schedule day of month found [" + day + "] for container [" + this.m_configID + "]; schedule ignored", 2);
                return result;
            }
            result.add(day);
        }
        if (fields.size() == 3) {
            if (!occursType.equalsIgnoreCase("YEARLY")) {
                this.m_context.logMessage("Invalid schedule found for container [" + this.m_configID + "]; schedule ignored", 2);
                return result;
            }
            Integer dom = new Integer((String)fields.get(1));
            if (dom > 31 || dom < 1) {
                this.m_context.logMessage("Invalid schedule day of month found [" + dom + "] for container [" + this.m_configID + "]; schedule ignored", 2);
                return result;
            }
            result.add(dom);
            Integer moy = new Integer((String)fields.get(2));
            moy = new Integer(moy - 1);
            if (moy > 11 || moy < 0) {
                this.m_context.logMessage("Invalid schedule month of year found [" + moy + "] for container [" + this.m_configID + "]; schedule ignored", 2);
                return result;
            }
            result.add(moy);
        }
        return result;
    }

    String getConfigID() {
        return this.m_configID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConfiguration() {
        Object lastException = null;
        while (!this.m_isClosing) {
            ChildContainer e2;
            try {
                try {
                    this.m_config = this.m_context.getConfiguration(this.m_configID, false);
                    if (this.m_config == null) {
                        this.m_context.logMessage("Retrying to get container configuration [" + this.m_configID + "] due to unknown configuration", 2);
                    }
                }
                catch (Throwable e2) {
                    if (lastException == null || !lastException.getClass().isInstance(e2)) {
                        this.m_context.logMessage("Retrying to get container configuration [" + this.m_configID + "] due to failure, trace follows...", e2, 2);
                    }
                    lastException = e2;
                }
                if (this.m_config == null) continue;
                try {
                    this.setContainerSettings(this.m_config.getAttributes());
                    e2 = this;
                    synchronized (e2) {
                        this.notifyAll();
                        break;
                    }
                }
                catch (Exception e3) {
                    if (lastException == null || !lastException.getClass().isInstance(e3)) {
                        this.m_context.logMessage("Retrying to get container configuration [" + this.m_configID + "] due to setup failure, trace follows...", (Throwable)e3, 2);
                    }
                    lastException = e3;
                }
            }
            finally {
                if (this.m_containerState != null || this.m_isClosing) continue;
                e2 = this;
                synchronized (e2) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException e4) {}
                }
            }
        }
    }

    @Override
    public synchronized void run() {
        try {
            if (this.m_containerState.getState() != 3) {
                this.internalActivateContainer();
                if (this.m_isRunning) {
                    this.startStreamProcessors();
                    new Monitor().start();
                }
            }
        }
        catch (Exception e) {
            this.m_context.logMessage(this.m_containerName.getCanonicalName() + ": Container activation failure, trace follows...", (Throwable)e, 1);
        }
    }

    private void internalActivateContainer() throws Exception {
        ConfigCache.cleanupCorruptCache(this.m_cacheLockFile.getParentFile(), (ILogger)this.m_context);
        ArrayList cmdArray = this.m_daemon.getContainer().prepareCacheForActivatedContainer(this.m_context.getComponentName().getComponentName(), this.m_containerName.getContainerName(), this.m_configID, this.m_workingDir.getAbsolutePath(), this.m_cacheHostDir, this.m_cachePassword, m_activationProps);
        this.m_containerState.clearExitCode();
        this.m_context.logMessage(this.m_containerName.getCanonicalName() + ": Container activation initiated...", 3);
        if ((this.m_daemon.getTraceMask() & 0x10) > 0) {
            StringBuffer cmd = new StringBuffer("Container execution command args:\n");
            for (int i = 0; i < cmdArray.size(); ++i) {
                cmd.append("\n[").append((String)cmdArray.get(i) + ']');
            }
            cmd.append('\n');
            this.m_context.logMessage(cmd.toString(), 7);
        }
        String[] env = this.getNativeEnvironment();
        this.m_containerProcess = Runtime.getRuntime().exec(cmdArray.toArray(IEmptyArray.EMPTY_STRING_ARRAY), env, this.m_workingDir);
        try {
            this.m_containerState.setExitCode((short)this.m_containerProcess.exitValue());
        }
        catch (IllegalThreadStateException ex) {
            this.m_isRunning = true;
            this.m_containerStdin = this.m_containerProcess.getOutputStream();
            this.m_containerState.setState((short)3);
            this.sendActivateNotification();
        }
        catch (IllegalArgumentException e) {
            this.m_containerState.setExitCode((short)1);
            this.m_context.logMessage(this.m_containerName.getCanonicalName() + ": Container activation failure, unexpected exit code=" + (short)this.m_containerProcess.exitValue() + " (unknown)", 1);
        }
    }

    private synchronized void internalDeactivateContainer(short endingState) {
        short state = this.m_containerState.getState();
        if (state == 0 || state == 1) {
            return;
        }
        this.m_context.logMessage(this.m_containerName.getCanonicalName() + ": Container deactivation initiated...", 3);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.m_containerStdin));
        try {
            writer.write("shutdown" + LINE_SEPARATOR);
            writer.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        long startDeactivateTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startDeactivateTime < 300000L) {
            try {
                this.m_containerProcess.exitValue();
            }
            catch (IllegalThreadStateException e) {
                try {
                    this.wait(500L);
                    continue;
                }
                catch (InterruptedException interrupted) {}
            }
            break;
        }
        try {
            this.m_containerProcess.exitValue();
        }
        catch (IllegalThreadStateException e) {
            this.m_containerProcess.destroy();
            this.m_context.logMessage(this.m_containerName.getCanonicalName() + ": Container deactivation incomplete after " + 5L + "minutes, container process destroyed", 1);
        }
        this.m_containerState.setState(endingState);
    }

    private String[] getNativeEnvironment() throws Exception {
        String OS = System.getProperty("os.name").toLowerCase();
        ArrayList envList = this.m_daemon.getNativeEnvironment();
        if (envList != null && this.m_nativeLibPath != null) {
            for (int i = 0; i < envList.size(); ++i) {
                String varSetting = (String)envList.get(i);
                String newSetting = this.checkPathVariables(varSetting);
                if (newSetting == null) continue;
                envList.set(i, newSetting);
            }
        }
        if (envList != null && this.m_nativeLibPath != null && !this.m_ldLibraryPathSet && (OS.startsWith("linux") || OS.startsWith("sunos"))) {
            String setting = "LD_LIBRARY_PATH=" + this.m_nativeLibPath;
            envList.add(setting);
        }
        if (envList != null && this.m_nativeLibPath != null && !this.m_pathSet && OS.startsWith("windows")) {
            String setting = "PATH=" + this.m_nativeLibPath;
            envList.add(setting);
        }
        if (envList != null && this.m_nativeLibPath != null && !this.m_shLibPathSet && OS.startsWith("hp")) {
            String setting = "SHLIB_PATH=" + this.m_nativeLibPath;
            envList.add(setting);
        }
        if (envList != null && this.m_nativeLibPath != null && !this.m_libPathSet && OS.startsWith("aix")) {
            String setting = "LIBPATH=" + this.m_nativeLibPath;
            envList.add(setting);
        }
        String[] env = null;
        if (envList != null) {
            env = new String[envList.size()];
            envList.toArray(env);
        }
        return env;
    }

    private String checkPathVariables(String varSetting) {
        String OS = System.getProperty("os.name").toLowerCase();
        String pathSeparator = System.getProperty("path.separator");
        String newSetting = null;
        if (varSetting.toLowerCase().startsWith("path=") && OS.startsWith("windows")) {
            newSetting = varSetting.substring(0, 5) + this.m_nativeLibPath + pathSeparator + varSetting.substring(5);
            this.m_pathSet = true;
        } else if (varSetting.toLowerCase().startsWith("ld_library_path=") && (OS.startsWith("linux") || OS.startsWith("sunos"))) {
            newSetting = varSetting.substring(0, 16) + this.m_nativeLibPath + pathSeparator + varSetting.substring(16);
            this.m_ldLibraryPathSet = true;
        } else if (varSetting.toLowerCase().startsWith("shlib_path=") && OS.startsWith("hp")) {
            newSetting = varSetting.substring(0, 11) + this.m_nativeLibPath + pathSeparator + varSetting.substring(11);
            this.m_shLibPathSet = true;
        } else if (varSetting.toLowerCase().startsWith("libpath=") && OS.startsWith("aix")) {
            newSetting = varSetting.substring(0, 8) + this.m_nativeLibPath + pathSeparator + varSetting.substring(8);
            this.m_libPathSet = true;
        }
        return newSetting;
    }

    private void startStreamProcessors() {
        this.m_containerStdout = new OutputReader(this.m_containerProcess.getInputStream(), true);
        this.m_containerStderr = new OutputReader(this.m_containerProcess.getErrorStream(), false);
        Thread readerThread = null;
        readerThread = new Thread((Runnable)this.m_containerStdout, this.m_context.getComponentName().getComponentName() + " - Child Container stdout Reader: " + this.m_containerName.getCanonicalName());
        readerThread.setDaemon(true);
        readerThread.start();
        readerThread = new Thread((Runnable)this.m_containerStderr, this.m_context.getComponentName().getComponentName() + " - Child Container stderr Reader: " + this.m_containerName.getCanonicalName());
        readerThread.setDaemon(true);
        readerThread.start();
        this.m_inputFlusher = new InputFlusher(this.m_containerStdin, "container " + this.m_containerName.getCanonicalName());
        Thread flusherThread = new Thread((Runnable)this.m_inputFlusher, this.m_context.getComponentName().getComponentName() + " - Child Container input flusher: " + this.m_containerName.getCanonicalName());
        flusherThread.setDaemon(true);
        flusherThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorContainer() {
        try {
            short exitCode = (short)this.m_containerProcess.waitFor();
            ChildContainer childContainer = this;
            synchronized (childContainer) {
                this.notifyAll();
            }
            try {
                this.m_containerState.setExitCode(exitCode);
                this.m_context.logMessage(this.m_containerName.getCanonicalName() + ": Container deactivated/shutdown, exit code=" + exitCode + " (" + IContainerExitCodes.EXIT_CODE_TEXTS[exitCode] + ')', 3);
            }
            catch (IllegalArgumentException e) {
                this.m_containerState.setExitCode((short)1);
                this.m_context.logMessage(this.m_containerName.getCanonicalName() + ": Container deactivated/shutdown, unexpected exit code=" + exitCode + " (unknown)", 2);
            }
            this.m_isRunning = false;
            short state = this.m_containerState.getState();
            if (state == 3) {
                this.m_containerState.setState((short)1);
            }
            if (this.m_daemon.getState() == 1) {
                return;
            }
            switch (this.m_containerState.getExitCode()) {
                case 0: {
                    break;
                }
                case 14: {
                    this.m_context.logMessage(this.m_containerName.getCanonicalName() + ": Container initiated restart", 3);
                    Runnable activator = new Runnable(){

                        @Override
                        public void run() {
                            ChildContainer.this.activate(false);
                        }
                    };
                    this.m_context.scheduleTask(activator, new Date(System.currentTimeMillis() + 2000L));
                    break;
                }
                case 7: {
                    this.sendFailureNotification();
                    if (this.m_retryTimes > 0) {
                        this.m_context.logMessage(this.m_containerName.getCanonicalName() + ": Container activation retry not initiated due to previous cache failure", 2);
                        this.m_activationRetries = 0;
                        return;
                    }
                    break;
                }
                default: {
                    this.sendFailureNotification();
                    if (this.m_retryTimes > 0 && this.m_activationRetries < this.m_retryTimes) {
                        if (this.m_containerState.getExitCode() == 14) {
                            this.m_activationRetries = 0;
                            return;
                        }
                        Thread.sleep(this.m_retryInterval * 1000L);
                        if (!this.isExpectedToBeActive()) {
                            this.m_activationRetries = 0;
                            return;
                        }
                        this.m_context.logMessage(this.m_containerName.getCanonicalName() + ": Container activation retry initiated...", 3);
                        if (this.m_retryTimes != -1) {
                            ++this.m_activationRetries;
                        }
                        this.m_context.scheduleTask((Runnable)this, new Date(System.currentTimeMillis()));
                    }
                    break;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized boolean isExpectedToBeActive() {
        if (this.m_schedules.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.m_schedules.size(); ++i) {
            ScheduleInfo scheduleInfo = (ScheduleInfo)this.m_schedules.get(i);
            if (scheduleInfo.getScheduleType() != 0 || scheduleInfo.getPerformActionAtDate().getTime() > System.currentTimeMillis()) continue;
            return true;
        }
        return false;
    }

    private void sendActivateNotification() {
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], "Activate", 3);
        notification.setLogType((short)0);
        notification.setAttribute("Container", (Object)this.m_containerName.getCanonicalName());
        this.m_context.sendNotification(notification);
    }

    private void sendDeactivateNotification() {
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], "Deactivate", 3);
        notification.setLogType((short)0);
        notification.setAttribute("Container", (Object)this.m_containerName.getCanonicalName());
        this.m_context.sendNotification(notification);
    }

    void sendFailureNotification() {
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], "Failure", 1);
        notification.setLogType((short)2);
        notification.setAttribute("Container", (Object)this.m_containerName.getCanonicalName());
        notification.setAttribute("ExitCode", (Object)this.m_containerState.getExitCode().toString());
        this.m_context.sendNotification(notification);
    }

    static {
        LINE_SEPARATOR = System.getProperty("line.separator");
        QUOTE = System.getProperty("path.separator").equals(";") ? "\"" : "";
        m_activationProps = new HashMap();
        m_activationProps.put("sonicsw.mf.cli", "true");
        m_activationProps.put("sonicsw.mx.cli.prompt", "false");
        m_activationProps.put("sonicsw.mx.cli.echo", "false");
        m_activationProps.put("sonicsw.mf.signal", "true");
        m_activationProps.put("sonicsw.mf.allowRestart", "true");
        m_rootWorkingDir = System.getProperty("user.dir") + File.separatorChar;
        m_defaultCmdArgs = new ArrayList();
        String bootClasspath = System.getProperty("sun.boot.class.path");
        if (bootClasspath != null) {
            m_defaultCmdArgs.add(QUOTE + "-Xbootclasspath:" + bootClasspath + QUOTE);
        }
        m_defaultCmdArgs.add("-Dsonicsw.mf.cli=true");
        m_defaultCmdArgs.add("-Dsonicsw.mx.cli.prompt=false");
        m_defaultCmdArgs.add("-Dsonicsw.mx.cli.echo=false");
        m_defaultCmdArgs.add("-Dsonicsw.mf.signal=true");
        m_defaultCmdArgs.add("-Dsonicsw.mf.allowRestart=true");
        if (IContainer.PASSWORD != null) {
            m_defaultCmdArgs.add("-Dsonicsw.mf.password=" + IContainer.PASSWORD);
        }
        m_defaultCmdArgs.add("-cp");
        m_defaultCmdArgs.add(QUOTE + System.getProperty("java.class.path") + QUOTE);
        m_defaultCmdArgs.add("com.sonicsw.mf.framework.agent.ci.Agent");
    }

    private final class OutputReader
    implements Runnable {
        InputStream stream;
        boolean isStdOut = false;

        private OutputReader(InputStream stream, boolean isStdOut) {
            this.stream = stream;
            this.isStdOut = isStdOut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.stream));
            final ArrayList<String> traceBuffer = new ArrayList<String>();
            Thread traceThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block5: while (ChildContainer.this.m_isRunning && !this.isInterrupted()) {
                        ArrayList arrayList = traceBuffer;
                        synchronized (arrayList) {
                            if (traceBuffer.size() < 2) {
                                try {
                                    traceBuffer.wait(500L);
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                            }
                            if (!traceBuffer.isEmpty()) {
                                StringBuffer sb = new StringBuffer(OutputReader.this.isStdOut ? "[stdout]" : "[stderr]");
                                sb.append(' ').append(ChildContainer.this.m_containerName.getCanonicalName());
                                int initialSize = traceBuffer.size();
                                for (int i = 0; i < initialSize; ++i) {
                                    String traceLine = (String)traceBuffer.get(0);
                                    if (i > 0 && traceLine.startsWith("[")) break;
                                    traceBuffer.remove(0);
                                    if (traceLine.length() == 0 && i == 0) {
                                        continue block5;
                                    }
                                    sb.append(LINE_SEPARATOR).append(">>").append(traceLine);
                                }
                                ChildContainer.this.m_context.logMessage(sb.toString(), 7);
                            }
                        }
                    }
                }
            };
            traceThread.setDaemon(true);
            traceThread.start();
            block10: while (ChildContainer.this.m_isRunning) {
                try {
                    int traceMask;
                    String input = reader.readLine();
                    if (input == null) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    if (input.startsWith(ChildContainer.this.m_containerName.getCanonicalName() + '>')) continue;
                    if (input.length() > 0) {
                        if (input.charAt(0) == '\b' || input.length() > 1 && input.charAt(0) == '*' && input.charAt(1) == '\b') {
                            ChildContainer.this.m_context.logMessage(ChildContainer.this.m_containerName.getCanonicalName() + ": ...activation complete", 3);
                            input = input.substring(1);
                            ChildContainer.this.m_activationRetries = 0;
                        } else if (input.charAt(0) == '\u0007' || input.length() > 1 && input.charAt(0) == '*' && input.charAt(1) == '\u0007') {
                            for (int i = 1; i < input.length(); ++i) {
                                if (input.charAt(i) != '\u0007') continue;
                                if (i == input.length() - 1) continue block10;
                                input = input.substring(i + 1);
                                break;
                            }
                        }
                    }
                    if (!input.startsWith(ChildContainer.this.m_containerName.getCanonicalName() + '>')) {
                        ChildContainer.this.m_containerState.addLogLine(input);
                    }
                    if ((((traceMask = ChildContainer.this.m_daemon.getTraceMask().intValue()) & 0x20) <= 0 || !this.isStdOut) && ((traceMask & 0x40) <= 0 || this.isStdOut)) continue;
                    ArrayList<String> arrayList = traceBuffer;
                    synchronized (arrayList) {
                        traceBuffer.add(input);
                        if (input.startsWith("[")) {
                            traceBuffer.notifyAll();
                        }
                    }
                }
                catch (IOException e) {
                    Thread thread = traceThread;
                    synchronized (thread) {
                        if (traceThread.isAlive()) {
                            traceThread.interrupt();
                        }
                    }
                    ChildContainer.this.m_context.logMessage(ChildContainer.this.m_containerName + ": Failed to record stdin/stderr, trace follows...", (Throwable)e, 2);
                    break;
                }
            }
        }
    }

    private final class InputFlusher
    implements Runnable {
        OutputStream m_input;
        String m_flusherName;

        private InputFlusher(OutputStream stream, String flusherName) {
            this.m_input = stream;
            this.m_flusherName = flusherName;
        }

        @Override
        public void run() {
            while (ChildContainer.this.m_isRunning) {
                try {
                    this.m_input.write(System.getProperty("line.separator").getBytes());
                    this.m_input.flush();
                }
                catch (IOException ioE) {
                    break;
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interrupted) {
                    break;
                }
            }
        }
    }

    private final class Monitor
    extends Thread {
        private Monitor() {
            super(ChildContainer.this.m_context.getComponentName().getComponentName() + " - Child Container Monitor: " + ChildContainer.this.m_containerName.getCanonicalName());
            this.setDaemon(true);
        }

        @Override
        public void run() {
            ChildContainer.this.monitorContainer();
        }
    }
}

