/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.daemon;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

class ScheduleInfo {
    public static final int STOP_TYPE = 0;
    public static final int START_TYPE = 1;
    private int m_type;
    private long m_occursType;
    int m_schHOD = 0;
    int m_schMin = 0;
    int m_schDOW = 1;
    int m_schDOM = 0;
    int m_schMOY = 1;
    private Date m_performActionAt;

    ScheduleInfo(String schType, String occursType, ArrayList values) {
        this.setScheduleType(schType);
        this.setOccursType(occursType);
        this.setOccursValues(values);
        this.setScheduledDate(new GregorianCalendar());
    }

    private void setOccursValues(ArrayList values) {
        this.m_schHOD = (Integer)values.get(0);
        this.m_schMin = (Integer)values.get(1);
        if (this.m_occursType == 604800000L) {
            this.m_schDOW = (Integer)values.get(2);
        } else if (this.m_occursType == -1L) {
            this.m_schDOM = (Integer)values.get(2);
        } else if (this.m_occursType == -2L) {
            this.m_schDOM = (Integer)values.get(2);
            this.m_schMOY = (Integer)values.get(3);
        }
    }

    private void setDateForDailyInterval(Calendar cal) {
        long currMS = cal.getTimeInMillis();
        cal.set(11, this.m_schHOD);
        cal.set(12, this.m_schMin);
        long newMS = cal.getTimeInMillis();
        if (newMS < currMS) {
            cal.add(6, 1);
        }
        this.m_performActionAt = cal.getTime();
    }

    private void setDateForWeeklyInterval(Calendar cal) {
        long currMS = cal.getTimeInMillis();
        cal.set(11, this.m_schHOD);
        cal.set(12, this.m_schMin);
        cal.set(7, this.m_schDOW);
        long newMS = cal.getTimeInMillis();
        if (newMS < currMS) {
            cal.add(3, 1);
        }
        this.m_performActionAt = cal.getTime();
    }

    private void setDateForMonthlyInterval(Calendar cal) {
        long currMS = cal.getTimeInMillis();
        int maxDate = cal.getActualMaximum(5);
        if (this.m_schDOM > maxDate) {
            cal.set(5, maxDate);
        } else {
            cal.set(5, this.m_schDOM);
        }
        cal.set(11, this.m_schHOD);
        cal.set(12, this.m_schMin);
        long newMS = cal.getTimeInMillis();
        if (newMS < currMS) {
            cal.add(2, 1);
            maxDate = cal.getActualMaximum(5);
            if (this.m_schDOM > maxDate) {
                cal.set(5, maxDate);
            } else {
                cal.set(5, this.m_schDOM);
            }
        }
        this.m_performActionAt = cal.getTime();
    }

    private void setDateForYearlyInterval(Calendar cal) {
        long currMS = cal.getTimeInMillis();
        cal.set(2, this.m_schMOY);
        cal.set(5, this.m_schDOM);
        cal.set(11, this.m_schHOD);
        cal.set(12, this.m_schMin);
        long newMS = cal.getTimeInMillis();
        if (newMS < currMS) {
            cal.add(1, 1);
        }
        this.m_performActionAt = cal.getTime();
    }

    final void setScheduledDate(Calendar date) {
        date.set(14, 0);
        date.set(13, 0);
        if (this.m_occursType == 86400000L) {
            this.setDateForDailyInterval(date);
        } else if (this.m_occursType == 604800000L) {
            this.setDateForWeeklyInterval(date);
        } else if (this.m_occursType == -1L) {
            this.setDateForMonthlyInterval(date);
        } else if (this.m_occursType == -2L) {
            this.setDateForYearlyInterval(date);
        }
        this.getBackToDesiredHour();
    }

    void getBackToDesiredHour() {
        long nextTime = this.m_performActionAt.getTime();
        GregorianCalendar nextCal = new GregorianCalendar();
        nextCal.setTimeInMillis(nextTime);
        int hour = nextCal.get(11);
        if (hour != this.m_schHOD) {
            nextCal.set(11, this.m_schHOD);
            this.setPerformActionAtDate(new Date(nextCal.getTimeInMillis()));
        }
    }

    int getMaxForNextMonth() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.m_performActionAt);
        cal.set(5, 1);
        cal.add(2, 1);
        return cal.getActualMaximum(5);
    }

    int getOriginalSchDate() {
        return this.m_schDOM;
    }

    Date getPerformActionAtDate() {
        return this.m_performActionAt;
    }

    void setPerformActionAtDate(Date date) {
        this.m_performActionAt = date;
    }

    private void setScheduleType(String schType) {
        if (schType.compareToIgnoreCase("start") == 0) {
            this.m_type = 1;
        } else if (schType.compareToIgnoreCase("stop") == 0) {
            this.m_type = 0;
        }
    }

    public int getScheduleType() {
        return this.m_type;
    }

    public long getOccursType() {
        return this.m_occursType;
    }

    public final void setOccursType(String reoccurType) {
        this.m_occursType = reoccurType.equalsIgnoreCase("DAILY") ? 86400000L : (reoccurType.equalsIgnoreCase("WEEKLY") ? 604800000L : (reoccurType.equalsIgnoreCase("MONTHLY") ? -1L : (reoccurType.equalsIgnoreCase("YEARLY") ? -2L : 86400000L)));
    }
}

