/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.daemon;

import com.sonicsw.mf.common.runtime.IChildContainerState;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.daemon.ChildContainer;
import com.sonicsw.mf.framework.daemon.ScheduleInfo;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;

class Scheduler
extends Thread {
    private IFrameworkComponentContext m_context;
    private HashMap m_childContainers;
    private Object m_schedulerLockObj = new Object();
    public static final long HOURLY = 3600000L;
    public static final long DAILY = 86400000L;
    public static final long WEEKLY = 604800000L;
    public static final long MONTHLY = -1L;
    public static final long YEARLY = -2L;

    Scheduler(IFrameworkComponentContext context, HashMap childContainers) {
        super(context.getComponentName().getComponentName() + " - Child Container Activation Scheduler");
        this.m_context = context;
        this.m_childContainers = childContainers;
        this.setDaemon(true);
    }

    private void runSchedules() {
        long currentTime = System.currentTimeMillis();
        Object[] childContainers = this.m_childContainers.values().toArray();
        for (int i = 0; i < childContainers.length; ++i) {
            IChildContainerState childContainerState;
            ChildContainer child = (ChildContainer)childContainers[i];
            if (child.isClosing() || (childContainerState = child.getContainerState()) != null && childContainerState.getState() == 2) continue;
            Object[] schedules = child.getSchedules().toArray();
            for (int j = 0; j < schedules.length; ++j) {
                short currentState;
                ScheduleInfo info = (ScheduleInfo)schedules[j];
                if (info.getPerformActionAtDate().getTime() > currentTime) continue;
                boolean start = info.getScheduleType() == 1;
                short s = currentState = childContainerState == null ? (short)0 : childContainerState.getState();
                if (start && currentState != 3) {
                    this.m_context.scheduleTask((Runnable)child, info.getPerformActionAtDate());
                } else if (!start && currentState == 3) {
                    child.deactivate((short)1);
                }
                this.updateSchedule(info);
            }
        }
    }

    private void updateSchedule(ScheduleInfo info) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(info.getPerformActionAtDate());
        if (info.getOccursType() == -1L) {
            Date nextDate = this.getCorrectDOM(info);
            info.setPerformActionAtDate(nextDate);
        } else if (info.getOccursType() == -2L) {
            cal.add(1, 1);
            info.setPerformActionAtDate(cal.getTime());
        } else {
            if (info.getOccursType() == 604800000L) {
                cal.add(3, 1);
            } else {
                cal.add(6, 1);
            }
            info.setPerformActionAtDate(new Date(cal.getTimeInMillis()));
        }
        info.getBackToDesiredHour();
    }

    private Date getCorrectDOM(ScheduleInfo info) {
        GregorianCalendar cal = new GregorianCalendar();
        int origDate = info.getOriginalSchDate();
        int maxForNextMonth = info.getMaxForNextMonth();
        cal.setTime(info.getPerformActionAtDate());
        if (maxForNextMonth < origDate) {
            cal.set(5, maxForNextMonth);
            cal.add(2, 1);
        } else {
            cal.set(5, 1);
            cal.add(2, 1);
            cal.set(5, origDate);
        }
        return cal.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed() {
        Object object = this.m_schedulerLockObj;
        synchronized (object) {
            this.m_schedulerLockObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Object object = this.m_schedulerLockObj;
        synchronized (object) {
            while (!this.isInterrupted()) {
                this.runSchedules();
                GregorianCalendar date = new GregorianCalendar();
                date.set(14, 0);
                long delta = (60 - date.get(13)) * 1000;
                try {
                    if (delta <= 0L) continue;
                    this.m_schedulerLockObj.wait(delta);
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
            return;
        }
    }
}

