/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.upgrade;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.upgrade.IMigrationProcess;
import com.sonicsw.mf.common.config.upgrade.IVersionedDomainManagerUpgrade;
import com.sonicsw.mf.common.config.upgrade.UpgradeEnv;
import com.sonicsw.mf.common.config.upgrade.VersionedDomainManager;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import java.io.File;
import java.util.HashMap;

public class DomainManager75
extends VersionedDomainManager
implements IVersionedDomainManagerUpgrade,
IMigrationProcess {
    static String SERVICE_TYPE_FOLDER = "/System/SonicESB/properties/servicetypes";
    static String[] INSTALL_SERVICE_TYPE_FILES = new String[]{"AsynchServiceType", "BPELServiceType", "BPEType", "CBRType", "DatabaseServiceType", "DropService", "PickupService", "PrototypeService", "SOAPUnwrapComponentType", "SplitJoinForEach", "SplitJoinParallel", "SplitterService", "TerminateStepServiceType", "VerificationServiceType", "WMQJMSListener", "WMQJMSSender", "WSInvocationComponentType", "XFORMType", "XMLServiceType"};

    @Override
    public String upgrade(UpgradeEnv env) throws Exception {
        String result = super.upgrade(env);
        this.deleteFTFiles();
        this.createDomainElement();
        this.copyServiceTypes();
        return result;
    }

    @Override
    public String getUpgradedReleaseVersion() {
        return "103";
    }

    @Override
    public String getProductVersion() {
        return "7.5";
    }

    private void deleteFTFiles() {
        File backup;
        String hostDir = (String)this.m_upgradeEnv.getProp("ds.working.dir");
        boolean deleted = false;
        String separator = System.getProperty("file.separator");
        File hostDirFile = new File(hostDir);
        File primary = new File(hostDirFile + separator + this.m_upgradeEnv.dsAdmin.getDomain() + separator + "primary");
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println("DomainManager75.deleteFTFiles primary file == " + primary.toString());
        }
        if (primary.exists()) {
            if (this.m_upgradeEnv.isDEBUG()) {
                System.out.println("DomainManager75.deleteFTFiles primary exists");
            }
            if (!(deleted = primary.delete()) && this.m_upgradeEnv.isDEBUG()) {
                System.out.println("DomainManager75.deleteFTFiles primary file was not deleted");
            }
        }
        if ((backup = new File(hostDirFile + separator + this.m_upgradeEnv.dsAdmin.getDomain() + separator + "backup")).exists()) {
            backup.delete();
        }
    }

    private void createDomainElement() throws DirectoryServiceException, ConfigException {
        Reference authDomainRef;
        IAttributeSet topSet;
        try {
            this.m_upgradeEnv.dsAdmin.createDirectory("/domain");
        }
        catch (DirectoryServiceException e) {
            // empty catch block
        }
        IDirElement domainElement = this.m_upgradeEnv.dsAdmin.getElement("/domain/domain", true);
        if (domainElement == null) {
            domainElement = ElementFactory.createElement("/domain/domain", "MF_DOMAIN", "103");
        }
        if ((topSet = domainElement.getAttributes()).getAttribute("DEFAULT_MANAGEMENT_AUDIT_CONFIG") == null) {
            topSet.setStringAttribute("DEFAULT_MANAGEMENT_AUDIT_CONFIG", "sonicfs:///Security/DefaultAuditDestinations.xml");
        }
        if ((authDomainRef = (Reference)topSet.getAttribute("AUTHENTICATION_DOMAIN")) != null && authDomainRef.getElementName().length() == 0) {
            topSet.deleteAttribute("AUTHENTICATION_DOMAIN");
        }
        this.m_upgradeEnv.dsAdmin.setElement(domainElement.doneUpdate(), null);
    }

    void copyServiceTypes() throws DirectoryServiceException {
        HashMap[] serviceTypes75 = null;
        HashMap[] serviceTypes70 = null;
        try {
            serviceTypes75 = this.m_upgradeEnv.dsFileSystem.listFSAll("/System/SonicESB/7.5/properties/servicetypes");
        }
        catch (DirectoryServiceException dirE) {
            // empty catch block
        }
        try {
            serviceTypes70 = this.m_upgradeEnv.dsFileSystem.listFSAll("/System/SonicESB/7.0/properties/servicetypes");
        }
        catch (DirectoryServiceException directoryServiceException) {
            // empty catch block
        }
        if (serviceTypes75 != null && serviceTypes75.length > 0 || serviceTypes70 != null && serviceTypes70.length > 0) {
            this.m_upgradeEnv.dsFileSystem.createFolder("/System", true);
            this.m_upgradeEnv.dsFileSystem.createFolder("/System/SonicESB", true);
            this.m_upgradeEnv.dsFileSystem.createFolder("/System/SonicESB/properties", true);
            this.m_upgradeEnv.dsFileSystem.createFolder("/System/SonicESB/properties/servicetypes", true);
        }
        if (serviceTypes75 != null) {
            this.copyServiceTypesHelper(serviceTypes75);
        }
        if (serviceTypes70 != null) {
            this.copyServiceTypesHelper(serviceTypes70);
        }
    }

    void copyServiceTypesHelper(HashMap[] serviceTypes) throws DirectoryServiceException {
        for (int i = 0; i < serviceTypes.length; ++i) {
            boolean isInstallFile = false;
            HashMap elMap = serviceTypes[i];
            IElementIdentity elID = (IElementIdentity)elMap.get("_ELEMENT_IDENTITY");
            String elName = elID.getName();
            String fileName = elName.substring(elName.lastIndexOf(47) + 1);
            String fileNameBase = fileName.substring(0, fileName.lastIndexOf("."));
            if (this.m_upgradeEnv.isDEBUG()) {
                System.out.println("ConfigUpgrade.copyServiceTypesHelper examines base " + fileNameBase);
            }
            for (int j = 0; j < INSTALL_SERVICE_TYPE_FILES.length; ++j) {
                if (!fileNameBase.equals(INSTALL_SERVICE_TYPE_FILES[j]) && !fileNameBase.equals(INSTALL_SERVICE_TYPE_FILES[j] + "24x24")) continue;
                isInstallFile = true;
                if (!this.m_upgradeEnv.isDEBUG()) break;
                System.out.println("ConfigUpgrade.copyServiceTypesHelper: It is an install file");
                break;
            }
            if (isInstallFile) continue;
            String cloneFileID = SERVICE_TYPE_FOLDER + '/' + fileName;
            if (this.m_upgradeEnv.dsFileSystem.getFSElement(cloneFileID, false) == null) {
                this.m_upgradeEnv.dsFileSystem.cloneFSBlob(elName, cloneFileID);
                HashMap<String, String> metaAttributes = this.m_upgradeEnv.dsFileSystem.getMetaAttributes(cloneFileID);
                if (metaAttributes == null) {
                    metaAttributes = new HashMap<String, String>();
                }
                metaAttributes.put("TOOL_ATTRIBUTES", "TYPE=MF_FILE");
                this.m_upgradeEnv.dsFileSystem.setMetaAttributes(cloneFileID, metaAttributes);
                if (this.m_upgradeEnv.isDEBUG()) {
                    System.out.println("ConfigUpgrade.copyServiceTypesHelper: It is not an install file, so copying " + elName + " to " + cloneFileID);
                }
            }
            if (!this.m_upgradeEnv.isDEBUG()) continue;
            System.out.println("ConfigUpgrade.copyServiceTypesHelper: It is not an install file, bu not copying because it has already been copied " + cloneFileID);
        }
    }
}

