/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.upgrade;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeMetaData;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.upgrade.IMigrationProcess;
import com.sonicsw.mf.common.config.upgrade.IVersionedConfigUpgrade;
import com.sonicsw.mf.common.config.upgrade.UpgradeEnv;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.StringTokenizer;

public class TypedConfigUpgrade80
implements IVersionedConfigUpgrade,
IMigrationProcess {
    private UpgradeEnv m_upgradeEnv = null;
    private HashMap<String, Boolean> m_ftdValues = new HashMap();

    @Override
    public String basicConfigUpgrade(IDirElement el, UpgradeEnv env) throws Exception {
        return null;
    }

    @Override
    public String getUpgradedReleaseVersion() {
        return "105";
    }

    @Override
    public String upgradeMF_ACTIVATION_DAEMON(IDirElement daemon, UpgradeEnv env) throws Exception {
        return null;
    }

    @Override
    public String upgradeMF_AGENT_MANAGER(IDirElement agentManager, UpgradeEnv env) throws Exception {
        return null;
    }

    @Override
    public String upgradeMF_BACKUP_DIRECTORY_SERVICE(IDirElement backupElement, UpgradeEnv env) throws Exception {
        return null;
    }

    @Override
    public String upgradeMF_COLLECTION_MONITOR(IDirElement monitor, UpgradeEnv env) throws Exception {
        return null;
    }

    @Override
    public String upgradeMF_HOST_MANAGER(IDirElement hostmanager, UpgradeEnv env) throws Exception {
        return null;
    }

    @Override
    public String upgradeMF_CONTAINER(IDirElement container, UpgradeEnv env) throws Exception {
        this.upgradeContainerMetrics(container, env);
        this.upgradeComponentMetrics(container, env);
        return null;
    }

    @Override
    public String upgradeMF_DIRECTORY_SERVICE(IDirElement dsElement, UpgradeEnv env) throws Exception {
        return null;
    }

    @Override
    public String upgradeMF_LOGGER(IDirElement logger, UpgradeEnv env) throws Exception {
        this.m_upgradeEnv = env;
        IAttributeSet topSet = logger.getAttributes();
        IAttributeSet product_information = (IAttributeSet)topSet.getAttribute("PRODUCT_INFORMATION");
        IAttributeMetaData pi_metadata = topSet.getAttributeMetaData("PRODUCT_INFORMATION");
        if (!(pi_metadata != null && pi_metadata.isFromTemplate() || product_information == null)) {
            topSet.deleteAttribute("PRODUCT_INFORMATION");
        }
        return null;
    }

    @Override
    public String upgradeMQ_BROKER(IDirElement broker, UpgradeEnv env) throws Exception {
        this.m_upgradeEnv = env;
        IAttributeSet topSet = broker.getAttributes();
        IAttributeSet sslSet = (IAttributeSet)topSet.getAttribute("BROKER_SSL_PARAMETERS");
        IAttributeMetaData sslMetaData = topSet.getAttributeMetaData("BROKER_SSL_PARAMETERS");
        if (!(sslMetaData != null && sslMetaData.isFromTemplate() || sslSet == null)) {
            String ciphersSet = (String)sslSet.getAttribute("SSL_CIPHER_SUITES");
            String newCiphersSet = "";
            IAttributeMetaData cipherMeta = sslSet.getAttributeMetaData("SSL_CIPHER_SUITES");
            if (!(cipherMeta != null && cipherMeta.isFromTemplate() || ciphersSet == null)) {
                if (this.m_upgradeEnv.isDEBUG()) {
                    System.out.println("TypesConfigUpgrade80.migrateToJSSE original ciphers " + ciphersSet);
                }
                StringTokenizer cipherTokenizer = new StringTokenizer(ciphersSet, ",");
                while (cipherTokenizer.hasMoreTokens()) {
                    String cipher = cipherTokenizer.nextToken();
                    if (newCiphersSet.indexOf(cipher) >= 0) continue;
                    newCiphersSet = newCiphersSet + "," + cipher;
                }
                if (newCiphersSet.indexOf(",") > 0) {
                    newCiphersSet = newCiphersSet.substring(newCiphersSet.indexOf(",") + 1);
                }
                sslSet.setStringAttribute("SSL_CIPHER_SUITES", newCiphersSet);
            }
        }
        IAttributeSet refs = (IAttributeSet)topSet.getAttribute("CONFIG_ELEMENT_REFERENCES");
        Reference clusterRef = null;
        if (refs != null) {
            clusterRef = (Reference)refs.getAttribute("CLUSTER_CONFIG_ELEMENT_REF");
        }
        if (clusterRef != null) {
            boolean pubsubFromTemplate;
            IAttributeMetaData clusterMetaData = refs.getAttributeMetaData("CLUSTER_CONFIG_ELEMENT_REF");
            boolean clusterFromTemplate = clusterMetaData != null && clusterMetaData.isFromTemplate();
            IAttributeSet pubsub = (IAttributeSet)topSet.getAttribute("BROKER_PUBSUB_PARAMETERS");
            IAttributeMetaData pubsubMetaData = topSet.getAttributeMetaData("BROKER_PUBSUB_PARAMETERS");
            boolean bl = pubsubFromTemplate = pubsubMetaData != null && pubsubMetaData.isFromTemplate();
            if (!(clusterFromTemplate && pubsubFromTemplate || pubsub == null)) {
                this.m_ftdValues.put(broker.getIdentity().getName(), (Boolean)pubsub.getAttribute("FLOW_TO_DISK"));
                pubsub.setBooleanAttribute("FLOW_TO_DISK", Boolean.FALSE);
            }
        }
        return null;
    }

    @Override
    public String upgradeMQ_CLUSTER(IDirElement cluster, UpgradeEnv env) throws Exception {
        boolean flowToDisk = false;
        IAttributeSet topSet = cluster.getAttributes();
        IAttributeSet clusterMembers = (IAttributeSet)topSet.getAttribute("CLUSTER_MEMBERS");
        IAttributeMetaData membersMetaData = topSet.getAttributeMetaData("CLUSTER_MEMBERS");
        if (membersMetaData == null || !membersMetaData.isFromTemplate()) {
            Collection memberRefs = clusterMembers.getAttributes().values();
            for (Reference ref : memberRefs) {
                Boolean ftd = this.m_ftdValues.get(ref.getElementName());
                if (ftd != null && ftd.booleanValue()) {
                    flowToDisk = true;
                    break;
                }
                IDirElement broker = env.dsFileSystem.getFSElement(ref.getElementName(), false);
                IAttributeSet pubSub = (IAttributeSet)broker.getAttributes().getAttribute("BROKER_PUBSUB_PARAMETERS");
                if (pubSub == null || (ftd = (Boolean)pubSub.getAttribute("FLOW_TO_DISC")) == null || !ftd.booleanValue()) continue;
                flowToDisk = true;
                break;
            }
            topSet.setBooleanAttribute("CLUSTER_FLOW_TO_DISK", flowToDisk);
        }
        return null;
    }

    @Override
    public String upgradeXQ_CONTAINER(IDirElement xqContainer, UpgradeEnv env) throws Exception {
        return null;
    }

    private void upgradeContainerMetrics(IDirElement container, UpgradeEnv env) throws ConfigException {
        this.modifyMetrics(container.getAttributes());
    }

    private void upgradeComponentMetrics(IDirElement container, UpgradeEnv env) throws ConfigException {
        IAttributeSet topSet = container.getAttributes();
        IAttributeSet componentsSet = (IAttributeSet)topSet.getAttribute("COMPONENTS");
        if (componentsSet != null && !componentsSet.getAttributes().isEmpty()) {
            for (String componentName : componentsSet.getAttributes().keySet()) {
                IAttributeSet componentSet = (IAttributeSet)componentsSet.getAttribute(componentName);
                this.modifyMetrics(componentSet);
            }
        }
    }

    private void modifyMetrics(IAttributeSet parentSet) throws ConfigException {
        IAttributeSet existingMetrics = (IAttributeSet)parentSet.getAttribute("ENABLED_METRICS");
        if (existingMetrics != null) {
            HashMap<String, IAttributeSet> enabledAlerts = new HashMap<String, IAttributeSet>();
            HashMap enabledMetrics = existingMetrics.getAttributes();
            parentSet.deleteAttribute("ENABLED_METRICS");
            IAttributeSet newMetrics = parentSet.createAttributeSet("ENABLED_METRICS");
            for (String metric : enabledMetrics.keySet()) {
                String withoutStar;
                IAttributeSet thresholds = (IAttributeSet)enabledMetrics.get(metric);
                if (!thresholds.getAttributes().isEmpty()) {
                    enabledAlerts.put(metric, thresholds);
                }
                if (metric.endsWith("*") && newMetrics.getAttribute(withoutStar = metric.substring(0, metric.length() - 2)) != null) {
                    newMetrics.deleteAttribute(withoutStar);
                }
                if (newMetrics.getAttribute(metric + ".*") != null) continue;
                newMetrics.setStringAttribute(metric, metric);
            }
            IAttributeSet newEnabledAlerts = null;
            if (!enabledAlerts.isEmpty()) {
                newEnabledAlerts = parentSet.createAttributeSet("ENABLED_ALERTS");
                for (String alert : enabledAlerts.keySet()) {
                    IAttributeSet thresholds = (IAttributeSet)enabledAlerts.get(alert);
                    IAttributeSet indivAlert = newEnabledAlerts.createAttributeSet(alert);
                    String threshold = null;
                    threshold = (String)thresholds.getAttribute("HIGH_THRESHOLDS");
                    if (threshold != null) {
                        indivAlert.setStringAttribute("HIGH_THRESHOLDS", threshold);
                    }
                    if ((threshold = (String)thresholds.getAttribute("LOW_THRESHOLDS")) == null) continue;
                    indivAlert.setStringAttribute("LOW_THRESHOLDS", threshold);
                }
            }
        }
    }
}

