/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.metrics.manager.impl;

import com.sonicsw.mf.common.metrics.manager.IHistoricalStatistic;
import com.sonicsw.mf.common.metrics.manager.StatisticsFactory;
import com.sonicsw.mf.common.metrics.manager.impl.Statistic;

public class HistoricalStatistic
extends Statistic
implements IHistoricalStatistic {
    protected long[] m_historyValues;
    protected int m_beginIndex = -1;
    protected int m_endIndex;
    protected boolean m_newHistory = true;
    protected IHistoricalStatistic m_updateCountsStatistic;
    private boolean DEBUG = false;

    public HistoricalStatistic(short updateMode, boolean intervalMode, boolean saveUpdateCounts) {
        super(updateMode, intervalMode);
        if (saveUpdateCounts) {
            this.m_updateCountsStatistic = (IHistoricalStatistic)StatisticsFactory.createStatistic((short)0, true, null, (short)1);
        }
    }

    @Override
    public synchronized long getCurrencyTimestamp() {
        return this.m_currencyTimestamp;
    }

    @Override
    public synchronized long[] getLastValues() {
        if (this.m_historyValues == null) {
            throw new IllegalStateException("Number of values not yet set.");
        }
        if (this.m_beginIndex < 0) {
            return null;
        }
        long[] values = null;
        if (this.m_beginIndex > this.m_endIndex) {
            int tailCount = this.m_historyValues.length - this.m_beginIndex;
            int headCount = this.m_endIndex + 1;
            values = new long[tailCount + headCount];
            System.arraycopy(this.m_historyValues, this.m_beginIndex, values, 0, tailCount);
            System.arraycopy(this.m_historyValues, 0, values, tailCount, headCount);
        } else if (this.m_beginIndex < this.m_endIndex) {
            int count = this.m_endIndex - this.m_beginIndex + 1;
            values = new long[count];
            System.arraycopy(this.m_historyValues, this.m_beginIndex, values, 0, count);
        } else {
            values = new long[]{this.m_historyValues[this.m_beginIndex]};
        }
        return values;
    }

    @Override
    public long[] getLastUpdateCounts() {
        if (this.m_updateCountsStatistic == null) {
            return null;
        }
        return this.m_updateCountsStatistic.getLastValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNumValues(int numValues) {
        if (numValues < 2) {
            throw new IllegalArgumentException("Number of values must be > 1.");
        }
        if (this.DEBUG) {
            System.out.println(System.currentTimeMillis() + " (" + this.m_name + ") HistoricalStatistic: setNumValues = " + numValues);
        }
        HistoricalStatistic historicalStatistic = this;
        synchronized (historicalStatistic) {
            this.m_endIndex = -1;
            this.m_beginIndex = -1;
            this.m_historyValues = new long[numValues];
            if (this.m_updateCountsStatistic != null) {
                this.m_updateCountsStatistic.setNumValues(numValues);
            }
            this.m_currentIntervalValue = this.m_lastIntervalValue = this.m_initialValue;
            this.m_currencyTimestamp = -1L;
            this.m_lastCurrencyTimestamp = -1L;
            this.m_newHistory = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        if (this.m_historyValues == null) {
            throw new IllegalStateException("Number of values not yet set.");
        }
        HistoricalStatistic historicalStatistic = this;
        synchronized (historicalStatistic) {
            super.refresh();
            if (this.m_updateCountsStatistic != null) {
                this.m_updateCountsStatistic.updateValue(this.getLastUpdateCount());
                this.m_updateCountsStatistic.refresh();
            }
            if (this.m_updateMode == 3 || this.m_updateMode == 4) {
                this.m_currentUpdateValue = this.m_lastUpdateValue;
            }
            if (this.m_newHistory) {
                this.m_newHistory = false;
                return;
            }
            if (this.m_beginIndex > this.m_endIndex) {
                --this.m_beginIndex;
                --this.m_endIndex;
                if (this.m_endIndex < 0) {
                    this.m_endIndex = this.m_historyValues.length - 1;
                }
            } else if (this.m_beginIndex == -1) {
                this.m_beginIndex = this.m_endIndex = this.m_historyValues.length - 1;
            } else {
                --this.m_beginIndex;
                if (this.m_beginIndex < 0) {
                    this.m_beginIndex = this.m_historyValues.length - 1;
                    --this.m_endIndex;
                    if (this.DEBUG) {
                        System.out.println(" HistoricalStatistic.refresh *** Collection interval complete!! " + this.m_name);
                        this.printValues();
                    }
                }
            }
            this.m_historyValues[this.m_beginIndex] = this.getLastValue();
        }
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.m_currentIntervalValue = this.m_lastIntervalValue = this.m_currentUpdateValue;
        if (this.m_historyValues != null) {
            this.setNumValues(this.m_historyValues.length);
        }
    }

    synchronized void printValues() {
        System.out.println(System.currentTimeMillis() + " (" + this.m_name + ") History values: begin = " + this.m_beginIndex + " end = " + this.m_endIndex);
        String values = " ";
        for (int i = 0; i < this.m_historyValues.length; ++i) {
            if ((values = values + " " + this.m_historyValues[i]).length() <= 72) continue;
            System.out.println(values);
            values = " ";
        }
        System.out.println(values);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.m_updateCountsStatistic != null) {
            ((Statistic)((Object)this.m_updateCountsStatistic)).m_name = "Count for " + this.m_name;
        }
    }

    @Override
    public String toString() {
        return "HistoricalStatistic@" + Integer.toHexString(this.hashCode()) + ": name=" + this.m_name + ", updateMode=" + this.m_updateMode + ", intervalMode=" + this.m_intervalMode;
    }
}

