/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.metrics.manager.impl;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.metrics.IAlert;
import com.sonicsw.mf.common.metrics.IMetric;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.IMetricsData;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.impl.Alert;
import com.sonicsw.mf.common.metrics.impl.Metric;
import com.sonicsw.mf.common.metrics.impl.MetricIdentity;
import com.sonicsw.mf.common.metrics.impl.MetricInfo;
import com.sonicsw.mf.common.metrics.manager.IHistoricalStatistic;
import com.sonicsw.mf.common.metrics.manager.IMetricAnalyzer;
import com.sonicsw.mf.common.metrics.manager.IMetricsManager;
import com.sonicsw.mf.common.metrics.manager.IMetricsRegistrar;
import com.sonicsw.mf.common.metrics.manager.ISampledStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatisticProvider;
import com.sonicsw.mf.common.metrics.manager.impl.Average;
import com.sonicsw.mf.common.metrics.manager.impl.Count;
import com.sonicsw.mf.common.metrics.manager.impl.HistoricalSampledStatistic;
import com.sonicsw.mf.common.metrics.manager.impl.HistoricalStatistic;
import com.sonicsw.mf.common.metrics.manager.impl.Maximum;
import com.sonicsw.mf.common.metrics.manager.impl.Minimum;
import com.sonicsw.mf.common.metrics.manager.impl.PeakRate;
import com.sonicsw.mf.common.metrics.manager.impl.Rate;
import com.sonicsw.mf.common.metrics.manager.impl.Total;
import com.sonicsw.mf.common.metrics.manager.impl.Value;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.sdf.AbstractDiagnosticsProvider;
import com.sonicsw.sdf.DiagnosticsManagerAccess;
import com.sonicsw.sdf.IDiagnosticsManager;
import com.sonicsw.sdf.IStateWriter;
import com.sonicsw.sdf.ITracer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetricsManager
implements IMetricsManager,
IMetricsRegistrar {
    private static final int SDF_TRACE_NOTHING = 0;
    private static final int SDF_TRACE_VERBOSE = 1;
    private static final int SDF_TRACE_REGISTRATION_COUNTS = 2;
    private static final String SDF_DOIID_STATISTICS = "Statistics";
    private static final String SDF_DOIID_METRICS = "Metrics";
    public static int m_sdfStatisticsTraceMask = 0;
    public static int m_sdfMetricsTraceMask = 0;
    private long m_statisticRegistrations = -1L;
    private long m_statisticUnregistrations = 0L;
    private long m_metricRegistrations = 0L;
    private long m_metricUnregistrations = 0L;
    private static HashSet m_metricsManagers = new HashSet();
    private static IDiagnosticsManager m_diagnosticsManager;
    private static MetricsManagerDiagnostics m_metricsManagerDiagnostics;
    private static boolean DEBUG_CONFIG;
    private static boolean DEBUG_METRICS;
    private static boolean DEBUG_STATS;
    private static boolean DEBUG_ALERTS;
    private static boolean DEBUG_AGENT;
    private static String METRICID_NONNULL;
    private static String STATISTIC_NONNULL;
    private IComponentContext m_mfContext;
    private String m_componentName = "";
    private boolean m_isAgent;
    private boolean m_isClosing = false;
    protected HashMap m_metricInfos = new HashMap();
    protected HashMap m_activeMetrics = new HashMap();
    protected HashSet m_statistics = new HashSet();
    protected HashSet m_enabledMetricsPatterns = new HashSet();
    protected HashMap m_enabledAlerts = new HashMap();
    protected HashSet m_activeAlerts = new HashSet();
    protected HashSet m_idleAlerts = new HashSet();
    protected long m_currentMetricId = 0L;
    private Map m_alertNotificationAttributes = null;
    private short m_alertNotificationCategory = 0;
    protected long m_currencyTimestamp;
    protected HistoricalStatistic m_elapsedCollectionTimeStatistic;
    protected IMetricAnalyzer m_elapsedCollectionTimeAnalyzer;
    protected Timer m_intervalTimer;
    protected static final long MIN_REFRESH_INTERVAL = 5000L;
    protected static final long MAX_REFRESH_INTERVAL = 900000L;
    protected static final long MIN_COLLECTION_INTERVAL = 60000L;
    protected static final long MAX_COLLECTION_INTERVAL = 86400000L;
    protected static final int MAX_HISTORY_VALUES = 250;
    protected long m_refreshInterval = 20000L;
    protected long m_collectionInterval = 600000L;
    protected boolean m_repeatAlerts = false;
    protected int m_numHistoricalValues = (int)(this.m_collectionInterval / this.m_refreshInterval);
    protected static final IMetricInfo[] EMPTY_INFO_ARRAY;
    protected static final IMetric[] EMPTY_METRIC_ARRAY;
    protected static final IAlert[] EMPTY_ALERT_ARRAY;
    protected IMetricAnalyzer[] m_defaultAnalyzers = new IMetricAnalyzer[14];

    public MetricsManager(IMetricInfo[] metricInfos) {
        for (int i = 0; i < metricInfos.length; ++i) {
            if (DEBUG_CONFIG) {
                System.out.println("MetricsManager " + metricInfos[i]);
            }
            this.m_metricInfos.put(metricInfos[i].getMetricIdentity(), metricInfos[i]);
            if (metricInfos[i].isDynamic()) continue;
            this.m_enabledMetricsPatterns.add(metricInfos[i].getMetricIdentity());
        }
        m_metricsManagers.add(this);
    }

    @Override
    public synchronized void init(IComponentContext mfContext) {
        if (this.m_mfContext != null) {
            throw new IllegalStateException("Context already set");
        }
        this.m_mfContext = mfContext;
        this.m_componentName = this.m_mfContext.getComponentName().getComponentName();
        this.m_isAgent = this.m_componentName.equals("AGENT");
        this.m_elapsedCollectionTimeAnalyzer = this.getMetricAnalyzer((short)2);
        this.m_elapsedCollectionTimeStatistic = new HistoricalSampledStatistic(0, true, false, new IStatisticProvider[]{new IStatisticProvider(){

            @Override
            public void updateStatistic(ISampledStatistic statistic) {
                statistic.updateValue(System.currentTimeMillis());
            }

            @Override
            public void resetStatistic(ISampledStatistic statistic) {
                statistic.updateValue(System.currentTimeMillis());
            }
        }});
        this.m_elapsedCollectionTimeStatistic.m_name = "TimeKeeper";
        this.registerStatistic(this.m_elapsedCollectionTimeStatistic);
    }

    @Override
    public synchronized void cleanup() {
        m_metricsManagers.remove(this);
        this.m_isClosing = true;
        if (this.m_intervalTimer != null) {
            this.m_intervalTimer.cancel();
        }
        this.m_activeMetrics.clear();
        this.m_statistics.clear();
        this.m_enabledMetricsPatterns.clear();
        this.m_enabledAlerts.clear();
        this.m_activeAlerts.clear();
        if (this.m_alertNotificationAttributes != null) {
            this.m_alertNotificationAttributes.clear();
        }
    }

    @Override
    public void registerAlertNotificationProperties(short category, Map attributes) {
        this.m_alertNotificationCategory = category;
        this.m_alertNotificationAttributes = attributes;
    }

    public int getStatisticCount() {
        return this.m_statistics.size();
    }

    @Override
    public IMetricInfo[] getMetricsInfo() {
        return this.internalGetMetricsInfo(false);
    }

    @Override
    public synchronized IMetricsData getMetricsData(IMetricIdentity[] ids, Boolean getTriggeredAlerts) {
        return this.internalGetMetricsData(ids, getTriggeredAlerts, false);
    }

    @Override
    public synchronized IMetricIdentity[] getActiveMetrics(IMetricIdentity[] ids) {
        return this.internalGetActiveMetrics(ids, false);
    }

    @Override
    public synchronized void resetMetrics() {
        if (DEBUG_STATS && (DEBUG_AGENT || !this.m_isAgent)) {
            System.out.println(System.currentTimeMillis() + " [" + this.m_componentName + "] *** MetricsManager.resetMetrics");
        }
        if (this.m_isClosing) {
            return;
        }
        for (IStatistic statistic : this.m_statistics) {
            statistic.reset();
            if (!(statistic instanceof ISampledStatistic)) continue;
            IStatisticProvider[] providers = ((ISampledStatistic)statistic).getStatisticProviders();
            for (int i = 0; i < providers.length; ++i) {
                providers[i].resetStatistic((ISampledStatistic)statistic);
            }
        }
        this.startRefreshing();
    }

    @Override
    public synchronized IMetricIdentity[] getEnabledMetrics(IMetricIdentity[] ids) {
        return this.internalGetEnabledMetrics(ids, false);
    }

    @Override
    public synchronized boolean isInstanceEnabled(IMetricIdentity id) {
        if (id == null) {
            throw new IllegalArgumentException(METRICID_NONNULL);
        }
        IMetricIdentity[] idPatterns = this.m_enabledMetricsPatterns.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
        for (int i = 0; i < idPatterns.length; ++i) {
            if (idPatterns[i] == null || !id.isInstanceOf(idPatterns[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IAlert[] getEnabledAlerts(IMetricIdentity[] ids) {
        ArrayList retAlerts = new ArrayList();
        for (IMetricIdentity id : this.m_enabledAlerts.keySet()) {
            Set alerts;
            boolean check = false;
            if (ids == null) {
                check = true;
            } else {
                for (int i = 0; i < ids.length; ++i) {
                    if (!id.isInstanceOf(ids[i])) continue;
                    check = true;
                }
            }
            if (!check || (alerts = (Set)this.m_enabledAlerts.get(id)) == null) continue;
            Iterator it1 = alerts.iterator();
            while (it1.hasNext()) {
                retAlerts.add(it1.next());
            }
        }
        if (DEBUG_ALERTS) {
            System.out.println("[" + this.m_componentName + "] Active Alerts:");
            HashSet hashSet = this.m_activeAlerts;
            synchronized (hashSet) {
                Iterator it1 = this.m_activeAlerts.iterator();
                while (it1.hasNext()) {
                    System.out.println((IAlert)it1.next());
                }
            }
        }
        return retAlerts.toArray(EMPTY_ALERT_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAlert[] getActiveAlerts() {
        ArrayList retAlerts = new ArrayList();
        HashSet hashSet = this.m_activeAlerts;
        synchronized (hashSet) {
            Iterator it = this.m_activeAlerts.iterator();
            while (it.hasNext()) {
                retAlerts.add(it.next());
            }
        }
        return retAlerts.toArray(EMPTY_ALERT_ARRAY);
    }

    @Override
    public synchronized IAlert[] enableAlerts(IAlert[] enableAlerts) {
        if (enableAlerts == null) {
            throw new IllegalArgumentException("List of alerts cannot be null");
        }
        if (this.m_isClosing) {
            return EMPTY_ALERT_ARRAY;
        }
        ArrayList<IAlert> retEnabled = new ArrayList<IAlert>();
        for (int i = 0; i < enableAlerts.length; ++i) {
            IMetricIdentity id = enableAlerts[i].getMetricIdentity();
            if (this.getMetricNodeId(id) == null || this.isInstancePattern(id)) continue;
            IMetricInfo info = this.getMetricInfo(id);
            if (enableAlerts[i].isHighThreshold() && !info.supportsHighThresholdAlerts() || !enableAlerts[i].isHighThreshold() && !info.supportsLowThresholdAlerts()) continue;
            HashSet<IAlert> alerts = (HashSet<IAlert>)this.m_enabledAlerts.get(id);
            if (alerts == null) {
                alerts = new HashSet<IAlert>();
                this.m_enabledAlerts.put(id, alerts);
                if (DEBUG_ALERTS) {
                    System.out.println("[" + this.m_componentName + "] Enabling alert " + id);
                }
            }
            if (this.matchAlert(alerts, enableAlerts[i]) == null) {
                alerts.add(enableAlerts[i]);
                if (!info.isInstanceMetric()) {
                    this.activateAlert(enableAlerts[i]);
                    if (DEBUG_ALERTS) {
                        System.out.println("[" + this.m_componentName + "] Activating alert " + enableAlerts[i]);
                    }
                } else {
                    IMetricIdentity[] instances = this.getActiveInstanceMetrics(new IMetricIdentity[]{id});
                    for (int c = 0; c < instances.length; ++c) {
                        IAlert childAlert = MetricsFactory.createAlert(instances[c], enableAlerts[i].isHighThreshold(), enableAlerts[i].getThresholdValue());
                        this.activateAlert(childAlert);
                        if (!DEBUG_ALERTS) continue;
                        System.out.println("[" + this.m_componentName + "] Activating alert " + childAlert);
                    }
                }
            }
            retEnabled.add(enableAlerts[i]);
        }
        return retEnabled.toArray(EMPTY_ALERT_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateAlert(IAlert alert) {
        HashSet hashSet = this.m_activeAlerts;
        synchronized (hashSet) {
            if (this.matchAlert(this.m_activeAlerts, alert) == null) {
                IAlert otherAlert;
                if (DEBUG_ALERTS) {
                    System.out.println("[" + this.m_componentName + "] Activating " + alert);
                }
                if (!this.m_repeatAlerts && (otherAlert = this.matchMetricIdentity(this.m_activeAlerts, alert)) != null) {
                    this.m_activeAlerts.remove(otherAlert);
                    this.m_idleAlerts.add(otherAlert);
                }
                this.m_activeAlerts.add(alert);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateAlert(IAlert alert) {
        HashSet hashSet = this.m_activeAlerts;
        synchronized (hashSet) {
            IAlert otherAlert;
            Iterator it = this.m_activeAlerts.iterator();
            while (it.hasNext()) {
                IAlert match = (IAlert)it.next();
                if (!((Alert)match).isInstanceOf(alert)) continue;
                if (DEBUG_ALERTS) {
                    System.out.println("[" + this.m_componentName + "] deactivating " + match);
                }
                it.remove();
            }
            if (!this.m_repeatAlerts && (otherAlert = this.matchMetricIdentity(this.m_idleAlerts, alert)) != null) {
                this.m_idleAlerts.remove(otherAlert);
                this.m_activeAlerts.add(otherAlert);
            }
        }
    }

    @Override
    public synchronized IAlert[] disableAlerts(IAlert[] disableAlerts) {
        if (disableAlerts == null) {
            throw new IllegalArgumentException("List of alerts cannot be null");
        }
        ArrayList retDisabled = new ArrayList();
        for (int i = 0; i < disableAlerts.length; ++i) {
            Set alerts;
            IMetricIdentity id = disableAlerts[i].getMetricIdentity();
            if (this.getMetricNodeId(id) == null || this.isInstancePattern(id) || (alerts = (Set)this.m_enabledAlerts.get(id)) == null) continue;
            IAlert match = this.matchAlert(alerts, disableAlerts[i]);
            if (match != null) {
                if (DEBUG_ALERTS) {
                    System.out.println("[" + this.m_componentName + "] Disabling alert " + match);
                }
                alerts.remove(match);
                this.deactivateAlert(match);
            }
            if (!alerts.isEmpty()) continue;
            this.m_enabledAlerts.remove(id);
        }
        return retDisabled.toArray(EMPTY_ALERT_ARRAY);
    }

    public synchronized IMetricIdentity[][] replaceEnabledMetrics(IMetricIdentity[] metricIds) {
        IMetricIdentity[][] result = new IMetricIdentity[2][];
        IMetricIdentity[] enabledMetricIds = this.getEnabledMetrics(null);
        if (enabledMetricIds.length > 0) {
            ArrayList<IMetricIdentity> disableMetricIdList = new ArrayList<IMetricIdentity>();
            for (int i = 0; i < enabledMetricIds.length; ++i) {
                boolean disable = true;
                for (int j = 0; metricIds != null && j < metricIds.length; ++j) {
                    if (!enabledMetricIds[i].equals(metricIds[j])) continue;
                    disable = false;
                    break;
                }
                if (!disable) continue;
                disableMetricIdList.add(enabledMetricIds[i]);
            }
            result[0] = this.disableMetrics(disableMetricIdList.toArray(new IMetricIdentity[disableMetricIdList.size()]));
        } else {
            result[0] = IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY;
        }
        result[1] = metricIds == null ? IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY : this.enableMetrics(metricIds);
        return result;
    }

    public synchronized IAlert[] replaceEnabledAlerts(IAlert[] alerts) {
        IAlert[] enabledAlerts = this.getEnabledAlerts(null);
        if (enabledAlerts.length > 0) {
            ArrayList<IAlert> disableAlertList = new ArrayList<IAlert>();
            for (int i = 0; i < enabledAlerts.length; ++i) {
                boolean disable = true;
                for (int j = 0; alerts != null && j < alerts.length; ++j) {
                    if (!enabledAlerts[i].equals(alerts[j])) continue;
                    disable = false;
                    break;
                }
                if (!disable) continue;
                disableAlertList.add(enabledAlerts[i]);
            }
            this.disableAlerts(disableAlertList.toArray(new IAlert[disableAlertList.size()]));
        }
        return alerts == null ? EMPTY_ALERT_ARRAY : this.enableAlerts(alerts);
    }

    public synchronized IMetricIdentity[] enableAllMetrics(IMetricIdentity[] ids) {
        return this.internalEnableMetrics(ids, true);
    }

    public synchronized IMetricIdentity[] disableAllMetrics(IMetricIdentity[] ids) {
        return this.internalDisableMetrics(ids, true);
    }

    public IMetricInfo[] getAllMetricsInfo() {
        return this.internalGetMetricsInfo(true);
    }

    public synchronized IMetricIdentity[] getAllEnabledMetrics(IMetricIdentity[] ids) {
        return this.internalGetEnabledMetrics(ids, true);
    }

    public synchronized IMetricIdentity[] getAllActiveMetrics(IMetricIdentity[] ids) {
        return this.internalGetActiveMetrics(ids, true);
    }

    public synchronized IMetricsData getAllMetricsData(IMetricIdentity[] ids, Boolean returnTriggeredAlerts) {
        return this.internalGetMetricsData(ids, returnTriggeredAlerts, true);
    }

    public synchronized IMetricsData getAllMetricsData() {
        return this.internalGetMetricsData(this.m_activeMetrics.values());
    }

    private IMetricIdentity[] getActiveInstanceMetrics(IMetricIdentity[] ids) {
        ArrayList<IMetricIdentity> ret = new ArrayList<IMetricIdentity>();
        for (int i = 0; i < ids.length; ++i) {
            IMetricInfo info = this.getMetricInfo(ids[i]);
            if (!info.isInstanceMetric()) continue;
            for (IMetricIdentity match : this.m_activeMetrics.keySet()) {
                if (!match.isInstanceOf(ids[i])) continue;
                ret.add(match);
            }
        }
        return ret.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
    }

    @Override
    public void registerMetric(IMetricIdentity id, IStatistic statistic) {
        if (id == null) {
            throw new IllegalArgumentException(METRICID_NONNULL);
        }
        if (statistic == null) {
            throw new IllegalArgumentException(STATISTIC_NONNULL);
        }
        IMetricInfo info = this.getMetricInfo(id);
        if (info.isInstanceMetric() && info.getMetricIdentity().equals(id)) {
            throw new IllegalArgumentException("Cannot register an instance metric parent");
        }
        IMetricAnalyzer analyzer = this.getMetricAnalyzer(info.getValueType());
        this.registerMetric(id, analyzer, statistic);
    }

    @Override
    public synchronized void registerMetric(IMetricIdentity id, IMetricAnalyzer analyzer, IStatistic statistic) {
        if (DEBUG_CONFIG || DEBUG_METRICS) {
            System.out.println("[" + this.m_componentName + "] Registering metric " + id + " for statistic = " + statistic + " with analyzer = " + analyzer);
        }
        if (id == null) {
            throw new IllegalArgumentException(METRICID_NONNULL);
        }
        if (statistic == null) {
            throw new IllegalArgumentException(STATISTIC_NONNULL);
        }
        IMetricInfo info = this.getMetricInfo(id);
        if (info.isInstanceMetric() && info.getMetricIdentity().equals(id)) {
            throw new IllegalArgumentException("Cannot register an instance metric parent");
        }
        if (!info.isInstanceMetric() && !info.getMetricIdentity().equals(id)) {
            throw new IllegalArgumentException("Cannot register a metric parent");
        }
        if (this.m_isClosing) {
            return;
        }
        RegisteredMetric existingMetric = (RegisteredMetric)this.m_activeMetrics.get(id);
        if (existingMetric != null) {
            IStatistic existingStatistic = existingMetric.getStatistic();
            if (statistic == existingStatistic) {
                if (DEBUG_CONFIG || DEBUG_METRICS) {
                    System.out.println("[" + this.m_componentName + "] Metric " + id + " already registered with statistic = " + statistic + " - returning");
                }
                return;
            }
            if (DEBUG_CONFIG || DEBUG_METRICS) {
                System.out.println("[" + this.m_componentName + "] Metric " + id + " already registered, but with statistic = " + existingStatistic + " - unregistering existing metric");
            }
            this.unregisterMetric(id, existingStatistic);
        }
        this.registerStatistic(statistic);
        this.m_activeMetrics.put(id, new RegisteredMetric(id, statistic, analyzer, ++this.m_currentMetricId));
        ++this.m_metricRegistrations;
        Set alerts = (Set)this.m_enabledAlerts.get(id);
        if (alerts == null) {
            alerts = (Set)this.m_enabledAlerts.get(this.getMetricNodeId(id));
        }
        if (alerts != null) {
            for (IAlert parent : alerts) {
                IAlert alert = MetricsFactory.createAlert(id, parent.isHighThreshold(), parent.getThresholdValue());
                this.activateAlert(alert);
            }
        }
        if (this.m_intervalTimer == null && !this.m_isClosing) {
            this.startRefreshing();
        }
    }

    public synchronized void registerStatistic(IStatistic stat) {
        if (DEBUG_CONFIG) {
            System.out.println("[" + this.m_componentName + "] Registering statistic " + stat);
        }
        if (stat == null) {
            throw new IllegalArgumentException(STATISTIC_NONNULL);
        }
        if (this.m_isClosing) {
            return;
        }
        if (!this.m_statistics.contains(stat)) {
            if (DEBUG_CONFIG) {
                System.out.println("[" + this.m_componentName + "] Adding statistic " + stat);
            }
            this.m_statistics.add(stat);
            ++this.m_statisticRegistrations;
            if (stat instanceof IHistoricalStatistic && this.m_intervalTimer != null) {
                ((IHistoricalStatistic)stat).setNumValues(this.m_numHistoricalValues);
            }
        } else if (DEBUG_CONFIG) {
            System.out.println("[" + this.m_componentName + "] Statistic " + stat + " already registered");
        }
    }

    public synchronized void unregisterStatistic(IStatistic stat) {
        if (DEBUG_CONFIG) {
            System.out.println("[" + this.m_componentName + "] Unregistering statistic " + stat);
        }
        if (stat == null) {
            throw new IllegalArgumentException(STATISTIC_NONNULL);
        }
        if (this.m_statistics.contains(stat)) {
            boolean found = false;
            Iterator it = this.m_activeMetrics.values().iterator();
            while (it.hasNext()) {
                if (((RegisteredMetric)it.next()).getStatistic() != stat) continue;
                found = true;
                break;
            }
            if (!found) {
                this.m_statistics.remove(stat);
                ++this.m_statisticUnregistrations;
                MetricsManager.m_metricsManagerDiagnostics.traceStatisticRegistrations(this);
                if (DEBUG_CONFIG) {
                    System.out.println("[" + this.m_componentName + "] Removing statistic " + stat);
                }
            } else if (DEBUG_CONFIG) {
                System.out.println("[" + this.m_componentName + "] Statistic " + stat + " still in use");
            }
        } else if (DEBUG_CONFIG) {
            System.out.println("[" + this.m_componentName + "] Statistic " + stat + " not registered");
        }
    }

    private IMetricIdentity getMetricNodeId(IMetricIdentity id) {
        IMetricInfo info = this.getMetricInfo(id);
        if (info == null) {
            return null;
        }
        return info.getMetricIdentity();
    }

    private String getInstanceName(IMetricIdentity id) {
        IMetricInfo info = this.getMetricInfo(id);
        if (info == null || !info.isInstanceMetric() || id.equals(info.getMetricIdentity())) {
            return null;
        }
        String[] components = id.getNameComponents();
        return components[components.length - 1];
    }

    private boolean isInstancePattern(IMetricIdentity id) {
        String instanceName = this.getInstanceName(id);
        if (instanceName == null) {
            return false;
        }
        return this.containsWildcard(instanceName);
    }

    private boolean containsWildcard(String name) {
        String wildcard = "*";
        int index = name.indexOf(wildcard);
        if (index == -1) {
            return false;
        }
        String[] exceptionStrings = new String[]{".*"};
        int[] wildcardPos = new int[exceptionStrings.length];
        for (int i = 0; i < exceptionStrings.length; ++i) {
            wildcardPos[i] = exceptionStrings[i].indexOf(wildcard);
            if (wildcardPos[i] != -1) continue;
            return true;
        }
        StringBuffer buf = new StringBuffer(name);
        boolean isExceptionString = false;
        while (index != -1) {
            isExceptionString = false;
            for (int j = 0; j < wildcardPos.length; ++j) {
                int exceptionIndex;
                int fromIndex = index - wildcardPos[j];
                if (fromIndex < 0 || (exceptionIndex = buf.indexOf(exceptionStrings[j], fromIndex)) + wildcardPos[j] != index) continue;
                isExceptionString = true;
                break;
            }
            if (!isExceptionString) {
                return true;
            }
            if (index == -1 || index >= buf.length()) continue;
            index = buf.indexOf(wildcard, index + 1);
        }
        return index != -1 && !isExceptionString;
    }

    @Override
    public synchronized IMetricIdentity[] enableMetrics(IMetricIdentity[] ids) {
        return this.internalEnableMetrics(ids, false);
    }

    @Override
    public synchronized IMetricIdentity[] disableMetrics(IMetricIdentity[] ids) {
        return this.internalDisableMetrics(ids, false);
    }

    @Override
    public void unregisterMetric(IMetricIdentity id) {
        this.unregisterMetric(id, null);
    }

    @Override
    public synchronized void unregisterMetric(IMetricIdentity id, IStatistic statistic) {
        IMetricInfo info;
        if (DEBUG_CONFIG || DEBUG_METRICS) {
            if (statistic == null) {
                System.out.println("[" + this.m_componentName + "] Unregistering metric " + id);
            } else {
                System.out.println("[" + this.m_componentName + "] Unregistering metric " + id + ", statistic " + statistic);
            }
        }
        if ((info = this.getMetricInfo(id)).isInstanceMetric() && info.getMetricIdentity().equals(id)) {
            throw new IllegalArgumentException("Cannot unregister an instance metric parent");
        }
        if (!info.isDynamic()) {
            return;
        }
        RegisteredMetric metricDetails = (RegisteredMetric)this.m_activeMetrics.get(id);
        if (metricDetails == null) {
            return;
        }
        IStatistic registeredStatistic = metricDetails.getStatistic();
        if (statistic != null && statistic != registeredStatistic) {
            if (DEBUG_CONFIG || DEBUG_METRICS) {
                System.out.println("[" + this.m_componentName + "] Unregister skipped for metric " + id + ", statistic parameter does not match currently registered statistic");
            }
            return;
        }
        this.m_activeMetrics.remove(id);
        ++this.m_metricUnregistrations;
        MetricsManager.m_metricsManagerDiagnostics.traceMetricRegistrations(this);
        this.unregisterStatistic(registeredStatistic);
        this.deactivateAlerts(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateAlerts(IMetricIdentity metricId) {
        HashSet hashSet = this.m_activeAlerts;
        synchronized (hashSet) {
            Iterator it = this.m_activeAlerts.iterator();
            while (it.hasNext()) {
                IAlert alert = (IAlert)it.next();
                if (!metricId.equals(alert.getMetricIdentity())) continue;
                it.remove();
            }
        }
    }

    private void checkValidRefreshInterval(long refreshInterval) throws MFException {
        if (refreshInterval < 5000L || refreshInterval > 900000L) {
            throw new MFException("Refresh interval=[" + refreshInterval + "] cannot be < " + 5000L + " or >" + 900000L + " milliseconds.");
        }
    }

    private void checkValidCollectionInterval(long collectionInterval) throws MFException {
        if (collectionInterval < 60000L || collectionInterval > 86400000L) {
            throw new MFException("Collection interval=[" + collectionInterval + "] cannot be < " + 60000L + " or >" + 86400000L + " milliseconds.");
        }
    }

    private void checkValidIntervalRatio(long refreshInterval, long collectionInterval) throws MFException {
        if ((int)(collectionInterval / refreshInterval) > 250) {
            this.m_refreshInterval = 20000L;
            this.m_collectionInterval = 600000L;
            throw new MFException("Collection interval divided by Refresh interval cannot be > 250.");
        }
    }

    private void validateRefreshAndCollectionInterval(long refreshInterval, long collectionInterval) throws MFException {
        this.checkValidRefreshInterval(refreshInterval);
        this.checkValidCollectionInterval(collectionInterval);
        this.checkValidIntervalRatio(this.m_collectionInterval, refreshInterval);
    }

    @Override
    public long getRefreshInterval() {
        return this.m_refreshInterval;
    }

    @Override
    public synchronized void setRefreshInterval(long refreshInterval) throws MFException {
        this.validateRefreshAndCollectionInterval(refreshInterval, this.m_collectionInterval);
        if (refreshInterval != this.m_refreshInterval) {
            this.m_refreshInterval = refreshInterval;
            this.m_numHistoricalValues = (int)(this.m_collectionInterval / this.m_refreshInterval);
            if (DEBUG_STATS && (DEBUG_AGENT || !this.m_isAgent)) {
                System.out.println(System.currentTimeMillis() + " [" + this.m_componentName + "] *** MetricsManager.setRefreshInterval = " + refreshInterval);
            }
            if (this.m_isClosing) {
                return;
            }
            this.startRefreshing();
        }
    }

    @Override
    public long getCollectionInterval() {
        return this.m_collectionInterval;
    }

    @Override
    public synchronized void setCollectionInterval(long collectionInterval) throws MFException {
        this.validateRefreshAndCollectionInterval(this.m_refreshInterval, collectionInterval);
        if (collectionInterval != this.m_collectionInterval) {
            this.m_collectionInterval = collectionInterval;
            this.m_numHistoricalValues = (int)(this.m_collectionInterval / this.m_refreshInterval);
            if (DEBUG_STATS && (DEBUG_AGENT || !this.m_isAgent)) {
                System.out.println(System.currentTimeMillis() + " [" + this.m_componentName + "] *** MetricsManager.setCollectionInterval = " + collectionInterval);
            }
            if (this.m_isClosing) {
                return;
            }
            this.startRefreshing();
        }
    }

    @Override
    public synchronized void setRefreshAndCollectionInterval(long refreshInterval, long collectionInterval) throws MFException {
        this.validateRefreshAndCollectionInterval(refreshInterval, collectionInterval);
        if (refreshInterval != this.m_refreshInterval || collectionInterval != this.m_collectionInterval) {
            this.m_refreshInterval = refreshInterval;
            this.m_collectionInterval = collectionInterval;
            this.m_numHistoricalValues = (int)(this.m_collectionInterval / this.m_refreshInterval);
            if (DEBUG_STATS && (DEBUG_AGENT || !this.m_isAgent)) {
                System.out.println(System.currentTimeMillis() + " [" + this.m_componentName + "] *** MetricsManager.setRefreshAndCollectionInterval(" + refreshInterval + "," + collectionInterval + ")");
            }
            if (this.m_isClosing) {
                return;
            }
            this.startRefreshing();
        }
    }

    @Override
    public synchronized boolean getRepeatMetricAlerts() {
        return this.m_repeatAlerts;
    }

    @Override
    public synchronized void setRepeatMetricAlerts(boolean repeatMetricAlerts) throws MFException {
        this.m_repeatAlerts = repeatMetricAlerts;
    }

    synchronized long getElapsedCollectionTime() {
        long[] values = this.m_elapsedCollectionTimeAnalyzer.evaluateValue(this.m_elapsedCollectionTimeStatistic);
        if (DEBUG_STATS && (DEBUG_AGENT || !this.m_isAgent)) {
            System.out.println(System.currentTimeMillis() + " [" + this.m_componentName + "] ElapsedCollectionTime = " + values[0] + " timestamp = " + values[1]);
        }
        return values[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getElapsedCollectionTime(int maxCycles) {
        long[] values;
        MetricsManager metricsManager = this;
        synchronized (metricsManager) {
            values = this.m_elapsedCollectionTimeStatistic.getLastValues();
        }
        if (values == null) {
            return 0L;
        }
        int len = values.length;
        if (maxCycles < len) {
            len = maxCycles;
        }
        long ret = 0L;
        for (int i = 0; i < len; ++i) {
            ret += values[i];
        }
        return ret;
    }

    public long getCurrencyTimestamp() {
        return this.m_currencyTimestamp;
    }

    public IMetricAnalyzer getMetricAnalyzer(short valueType) {
        if (valueType >= this.m_defaultAnalyzers.length) {
            throw new IllegalArgumentException("No default metric analyzer is available for the value type: [type=" + valueType + ']');
        }
        IMetricAnalyzer analyzer = this.m_defaultAnalyzers[valueType];
        if (analyzer == null) {
            if (DEBUG_CONFIG) {
                System.out.println("[" + this.m_componentName + "] Creating analyzer for value type: " + valueType);
            }
            switch (valueType) {
                case 0: {
                    analyzer = new Value();
                    break;
                }
                case 1: {
                    analyzer = new Count();
                    break;
                }
                case 2: {
                    analyzer = new Total();
                    break;
                }
                case 3: {
                    analyzer = new Minimum();
                    break;
                }
                case 4: {
                    analyzer = new Maximum();
                    break;
                }
                case 5: {
                    analyzer = new Average();
                    break;
                }
                case 6: {
                    analyzer = new Rate(this, 100L);
                    break;
                }
                case 7: {
                    analyzer = new PeakRate(this, 100L);
                    break;
                }
                case 8: {
                    analyzer = new Rate(this, 1000L);
                    break;
                }
                case 9: {
                    analyzer = new PeakRate(this, 1000L);
                    break;
                }
                case 10: {
                    analyzer = new Rate(this, 60000L);
                    break;
                }
                case 11: {
                    analyzer = new PeakRate(this, 60000L);
                    break;
                }
                case 12: {
                    analyzer = new Rate(this, 3600000L);
                    break;
                }
                case 13: {
                    analyzer = new PeakRate(this, 3600000L);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No default metric analyzer is available for the value type: [type=" + valueType + ']');
                }
            }
            this.m_defaultAnalyzers[valueType] = analyzer;
        }
        return analyzer;
    }

    private void sendAlertNotification(IAlert alert, long value) {
        IMetricIdentity metricId = alert.getMetricIdentity();
        String metricName = this.getMetricNodeId(metricId).getName();
        String units = this.getMetricInfo(metricId).getUnits();
        String instance = this.getInstanceName(metricId);
        long threshold = alert.getThresholdValue();
        boolean isHighThreshold = alert.isHighThreshold();
        GregorianCalendar initialAlertTime = ((Alert)alert).getInitialAlertTime();
        if (DEBUG_ALERTS) {
            System.out.println(System.currentTimeMillis() + " [" + this.m_componentName + "]  **** sendAlertNotification for metric = " + metricName + " instance = " + instance + " Units = " + units + (isHighThreshold ? " High" : " Low") + " Threshold = " + threshold + " value = " + value);
        }
        if (this.m_mfContext == null) {
            throw new IllegalStateException("Context not set");
        }
        INotification notification = this.m_mfContext.createNotification(this.m_alertNotificationCategory, INotification.SUBCATEGORY_TEXT[4], metricName, 3);
        notification.setLogType((short)0);
        notification.setAttribute("Threshold", new Long(threshold));
        notification.setAttribute("Value", new Long(value));
        notification.setAttribute("InitialAlert", initialAlertTime);
        notification.setAttribute("Repeat", ((Alert)alert).isRepeat());
        notification.setAttribute("ThresholdType", isHighThreshold ? "high" : "low");
        notification.setAttribute("Units", units);
        if (instance != null) {
            notification.setAttribute("Instance", instance);
        }
        if (this.m_alertNotificationAttributes != null && !this.m_alertNotificationAttributes.isEmpty()) {
            for (String attr : this.m_alertNotificationAttributes.keySet()) {
                notification.setAttribute(attr, this.m_alertNotificationAttributes.get(attr));
            }
        }
        this.m_mfContext.sendNotification(notification);
    }

    protected synchronized void startRefreshing() {
        if (this.m_isClosing) {
            return;
        }
        if (DEBUG_STATS && (DEBUG_AGENT || !this.m_isAgent)) {
            System.out.println(System.currentTimeMillis() + " [" + this.m_componentName + "] Start refreshing");
        }
        for (IStatistic statistic : this.m_statistics) {
            if (!(statistic instanceof IHistoricalStatistic)) continue;
            ((IHistoricalStatistic)statistic).setNumValues(this.m_numHistoricalValues);
        }
        if (this.m_intervalTimer != null) {
            this.m_intervalTimer.cancel();
        }
        this.m_intervalTimer = new Timer(true);
        this.m_elapsedCollectionTimeStatistic.updateValue(System.currentTimeMillis());
        this.m_intervalTimer.scheduleAtFixedRate((TimerTask)new MetricRefresher(), 0L, this.m_refreshInterval);
    }

    private boolean isHiddenMetric(IMetricIdentity id) {
        IMetricInfo info = this.getMetricInfo(id);
        if (info == null) {
            return false;
        }
        return ((MetricInfo)info).isHidden();
    }

    private IMetricInfo[] internalGetMetricsInfo(boolean includeAll) {
        if (includeAll) {
            return this.m_metricInfos.values().toArray(EMPTY_INFO_ARRAY);
        }
        ArrayList<IMetricInfo> metricInfos = new ArrayList<IMetricInfo>();
        for (IMetricInfo info : this.m_metricInfos.values()) {
            if (((MetricInfo)info).isHidden()) continue;
            metricInfos.add(info);
        }
        return metricInfos.toArray(EMPTY_INFO_ARRAY);
    }

    private IMetricIdentity[] internalGetEnabledMetrics(IMetricIdentity[] ids, boolean showHidden) {
        if (ids == null && showHidden) {
            return this.m_enabledMetricsPatterns.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
        }
        ArrayList<IMetricIdentity> retPatterns = new ArrayList<IMetricIdentity>();
        for (IMetricIdentity pat : this.m_enabledMetricsPatterns) {
            if (this.isHiddenMetric(pat) && !showHidden) continue;
            if (ids == null) {
                retPatterns.add(pat);
                continue;
            }
            for (int i = 0; i < ids.length; ++i) {
                if (!pat.isInstanceOf(ids[i])) continue;
                retPatterns.add(pat);
            }
        }
        return retPatterns.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
    }

    private IMetricIdentity[] internalGetActiveMetrics(IMetricIdentity[] ids, boolean includeAll) {
        ArrayList<IMetricIdentity> retActive = new ArrayList<IMetricIdentity>();
        for (IMetricIdentity id : this.m_activeMetrics.keySet()) {
            IMetricInfo info = this.getMetricInfo(id);
            if (!includeAll && ((MetricInfo)info).isHidden()) continue;
            RegisteredMetric details = (RegisteredMetric)this.m_activeMetrics.get(id);
            if (details != null) {
                ((MetricIdentity)id).setHash(details.getHash());
            }
            if (ids == null) {
                retActive.add(id);
                continue;
            }
            for (int i = 0; i < ids.length; ++i) {
                if (!id.isInstanceOf(ids[i])) continue;
                retActive.add(id);
            }
        }
        return retActive.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
    }

    private IMetricIdentity[] new_internalEnableMetrics(IMetricIdentity[] ids, boolean includeHidden) {
        if (ids == null) {
            throw new IllegalArgumentException("List of metric identities cannot be null");
        }
        if (DEBUG_CONFIG || DEBUG_METRICS) {
            System.out.println("[" + this.m_componentName + "] Enabling metrics:");
            for (int i = 0; i < ids.length; ++i) {
                System.out.println(" - " + ids[i]);
            }
        }
        if (this.m_isClosing) {
            return IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY;
        }
        HashSet<IMetricIdentity> retEnabled = new HashSet<IMetricIdentity>();
        Object mid = null;
        Object metricNamePattern = null;
        for (int i = 0; i < ids.length; ++i) {
            Pattern pattern = Pattern.compile(ids[i].getAbsoluteName());
            Matcher matcher = pattern.matcher("");
            Pattern instancePattern = null;
            Matcher instanceMatcher = null;
            String[] nameComponents = ids[i].getNameComponents();
            MetricIdentity tempID = null;
            if (nameComponents.length > 2) {
                String[] parentName = null;
                if (ids[i].getAbsoluteName().endsWith("..*")) {
                    parentName = new String[nameComponents.length - 2];
                    System.arraycopy(nameComponents, 0, parentName, 0, nameComponents.length - 2);
                } else {
                    parentName = new String[nameComponents.length - 1];
                    System.arraycopy(nameComponents, 0, parentName, 0, nameComponents.length - 1);
                }
                tempID = new MetricIdentity(parentName);
            }
            for (IMetricInfo info : this.m_metricInfos.values()) {
                if (((MetricInfo)info).isHidden() && !includeHidden) continue;
                IMetricIdentity idNode = info.getMetricIdentity();
                matcher.reset(idNode.getAbsoluteName());
                if (matcher.matches()) {
                    retEnabled.add(ids[i]);
                    this.m_enabledMetricsPatterns.add(idNode);
                    continue;
                }
                if (matcher.lookingAt()) {
                    if (!ids[i].getAbsoluteName().endsWith("..*")) continue;
                    IMetricIdentity pat = null;
                    IMetricIdentity parentID = this.getMetricParent(ids[i]);
                    if (parentID.isInstanceOf(idNode) && info.isInstanceMetric()) {
                        retEnabled.add(idNode);
                        this.m_enabledMetricsPatterns.add(ids[i]);
                        continue;
                    }
                    if (!idNode.isInstanceOf(parentID)) continue;
                    retEnabled.add(idNode);
                    pat = info.isInstanceMetric() ? MetricsFactory.createMetricIdentity(idNode.getAbsoluteName() + "..*") : idNode;
                    this.m_enabledMetricsPatterns.add(pat);
                    continue;
                }
                if (tempID == null || !(instanceMatcher = (instancePattern = Pattern.compile(idNode.getAbsoluteName())).matcher(tempID.getAbsoluteName())).lookingAt()) continue;
                this.m_enabledMetricsPatterns.add(ids[i]);
                retEnabled.add(tempID);
            }
        }
        IMetricIdentity[] retIds = retEnabled.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
        return retIds;
    }

    private IMetricIdentity getMetricParent(IMetricIdentity id) {
        String[] nameComponents = id.getNameComponents();
        int len = nameComponents.length;
        MetricIdentity parentID = null;
        int index = 0;
        String[] parent = null;
        if (len > 2 && nameComponents[len - 1].equals("*") && nameComponents[len - 2].equals("")) {
            index = len - 2;
            parent = new String[len - 2];
        } else {
            index = len - 1;
            parent = new String[len - 1];
        }
        System.arraycopy(nameComponents, 0, parent, 0, index);
        parentID = new MetricIdentity(parent);
        return parentID;
    }

    private IMetricIdentity[] internalEnableMetrics(IMetricIdentity[] inputMetricIds, boolean includeHidden) {
        if (inputMetricIds == null) {
            throw new IllegalArgumentException("List of metric identities cannot be null");
        }
        if (DEBUG_CONFIG || DEBUG_METRICS) {
            System.out.println("[" + this.m_componentName + "] Enabling metrics:");
            for (int i = 0; i < inputMetricIds.length; ++i) {
                System.out.println(" - " + inputMetricIds[i]);
            }
        }
        if (this.m_isClosing) {
            return IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY;
        }
        HashSet<IMetricIdentity> retNewlyEnabled = new HashSet<IMetricIdentity>();
        for (IMetricInfo definedInfo : this.m_metricInfos.values()) {
            if (((MetricInfo)definedInfo).isHidden() && !includeHidden) continue;
            IMetricIdentity definedIdNode = definedInfo.getMetricIdentity();
            for (int i = 0; i < inputMetricIds.length; ++i) {
                if (definedIdNode.isInstanceOf(inputMetricIds[i])) {
                    if (definedInfo.isInstanceMetric() || this.m_enabledMetricsPatterns.contains(definedIdNode)) continue;
                    this.m_enabledMetricsPatterns.add(definedIdNode);
                    if (retNewlyEnabled.contains(definedIdNode)) continue;
                    retNewlyEnabled.add(definedIdNode);
                    continue;
                }
                if (!inputMetricIds[i].isInstanceOf(definedIdNode) || !definedInfo.isInstanceMetric()) continue;
                if (definedInfo.getMetricIdentity().getNameComponents().length < inputMetricIds[i].getNameComponents().length - 1) {
                    throw new IllegalArgumentException("Invalid metric identity: " + inputMetricIds[i] + " (instance names containing '.' should be escaped with '%')");
                }
                if (this.m_enabledMetricsPatterns.contains(inputMetricIds[i])) continue;
                this.m_enabledMetricsPatterns.add(inputMetricIds[i]);
                if (retNewlyEnabled.contains(definedIdNode)) continue;
                retNewlyEnabled.add(definedIdNode);
            }
        }
        IMetricIdentity[] retNewlyEnabledIds = retNewlyEnabled.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
        if (DEBUG_CONFIG || DEBUG_METRICS) {
            System.out.println("[" + this.m_componentName + "] Enable list for component " + retNewlyEnabledIds.length);
            for (int i = 0; i < retNewlyEnabledIds.length; ++i) {
                System.out.println(" - " + retNewlyEnabledIds[i]);
            }
        }
        return retNewlyEnabledIds;
    }

    private IMetricIdentity[] new_internalDisableMetrics(IMetricIdentity[] ids, boolean includeAll) {
        if (ids == null) {
            throw new IllegalArgumentException("List of metric identities cannot be null");
        }
        if (DEBUG_CONFIG || DEBUG_METRICS) {
            for (int i = 0; i < ids.length; ++i) {
                System.out.println(" - " + ids[i]);
            }
        }
        HashSet<IMetricIdentity> disabled = new HashSet<IMetricIdentity>();
        IMetricIdentity mid = null;
        String metricNamePattern = null;
        for (int i = 0; i < ids.length; ++i) {
            IMetricInfo info = this.getMetricInfo(ids[i]);
            if (info == null || info.isInstanceMetric() && info.getMetricIdentity().equals(ids[i])) {
                mid = ids[i];
                metricNamePattern = mid.getAbsoluteName();
                Pattern pattern = Pattern.compile(metricNamePattern);
                Matcher matcher = pattern.matcher("");
                Iterator iterator = this.m_enabledMetricsPatterns.iterator();
                while (iterator.hasNext()) {
                    IMetricInfo enaInfo;
                    IMetricIdentity enabledID = (IMetricIdentity)iterator.next();
                    if (!enabledID.isInstanceOf(ids[i]) || (enaInfo = this.getMetricInfo(enabledID)) == null || !enaInfo.isDynamic()) continue;
                    iterator.remove();
                    disabled.add(enaInfo.getMetricIdentity());
                }
                continue;
            }
            if (!info.isDynamic()) continue;
            this.m_enabledMetricsPatterns.remove(ids[i]);
            disabled.add(info.getMetricIdentity());
        }
        IMetricIdentity[] retIds = disabled.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
        if (DEBUG_CONFIG || DEBUG_METRICS) {
            System.out.println("[" + this.m_componentName + "] Disable list for component " + retIds.length);
            for (int i = 0; i < retIds.length; ++i) {
                System.out.println(" - " + retIds[i]);
            }
        }
        return retIds;
    }

    private IMetricIdentity[] internalDisableMetrics(IMetricIdentity[] ids, boolean includeAll) {
        if (ids == null) {
            throw new IllegalArgumentException("List of metric identities cannot be null");
        }
        if (DEBUG_CONFIG || DEBUG_METRICS) {
            for (int i = 0; i < ids.length; ++i) {
                System.out.println(" - " + ids[i]);
            }
        }
        HashSet<IMetricIdentity> disabled = new HashSet<IMetricIdentity>();
        for (int i = 0; i < ids.length; ++i) {
            IMetricInfo info = this.getMetricInfo(ids[i]);
            if (info != null && info.isInstanceMetric() && info.getMetricIdentity().equals(ids[i])) {
                this.disableAlerts(this.getEnabledAlerts(new IMetricIdentity[]{ids[i]}));
                continue;
            }
            if (info == null) {
                Iterator iterator = this.m_enabledMetricsPatterns.iterator();
                while (iterator.hasNext()) {
                    IMetricInfo enabledInfo;
                    IMetricIdentity enabledID = (IMetricIdentity)iterator.next();
                    if (!enabledID.isInstanceOf(ids[i]) || !(enabledInfo = this.getMetricInfo(enabledID)).isDynamic()) continue;
                    iterator.remove();
                    disabled.add(enabledInfo.getMetricIdentity());
                }
                continue;
            }
            if (!info.isDynamic()) continue;
            this.m_enabledMetricsPatterns.remove(ids[i]);
            disabled.add(info.getMetricIdentity());
        }
        IMetricIdentity[] retIds = disabled.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
        if (DEBUG_CONFIG || DEBUG_METRICS) {
            System.out.println("[" + this.m_componentName + "] Disable list for component " + retIds.length);
            for (int i = 0; i < retIds.length; ++i) {
                System.out.println(" - " + retIds[i]);
            }
        }
        return retIds;
    }

    private IMetricIdentity[] internalEvaluateEnableMetrics(IMetricIdentity[] ids, boolean showAll) {
        HashSet<IMetricIdentity> retEval = new HashSet<IMetricIdentity>();
        for (IMetricInfo info : this.m_metricInfos.values()) {
            if (((MetricInfo)info).isHidden() && !showAll) continue;
            IMetricIdentity id = info.getMetricIdentity();
            if (!this.m_enabledMetricsPatterns.contains(id)) {
                retEval.add(id);
                continue;
            }
            if (ids == null) continue;
            for (int i = 0; i < ids.length; ++i) {
                if (!id.isInstanceOf(ids[i]) && (!ids[i].isInstanceOf(id) || !this.isInstancePattern(ids[i])) || this.m_enabledMetricsPatterns.contains(id)) continue;
                retEval.add(ids[i]);
            }
        }
        return retEval.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
    }

    private IMetricsData internalGetMetricsData(IMetricIdentity[] ids, Boolean includeTriggeredAlerts, boolean includeAll) {
        Collection<Object> registeredMetrics;
        if (ids != null) {
            registeredMetrics = new HashSet();
            for (int i = 0; i < ids.length; ++i) {
                int inputLength;
                Object rm = this.m_activeMetrics.get(ids[i]);
                if (rm != null) {
                    registeredMetrics.add(rm);
                    continue;
                }
                String[] inputNameComponents = ids[i].getNameComponents();
                if (!inputNameComponents[(inputLength = inputNameComponents.length) - 1].endsWith("*")) continue;
                for (IMetricIdentity activeMetricID : this.m_activeMetrics.keySet()) {
                    String[] activeNameComponents = activeMetricID.getNameComponents();
                    if (activeNameComponents.length > inputLength || inputLength > activeNameComponents.length) continue;
                    boolean match = true;
                    for (int j = 0; j < activeNameComponents.length - 1; ++j) {
                        if (activeNameComponents[j].equals(inputNameComponents[j])) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    rm = this.m_activeMetrics.get(activeMetricID);
                    registeredMetrics.add(rm);
                }
            }
        } else {
            registeredMetrics = this.m_activeMetrics.values();
        }
        IMetricsData data = this.internalGetMetricsData(registeredMetrics);
        if (!includeTriggeredAlerts.booleanValue()) {
            return data;
        }
        return this.updateTriggeredAlerts(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMetricsData updateTriggeredAlerts(IMetricsData data) {
        IMetric[] metrics = data.getMetrics();
        if (metrics == null) {
            return data;
        }
        ArrayList<Alert> exceededAlerts = new ArrayList<Alert>();
        HashSet hashSet = this.m_activeAlerts;
        synchronized (hashSet) {
            for (Alert al : this.m_activeAlerts) {
                if (!al.isExceeded()) continue;
                exceededAlerts.add(al);
            }
        }
        if (exceededAlerts.isEmpty()) {
            return data;
        }
        for (int i = 0; i < metrics.length; ++i) {
            ArrayList<IAlert> triggeredAls = null;
            for (IAlert iAlert : exceededAlerts) {
                if (!iAlert.getMetricIdentity().equals(metrics[i].getMetricIdentity())) continue;
                if (triggeredAls == null) {
                    triggeredAls = new ArrayList<IAlert>();
                }
                triggeredAls.add(iAlert);
            }
            if (triggeredAls == null) continue;
            ((Metric)metrics[i]).setTriggeredAlerts(triggeredAls.toArray(EMPTY_ALERT_ARRAY));
        }
        return MetricsFactory.createMetricsData(metrics, data.getCurrencyTimestamp());
    }

    private IMetricsData internalGetMetricsData(Collection registeredMetrics) {
        ArrayList<IMetric> metrics = new ArrayList<IMetric>();
        long currencyTimestamp = 0L;
        long minCurrencyTimestamp = Long.MAX_VALUE;
        long maxCurrencyTimestamp = Long.MIN_VALUE;
        int retryCount = 0;
        block0: while (retryCount < 2) {
            Iterator iterator = registeredMetrics.iterator();
            currencyTimestamp = this.m_currencyTimestamp;
            long nextRefreshTime = this.m_currencyTimestamp + this.m_refreshInterval;
            while (iterator.hasNext()) {
                RegisteredMetric enabledMetricDetails = (RegisteredMetric)iterator.next();
                IMetricIdentity id = enabledMetricDetails.getMetricIdentity();
                ((MetricIdentity)id).setHash(enabledMetricDetails.getHash());
                long[] value = null;
                value = enabledMetricDetails.evaluate();
                if (value[1] > nextRefreshTime) {
                    retryCount = (short)(retryCount + 1);
                    continue block0;
                }
                if (value[1] < minCurrencyTimestamp) {
                    minCurrencyTimestamp = value[1];
                }
                if (value[1] > maxCurrencyTimestamp) {
                    maxCurrencyTimestamp = value[1];
                }
                metrics.add(MetricsFactory.createMetric(id, value[0], value[1]));
            }
            if (this.m_currencyTimestamp == currencyTimestamp) break;
            retryCount = (short)(retryCount + 1);
        }
        currencyTimestamp = (minCurrencyTimestamp + maxCurrencyTimestamp) / 2L;
        return MetricsFactory.createMetricsData(metrics.toArray(EMPTY_METRIC_ARRAY), currencyTimestamp);
    }

    private IAlert matchAlert(Set set, IAlert alert) {
        IAlert ret = null;
        for (IAlert match : set) {
            if (!alert.equals(match)) continue;
            ret = match;
            break;
        }
        return ret;
    }

    private IAlert matchMetricIdentity(Set set, IAlert alert) {
        IAlert ret = null;
        for (IAlert match : set) {
            if (!alert.sameMetricIdentity(match.getMetricIdentity())) continue;
            ret = match;
            break;
        }
        return ret;
    }

    public IMetricInfo getMetricInfo(IMetricIdentity id) {
        if (id == null) {
            return null;
        }
        IMetricInfo info = (IMetricInfo)this.m_metricInfos.get(id);
        if (info == null) {
            String[] nameComponents = id.getNameComponents();
            if (nameComponents.length == 1) {
                return null;
            }
            String[] parentNameComponents = new String[nameComponents.length - 1];
            System.arraycopy(nameComponents, 0, parentNameComponents, 0, parentNameComponents.length);
            id = MetricsFactory.createMetricIdentity(parentNameComponents);
            info = (IMetricInfo)this.m_metricInfos.get(id);
            if (info == null || !info.isInstanceMetric()) {
                return null;
            }
        }
        return info;
    }

    public IMetricInfo new_getMetricInfo(IMetricIdentity id) {
        if (id == null) {
            return null;
        }
        IMetricInfo info = (IMetricInfo)this.m_metricInfos.get(id);
        if (info == null) {
            String[] nameComponents = id.getNameComponents();
            if (nameComponents.length == 1) {
                return null;
            }
            info = (IMetricInfo)this.m_metricInfos.get(id = this.getParentMetricID(id));
            if (info == null || !info.isInstanceMetric()) {
                return null;
            }
        }
        return info;
    }

    private synchronized IMetricIdentity getParentMetricID(IMetricIdentity instanceID) {
        IMetricIdentity parentID = null;
        String absoluteName = instanceID.getAbsoluteName();
        int pos = absoluteName.lastIndexOf(".");
        String sub = absoluteName.substring(0, pos);
        while (sub.lastIndexOf(".") == sub.length() - 1) {
            sub = sub.substring(0, sub.lastIndexOf("."));
        }
        parentID = MetricsFactory.createMetricIdentity(sub);
        return parentID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refresh() {
        if (DEBUG_STATS && (DEBUG_AGENT || !this.m_isAgent)) {
            System.out.println(System.currentTimeMillis() + " [" + this.m_componentName + "] Refreshing ...");
        }
        this.m_currencyTimestamp = System.currentTimeMillis();
        Object[] statistics = this.m_statistics.toArray();
        for (int i = 0; i < statistics.length; ++i) {
            IStatistic statistic = (IStatistic)statistics[i];
            if (statistic instanceof ISampledStatistic) {
                IStatisticProvider[] providers = ((ISampledStatistic)statistic).getStatisticProviders();
                for (int j = 0; j < providers.length; ++j) {
                    providers[j].updateStatistic((ISampledStatistic)statistic);
                }
            }
            statistic.refresh();
        }
        if (DEBUG_STATS && (DEBUG_AGENT || !this.m_isAgent)) {
            this.m_elapsedCollectionTimeStatistic.printValues();
        }
        HashSet hashSet = this.m_activeAlerts;
        synchronized (hashSet) {
            if (!this.m_activeAlerts.isEmpty()) {
                for (Map.Entry activeMetric : this.m_activeMetrics.entrySet()) {
                    IMetricIdentity id = (IMetricIdentity)activeMetric.getKey();
                    Alert highAlert = null;
                    Alert lowAlert = null;
                    Iterator activeAlerts = this.m_activeAlerts.iterator();
                    long[] value = null;
                    while (activeAlerts.hasNext()) {
                        Alert alert = (Alert)activeAlerts.next();
                        if (!alert.getMetricIdentity().equals(id)) continue;
                        if (value == null) {
                            value = ((RegisteredMetric)activeMetric.getValue()).evaluate();
                        }
                        if (!alert.check((long)value[0], this.m_repeatAlerts)) continue;
                        if (alert.isHighThreshold()) {
                            if (highAlert != null && highAlert.getThresholdValue() >= alert.getThresholdValue()) continue;
                            highAlert = alert;
                            continue;
                        }
                        if (lowAlert != null && lowAlert.getThresholdValue() <= alert.getThresholdValue()) continue;
                        lowAlert = alert;
                    }
                    if (highAlert != null) {
                        this.sendAlertNotification(highAlert, (long)value[0]);
                    }
                    if (lowAlert == null) continue;
                    this.sendAlertNotification(lowAlert, (long)value[0]);
                }
            }
        }
    }

    static {
        DEBUG_CONFIG = false;
        DEBUG_METRICS = false;
        DEBUG_STATS = false;
        DEBUG_ALERTS = false;
        DEBUG_AGENT = false;
        METRICID_NONNULL = "Metric identity cannot be null";
        STATISTIC_NONNULL = "Statistic cannot be null";
        EMPTY_INFO_ARRAY = new IMetricInfo[0];
        EMPTY_METRIC_ARRAY = new IMetric[0];
        EMPTY_ALERT_ARRAY = new IAlert[0];
        m_diagnosticsManager = DiagnosticsManagerAccess.createManager();
        m_metricsManagerDiagnostics = new MetricsManagerDiagnostics();
        m_metricsManagerDiagnostics.register();
    }

    private static class MetricsManagerDiagnostics
    extends AbstractDiagnosticsProvider {
        private static String[] OPERATIONS;
        private static HashMap SHOW_TRACE_LEVEL_PARAM_DESCIPTOR;
        private static HashMap UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR;
        private static HashMap PARAM_DESCRIPTOR;
        private static HashMap DUMP_STATE_PARAM_DESCIPTOR;
        private static HashMap DESCRIBE_PARAM_DESCIPTOR;
        private static HashMap LIST_DIAGNOSTICS_INSTANCES_PARAM_DESCIPTOR;
        String description = "Use this subsystem to help diagnose the Sonic MF metrics management subsystem." + NEWLINE + NEWLINE + "The diagnosis includes tracing of statistics and their metric usage." + NEWLINE + "Two diagnosed object instances are used to distinguish between statistics (\"Statistics\") and metrics (\"Metrics\")." + NEWLINE + "Tracing can be configured so to provide various levels of verbosity. The various trace options are:" + NEWLINE + " 1 - verbose : provide more detailed or frequent tracing." + NEWLINE + " 2 - registration counts : for every 500 (100 with verbose bit set) unregistrations dumps registration counts" + NEWLINE + NEWLINE + "Examples:" + NEWLINE + "  sonic.mf.metrics updateTraceLevel doiID=Statistics integerTraceLevel=2" + NEWLINE + "  sonic.mf.metrics dumpState" + NEWLINE;

        MetricsManagerDiagnostics() {
            super("sonic.mf.metrics");
        }

        public String describe() {
            return this.description;
        }

        public String[] getOperations() {
            return OPERATIONS;
        }

        public HashMap describeParameters(String operationName) {
            return (HashMap)PARAM_DESCRIPTOR.get(operationName);
        }

        public String[] getDOInstances() {
            return new String[]{MetricsManager.SDF_DOIID_STATISTICS, MetricsManager.SDF_DOIID_METRICS};
        }

        public void updateTraceLevel(String doiID, HashMap parameters, StringBuffer buffer) {
            try {
                if (doiID.equals(MetricsManager.SDF_DOIID_STATISTICS)) {
                    m_sdfStatisticsTraceMask = this.parseTraceLevel(doiID, parameters, buffer, m_sdfStatisticsTraceMask, m_sdfMetricsTraceMask);
                }
                if (doiID.equals(MetricsManager.SDF_DOIID_METRICS)) {
                    m_sdfMetricsTraceMask = this.parseTraceLevel(doiID, parameters, buffer, m_sdfMetricsTraceMask, m_sdfStatisticsTraceMask);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                buffer.append(e.toString());
            }
        }

        public void showTraceLevel(String doiID, HashMap parameters, StringBuffer buffer) {
            if (doiID.equals(MetricsManager.SDF_DOIID_STATISTICS)) {
                buffer.append("Trace level for \"").append(this.m_subsystemName).append("\" [").append(doiID).append("] is ").append(m_sdfStatisticsTraceMask);
            }
            if (doiID.equals(MetricsManager.SDF_DOIID_METRICS)) {
                buffer.append("Trace level for \"").append(this.m_subsystemName).append("\" [").append(doiID).append("] is ").append(m_sdfMetricsTraceMask);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void appendStateDump(String doiID, HashMap Parameters, StringBuffer buffer) {
            try (IStateWriter writer = null;){
                writer = this.m_diagnosticsContext.getStateWriter();
                Iterator metricsManagers = ((HashSet)m_metricsManagers.clone()).iterator();
                while (metricsManagers.hasNext()) {
                    this.dumpMetricsManager(writer, (MetricsManager)metricsManagers.next());
                }
            }
            if (writer != null) {
                buffer.append("Dump of \"").append(this.m_subsystemName).append("\" written to ").append(writer.getFilePath());
            }
        }

        private String createIndent(int offset) {
            String indent = "";
            for (int i = 0; i < offset; ++i) {
                indent = indent + "  ";
            }
            return indent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dumpMetricsManager(IStateWriter writer, MetricsManager metricsManager) throws Exception {
            writer.write(new Date().toString());
            writer.write(NEWLINE);
            writer.write("+ <metrics manager> " + metricsManager.m_componentName);
            writer.write(NEWLINE);
            HashSet<IStatistic> usedStatistics = new HashSet<IStatistic>();
            MetricsManager metricsManager2 = metricsManager;
            synchronized (metricsManager2) {
                writer.write("  + <active metrics>  (count=" + metricsManager.m_activeMetrics.size() + ")");
                if (metricsManager.m_activeMetrics.size() == 0) {
                    writer.write(NEWLINE);
                    writer.write("    - <none>");
                } else {
                    for (RegisteredMetric registeredMetric : metricsManager.m_activeMetrics.values()) {
                        writer.write(NEWLINE);
                        writer.write("    - " + registeredMetric.m_metricId.getName() + " (statistic=" + registeredMetric.m_statistic.hashCode() + ")");
                        usedStatistics.add(registeredMetric.m_statistic);
                    }
                }
                writer.write(NEWLINE);
                writer.write("  + <statistics>  (count=" + (metricsManager.m_statistics.size() - 1) + ")");
                if (metricsManager.m_statistics.size() == 1) {
                    writer.write(NEWLINE);
                    writer.write("    - <none>");
                } else {
                    for (IStatistic statistic : metricsManager.m_statistics) {
                        if (statistic == metricsManager.m_elapsedCollectionTimeStatistic) continue;
                        writer.write(NEWLINE);
                        String type = statistic.getClass().getName();
                        type = type.substring(type.lastIndexOf(46) + 1);
                        writer.write("    - " + statistic.hashCode());
                        if (!usedStatistics.contains(statistic)) {
                            writer.write("*");
                        }
                        writer.write(" (type=" + type + ")");
                    }
                }
            }
            writer.write(NEWLINE);
        }

        private int parseTraceLevel(String doiID, HashMap parameters, StringBuffer buffer, int currentTraceMask, int otherTraceMask) throws Exception {
            int traceMask;
            String traceLevel = (String)parameters.get("integerTraceLevel");
            if (traceLevel == null) {
                traceLevel = new String("0");
            }
            if ((traceMask = Integer.parseInt(traceLevel)) == 0 && currentTraceMask > 0 && otherTraceMask == 0 && this.m_tracer != null) {
                this.m_tracer.close();
                this.m_tracer = null;
            }
            if (traceMask > 0) {
                if (this.m_tracer == null) {
                    this.m_tracer = this.m_diagnosticsContext.getTracer();
                }
                buffer.append("Trace file for \"").append(this.m_subsystemName).append("\" [").append(doiID).append("] is \"").append(this.m_tracer.getFilePath()).append("\"");
                this.m_tracer.trace("Start tracing " + this.m_subsystemName + '.' + doiID + " with tracing level " + traceLevel, false);
            }
            return traceMask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void traceStatisticRegistrations(MetricsManager metricsManager) {
            if ((m_sdfStatisticsTraceMask & 2) == 0) {
                return;
            }
            ITracer tracer = this.m_tracer;
            if (tracer != null) {
                MetricsManager metricsManager2 = metricsManager;
                synchronized (metricsManager2) {
                    int factor;
                    int n = factor = (m_sdfStatisticsTraceMask & 1) == 0 ? 500 : 100;
                    if (metricsManager.m_statisticUnregistrations % (long)factor != 0L) {
                        return;
                    }
                    StringBuffer sb = new StringBuffer();
                    sb.append("<statistic registrations> " + metricsManager.m_componentName);
                    sb.append(" registrations=").append(metricsManager.m_statisticRegistrations);
                    sb.append(", unregistrations=").append(metricsManager.m_statisticUnregistrations);
                    try {
                        tracer.trace(sb.toString(), false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void traceMetricRegistrations(MetricsManager metricsManager) {
            if ((m_sdfMetricsTraceMask & 2) == 0) {
                return;
            }
            ITracer tracer = this.m_tracer;
            if (tracer != null) {
                MetricsManager metricsManager2 = metricsManager;
                synchronized (metricsManager2) {
                    int factor;
                    int n = factor = (m_sdfMetricsTraceMask & 1) == 0 ? 500 : 100;
                    if (metricsManager.m_metricUnregistrations % (long)factor != 0L) {
                        return;
                    }
                    StringBuffer sb = new StringBuffer();
                    sb.append("<metric registrations> " + metricsManager.m_componentName);
                    sb.append(" registrations=").append(metricsManager.m_metricRegistrations);
                    sb.append(", unregistrations=").append(metricsManager.m_metricUnregistrations);
                    try {
                        tracer.trace(sb.toString(), false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        static {
            SHOW_TRACE_LEVEL_PARAM_DESCIPTOR = new HashMap();
            UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR = new HashMap();
            PARAM_DESCRIPTOR = new HashMap();
            DUMP_STATE_PARAM_DESCIPTOR = new HashMap();
            DESCRIBE_PARAM_DESCIPTOR = new HashMap();
            LIST_DIAGNOSTICS_INSTANCES_PARAM_DESCIPTOR = new HashMap();
            UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR.put("doiID", "values: \"Statistics\", \"Metrics\"");
            UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR.put("integerTraceLevel", "bits: 1 - verbose, 2 - registration counts");
            PARAM_DESCRIPTOR.put("dumpState", DUMP_STATE_PARAM_DESCIPTOR);
            PARAM_DESCRIPTOR.put("describe", DESCRIBE_PARAM_DESCIPTOR);
            PARAM_DESCRIPTOR.put("showTraceLevel", SHOW_TRACE_LEVEL_PARAM_DESCIPTOR);
            PARAM_DESCRIPTOR.put("updateTraceLevel", UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR);
            PARAM_DESCRIPTOR.put("listDiagnosticsInstances", LIST_DIAGNOSTICS_INSTANCES_PARAM_DESCIPTOR);
            OPERATIONS = MetricsManagerDiagnostics.toOpnameArray((HashMap)PARAM_DESCRIPTOR);
        }
    }

    private class RegisteredMetric {
        private IMetricIdentity m_metricId;
        private IStatistic m_statistic;
        private IMetricAnalyzer m_analyzer;
        private long m_hash;

        RegisteredMetric(IMetricIdentity id, IStatistic stat, IMetricAnalyzer ana, long hash) {
            this.m_metricId = id;
            this.m_statistic = stat;
            this.m_analyzer = ana;
            this.m_hash = hash;
        }

        IMetricIdentity getMetricIdentity() {
            return this.m_metricId;
        }

        IStatistic getStatistic() {
            return this.m_statistic;
        }

        IMetricAnalyzer getAnalyzer() {
            return this.m_analyzer;
        }

        long getHash() {
            return this.m_hash;
        }

        long[] evaluate() {
            if (DEBUG_STATS && (DEBUG_AGENT || !MetricsManager.this.m_isAgent) && this.m_statistic instanceof HistoricalStatistic) {
                ((HistoricalStatistic)this.m_statistic).printValues();
                MetricsManager.this.m_elapsedCollectionTimeStatistic.printValues();
            }
            long[] value = this.m_analyzer.evaluateValue(this.m_statistic);
            if (DEBUG_STATS && (DEBUG_AGENT || !MetricsManager.this.m_isAgent)) {
                System.out.println("[" + MetricsManager.this.m_componentName + "] Id = " + this.m_metricId + " Value = " + value[0] + " Time = " + value[1]);
            }
            return value;
        }
    }

    private class MetricRefresher
    extends TimerTask {
        private MetricRefresher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MetricsManager metricsManager = MetricsManager.this;
            synchronized (metricsManager) {
                if (MetricsManager.this.m_isClosing) {
                    return;
                }
                long currentTime = System.currentTimeMillis();
                long scheduledTime = super.scheduledExecutionTime();
                if (DEBUG_STATS && (DEBUG_AGENT || !MetricsManager.this.m_isAgent)) {
                    System.out.println(currentTime + " [" + MetricsManager.this.m_componentName + "] MetricsManager$MetricRefresher: scheduled=" + scheduledTime + " late= " + (currentTime - scheduledTime));
                }
                if (currentTime - scheduledTime > MetricsManager.this.m_collectionInterval) {
                    if (DEBUG_STATS && (DEBUG_AGENT || !MetricsManager.this.m_isAgent)) {
                        System.out.println(currentTime + " [" + MetricsManager.this.m_componentName + "] MetricsManager$MetricRefresher: Start Over! ");
                    }
                    MetricsManager.this.startRefreshing();
                    return;
                }
                MetricsManager.this.refresh();
            }
        }
    }
}

