/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.metrics.manager.impl;

import com.sonicsw.mf.common.metrics.manager.IHistoricalStatistic;
import com.sonicsw.mf.common.metrics.manager.IMetricAnalyzer;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.metrics.manager.impl.AbstractTimeBasedAnalyzer;
import com.sonicsw.mf.common.metrics.manager.impl.HistoricalStatistic;
import com.sonicsw.mf.common.metrics.manager.impl.MetricsManager;
import com.sonicsw.mf.common.metrics.manager.impl.Statistic;

public class Rate
extends AbstractTimeBasedAnalyzer
implements IMetricAnalyzer {
    protected long m_factor;
    boolean DEBUG = false;

    public Rate(MetricsManager metricsManager, long factor) {
        super(metricsManager);
        if (factor < 1L) {
            throw new IllegalArgumentException("Factor cannot be less than 1");
        }
        this.m_factor = factor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] evaluateValue(IStatistic statistic) {
        long elapsedTime = 0L;
        long[] value = new long[2];
        long lastValue = 0L;
        if (statistic instanceof IHistoricalStatistic) {
            long[] values = null;
            MetricsManager metricsManager = this.m_metricsManager;
            synchronized (metricsManager) {
                IStatistic iStatistic = statistic;
                synchronized (iStatistic) {
                    values = ((IHistoricalStatistic)statistic).getLastValues();
                    value[1] = statistic.getCurrencyTimestamp();
                }
                if (values != null) {
                    elapsedTime = this.m_metricsManager.getElapsedCollectionTime(values.length);
                }
                if (this.DEBUG) {
                    System.out.println("Computing " + this + " for historical statistic " + statistic);
                    ((HistoricalStatistic)statistic).printValues();
                    System.out.println("Elapsed Time:");
                    this.m_metricsManager.m_elapsedCollectionTimeStatistic.printValues();
                }
            }
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    lastValue += values[i];
                }
            }
        } else {
            MetricsManager metricsManager = this.m_metricsManager;
            synchronized (metricsManager) {
                IStatistic iStatistic = statistic;
                synchronized (iStatistic) {
                    lastValue = statistic.getCurrentValue();
                    value[1] = statistic.getCurrencyTimestamp();
                    elapsedTime = value[1] - ((Statistic)statistic).m_resetTimestamp;
                }
            }
        }
        if (elapsedTime > 0L) {
            value[0] = Math.round((double)lastValue * (double)this.m_factor / (double)elapsedTime);
        }
        if (this.DEBUG) {
            System.out.println(this + " for " + statistic + " last value = " + lastValue + " elapsed = " + elapsedTime + " value = " + value[0]);
        }
        return value;
    }

    public String toString() {
        return "Rate *" + this.m_factor;
    }
}

