/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.runtime.impl;

import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IContainerIdentity;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.IIdentity;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.runtime.impl.ContainerIdentity;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;

public class ContainerState
implements IContainerState,
Serializable {
    private static final long serialVersionUID = -7773691032575402133L;
    private static final short m_serialVersion = 0;
    private IContainerIdentity m_containerID;
    private long m_timestamp;
    private short m_state = (short)3;
    String m_host;
    private ArrayList m_componentStates = new ArrayList();

    public ContainerState(CanonicalName canonicalName, IElementIdentity configID) {
        this.m_containerID = new ContainerIdentity(canonicalName, configID);
        try {
            this.m_host = InetAddress.getByName(InetAddress.getLocalHost().getHostAddress()).getHostName();
        }
        catch (UnknownHostException e) {
            this.m_host = "UNKNOWN";
        }
        this.m_timestamp = System.currentTimeMillis();
    }

    public void addComponentState(IComponentState componentState) {
        this.m_componentStates.add(componentState);
    }

    public void removeComponentState(String componentName) {
        for (int i = 0; i < this.m_componentStates.size(); ++i) {
            IComponentState componentState = (IComponentState)this.m_componentStates.get(i);
            IComponentIdentity componentIdentity = (IComponentIdentity)componentState.getRuntimeIdentity();
            if (!componentIdentity.getComponentName().equals(componentName)) continue;
            this.m_componentStates.remove(i);
            return;
        }
    }

    @Override
    public IIdentity getRuntimeIdentity() {
        return this.m_containerID;
    }

    @Override
    public long getTimeStamp() {
        return this.m_timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.m_timestamp = timestamp;
    }

    @Override
    public short getState() {
        return this.m_state;
    }

    public void setState(short state) {
        if (state != 0 && state != 3 && state != 1) {
            throw new IllegalArgumentException("Invalid container state: " + state);
        }
        this.m_state = state;
    }

    @Override
    public String getStateString() {
        return IComponentState.STATE_TEXT[this.getState()];
    }

    @Override
    public IComponentState[] getComponentStates() {
        IComponentState[] states = new IComponentState[this.m_componentStates.size()];
        return this.m_componentStates.toArray(states);
    }

    @Override
    public String getContainerHost() {
        return this.m_host;
    }

    public void setContainerHost(String host) {
        if (host == null || host.length() == 0) {
            throw new IllegalArgumentException("Container host cannot be null or empty.");
        }
        this.m_host = host;
    }

    public String toString() {
        return this.getStateString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IContainerState)) {
            return false;
        }
        return this.getRuntimeIdentity().equals(((IContainerState)object).getRuntimeIdentity()) && this.getState() == ((IContainerState)object).getState();
    }

    public int hashCode() {
        return Objects.hash(this.getRuntimeIdentity(), this.getState());
    }

    @Override
    public int compareTo(Object object) throws ClassCastException {
        return this.toString().compareTo(((IContainerState)object).toString());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(6);
        stream.writeUTF("serialVersion");
        stream.writeObject(new Short(0));
        stream.writeUTF("containerID");
        stream.writeObject(this.m_containerID);
        stream.writeUTF("timestamp");
        stream.writeObject(new Long(this.m_timestamp));
        stream.writeUTF("state");
        stream.writeObject(new Short(this.m_state));
        stream.writeUTF("host");
        stream.writeObject(this.m_host);
        stream.writeUTF("componentStates");
        stream.writeObject(this.m_componentStates);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int numValues = stream.readInt();
        HashMap<String, Object> map = new HashMap<String, Object>(numValues);
        for (int i = 0; i < numValues; ++i) {
            map.put(stream.readUTF(), stream.readObject());
        }
        switch ((Short)map.get("serialVersion")) {
            default: 
        }
        try {
            this.m_containerID = (IContainerIdentity)map.get("containerID");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.m_timestamp = (Long)map.get("timestamp");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.m_state = (Short)map.get("state");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.m_host = (String)map.get("host");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.m_componentStates = (ArrayList)map.get("componentStates");
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

