/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.view.impl;

import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.IReplaceRef;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.common.view.ILogicalNameSpace;

public class NameReplacer
implements IReplaceRef {
    private boolean m_fromLogical;
    ILogicalNameSpace m_nameSpace;

    NameReplacer(boolean fromLogical, ILogicalNameSpace nameSpace) {
        this.m_fromLogical = fromLogical;
        this.m_nameSpace = nameSpace;
    }

    @Override
    public Reference replace(Reference ref) {
        String replacedValue = null;
        try {
            if (this.m_fromLogical) {
                replacedValue = this.m_nameSpace.storageFromLogical(ref.getElementName());
            } else {
                String storageName = ref.getElementName();
                if (!storageName.startsWith("/NO_STORAGE:")) {
                    replacedValue = this.m_nameSpace.logicalFromStorage(storageName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (replacedValue == null) {
            replacedValue = this.m_fromLogical ? "/NO_STORAGE:" + ref.getElementName() : (ref.getElementName().startsWith("/NO_STORAGE:") ? ref.getElementName() : "DELETED:" + ref.getElementName());
        }
        return new Reference(replacedValue);
    }

    @Override
    public String replace(String name) throws VersionOutofSyncException {
        try {
            String newName = null;
            newName = this.m_fromLogical ? this.m_nameSpace.storageFromLogical(name) : this.m_nameSpace.logicalFromStorage(name);
            if (newName == null) {
                throw new VersionOutofSyncException("Could not translate " + name);
            }
            return newName;
        }
        catch (Exception e) {
            throw new VersionOutofSyncException(e.getMessage());
        }
    }
}

