/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.xml;

import com.sonicsw.mf.common.IDSImport;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IAttributeSetType;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IIdentity;
import com.sonicsw.mf.common.config.ITypeCollection;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.InvalidXMLException;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.common.xml.ByteStringConverter;
import com.sonicsw.mf.common.xml.XMLStringWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDocumentHandler
extends DefaultHandler
implements ContentHandler,
LexicalHandler {
    protected Stack elements = null;
    protected boolean topAttributeSet = false;
    protected IDirectoryAdminService m_directoryService = null;
    protected Locator m_locator = null;
    protected String m_strDomain = null;
    protected IDirElement m_dirElement = null;
    protected ArrayList m_elements = new ArrayList();
    protected StringBuffer m_contentCDATA = new StringBuffer();
    protected boolean m_isCData = false;
    protected ArrayList m_stringElements = new ArrayList(1);
    boolean m_keepElements = false;

    public void setDirectoryService(IDirectoryAdminService directoryService) {
        this.m_directoryService = directoryService;
    }

    public void setDomainName(String name) {
        this.m_strDomain = name;
    }

    public void setKeepElements(boolean keep) {
        this.m_keepElements = keep;
    }

    public IDirElement getElement() {
        return this.m_dirElement;
    }

    public IDirElement[] getElements() {
        IDirElement[] elements = new IDirElement[this.m_elements.size()];
        this.m_elements.toArray(elements);
        return elements;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.m_locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.elements = new Stack();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.m_isCData) {
            this.m_contentCDATA.append(ch, start, length);
        }
    }

    @Override
    public void startElement(String uri, String localpart, String rawname, Attributes attributes) throws SAXException {
        try {
            if (localpart.equals("Domain")) {
                this.checkDomain(attributes.getValue("name"));
            }
            if (localpart.equals("Directory")) {
                this.createDirectory(attributes);
            }
            if (localpart.equals("ConfigElement")) {
                this.topAttributeSet = true;
            } else {
                if (this.m_stringElements.size() == 1) {
                    this.addStringAttribute(null);
                }
                if (localpart.equals("ElementID")) {
                    this.createElement(attributes);
                } else if (localpart.equals("AttributeSet")) {
                    this.createAttributeSet(attributes);
                } else if (localpart.equals("AttributeList")) {
                    this.createAttributeList(attributes);
                } else if (localpart.equals("AttributeSetType")) {
                    this.createAttributeSetType(attributes);
                } else if (localpart.equals("AttributeName")) {
                    this.createAttributeName(attributes);
                } else if (localpart.equals("Attribute")) {
                    this.createAttribute(attributes);
                } else if (localpart.equals("ListItem")) {
                    this.createListItem(attributes);
                }
            }
        }
        catch (Exception e) {
            throw new SAXParseException(e.getMessage(), this.m_locator, e);
        }
    }

    @Override
    public void endElement(String uri, String localpart, String rawname) throws SAXException {
        if (this.m_stringElements.size() == 1) {
            this.addStringAttribute(null);
        }
        if (localpart.equals("AttributeSet")) {
            this.elements.pop();
        } else if (localpart.equals("AttributeList")) {
            this.elements.pop();
        } else if (localpart.equals("AttributeSetType")) {
            this.elements.pop();
        } else if (localpart.equals("ConfigElement")) {
            this.m_dirElement = (IDirElement)this.elements.peek();
            if (this.m_keepElements) {
                this.m_elements.add(this.m_dirElement);
            }
            if (this.m_directoryService != null) {
                this.addElementToDS(this.m_dirElement);
            }
            this.elements.pop();
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        this.m_isCData = true;
    }

    @Override
    public void endCDATA() throws SAXException {
        this.m_isCData = false;
        String tmp = XMLStringWriter.replaceAll(this.m_contentCDATA.toString(), "<![_MF_CDATA[", "<![CDATA[");
        String data = XMLStringWriter.replaceAll(tmp, "]_MF_]>", "]]>");
        this.addStringAttribute(data);
        this.m_contentCDATA.setLength(0);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    private void addElementToDS(IDirElement dirElement) throws SAXException {
        try {
            ((IDSImport)((Object)this.m_directoryService)).importedElement(dirElement.doneUpdate());
        }
        catch (Exception e) {
            this.cleanup();
            throw new SAXParseException(e.getMessage(), this.m_locator, e);
        }
    }

    private void createDirectory(Attributes attributes) throws SAXException {
        if (this.m_directoryService == null) {
            throw new SAXException("Directory element can't be specified.");
        }
        String dirName = attributes.getValue("name");
        try {
            if (!this.checkDirectoryExistance(dirName)) {
                this.buildParentDirectories(dirName);
                this.m_directoryService.createDirectory(dirName);
            }
        }
        catch (Exception ex) {
            throw new SAXException(ex.getMessage(), ex);
        }
    }

    private void buildParentDirectories(String dirName) throws DirectoryServiceException, VersionOutofSyncException, ConfigException {
        EntityName name = new EntityName(dirName);
        String[] parentsList = name.getNameComponents();
        String fullName = "";
        if (parentsList.length == 0) {
            return;
        }
        for (int i = 0; i < parentsList.length - 1; ++i) {
            if (this.checkDirectoryExistance(fullName = fullName + "/" + parentsList[i])) continue;
            this.m_directoryService.createDirectory(fullName);
        }
    }

    private boolean checkDirectoryExistance(String name) throws DirectoryServiceException, VersionOutofSyncException {
        boolean exist = false;
        IIdentity identity = this.m_directoryService.getIdentity(name);
        if (identity instanceof IElementIdentity) {
            throw new DirectoryServiceException("Can't create directory, domain contain element with same name");
        }
        if (identity != null) {
            exist = true;
        }
        return exist;
    }

    private void createElement(Attributes attributes) {
        String name = attributes.getValue("name");
        String type = attributes.getValue("type");
        String releaseVersion = attributes.getValue("releaseVersion");
        IDirElement configElement = ElementFactory.createElement(name, type, releaseVersion);
        this.elements.push(configElement);
    }

    private void createAttributeSet(Attributes attributes) throws AttributeSetTypeException, ReadOnlyException, ConfigException {
        IAttributeSet attrSet = null;
        if (this.topAttributeSet) {
            attrSet = ((IDirElement)this.elements.peek()).getAttributes();
            this.topAttributeSet = false;
        } else {
            Object parent = this.elements.peek();
            if (parent instanceof IAttributeSet) {
                NamedCollection attrs = new NamedCollection(1);
                attrs.setAttributes(attributes);
                this.elements.push(attrs);
            } else if (parent instanceof IAttributeList) {
                IAttributeSetType setType = null;
                String type = attributes.getValue("type");
                if (type != null) {
                    setType = this.getAttributeSetType(type);
                }
                attrSet = ((IAttributeList)parent).addNewAttributeSetItem(setType);
            } else if (parent instanceof NamedCollection) {
                this.cleanup();
                throw new ConfigException("Parent element must have a name, which specified as 'name' attribute of AttributeName element.");
            }
        }
        if (attrSet != null) {
            this.elements.push(attrSet);
        }
    }

    private void createAttributeList(Attributes attributes) throws AttributeSetTypeException, ReadOnlyException, ConfigException {
        IAttributeList attrList = null;
        Object parent = this.elements.peek();
        if (parent instanceof IAttributeSet) {
            NamedCollection attrs = new NamedCollection(0);
            attrs.setAttributes(attributes);
            this.elements.push(attrs);
        } else if (parent instanceof IAttributeList) {
            attrList = ((IAttributeList)parent).addNewAttributeListItem();
        } else if (parent instanceof NamedCollection) {
            this.cleanup();
            throw new ConfigException("Parent element must have a name, which specified as 'name' attribute of AttributeName element.");
        }
        if (attrList != null) {
            this.elements.push(attrList);
        }
    }

    private void createAttributeSetType(Attributes attributes) throws ReadOnlyException, ConfigException, AttributeSetTypeException {
        if (this.elements.peek() instanceof NamedCollection) {
            this.cleanup();
            throw new ConfigException("Parent element must have a name, which specified as 'name' attribute of AttributeName element.");
        }
        IAttributeSetType attrSetType = this.getAttributeSetType(attributes.getValue("name"));
        if (attrSetType != null) {
            this.elements.push(attrSetType);
        }
    }

    private IAttributeSetType getAttributeSetType(String type) throws AttributeSetTypeException, ReadOnlyException, ConfigException {
        ITypeCollection parent = (ITypeCollection)this.elements.peek();
        IAttributeSetType attrSetType = parent.getAttributeSetType(type);
        if (attrSetType == null) {
            attrSetType = parent.createAttributeSetType(type);
        }
        return attrSetType;
    }

    private void createAttribute(Attributes attributes) throws AttributeSetTypeException, ReadOnlyException, ConfigException {
        if (this.elements.peek() instanceof NamedCollection) {
            this.cleanup();
            throw new ConfigException("Parent element must have a name, which specified as 'name' attribute of AttributeName element.");
        }
        String name = attributes.getValue("name");
        String value = attributes.getValue("value");
        String type = attributes.getValue("type");
        IAttributeSet parent = (IAttributeSet)this.elements.peek();
        if (type.equalsIgnoreCase("integer")) {
            parent.setIntegerAttribute(name, new Integer(value == null ? "0" : value));
        } else if (type.equalsIgnoreCase("long")) {
            parent.setLongAttribute(name, new Long(value == null ? "0" : value));
        } else if (type.equalsIgnoreCase("boolean")) {
            parent.setBooleanAttribute(name, new Boolean(value == null ? "false" : value));
        } else if (type.equalsIgnoreCase("bigdecimal")) {
            parent.setDecimalAttribute(name, new BigDecimal(value == null ? "0" : value));
        } else if (type.equalsIgnoreCase("string")) {
            String strValue = value == null ? "" : value;
            this.m_stringElements.add(new StringAttributeInfo(name, strValue, parent));
        } else if (type.equalsIgnoreCase("reference")) {
            parent.setReferenceAttribute(name, new Reference(value == null ? "" : value));
        } else if (type.equalsIgnoreCase("bytes")) {
            byte[] bytes = ByteStringConverter.getBytesFromString(value == null ? "" : value);
            parent.setBytesAttribute(name, bytes);
        } else if (type.equalsIgnoreCase("date")) {
            parent.setDateAttribute(name, new Date(value == null ? "January 1, 1970" : value));
        }
    }

    private void createListItem(Attributes attributes) throws ReadOnlyException, ConfigException {
        if (this.elements.peek() instanceof NamedCollection) {
            this.cleanup();
            throw new ConfigException("Parent element must have a name, which specified as 'name' attribute of AttributeName element.");
        }
        String value = attributes.getValue("value");
        String type = attributes.getValue("type");
        IAttributeList parent = (IAttributeList)this.elements.peek();
        if (type.equalsIgnoreCase("integer")) {
            parent.addIntegerItem(new Integer(value == null ? "0" : value));
        } else if (type.equalsIgnoreCase("long")) {
            parent.addLongItem(new Long(value == null ? "0" : value));
        } else if (type.equalsIgnoreCase("boolean")) {
            parent.addBooleanItem(new Boolean(value == null ? "false" : value));
        } else if (type.equalsIgnoreCase("bigdecimal")) {
            parent.addDecimalItem(new BigDecimal(value == null ? "0" : value));
        } else if (type.equalsIgnoreCase("string")) {
            String strValue = value == null ? "" : value;
            this.m_stringElements.add(new StringAttributeInfo("", strValue, parent));
        } else if (type.equalsIgnoreCase("reference")) {
            parent.addReferenceItem(new Reference(value == null ? "" : value));
        } else if (type.equalsIgnoreCase("bytes")) {
            byte[] bytes = ByteStringConverter.getBytesFromString(value == null ? "" : value);
            parent.addBytesItem(bytes);
        } else if (type.equalsIgnoreCase("date")) {
            parent.addDateItem(new Date(value == null ? "January 1, 1970" : value));
        }
    }

    private void createNewListItem(Object parent, Attributes attributes) {
    }

    private void createDeletedListItem(Object parent, Attributes attributes) {
    }

    private void createAttributeName(Attributes attributes) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        Object parent = this.elements.peek();
        if (parent instanceof NamedCollection) {
            NamedCollection attrs = (NamedCollection)this.elements.pop();
            this.createNamedCollection(attributes.getValue("name"), attrs);
        } else if (parent instanceof IAttributeSetType) {
            ((IAttributeSetType)parent).addAttributeName(attributes.getValue("name"));
        }
    }

    private void createNamedCollection(String name, NamedCollection attrs) throws AttributeSetTypeException, ReadOnlyException, ConfigException {
        Object parent = this.elements.peek();
        if (attrs.getType() == 0) {
            IAttributeList attrList = ((IAttributeSet)parent).createAttributeList(name);
            this.elements.push(attrList);
        } else {
            IAttributeSetType setType = null;
            String type = attrs.getValue("type");
            if (type != null) {
                setType = this.getAttributeSetType(type);
            }
            IAttributeSet attrSet = ((IAttributeSet)parent).createAttributeSet(name, setType);
            this.elements.push(attrSet);
        }
    }

    private void checkDomain(String domainName) throws InvalidXMLException {
        if (this.m_strDomain == null) {
            return;
        }
        if (!domainName.equals(this.m_strDomain)) {
            throw new InvalidXMLException("Can't import data from different domain");
        }
    }

    private void addStringAttribute(String value) throws SAXException {
        if (this.m_stringElements.size() == 0) {
            throw new SAXException("(#PCDATA) can be entered for 'string' type only.");
        }
        StringAttributeInfo attrInfo = (StringAttributeInfo)this.m_stringElements.get(0);
        Object parent = attrInfo.getParent();
        if (value == null) {
            value = attrInfo.getValue();
        }
        try {
            if (parent instanceof IAttributeSet) {
                ((IAttributeSet)parent).setStringAttribute(attrInfo.getName(), value);
            } else if (parent instanceof IAttributeList) {
                ((IAttributeList)parent).addStringItem(value);
            }
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
        this.m_stringElements.clear();
    }

    private void cleanup() {
        this.elements.removeAllElements();
        this.elements = null;
        if (this.m_directoryService != null) {
            this.m_directoryService = null;
        }
        this.m_dirElement = null;
        this.m_locator = null;
    }

    class StringAttributeInfo {
        private String m_attrName = null;
        private String m_attrValue = null;
        private Object m_attrParent = null;

        StringAttributeInfo(String name, String value, Object parent) {
            this.m_attrName = name;
            this.m_attrValue = value;
            this.m_attrParent = parent;
        }

        protected String getName() {
            return this.m_attrName;
        }

        protected String getValue() {
            return this.m_attrValue;
        }

        protected Object getParent() {
            return this.m_attrParent;
        }
    }

    class NamedCollection {
        private HashMap m_attrs = null;
        private int m_collectionType;

        NamedCollection(int type) {
            this.m_collectionType = type;
        }

        private void setAttributes(Attributes attrs) {
            this.m_attrs = new HashMap(attrs.getLength());
            for (int i = 0; i < attrs.getLength(); ++i) {
                this.m_attrs.put(attrs.getLocalName(i), attrs.getValue(i));
            }
        }

        private String getValue(String attrName) {
            return (String)this.m_attrs.get(attrName);
        }

        private int getType() {
            return this.m_collectionType;
        }
    }
}

