/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.jmx.client;

import com.sonicsw.mf.comm.IRetryCallback;
import com.sonicsw.mf.comm.InvokeTimeoutCommsException;
import com.sonicsw.mf.comm.jms.ConnectorClient;
import com.sonicsw.mf.comm.jms.DurableConnector;
import com.sonicsw.mf.common.util.ObjectNameHelper;
import com.sonicsw.mf.jmx.client.CommunicationException;
import com.sonicsw.mf.jmx.client.IConnectionListener;
import com.sonicsw.mf.jmx.client.IExceptionListener;
import com.sonicsw.mf.jmx.client.IOrphanedReplyListener;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.NotificationListenerDelegate;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class JMSConnectorClient
implements IRemoteMBeanServer {
    private volatile boolean m_isClosing = false;
    protected ConnectorClient m_connector;
    private boolean m_failWhenDisconnected = false;
    private JMSConnectorAddress m_address;
    private String m_serverIdentity;
    private HashMap m_mBeanToLocalListeners = new HashMap();
    private HashMap<String, SubscriptionRenewalThread> m_mBeanToSubscriptionRenewalThreads = new HashMap();
    private HashMap m_notificationSourceUsages = new HashMap();
    private HashSet m_renewalFailures = new HashSet();
    private boolean m_needsRenewal;
    private long m_connectTimeout;
    private long m_socketConnectTimeout;
    private long m_requestTimeout = ConnectorClient.REQUEST_TIMEOUT_DEFAULT;
    private long m_notificationSubscriptionTimeout = DurableConnector.DURABLE_SUBSCRIPTION_TTL;
    private long m_notificationSubscriptionRenewalInterval = 30000L;
    private boolean m_useOnewaySubscriptionRequests = false;
    private static final String ADD_NOTIFICATION_LISTENER_METHOD_NAME = "addNotificationListener";
    static final char COMPOUND_HANDBACK_ID_DELIMITER = '\b';
    private static final Object[] EMPTY_PARAMS_ARRAY = new Object[0];
    private static final String[] EMPTY_SIGNATURE_ARRAY = new String[0];
    private static final String OBJECT_CLASSNAME = Object.class.getName();
    private static final String STRING_CLASSNAME = String.class.getName();
    private static final String OBJECT_ARRAY_CLASSNAME = Object[].class.getName();
    private static final String STRING_ARRAY_CLASSNAME = String[].class.getName();
    private static final String LONG_CLASSNAME = Long.class.getName();
    private static final String OBJECTNAME_CLASSNAME = ObjectName.class.getName();
    private static final String ATTRIBUTE_CLASSNAME = Attribute.class.getName();
    private static final String ATTRIBUTELIST_CLASSNAME = AttributeList.class.getName();
    private static final String NOTIFICATIONLISTENER_CLASSNAME = NotificationListener.class.getName();
    private static final String NOTIFICATIONFILTER_CLASSNAME = NotificationFilter.class.getName();
    private static final String QUERYEXP_CLASSNAME = QueryExp.class.getName();
    private static final String[] ADDREMOVE_NOTIFICATION_LISTENER_SIGNATURE = new String[]{OBJECTNAME_CLASSNAME, NOTIFICATIONLISTENER_CLASSNAME, NOTIFICATIONFILTER_CLASSNAME, OBJECT_CLASSNAME};
    private static final String[] ADDREMOVE_NOTIFICATION_LISTENER_WITH_TIMEOUT_SIGNATURE = new String[]{OBJECTNAME_CLASSNAME, NOTIFICATIONLISTENER_CLASSNAME, NOTIFICATIONFILTER_CLASSNAME, OBJECT_CLASSNAME, LONG_CLASSNAME};
    private IConnectionListener m_connectionListener;
    private IExceptionListener m_exceptionListener;

    @Override
    public synchronized String connect(JMSConnectorAddress address) {
        return this.connect(address, 0L);
    }

    public synchronized String connect(JMSConnectorAddress address, long timeout) {
        if (this.m_address != null && !address.equals(this.m_address)) {
            throw new IllegalArgumentException("Cannot connect with a different address.");
        }
        if (this.m_connector != null) {
            throw new IllegalStateException("Already connected");
        }
        this.m_connector = new ConnectorClient("JMXCLIENT");
        this.m_connector.setRequestTimeout(this.m_requestTimeout);
        this.m_connector.setConnectTimeout(this.m_connectTimeout);
        this.m_connector.setSocketConnectTimeout(this.m_socketConnectTimeout);
        String managementNode = address.getManagementNode();
        if (managementNode != null && managementNode.length() > 0) {
            this.m_connector.setManagementNode(managementNode);
        }
        this.m_connector.setConnectionListener(new com.sonicsw.mf.comm.IConnectionListener(){
            public String lrn;

            @Override
            public void onFailure(Exception e) {
                if (JMSConnectorClient.this.m_connectionListener != null) {
                    JMSConnectorClient.this.m_connectionListener.onFailure(e);
                }
                if (JMSConnectorClient.this.m_exceptionListener != null) {
                    JMSConnectorClient.this.m_exceptionListener.onException(e);
                }
            }

            @Override
            public void onReconnect(String localRoutingNode) {
                this.lrn = localRoutingNode;
                Thread reconnectHandler = new Thread("JMSConnectorClient - Reconnect Handler"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        JMSConnectorClient jMSConnectorClient = JMSConnectorClient.this;
                        synchronized (jMSConnectorClient) {
                            JMSConnectorClient.this.restartSubscriptionRenewalThreads();
                            if (JMSConnectorClient.this.m_connectionListener != null) {
                                JMSConnectorClient.this.m_connectionListener.onReconnect(lrn);
                            }
                        }
                    }
                };
                reconnectHandler.setDaemon(true);
                reconnectHandler.start();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisconnect() {
                JMSConnectorClient jMSConnectorClient = JMSConnectorClient.this;
                synchronized (jMSConnectorClient) {
                    JMSConnectorClient.this.stopSubscriptionRenewalThreads();
                    if (JMSConnectorClient.this.m_connectionListener != null) {
                        JMSConnectorClient.this.m_connectionListener.onDisconnect();
                    }
                }
            }
        });
        try {
            this.m_connector.connect(address.getEnv(), timeout);
        }
        catch (Exception e) {
            if (this.m_connector != null) {
                this.m_connector.close();
                this.m_connector = null;
            }
            JMRuntimeException jmre = new JMRuntimeException(e.getMessage());
            try {
                Method method = jmre.getClass().getMethod("initCause", Throwable.class);
                method.invoke((Object)jmre, e);
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw jmre;
        }
        this.m_address = address;
        this.m_serverIdentity = address.getServerIdentity();
        return this.m_serverIdentity;
    }

    public IExceptionListener getExceptionListener() {
        return this.m_exceptionListener;
    }

    public synchronized void setExceptionListener(IExceptionListener listener) {
        this.m_exceptionListener = listener;
    }

    public IConnectionListener getConnectionListener() {
        return this.m_connectionListener;
    }

    public synchronized void setConnectionListener(IConnectionListener listener) {
        this.m_connectionListener = listener;
    }

    public IOrphanedReplyListener getOrphanedReplyListener() {
        return (IOrphanedReplyListener)this.m_connector.getOrphanedReplyListener();
    }

    public synchronized void setOrphanedReplyListener(IOrphanedReplyListener listener) {
        this.m_connector.setOrphanedReplyListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void disconnect() {
        if (this.m_connector == null) {
            return;
        }
        this.m_isClosing = true;
        this.m_connector.closePending();
        HashMap hashMap = this.m_mBeanToLocalListeners;
        synchronized (hashMap) {
            for (String componentCanonicalName : this.m_mBeanToLocalListeners.keySet()) {
                HashMap listenerDelegateMap = (HashMap)this.m_mBeanToLocalListeners.get(componentCanonicalName);
                for (NotificationListener listener : listenerDelegateMap.keySet()) {
                    NotificationListenerDelegate delegate = (NotificationListenerDelegate)listenerDelegateMap.get(listener);
                    try {
                        ObjectName objectName = new ObjectName(componentCanonicalName);
                        this.m_connector.invokeOneway("jmx", this.getMFNamespace(objectName), componentCanonicalName, "removeNotificationListener", new Object[]{objectName, delegate}, new String[]{OBJECTNAME_CLASSNAME, NOTIFICATIONLISTENER_CLASSNAME}, this.m_requestTimeout);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    delegate.close();
                }
            }
            this.m_mBeanToLocalListeners.clear();
            for (SubscriptionRenewalThread thread : this.m_mBeanToSubscriptionRenewalThreads.values()) {
                Object object = thread.getThreadLockObject();
                synchronized (object) {
                    this.m_needsRenewal = true;
                    thread.getThreadLockObject().notifyAll();
                }
            }
            this.m_mBeanToSubscriptionRenewalThreads.clear();
        }
        this.m_connector.close();
        this.m_connector = null;
    }

    public void setRequestTimeout(long milliseconds) {
        long l = this.m_requestTimeout = milliseconds >= 10000L ? milliseconds : 10000L;
        if (this.m_connector != null) {
            this.m_connector.setRequestTimeout(this.m_requestTimeout);
        }
    }

    public long getRequestTimeout() {
        return this.m_requestTimeout;
    }

    public void setNotificationSubscriptionTimeout(long seconds) {
        this.m_notificationSubscriptionTimeout = seconds * 1000L;
    }

    public long getNotificationSubscriptionTimeout() {
        return this.m_notificationSubscriptionTimeout / 1000L;
    }

    public void setNotificationSubscriptionRenewalInterval(long interval) {
        this.m_notificationSubscriptionRenewalInterval = interval * 1000L;
    }

    public long getNotificationSubscriptionRenewalInterval() {
        return this.m_notificationSubscriptionRenewalInterval / 1000L;
    }

    public void setFailWhenDisconnected(boolean failWhenDisconnected) {
        this.m_failWhenDisconnected = failWhenDisconnected;
    }

    public boolean getFailWhenDisconnected() {
        return this.m_failWhenDisconnected;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.createMBean(className, objectName, EMPTY_PARAMS_ARRAY, EMPTY_SIGNATURE_ARRAY);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName objectName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        this.checkNotNull("className", className);
        this.checkNotNull("objectName", objectName);
        this.checkNotNull("params", params);
        this.checkNotNull("signature", signature);
        this.testOperationSupported();
        this.testConnector();
        this.testFailWhenDisconnected();
        ObjectInstance returnValue = null;
        try {
            returnValue = (ObjectInstance)this.m_connector.invoke("jmx", this.m_serverIdentity, null, "createMBean", new Object[]{className, objectName, params, signature}, new String[]{STRING_CLASSNAME, OBJECTNAME_CLASSNAME, OBJECT_ARRAY_CLASSNAME, STRING_ARRAY_CLASSNAME});
        }
        catch (ReflectionException re) {
            throw re;
        }
        catch (InstanceAlreadyExistsException iaee) {
            throw iaee;
        }
        catch (MBeanRegistrationException mre) {
            throw mre;
        }
        catch (MBeanException mbe) {
            throw mbe;
        }
        catch (NotCompliantMBeanException ncme) {
            throw ncme;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed createMBean");
        }
        return returnValue;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(className, objectName, loaderName, EMPTY_PARAMS_ARRAY, EMPTY_SIGNATURE_ARRAY);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.checkNotNull("className", className);
        this.checkNotNull("objectName", objectName);
        this.checkNotNull("params", params);
        this.checkNotNull("signature", signature);
        this.testOperationSupported();
        this.testConnector();
        this.testFailWhenDisconnected();
        ObjectInstance returnValue = null;
        try {
            returnValue = (ObjectInstance)this.m_connector.invoke("jmx", this.m_serverIdentity, null, "createMBean", new Object[]{className, objectName, loaderName, params, signature}, new String[]{STRING_CLASSNAME, OBJECTNAME_CLASSNAME, OBJECTNAME_CLASSNAME, OBJECT_ARRAY_CLASSNAME, STRING_ARRAY_CLASSNAME});
        }
        catch (ReflectionException re) {
            throw re;
        }
        catch (InstanceAlreadyExistsException iaee) {
            throw iaee;
        }
        catch (MBeanRegistrationException mre) {
            throw mre;
        }
        catch (MBeanException mbe) {
            throw mbe;
        }
        catch (NotCompliantMBeanException ncme) {
            throw ncme;
        }
        catch (InstanceNotFoundException infe) {
            throw infe;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed createMBean");
        }
        return returnValue;
    }

    @Override
    public Object getAttribute(ObjectName objectName, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        this.checkNotNull("objectName", objectName);
        this.checkNotNull("attribute", attribute);
        this.testConnector();
        this.testFailWhenDisconnected();
        Object returnValue = null;
        try {
            returnValue = this.m_connector.invoke("jmx", this.getMFNamespace(objectName), objectName.getCanonicalName(), "getAttribute", new Object[]{objectName, attribute}, new String[]{OBJECTNAME_CLASSNAME, STRING_CLASSNAME});
        }
        catch (MBeanException mbe) {
            throw mbe;
        }
        catch (AttributeNotFoundException anfe) {
            throw anfe;
        }
        catch (InstanceNotFoundException infe) {
            throw infe;
        }
        catch (ReflectionException re) {
            throw re;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed getAttribute");
        }
        return returnValue;
    }

    @Override
    public AttributeList getAttributes(ObjectName objectName, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        this.checkNotNull("objectName", objectName);
        this.checkNotNull("attributes", attributes);
        this.testConnector();
        this.testFailWhenDisconnected();
        AttributeList returnValue = null;
        try {
            returnValue = (AttributeList)this.m_connector.invoke("jmx", this.getMFNamespace(objectName), objectName.getCanonicalName(), "getAttributes", new Object[]{objectName, attributes}, new String[]{OBJECTNAME_CLASSNAME, STRING_ARRAY_CLASSNAME});
        }
        catch (InstanceNotFoundException infe) {
            throw infe;
        }
        catch (ReflectionException re) {
            throw re;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed getAttributes");
        }
        return returnValue;
    }

    @Override
    public String getDefaultDomain() {
        this.testOperationSupported();
        this.testConnector();
        this.testFailWhenDisconnected();
        String returnValue = null;
        try {
            returnValue = (String)this.m_connector.invoke("jmx", this.m_serverIdentity, null, "getDefaultDomain", EMPTY_PARAMS_ARRAY, EMPTY_SIGNATURE_ARRAY);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed getDefaultDomain");
        }
        return returnValue;
    }

    @Override
    public String[] getDomains() throws IOException {
        this.testOperationSupported();
        this.testConnector();
        this.testFailWhenDisconnected();
        String[] returnValue = null;
        try {
            returnValue = (String[])this.m_connector.invoke("jmx", this.m_serverIdentity, null, "getDomains", EMPTY_PARAMS_ARRAY, EMPTY_SIGNATURE_ARRAY);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed getDomains");
        }
        return returnValue;
    }

    @Override
    public Integer getMBeanCount() {
        this.testOperationSupported();
        this.testConnector();
        this.testFailWhenDisconnected();
        Integer returnValue = null;
        try {
            returnValue = (Integer)this.m_connector.invoke("jmx", this.m_serverIdentity, null, "getMBeanCount", EMPTY_PARAMS_ARRAY, EMPTY_SIGNATURE_ARRAY);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed getMBeanCount");
        }
        return returnValue;
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        this.checkNotNull("objectName", objectName);
        this.testConnector();
        this.testFailWhenDisconnected();
        MBeanInfo returnValue = null;
        try {
            returnValue = (MBeanInfo)this.m_connector.invoke("jmx", this.getMFNamespace(objectName), objectName.getCanonicalName(), "getMBeanInfo", new Object[]{objectName}, new String[]{OBJECTNAME_CLASSNAME});
        }
        catch (InstanceNotFoundException infe) {
            throw infe;
        }
        catch (IntrospectionException ie) {
            throw ie;
        }
        catch (ReflectionException re) {
            throw re;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed getMBeanInfo");
        }
        return returnValue;
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        this.checkNotNull("objectName", objectName);
        this.testConnector();
        this.testFailWhenDisconnected();
        ObjectInstance returnValue = null;
        try {
            returnValue = (ObjectInstance)this.m_connector.invoke("jmx", this.getMFNamespace(objectName), null, "getObjectInstance", new Object[]{objectName}, new String[]{OBJECTNAME_CLASSNAME});
        }
        catch (InstanceNotFoundException infe) {
            throw infe;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed getObjectInstance");
        }
        return returnValue;
    }

    @Override
    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.invoke(objectName, operationName, params, signature, null);
    }

    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature, long timeout) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.invoke(objectName, operationName, params, signature, timeout, null);
    }

    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature, ClassLoader loader) throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.checkNotNull("objectName", objectName);
        this.checkNotNull("operationName", operationName);
        this.checkNotNull("params", params);
        this.checkNotNull("signature", signature);
        this.testConnector();
        this.testFailWhenDisconnected();
        Object returnValue = null;
        ClassLoader existingContextLoader = null;
        try {
            if (loader != null) {
                existingContextLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(loader);
            }
            returnValue = this.m_connector.invoke("jmx", this.getMFNamespace(objectName), objectName.getCanonicalName(), "invoke", new Object[]{objectName, operationName, params, signature}, new String[]{OBJECTNAME_CLASSNAME, STRING_CLASSNAME, OBJECT_ARRAY_CLASSNAME, STRING_ARRAY_CLASSNAME});
        }
        catch (MBeanException mbe) {
            throw mbe;
        }
        catch (InstanceNotFoundException infe) {
            throw infe;
        }
        catch (ReflectionException re) {
            throw re;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed invoke");
        }
        finally {
            if (loader != null) {
                Thread.currentThread().setContextClassLoader(existingContextLoader);
            }
        }
        return returnValue;
    }

    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature, long timeout, ClassLoader loader) throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.checkNotNull("objectName", objectName);
        this.checkNotNull("operationName", operationName);
        this.checkNotNull("params", params);
        this.checkNotNull("signature", signature);
        this.testConnector();
        this.testFailWhenDisconnected();
        Object returnValue = null;
        ClassLoader existingContextLoader = null;
        try {
            if (loader != null) {
                existingContextLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(loader);
            }
            returnValue = this.m_connector.invoke("jmx", this.getMFNamespace(objectName), objectName.getCanonicalName(), "invoke", new Object[]{objectName, operationName, params, signature}, new String[]{OBJECTNAME_CLASSNAME, STRING_CLASSNAME, OBJECT_ARRAY_CLASSNAME, STRING_ARRAY_CLASSNAME}, timeout);
        }
        catch (MBeanException mbe) {
            throw mbe;
        }
        catch (InstanceNotFoundException infe) {
            throw infe;
        }
        catch (ReflectionException re) {
            throw re;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed invoke");
        }
        finally {
            if (loader != null) {
                Thread.currentThread().setContextClassLoader(existingContextLoader);
            }
        }
        return returnValue;
    }

    @Override
    public boolean isConnected() {
        if (this.m_connector == null) {
            return false;
        }
        try {
            return this.m_connector.isConnected();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public boolean isInstanceOf(ObjectName objectName, String className) throws InstanceNotFoundException {
        this.checkNotNull("objectName", objectName);
        this.checkNotNull("className", className);
        this.testConnector();
        this.testFailWhenDisconnected();
        Boolean returnValue = null;
        try {
            returnValue = (Boolean)this.m_connector.invoke("jmx", this.getMFNamespace(objectName), null, "isInstanceOf", new Object[]{objectName, className}, new String[]{OBJECTNAME_CLASSNAME, STRING_CLASSNAME});
        }
        catch (InstanceNotFoundException infe) {
            throw infe;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed isInstanceOf");
        }
        return returnValue;
    }

    @Override
    public boolean isRegistered(ObjectName objectName) {
        this.checkNotNull("objectName", objectName);
        this.testConnector();
        this.testFailWhenDisconnected();
        Boolean returnValue = null;
        try {
            returnValue = (Boolean)this.m_connector.invoke("jmx", this.getMFNamespace(objectName), null, "isRegistered", new Object[]{objectName}, new String[]{OBJECTNAME_CLASSNAME});
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed isRegistered");
        }
        return returnValue;
    }

    @Override
    public Set queryMBeans(ObjectName objectName, QueryExp query) {
        this.testOperationSupported();
        this.testConnector();
        this.testFailWhenDisconnected();
        Set returnValue = null;
        try {
            returnValue = (Set)this.m_connector.invoke("jmx", this.m_serverIdentity, null, "queryMBeans", new Object[]{objectName, query}, new String[]{OBJECTNAME_CLASSNAME, QUERYEXP_CLASSNAME});
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed queryMBeans");
        }
        return returnValue;
    }

    @Override
    public Set queryNames(ObjectName objectName, QueryExp query) {
        this.testOperationSupported();
        this.testConnector();
        this.testFailWhenDisconnected();
        Set returnValue = null;
        try {
            returnValue = (Set)this.m_connector.invoke("jmx", this.m_serverIdentity, null, "queryNames", new Object[]{objectName, query}, new String[]{OBJECTNAME_CLASSNAME, QUERYEXP_CLASSNAME});
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed queryNames");
        }
        return returnValue;
    }

    @Override
    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.checkNotNull("objectName", objectName);
        this.checkNotNull("attribute", attribute);
        this.testConnector();
        this.testFailWhenDisconnected();
        try {
            this.m_connector.invoke("jmx", this.getMFNamespace(objectName), objectName.getCanonicalName(), "setAttribute", new Object[]{objectName, attribute}, new String[]{OBJECTNAME_CLASSNAME, ATTRIBUTE_CLASSNAME});
        }
        catch (MBeanException mbe) {
            throw mbe;
        }
        catch (AttributeNotFoundException anfe) {
            throw anfe;
        }
        catch (InvalidAttributeValueException iave) {
            throw iave;
        }
        catch (InstanceNotFoundException infe) {
            throw infe;
        }
        catch (ReflectionException re) {
            throw re;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed setAttribute");
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName objectName, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        this.checkNotNull("objectName", objectName);
        this.checkNotNull("attributes", attributes);
        this.testConnector();
        this.testFailWhenDisconnected();
        AttributeList returnValue = null;
        try {
            returnValue = (AttributeList)this.m_connector.invoke("jmx", this.getMFNamespace(objectName), objectName.getCanonicalName(), "setAttributes", new Object[]{objectName, attributes}, new String[]{OBJECTNAME_CLASSNAME, ATTRIBUTELIST_CLASSNAME});
        }
        catch (InstanceNotFoundException infe) {
            throw infe;
        }
        catch (ReflectionException re) {
            throw re;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed setAttributes");
        }
        return returnValue;
    }

    @Override
    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.checkNotNull("objectName", objectName);
        this.testOperationSupported();
        this.testConnector();
        this.testFailWhenDisconnected();
        try {
            this.m_connector.invoke("jmx", this.m_serverIdentity, null, "unregisterMBean", new Object[]{objectName}, new String[]{OBJECTNAME_CLASSNAME});
        }
        catch (InstanceNotFoundException infe) {
            throw infe;
        }
        catch (MBeanRegistrationException mre) {
            throw mre;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed unregisterMBean");
        }
    }

    @Override
    public void addNotificationListener(ObjectName objectName, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.addNotificationListener(objectName, listener, filter, handback, this.m_notificationSubscriptionTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(ObjectName objectName, NotificationListener listener, NotificationFilter filter, Object handback, long timeout) throws InstanceNotFoundException {
        this.checkNotNull("objectName", objectName);
        this.checkNotNull("listener", listener);
        this.testConnector();
        String canonicalName = objectName.getCanonicalName();
        HashMap hashMap = this.m_mBeanToLocalListeners;
        synchronized (hashMap) {
            NotificationListenerDelegate delegate;
            HashMap<NotificationListener, NotificationListenerDelegate> localToRemoteListeners = (HashMap<NotificationListener, NotificationListenerDelegate>)this.m_mBeanToLocalListeners.get(canonicalName);
            if (localToRemoteListeners == null) {
                localToRemoteListeners = new HashMap<NotificationListener, NotificationListenerDelegate>();
                this.m_mBeanToLocalListeners.put(canonicalName, localToRemoteListeners);
            }
            if ((delegate = (NotificationListenerDelegate)localToRemoteListeners.get(listener)) == null) {
                delegate = new NotificationListenerDelegate(this.m_connector, listener);
                localToRemoteListeners.put(listener, delegate);
            }
            String handbackID = delegate.addSubscription(filter, handback);
            delegate.setNotificationSubscriptionTimeout(timeout);
            this.renewSubscription(objectName, delegate, filter, handbackID, timeout, false);
            this.startSubscriptionRenewalThread(objectName, false);
        }
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSubscriptionRenewalThread(ObjectName objectName, boolean renewImmediately) {
        String canonicalName = objectName.getCanonicalName();
        HashMap hashMap = this.m_mBeanToLocalListeners;
        synchronized (hashMap) {
            SubscriptionRenewalThread subscriptionRenewalThread = this.m_mBeanToSubscriptionRenewalThreads.get(canonicalName);
            if (subscriptionRenewalThread == null) {
                subscriptionRenewalThread = new SubscriptionRenewalThread(objectName, renewImmediately);
                this.m_mBeanToSubscriptionRenewalThreads.put(canonicalName, subscriptionRenewalThread);
                subscriptionRenewalThread.setDaemon(true);
                subscriptionRenewalThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartSubscriptionRenewalThreads() {
        HashMap hashMap = this.m_mBeanToLocalListeners;
        synchronized (hashMap) {
            Iterator iterator = this.m_mBeanToLocalListeners.keySet().iterator();
            while (iterator.hasNext()) {
                try {
                    ObjectName objectName = new ObjectName((String)iterator.next());
                    this.startSubscriptionRenewalThread(objectName, true);
                }
                catch (MalformedObjectNameException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSubscriptionRenewalThreads() {
        HashMap hashMap = this.m_mBeanToLocalListeners;
        synchronized (hashMap) {
            Iterator<SubscriptionRenewalThread> iterator = this.m_mBeanToSubscriptionRenewalThreads.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().interrupt();
            }
            this.m_mBeanToSubscriptionRenewalThreads.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean renewSubscriptions(ObjectName objectName, boolean renewImmediately, Object threadLockObject) {
        Object object = threadLockObject;
        synchronized (object) {
            try {
                if (!this.m_mBeanToSubscriptionRenewalThreads.containsValue(Thread.currentThread())) {
                    return false;
                }
                long timeout = renewImmediately ? 1000L : this.m_notificationSubscriptionRenewalInterval;
                long startTime = System.currentTimeMillis();
                this.m_needsRenewal = false;
                if (timeout <= 0L) {
                    while (!this.m_needsRenewal) {
                        threadLockObject.wait();
                    }
                } else {
                    long waitTime = timeout;
                    while (waitTime > 0L && !this.m_needsRenewal) {
                        threadLockObject.wait(waitTime);
                        waitTime = timeout - (System.currentTimeMillis() - startTime);
                    }
                }
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        String canonicalName = objectName.getCanonicalName();
        HashMap localToRemoteListeners = null;
        Object[] entries = null;
        HashMap startTime = this.m_mBeanToLocalListeners;
        synchronized (startTime) {
            if (this.m_isClosing) {
                return false;
            }
            if (!this.m_mBeanToSubscriptionRenewalThreads.containsValue(Thread.currentThread())) {
                return false;
            }
            localToRemoteListeners = (HashMap)this.m_mBeanToLocalListeners.get(canonicalName);
            if (localToRemoteListeners == null) {
                this.m_mBeanToSubscriptionRenewalThreads.remove(canonicalName);
                return false;
            }
            entries = localToRemoteListeners.entrySet().toArray();
        }
        for (int i = 0; i < entries.length; ++i) {
            Map.Entry entry = (Map.Entry)entries[i];
            Object localListener = entry.getKey();
            NotificationListenerDelegate remoteListener = (NotificationListenerDelegate)entry.getValue();
            ArrayList subscriptionRenewalPairs = remoteListener.getSubscriptionRenewalPairs();
            for (Object[] subscriptionRenewalPair : subscriptionRenewalPairs) {
                if (!this.m_mBeanToSubscriptionRenewalThreads.containsValue(Thread.currentThread())) {
                    return false;
                }
                if (Thread.currentThread().isInterrupted()) {
                    return true;
                }
                if (this.m_isClosing) {
                    return false;
                }
                if (!this.m_mBeanToLocalListeners.containsKey(canonicalName)) {
                    return true;
                }
                if (!localToRemoteListeners.containsKey(localListener)) continue;
                this.renewSubscription(objectName, remoteListener, (NotificationFilter)subscriptionRenewalPair[0], (String)subscriptionRenewalPair[1], this.m_notificationSubscriptionTimeout, true);
            }
        }
        return true;
    }

    private void renewSubscription(ObjectName objectName, NotificationListenerDelegate delegate, NotificationFilter filter, String handbackID, long notificationSubscriptionTimeout, boolean renewal) {
        block8: {
            StringBuffer sb = new StringBuffer();
            sb.append(objectName.getCanonicalName().hashCode()).append('.');
            sb.append(delegate.hashCode()).append('.');
            sb.append(filter == null ? 0 : delegate.hashCode()).append('.');
            sb.append(handbackID == null ? 0 : handbackID.hashCode());
            try {
                if (!this.m_isClosing) {
                    if (!this.m_connector.isConnected()) {
                        throw new InvokeTimeoutCommsException("Not connected");
                    }
                    Object[] params = new Object[]{objectName, delegate, filter, this.buildCompoundHandbackID(filter, handbackID), new Long(notificationSubscriptionTimeout)};
                    if (this.m_useOnewaySubscriptionRequests) {
                        this.m_connector.invokeOneway("jmx", this.getMFNamespace(objectName), objectName.getCanonicalName(), ADD_NOTIFICATION_LISTENER_METHOD_NAME, params, ADDREMOVE_NOTIFICATION_LISTENER_WITH_TIMEOUT_SIGNATURE, 0L);
                    } else {
                        this.m_connector.invoke("jmx", this.getMFNamespace(objectName), objectName.getCanonicalName(), ADD_NOTIFICATION_LISTENER_METHOD_NAME, params, ADDREMOVE_NOTIFICATION_LISTENER_WITH_TIMEOUT_SIGNATURE, 0L);
                    }
                }
                this.m_renewalFailures.remove(sb.toString());
            }
            catch (Exception e) {
                if (this.m_isClosing) {
                    return;
                }
                if (this.m_renewalFailures.contains(sb.toString())) {
                    return;
                }
                this.m_renewalFailures.add(sb.toString());
                if (this.m_connectionListener == null) break block8;
                this.m_connectionListener.onNotificationListenerRenewalFailure(e);
            }
        }
    }

    private String buildCompoundHandbackID(NotificationFilter filter, String handbackID) {
        StringBuffer sb = new StringBuffer();
        sb.append('\b');
        sb.append('\b');
        sb.append(filter == null ? 0 : filter.hashCode());
        sb.append('\b');
        sb.append(handbackID);
        return sb.toString();
    }

    public void registerRetryCallback(IRetryCallback rcb) {
        this.m_connector.registerRetryCallback(rcb);
    }

    public void deregisterRetryCallback() {
        this.m_connector.deregisterRetryCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkNotNull("objectName", objectName);
        this.checkNotNull("listener", listener);
        this.testConnector();
        String canonicalName = objectName.getCanonicalName();
        NotificationListenerDelegate delegate = null;
        HashMap hashMap = this.m_mBeanToLocalListeners;
        synchronized (hashMap) {
            HashMap localToRemoteListeners;
            SubscriptionRenewalThread subscriptionRenewalThread = this.m_mBeanToSubscriptionRenewalThreads.get(canonicalName);
            if (subscriptionRenewalThread != null) {
                Object object = subscriptionRenewalThread.getThreadLockObject();
                synchronized (object) {
                    this.m_needsRenewal = true;
                    subscriptionRenewalThread.getThreadLockObject().notifyAll();
                }
            }
            if ((localToRemoteListeners = (HashMap)this.m_mBeanToLocalListeners.get(canonicalName)) == null) {
                return;
            }
            delegate = (NotificationListenerDelegate)localToRemoteListeners.remove(listener);
            if (delegate == null) {
                return;
            }
            if (localToRemoteListeners.isEmpty()) {
                this.m_mBeanToLocalListeners.remove(canonicalName);
                HashMap hashMap2 = this.m_notificationSourceUsages;
                synchronized (hashMap2) {
                    this.m_notificationSourceUsages.remove(canonicalName);
                }
            }
        }
        delegate.close();
        try {
            this.m_connector.invoke("jmx", this.getMFNamespace(objectName), objectName.getCanonicalName(), "removeNotificationListener", new Object[]{objectName, delegate}, new String[]{OBJECTNAME_CLASSNAME, NOTIFICATIONLISTENER_CLASSNAME});
        }
        catch (InstanceNotFoundException e) {
            if (this.m_isClosing) {
                return;
            }
            throw e;
        }
        catch (ListenerNotFoundException e) {
            if (this.m_isClosing) {
                return;
            }
            throw e;
        }
        catch (Exception e) {
            if (this.m_isClosing) {
                return;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed removeNotificationListener");
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkNotNull("objectName", objectName);
        this.checkNotNull("listener", listener);
        this.testConnector();
        String canonicalName = objectName.getCanonicalName();
        String handbackID = null;
        NotificationListenerDelegate delegate = null;
        HashMap hashMap = this.m_mBeanToLocalListeners;
        synchronized (hashMap) {
            HashMap localToRemoteListeners;
            SubscriptionRenewalThread subscriptionRenewalThread = this.m_mBeanToSubscriptionRenewalThreads.get(canonicalName);
            if (subscriptionRenewalThread != null) {
                Object object = subscriptionRenewalThread.getThreadLockObject();
                synchronized (object) {
                    this.m_needsRenewal = true;
                    subscriptionRenewalThread.getThreadLockObject().notifyAll();
                }
            }
            if ((localToRemoteListeners = (HashMap)this.m_mBeanToLocalListeners.get(canonicalName)) == null) {
                return;
            }
            delegate = (NotificationListenerDelegate)localToRemoteListeners.get(listener);
            if (delegate == null) {
                return;
            }
            handbackID = delegate.removeSubscription(filter, handback);
            if (delegate.getSubscriptionRenewalPairs().size() == 0) {
                delegate.close();
                localToRemoteListeners.remove(listener);
            }
            if (localToRemoteListeners.isEmpty()) {
                this.m_mBeanToLocalListeners.remove(canonicalName);
                HashMap hashMap2 = this.m_notificationSourceUsages;
                synchronized (hashMap2) {
                    this.m_notificationSourceUsages.remove(canonicalName);
                }
            }
        }
        try {
            if (handbackID != null) {
                this.m_connector.invoke("jmx", this.getMFNamespace(objectName), objectName.getCanonicalName(), "removeNotificationListener", new Object[]{objectName, delegate, filter, this.buildCompoundHandbackID(filter, handbackID)}, ADDREMOVE_NOTIFICATION_LISTENER_SIGNATURE);
            }
        }
        catch (InstanceNotFoundException e) {
            if (this.m_isClosing) {
                return;
            }
            throw e;
        }
        catch (ListenerNotFoundException e) {
            if (this.m_isClosing) {
                return;
            }
            throw e;
        }
        catch (Exception e) {
            if (this.m_isClosing) {
                return;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed removeNotificationListener");
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void setTraceMask(int maskValue) {
        this.m_connector.setTraceMask(maskValue);
    }

    public int getTraceMask() {
        return this.m_connector.getTraceMask();
    }

    public void setConnectTimeout(long milliseconds) {
        long l = this.m_connectTimeout = milliseconds >= 10000L ? milliseconds : 10000L;
        if (this.m_connector != null) {
            this.m_connector.setConnectTimeout(this.m_connectTimeout);
        }
    }

    public long getConnectTimeout() {
        return this.m_connectTimeout;
    }

    public void setSocketConnectTimeout(long milliseconds) {
        long l = this.m_socketConnectTimeout = milliseconds >= 0L ? milliseconds : 0L;
        if (this.m_connector != null) {
            this.m_connector.setSocketConnectTimeout(this.m_socketConnectTimeout);
        }
    }

    public long getSocketConnectTimeout() {
        return this.m_socketConnectTimeout;
    }

    public void setUseOnewaySubscriptionRequests(boolean useOneway) {
        this.m_useOnewaySubscriptionRequests = useOneway;
    }

    public boolean getUseOnewaySubscriptionRequests() {
        return this.m_useOnewaySubscriptionRequests;
    }

    private void checkNotNull(String paramName, Object object) {
        if (object == null) {
            IllegalArgumentException e = new IllegalArgumentException(paramName + " must not be null");
            throw new RuntimeOperationsException(e);
        }
    }

    private void testOperationSupported() {
        if (this.m_serverIdentity == null) {
            throw new JMRuntimeException("Operation unsupported for unbounded client connector.");
        }
    }

    private void testConnector() {
        if (this.m_connector == null) {
            throw new IllegalStateException("Not connected");
        }
    }

    private void testFailWhenDisconnected() {
        if (this.m_failWhenDisconnected && !this.isConnected()) {
            throw CommunicationException.create("Not currently connected");
        }
    }

    private String getMFNamespace(ObjectName objectName) {
        String namespace = ObjectNameHelper.getMFNamespace(objectName);
        if (namespace == null) {
            namespace = this.m_serverIdentity;
        }
        return namespace;
    }

    private final class SubscriptionRenewalThread
    extends Thread {
        private ObjectName objectName;
        private boolean renewImmediately;
        private Object threadLockObj;

        private SubscriptionRenewalThread(ObjectName objectName, boolean renewImmediately) {
            super("Notification Subscription Renewer - " + objectName.getCanonicalName());
            this.threadLockObj = new Object();
            this.objectName = objectName;
            this.renewImmediately = renewImmediately;
        }

        @Override
        public void run() {
            while (JMSConnectorClient.this.renewSubscriptions(this.objectName, this.renewImmediately, this.threadLockObj)) {
                this.renewImmediately = false;
            }
        }

        public Object getThreadLockObject() {
            return this.threadLockObj;
        }
    }
}

