/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.jmx.util;

import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import com.sonicsw.mf.mgmtapi.runtime.IAgentProxy;
import com.sonicsw.mf.mgmtapi.runtime.MFProxyFactory;
import com.sonicsw.mf.mgmtapi.runtime.ProxyRuntimeException;
import java.util.Hashtable;
import javax.management.ObjectName;

public class ShutdownContainer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String m_url = "localhost:2506";
        String m_username = "Administrator";
        String m_password = "Administrator";
        String m_domain = "Domain1";
        String m_container = "DomainManager";
        JMSConnectorClient connector = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].startsWith("-")) continue;
                if (args[i].equalsIgnoreCase("-url")) {
                    m_url = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-username")) {
                    m_username = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-password")) {
                    m_password = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-domain")) {
                    m_domain = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-container")) {
                    m_container = args[++i];
                    continue;
                }
                throw new Exception("Mismatched argument: " + args[i]);
            }
            connector = ShutdownContainer.getConnector(m_url, m_username, m_password);
            IAgentProxy agent = ShutdownContainer.getAgentProxy(connector, m_domain, m_container);
            agent.shutdown();
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (t instanceof ProxyRuntimeException) {
                System.err.println("Caused by:");
                ((ProxyRuntimeException)t).getTargetException().printStackTrace();
            }
        }
        finally {
            if (connector != null) {
                connector.disconnect();
            }
        }
    }

    public static JMSConnectorClient getConnector(String urls, String user, String pwd) throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("ConnectionURLs", urls);
        env.put("DefaultUser", user);
        env.put("DefaultPassword", pwd);
        JMSConnectorAddress address = new JMSConnectorAddress(env);
        JMSConnectorClient connector = new JMSConnectorClient();
        connector.connect(address, 30000L);
        return connector;
    }

    public static IAgentProxy getAgentProxy(JMSConnectorClient connector, String domain, String container) throws Exception {
        ObjectName jmxName = new ObjectName(domain + "." + container + ":ID=AGENT");
        return MFProxyFactory.createAgentProxy(connector, jmxName);
    }
}

