/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.mgmtapi.config.impl;

import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationGroupBean;
import com.sonicsw.mf.mgmtapi.config.gen.impl.AbstractAuthenticationGroupBean;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.util.ConfigHelper;

public class AuthenticationGroupBean
extends AbstractAuthenticationGroupBean
implements IAuthenticationGroupBean {
    public AuthenticationGroupBean(MgmtBeanFactory factory) {
        super(factory);
    }

    @Override
    public void setGroupName(String value) throws MgmtException {
        try {
            IConfigBean bean = this.getConfigBean();
            String path = bean.getName();
            int index = path.lastIndexOf(47) + 1;
            path = path.substring(0, index);
            bean.setName(path + value);
            super.setGroupName(value);
        }
        catch (Throwable e) {
            throw new MgmtException("Failed setGroupName - " + e.getMessage(), e);
        }
    }

    @Override
    protected void saveBean() throws Exception {
        if (this.isNewBean()) {
            String beanName = this.getConfigBean().getName();
            int index = beanName.lastIndexOf(47);
            String path = beanName.substring(0, index);
            if (this.getMgmtBeanFactory().doesConfigurationNameExist(this.getGroupName(), path)) {
                throw new MgmtException("The specified group name already exist");
            }
            try {
                IConfigBean groupBean = this.getConfigBean();
                String groupName = this.getGroupName();
                String id = groupBean.getName();
                String domainPath = id.substring(0, id.lastIndexOf("_MFGroups"));
                String usersPath = domainPath + "_MFUsers" + '/';
                if (!ConfigHelper.isAttrValueUniqueWithinFolder((IConfigServer)this.getConfigBean().getConfigServer(), (String)usersPath, (String)"USER_NAME", (String)groupName)) {
                    throw new MgmtException("The specified group name '" + groupName + "' already exists - clashes with existing user name");
                }
            }
            catch (MgmtException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MgmtException("Failed to verify group name uniqueness: " + e.getMessage(), e);
            }
        }
        super.saveBean();
    }

    @Override
    public void addMember(String memberName, String memberType) throws MgmtException {
        IAuthenticationGroupBean.IGroupMembersType members = null;
        try {
            members = this.getGroupMembers();
        }
        catch (Exception e) {
            this.setGroupMembers(this.createGroupMembers());
            members = this.getGroupMembers();
        }
        IAuthenticationGroupBean.IGroupMemberType newType = members.createMember();
        newType.setMemberName(memberName);
        newType.setMemberType(memberType);
        members.addMember(memberName, newType);
    }

    public static class GroupMemberType
    extends AbstractAuthenticationGroupBean.AbstractGroupMemberType
    implements IAuthenticationGroupBean.IGroupMemberType {
        public GroupMemberType(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }
    }

    public static class GroupMembersType
    extends AbstractAuthenticationGroupBean.AbstractGroupMembersType
    implements IAuthenticationGroupBean.IGroupMembersType {
        public GroupMembersType(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }
    }
}

