/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.hostmanager;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.runtime.IFileDescriptor;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.IRemoteCallResult;
import com.sonicsw.mf.common.runtime.IRemoteExecResult;
import com.sonicsw.mf.common.runtime.impl.RemoteCallResultWithData;
import com.sonicsw.mf.framework.AbstractFrameworkComponent;
import com.sonicsw.mf.framework.IHostManager;
import com.sonicsw.mx.util.IEmptyArray;
import java.util.ArrayList;
import java.util.Properties;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public final class HostManager
extends AbstractFrameworkComponent {
    private IHostManager m_hostManager;
    private static final ArrayList<MBeanAttributeInfo> ATTRIBUTE_INFOS = new ArrayList();
    private static final ArrayList<MBeanOperationInfo> OPERATION_INFOS = new ArrayList();
    private static final ArrayList<MBeanNotificationInfo> NOTIFICATION_INFOS = new ArrayList();
    public static final String FILE_DOWNLOADED_NOTIFICATION_TYPE = "RemoteFileDownloaded";
    public static final String REMOTE_EXEC_TYPE = "RemoteExec";
    public static final String INSTALL_LAUNCHER_TYPE = "InstallLauncher";
    public static final String SETUP_CONTAINER_TYPE = "SetupContainer";
    public static final String LAUNCH_CONTAINER_TYPE = "LaunchContainer";
    public static final String REMOVE_CONTAINER_TYPE = "RemoveContainer";
    public static final String FILE_DOWNLOADED_FROM_DS_NOTIFICATION_TYPE = "DSFileDownloaded";
    public static final String DELETE_FILES_TYPE = "DeleteFiles";

    public MBeanAttributeInfo[] getAttributeInfos() {
        return ATTRIBUTE_INFOS.toArray(IEmptyArray.EMPTY_ATTRIBUTE_INFO_ARRAY);
    }

    public MBeanOperationInfo[] getOperationInfos() {
        return OPERATION_INFOS.toArray(IEmptyArray.EMPTY_OPERATION_INFO_ARRAY);
    }

    public MBeanNotificationInfo[] getNotificationInfos() {
        return NOTIFICATION_INFOS.toArray(IEmptyArray.EMPTY_NOTIFICATION_INFO_ARRAY);
    }

    public void init(IComponentContext context) {
        super.init(context);
        IElement hmanagerConfig = context.getConfiguration(true);
    }

    public synchronized void start() {
        if (this.m_state == 3) {
            return;
        }
        this.m_hostManager = this.m_frameworkContext.getHostManager();
        super.start();
    }

    public synchronized void stop() {
        if (this.m_state == 1) {
            return;
        }
        this.m_state = (short)4;
        super.stop();
    }

    public void destroy() {
        super.destroy();
    }

    public Properties getJVMProperties() {
        return this.m_hostManager.getJVMProperties();
    }

    public IRemoteCallResult bytesToFile(byte[] src, String destinationFilePath, Boolean rewriteIfExists) {
        IRemoteCallResult result = this.m_hostManager.bytesToFile(src, destinationFilePath, rewriteIfExists);
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], FILE_DOWNLOADED_NOTIFICATION_TYPE, result.isSuccessful() ? 3 : 2);
        notification.setAttribute("CreatedFilePath", (Object)destinationFilePath);
        notification.setAttribute("isSuccessful", (Object)result.isSuccessful());
        this.m_context.sendNotification(notification);
        return result;
    }

    public IRemoteCallResult installLauncher(String targetSonicHome) {
        IRemoteCallResult result = this.m_hostManager.installLauncher(targetSonicHome);
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], INSTALL_LAUNCHER_TYPE, result.isSuccessful() ? 3 : 2);
        notification.setAttribute("TargetSonicHome", (Object)targetSonicHome);
        notification.setAttribute("isSuccessful", (Object)result.isSuccessful());
        this.m_context.sendNotification(notification);
        return result;
    }

    public IRemoteCallResult setupContainer(Properties props, String INIEncryptionPassword) {
        IRemoteCallResult result = this.m_hostManager.setupContainer(props, INIEncryptionPassword);
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], SETUP_CONTAINER_TYPE, result.isSuccessful() ? 3 : 2);
        notification.setAttribute("SetupProperties", (Object)props);
        notification.setAttribute("isSuccessful", (Object)result.isSuccessful());
        this.m_context.sendNotification(notification);
        return result;
    }

    public IRemoteCallResult setupContainer(String containerDSPath, Properties props, String INIEncryptionPassword) {
        IRemoteCallResult result = this.m_hostManager.setupContainer(containerDSPath, props, INIEncryptionPassword);
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], SETUP_CONTAINER_TYPE, result.isSuccessful() ? 3 : 2);
        notification.setAttribute("SetupUnconfiguredProperties", (Object)props);
        notification.setAttribute("ContainerDSPath", (Object)containerDSPath);
        notification.setAttribute("isSuccessful", (Object)result.isSuccessful());
        this.m_context.sendNotification(notification);
        return result;
    }

    public IRemoteCallResult setupContainer(String sonicHome, String launcherVersion, Properties props, String INIEncryptionPassword) {
        IRemoteCallResult result = this.m_hostManager.setupContainer(sonicHome, launcherVersion, props, INIEncryptionPassword);
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], SETUP_CONTAINER_TYPE, result.isSuccessful() ? 3 : 2);
        notification.setAttribute("SetupProperties", (Object)props);
        notification.setAttribute("SonicHome", (Object)sonicHome);
        notification.setAttribute("isSuccessful", (Object)result.isSuccessful());
        this.m_context.sendNotification(notification);
        return result;
    }

    public IRemoteCallResult launchContainer(String containerName, Boolean launchAsWindowsService) {
        IRemoteCallResult result = this.m_hostManager.launchContainer(containerName, launchAsWindowsService);
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], LAUNCH_CONTAINER_TYPE, result.isSuccessful() ? 3 : 2);
        notification.setAttribute("ContainerName", (Object)containerName);
        notification.setAttribute("LaunchAsWindowsService", (Object)launchAsWindowsService);
        notification.setAttribute("isSuccessful", (Object)result.isSuccessful());
        this.m_context.sendNotification(notification);
        return result;
    }

    public IRemoteCallResult launchContainer(String sonicHome, String containerName, Boolean launchAsWindowsService) {
        IRemoteCallResult result = this.m_hostManager.launchContainer(sonicHome, containerName, launchAsWindowsService);
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], LAUNCH_CONTAINER_TYPE, result.isSuccessful() ? 3 : 2);
        notification.setAttribute("SonicHome", (Object)sonicHome);
        notification.setAttribute("ContainerName", (Object)containerName);
        notification.setAttribute("LaunchAsWindowsService", (Object)launchAsWindowsService);
        notification.setAttribute("isSuccessful", (Object)result.isSuccessful());
        this.m_context.sendNotification(notification);
        return result;
    }

    public IRemoteCallResult deleteFiles(String pathOfdirectoryOrFile, Boolean deleteContent) {
        IRemoteCallResult result = this.m_hostManager.deleteFiles(pathOfdirectoryOrFile, deleteContent);
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], DELETE_FILES_TYPE, result.isSuccessful() ? 3 : 2);
        notification.setAttribute("PathOfdirectoryOrFile", (Object)pathOfdirectoryOrFile);
        notification.setAttribute("isSuccessful", (Object)result.isSuccessful());
        this.m_context.sendNotification(notification);
        return result;
    }

    public IRemoteCallResult removeContainer(String containerName) {
        IRemoteCallResult result = this.m_hostManager.removeContainer(containerName);
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], REMOVE_CONTAINER_TYPE, result.isSuccessful() ? 3 : 2);
        notification.setAttribute("ContainerName", (Object)containerName);
        notification.setAttribute("isSuccessful", (Object)result.isSuccessful());
        this.m_context.sendNotification(notification);
        return result;
    }

    public IRemoteCallResult fileToBytes(String srcFilePath) {
        RemoteCallResultWithData result = this.m_hostManager.fileToBytes(srcFilePath);
        return result;
    }

    public IRemoteCallResult downloadFileFromDS(String dsFilePath, String destinationFilePath, Boolean rewriteIfExists, Boolean expandZip) {
        IRemoteCallResult result = this.m_hostManager.downloadFileFromDS(dsFilePath, destinationFilePath, rewriteIfExists, expandZip);
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], FILE_DOWNLOADED_FROM_DS_NOTIFICATION_TYPE, result.isSuccessful() ? 3 : 2);
        notification.setAttribute("DSFilePath", (Object)dsFilePath);
        notification.setAttribute("CreatedFilePath", (Object)destinationFilePath);
        notification.setAttribute("isSuccessful", (Object)result.isSuccessful());
        this.m_context.sendNotification(notification);
        return result;
    }

    public IFileDescriptor[] listDirectory(String directoryPath) {
        return this.m_hostManager.listDirectory(directoryPath);
    }

    public IRemoteExecResult remoteExec(String[] cmdarray, String[] envp, String workDirPath, byte[] inputBytes) {
        IRemoteExecResult result = this.m_hostManager.remoteExec(cmdarray, envp, workDirPath, inputBytes);
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], REMOTE_EXEC_TYPE, result.isSuccessful() ? 3 : 2);
        notification.setAttribute("CommandArray", (Object)cmdarray);
        notification.setAttribute("Environment", (Object)envp);
        notification.setAttribute("WorkingDirPath", (Object)workDirPath);
        notification.setAttribute("isSuccessful", (Object)result.isSuccessful());
        this.m_context.sendNotification(notification);
        return result;
    }

    public String[] getAllHostnamesAndIPs(Boolean includeLoopback) {
        return this.m_hostManager.getAllHostnamesAndIPs(includeLoopback);
    }

    public synchronized void handleElementChange(IElementChange elementChange) {
        this.m_context.fireAttributeChangeHandlers();
    }

    static {
        String[] notifTypes = null;
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], FILE_DOWNLOADED_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Remote file-system file or directory downloaded."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], REMOTE_EXEC_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Remote system command executed."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], INSTALL_LAUNCHER_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Launcher installed."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], SETUP_CONTAINER_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "New container setup."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], LAUNCH_CONTAINER_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Container launched."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], REMOVE_CONTAINER_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Container working directory files removed."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], FILE_DOWNLOADED_FROM_DS_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "File or directory downloaded from the Directory Service."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], DELETE_FILES_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "File or directory were deleted."));
        MBeanParameterInfo[] mbParamInfos = null;
        OPERATION_INFOS.add(new MBeanOperationInfo("getJVMProperties", "Returns the JVM's system properties.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Properties.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("dsFilePath", String.class.getName(), "File path in the DS."), new MBeanParameterInfo("destinationFilePath", String.class.getName(), "destination path on the container side."), new MBeanParameterInfo("rewriteIfExists", Boolean.class.getName(), "fails if false and the file already exists."), new MBeanParameterInfo("expandZip", Boolean.class.getName(), "if 'true' expand the zip file after downloading it.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("downloadFileFromDS", "Download a file from the Directory Service into the container's file-system.", mbParamInfos, IRemoteCallResult.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("directoryPath", String.class.getName(), "an absolute path or a path relative to the working directory of the container.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("listDirectory", "Return the list of files and directories under directoryPath.", mbParamInfos, IFileDescriptor[].class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("cmdarray", String[].class.getName(), "a specified system command. "), new MBeanParameterInfo("envp", String[].class.getName(), "array of strings, each element of which has environment variable settings in the format {name = value}, or null if the subprocess should inherit the environment of the current process."), new MBeanParameterInfo("workDirPath", String.class.getName(), "the working directory of the subprocess, or null if the subprocess should inherit the working directory of the current process."), new MBeanParameterInfo("inputBytes", byte[].class.getName(), "standrd input for the process (or null if there is no input)")};
        OPERATION_INFOS.add(new MBeanOperationInfo("remoteExec", "executes java.lang.Runtime.exec on the target container.", mbParamInfos, IRemoteExecResult.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("srcFilePath", String.class.getName(), "the file or directory path on the container side.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("fileToBytes", "Retrieves file(s) from the container's file-system as bytes.", mbParamInfos, IRemoteCallResult.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("source", byte[].class.getName(), "the bytes content of the created file(s)."), new MBeanParameterInfo("destinationFilePath", String.class.getName(), "destination path on the container side."), new MBeanParameterInfo("rewriteIfExists", Boolean.class.getName(), "fails if false and the file already exists.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("bytesToFile", "creates a file (or a directory), delivered as a byte array, in the container's file-system.", mbParamInfos, IRemoteCallResult.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("containerName", String.class.getName(), "container name."), new MBeanParameterInfo("launchAsWindowsService", Boolean.class.getName(), "if true and on Windows will launch the container as Windows Service.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("launchContainer", "launches the specified container.", mbParamInfos, IRemoteCallResult.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("sonicHome", String.class.getName(), "the home of this container."), new MBeanParameterInfo("containerName", String.class.getName(), "container name."), new MBeanParameterInfo("launchAsWindowsService", Boolean.class.getName(), "if true and on Windows will launch the container as Windows Service.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("launchContainer", "launches the specified container in the specified sonic home.", mbParamInfos, IRemoteCallResult.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("targetSonicHome", String.class.getName(), "install the launcher under this directory.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("installLauncher", "install the launcher that launched the container that hosts this HM under the specified sonic home.", mbParamInfos, IRemoteCallResult.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("properties", Properties.class.getName(), "the container setup properties."), new MBeanParameterInfo("INIEncryptionPassword", String.class.getName(), "an optional password for INI file encryption.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("setupContainer", "setup a new container by generating the launch and Windows Service scripts and the container.ini file.", mbParamInfos, IRemoteCallResult.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("containerDSPath", String.class.getName(), "the path of the container configuration in the DS."), new MBeanParameterInfo("unConfiguredProps", Properties.class.getName(), "the container setup unconfigured properties such as WINDOWS_SERVICE_NAME."), new MBeanParameterInfo("INIEncryptionPassword", String.class.getName(), "an optional password for INI file encryption.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("setupContainer", "setup a new container, given its DS configuration, by generating the launch and Windows Service scripts and the container.ini file.", mbParamInfos, IRemoteCallResult.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("sonicHome", String.class.getName(), "the sonic home used by the new container."), new MBeanParameterInfo("launcherVersion", String.class.getName(), "the launcher version used by the new container. If 'null' will use the same launcher version used to launch the remote container."), new MBeanParameterInfo("properties", Properties.class.getName(), "the container setup properties."), new MBeanParameterInfo("INIEncryptionPassword", String.class.getName(), "an optional password for INI file encryption.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("setupContainer", "Setup a new container under the specified soniv home.", mbParamInfos, IRemoteCallResult.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("containerName", String.class.getName(), "container name.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("removeContainer", "Uninstall the Windows Service (if installed) and removes the working directory files.", mbParamInfos, IRemoteCallResult.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("pathOfdirectoryOrFile", String.class.getName(), "the path of a directory or a file."), new MBeanParameterInfo("deleteContent", Boolean.class.getName(), "if true and 'pathOfdirectoryOrFile' is a directory, deletes the directory's content.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("deleteFiles", "delete the file or directory.", mbParamInfos, IRemoteCallResult.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("includeLoopback", Boolean.class.getName(), "if true include the loopback addresses.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getAllHostnamesAndIPs", "gets all known hostnames and ip addresses of this machine.", mbParamInfos, String[].class.getName(), 0));
    }
}

