/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui;

import com.sonicsw.ma.gui.IWorkspaceWindow;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedImageIcon;
import com.sonicsw.ma.gui.util.JBasicMenu;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.gui.util.MenuScroller;
import com.sonicsw.ma.gui.util.ResourceManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.event.MenuEvent;

final class ActionMenu
extends JBasicMenu {
    private PreferenceManager m_preferences;
    private JBasicMenu m_connectMenu;
    private JBasicMenuItem m_newConnectionMenuItem;
    private JBasicMenuItem m_disconnectMenuItem;
    private JBasicMenuItem m_exitMenuItem;

    ActionMenu(PreferenceManager preferences, MouseListener mouseListener) {
        super(new FileAction());
        this.m_preferences = preferences;
        this.m_connectMenu = new JBasicMenu(new FileConnectAction());
        this.m_newConnectionMenuItem = new JBasicMenuItem(new NewConnectionAction());
        this.m_exitMenuItem = new JBasicMenuItem(new ExitAction());
        this.m_disconnectMenuItem = new JBasicMenuItem(new DisconnectAction());
        MenuScroller.setScrollerFor(this.m_connectMenu, 25, 125, 1, 0);
        this.setMouseListener(mouseListener);
        this.buildMenu(null);
    }

    @Override
    public void menuSelected(MenuEvent evt) {
        JInternalFrame innerFrame = MgmtConsole.getMgmtConsole().getDesktopPane().getSelectedFrame();
        if (innerFrame != null && innerFrame instanceof IWorkspaceWindow) {
            this.buildMenu((IWorkspaceWindow)((Object)innerFrame));
        } else {
            this.buildMenu(null);
        }
        super.menuSelected(evt);
    }

    private void buildMenu(IWorkspaceWindow window) {
        this.removeAll();
        this.add(this.getConnectMenu());
        if (window != null) {
            int i;
            this.add(this.m_disconnectMenuItem);
            this.addSeparator();
            JComponent[] newItems = window.getSelectedMenuItems(1);
            JComponent[] pluginItems = window.getSelectedMenuItems(2);
            JComponent[] systemItems = window.getSelectedMenuItems(4);
            JComponent[] propertyItems = window.getSelectedMenuItems(6);
            if (newItems != null && newItems.length > 0) {
                for (i = 0; i < newItems.length; ++i) {
                    this.add(newItems[i]);
                }
                this.addSeparator();
            }
            if (pluginItems != null && pluginItems.length > 0) {
                for (i = 0; i < pluginItems.length; ++i) {
                    this.add(pluginItems[i]);
                }
                this.addSeparator();
            }
            if (systemItems != null && systemItems.length > 0) {
                for (i = 0; i < systemItems.length; ++i) {
                    this.add(systemItems[i]);
                }
                this.addSeparator();
            }
            if (propertyItems != null && propertyItems.length > 0) {
                for (i = 0; i < propertyItems.length; ++i) {
                    this.add(propertyItems[i]);
                }
                this.addSeparator();
            }
        } else {
            this.addSeparator();
        }
        this.add(this.m_exitMenuItem);
    }

    private JComponent getConnectMenu() {
        this.m_connectMenu.removeAll();
        this.m_connectMenu.add(this.m_newConnectionMenuItem);
        String[] children = this.m_preferences.getChildrenNames("connections");
        ArrayList list = DomainConnectionModel.getFirstN(this.m_preferences);
        if (!list.isEmpty()) {
            this.m_connectMenu.addSeparator();
        }
        for (int i = 0; i < list.size(); ++i) {
            DomainConnectionModel connectionModel = new DomainConnectionModel(this.m_preferences, (String)list.get(i));
            JBasicMenuItem mi = new JBasicMenuItem(new ConnectAction(i + 1, connectionModel));
            mi.setIcon(ResourceManager.getIcon(this.getClass(), "Connect"));
            this.m_connectMenu.add(mi);
        }
        return this.m_connectMenu;
    }

    Action getExitAction() {
        return this.m_exitMenuItem.getAction();
    }

    Action getDisconnectAction() {
        return this.m_disconnectMenuItem.getAction();
    }

    private final class DisconnectAction
    extends BasicGuiAction {
        public DisconnectAction() {
            super("file.disconnect");
            this.putValue("SmallIcon", new ExtendedImageIcon(ResourceManager.getIcon(this.getClass(), "Connect"), ResourceManager.getIcon(this.getClass(), "deleteoverlay")));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MgmtConsole.getMgmtConsole().disconnect();
        }
    }

    private final class ConnectAction
    extends BasicGuiAction {
        private DomainConnectionModel connectionModel;

        public ConnectAction(int index, DomainConnectionModel connectionModel) {
            super("file.connect.previous");
            this.connectionModel = connectionModel;
            this.putValue("Name", index + " - " + connectionModel.getDomainDescription());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MgmtConsole.getMgmtConsole().connectToDomain(this.connectionModel);
        }
    }

    private final class NewConnectionAction
    extends BasicGuiAction {
        public NewConnectionAction() {
            super("file.connect.new");
            this.putValue("SmallIcon", new ExtendedImageIcon((Icon)this.getValue("SmallIcon"), ResourceManager.getIcon(this.getClass(), "newoverlay")));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MgmtConsole.getMgmtConsole().connectToDomain(null);
        }
    }

    private final class ExitAction
    extends BasicGuiAction {
        public ExitAction() {
            super("file.exit");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            MgmtConsole.getMgmtConsole().windowClosing(null);
        }
    }

    class FileConnectAction
    extends BasicGuiAction {
        public FileConnectAction() {
            super("file.connect");
        }
    }

    static class FileAction
    extends BasicGuiAction {
        public FileAction() {
            super("file");
        }
    }
}

