/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.propsheets.JPropSheetTabbedDialog;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JBasicButton;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.ResourceManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.table.TableColumn;
import javax.swing.text.NumberFormatter;
import progress.message.zclient.Version;

public final class JAboutDialog
extends JPropSheetTabbedDialog {
    private static final String COMPANY = "Aurea Software, Inc.";
    private static final String PRODUCT_NAME = "Sonic Management Console";
    private static final String MQ_PRODUCT_NAME = "SonicMQ";
    private static final String COPYRIGHT = "Copyright (c) 2015. Aurea Software, Inc. All Rights Reserved.";
    private JLabel m_heap;
    private Timer m_timer;

    public JAboutDialog(JMAFrame parent) {
        super(parent, "help.about", AboutModel.class);
    }

    @Override
    public Object getModel() {
        return new AboutModel();
    }

    @Override
    public Action[] getButtonActions() {
        return new Action[]{new CloseAction((Action)this.getDefaultCancelAction())};
    }

    @Override
    protected void maCleanup() {
        if (this.m_timer != null) {
            this.m_timer.stop();
            this.m_timer = null;
        }
        super.maCleanup();
    }

    @Override
    public void initUI() throws Exception {
        this.addTabPanel("About", this.createAboutPanel());
        this.addTabPanel("Info", this.createInfoPanel());
    }

    @Override
    public void initForm() throws Exception {
    }

    private JPanel createAboutPanel() {
        JPartitionPanel panel = new JPartitionPanel(true, "r,p,p,p,r", null, 0, 10, 10);
        panel.setBackground(Color.WHITE);
        panel.add(new JTransparentPanel());
        panel.add(new JLabel(ResourceManager.getApplicationLogo(this.getClass(), "logo")));
        panel.add(new JLabel("Sonic Management Console " + com.sonicsw.mf.common.Version.getVersionText(), 0));
        panel.add(new JLabel("SonicMQ Release " + Version.getReleaseName() + " Build Number " + Version.getBuildNumber(), 0));
        panel.add(new JLabel(COPYRIGHT, 0));
        panel.add(new JTransparentPanel());
        return panel;
    }

    private JPanel createInfoPanel() {
        JPartitionPanel panel = new JPartitionPanel(true, "r,p", null);
        JRowTable table = new JRowTable(new TableColumn[]{new NameColumn(), new ValueColumn()}, this.getClass().getName());
        table.setPreferredScrollableViewportSize(new Dimension(table.getPreferredSize().width, table.getRowHeight() * 10));
        panel.add(new ExtendedJScrollPane(table));
        panel.add(this.createGCInfoPanel());
        try {
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                ((IModelTableModel)table.getModel()).addRow(entry);
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            e.printStackTrace();
        }
        return panel;
    }

    private JPanel createGCInfoPanel() {
        JPartitionPanel panel = new JPartitionPanel(false, "p,r,p", null);
        this.m_heap = new JLabel(" ");
        panel.add(new JLabel("Java Heap: "));
        panel.add(this.m_heap);
        panel.add(new JBasicButton(new ForceGCAction()));
        ActionListener heapUpdater = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Runtime r = Runtime.getRuntime();
                float usedMem = (float)(r.totalMemory() - r.freeMemory()) / 1024.0f / 1024.0f;
                float totalMem = (float)r.totalMemory() / 1024.0f / 1024.0f;
                try {
                    DecimalFormat decimalFormat = new DecimalFormat("0.0");
                    NumberFormatter textFormatter = new NumberFormatter(decimalFormat);
                    textFormatter.setOverwriteMode(true);
                    textFormatter.setAllowsInvalid(false);
                    JAboutDialog.this.m_heap.setText(textFormatter.valueToString(new Float(usedMem)) + "MB used, " + textFormatter.valueToString(new Float(totalMem)) + "MB allocated");
                }
                catch (Exception e) {
                    MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                    e.printStackTrace();
                }
            }
        };
        this.m_timer = new Timer(1000, heapUpdater);
        this.m_timer.start();
        return panel;
    }

    class CloseAction
    extends BasicGuiAction {
        public CloseAction(Action targetAction) {
            super("help.about.close", targetAction);
        }
    }

    class ForceGCAction
    extends BasicGuiAction {
        public ForceGCAction() {
            super("help.about.force-gc", (Action)null);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            System.gc();
        }
    }

    class ValueColumn
    extends RowTableColumn {
        public ValueColumn() {
            super(1, "Value", 40);
        }

        @Override
        public Object getColumnValue(Object value) {
            return ((Map.Entry)value).getValue();
        }
    }

    class NameColumn
    extends RowTableColumn {
        public NameColumn() {
            super(0, "Name", 60);
        }

        @Override
        public Object getColumnValue(Object value) {
            return ((Map.Entry)value).getKey();
        }
    }

    class JTransparentPanel
    extends JPanel {
        public JTransparentPanel() {
            this.setProperties();
        }

        private void setProperties() {
            this.setOpaque(false);
        }
    }

    class AboutModel {
        AboutModel() {
        }
    }
}

